/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.exception.CAFPartInitException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.IGenerateable;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.IContainCustomCode;
import com.sap.caf.designer.utils.ImportsExtractor;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorSite;

public class ImplementationProvider
extends CompilationUnitEditor {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$ImplementationProvider == null ? (class$com$sap$caf$designer$editors$ImplementationProvider = ImplementationProvider.class$("com.sap.caf.designer.editors.ImplementationProvider")) : class$com$sap$caf$designer$editors$ImplementationProvider);
    private static final TextPool mTextPool = TextPool.getInstance();
    private boolean isDocumentDirty = false;
    private INotifyDirtyCallback dirtyCallback;
    private SourceViewListener mSourceListener;
    private CAFBaseObject editedObject;
    private long srcLastTimeModified = -1L;
    private BOMSystem bomProject;
    private boolean objEdited;
    private String content = "";
    private StyledText controlStyledText = null;
    private ImportsExtractor templateImports = null;
    static /* synthetic */ Class class$com$sap$caf$designer$editors$ImplementationProvider;

    public ImplementationProvider(INotifyDirtyCallback dirtyCallback, BOMSystem bom, CAFBaseObject editedObject, boolean bEdited) {
        if (!(editedObject instanceof IGenerateable)) {
            throw new CAFRuntimeException("The parameter 'editedObject' cannot generate an implementation code.");
        }
        this.dirtyCallback = dirtyCallback;
        this.editedObject = editedObject;
        this.bomProject = bom;
        this.mSourceListener = new SourceViewListener();
        this.objEdited = bEdited;
    }

    public void setEditable(boolean aIsEditable) {
        this.objEdited = aIsEditable;
    }

    public boolean isEditable() {
        return this.objEdited;
    }

    public String getEditorContent() {
        StyledText text;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null && (text = sourceViewer.getTextWidget()) != null && !text.isDisposed()) {
            this.content = text.getText();
        }
        return this.content;
    }

    public void init(IEditorSite site, IEditorInput input) throws CAFPartInitException {
        try {
            if (site instanceof MultiPageEditorSite) {
                IGenerateable srcGenObj = (IGenerateable)((Object)this.editedObject);
                File mainImplFile = srcGenObj.getGeneratedImplementation();
                this.StoreImportsInto(mainImplFile);
                FileEditorInput javaFileEditorInput = this.createJavaFileEditorInput(mainImplFile);
                if (javaFileEditorInput != null) {
                    IEditorSite parentEditorSite = ((MultiPageEditorSite)site).getMultiPageEditor().getEditorSite();
                    super.init(parentEditorSite, (IEditorInput)javaFileEditorInput);
                }
                if (mainImplFile.exists()) {
                    this.srcLastTimeModified = mainImplFile.lastModified();
                }
            } else {
                super.init(site, input);
            }
        }
        catch (PartInitException pie) {
            throw new CAFPartInitException(pie);
        }
        catch (GeneratorException pie) {
            throw new CAFPartInitException((Throwable)((Object)pie));
        }
        catch (IOException pie) {
            throw new CAFPartInitException(pie);
        }
    }

    public void saveImplementation() {
        if (this.isDocumentDirty) {
            this.storeIntoMetaModel();
            this.bomProject.getModifiedServicesList().objectModified(this.editedObject.getBaseObject());
        }
        this.isDocumentDirty = false;
    }

    public boolean validateEditorInputState() {
        return this.objEdited;
    }

    void activateSourceDisplay() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            sourceViewer.removeTextListener((ITextListener)this.mSourceListener);
        }
        try {
            boolean bHaveToChangeInput;
            File mainImplFile = this.generateObject();
            boolean isFileExist = mainImplFile.exists();
            long timeFileLastModified = mainImplFile.lastModified();
            boolean bl = bHaveToChangeInput = isFileExist && this.srcLastTimeModified != timeFileLastModified || !isFileExist;
            if (bHaveToChangeInput) {
                FileEditorInput javaFileEditorInput = this.createJavaFileEditorInput(mainImplFile);
                if (javaFileEditorInput != null) {
                    super.setInput((IEditorInput)javaFileEditorInput);
                }
                this.srcLastTimeModified = isFileExist ? timeFileLastModified : -1L;
            }
        }
        catch (GeneratorPartInitException ex) {
            ex.showGeneratorErrorDialog();
        }
        if (sourceViewer != null) {
            sourceViewer.addTextListener((ITextListener)this.mSourceListener);
            if (this.controlStyledText == null) {
                this.controlStyledText = sourceViewer.getTextWidget();
                Listener deactivateHandle = new Listener(){

                    public void handleEvent(Event event) {
                        ImplementationProvider.this.storeIntoMetaModel();
                    }
                };
                this.controlStyledText.addListener(27, deactivateHandle);
            }
        }
    }

    void deactivateSourceDisplay() {
    }

    private static boolean isFileIntoProject(String filePrj, String strImplFileName) {
        if (filePrj.length() < strImplFileName.length()) {
            File implFileProject = new File(strImplFileName.substring(0, filePrj.length()));
            File prjFile = new File(filePrj);
            return implFileProject.equals(prjFile);
        }
        return false;
    }

    private FileEditorInput createJavaFileEditorInput(File mainImplFile) {
        IProject project = this.lookForProjectContainer(mainImplFile);
        try {
            project.refreshLocal(2, null);
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            ex.printStackTrace();
        }
        if (project != null) {
            String prjPath = project.getLocation().toString();
            String fileName = mainImplFile.toString();
            char chLast = prjPath.charAt(prjPath.length() - 1);
            String relFilePath = fileName.substring(prjPath.length() + (chLast == File.separatorChar || chLast == '\\' || chLast == '/' ? 0 : 1));
            Path path = new Path(relFilePath);
            IFile file = project.getFile((IPath)path);
            return new FileEditorInput(file);
        }
        return null;
    }

    private File generateObject() throws GeneratorPartInitException {
        IGenerateable objGen = (IGenerateable)((Object)this.editedObject);
        try {
            objGen.generateObject(null, this.bomProject.getResourceChangeListener());
            File mainImplFile = objGen.getGeneratedImplementation();
            this.StoreImportsInto(mainImplFile);
            return mainImplFile;
        }
        catch (Exception ex) {
            String objectName = this.editedObject.getBaseObject().getObjectName();
            logger.infoT("Code Generation Failed for '" + objectName + "'.");
            logger.catching((Throwable)ex);
            ex.printStackTrace();
            throw new GeneratorPartInitException("Cannot generate code for " + objectName, objectName, ex);
        }
    }

    private IProject lookForProjectContainer(File mainImplFile) {
        String strMainImplFile = mainImplFile.toString();
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] arrPrjNames = new String[]{this.bomProject.getRelatedProjectNameByType("EJB"), this.bomProject.getRelatedProjectNameByType("ASSEMBLY"), this.bomProject.getRelatedProjectNameByType("DICT"), this.bomProject.getRelatedProjectNameByType("MMR"), this.bomProject.getRelatedProjectNameByType("MMR_CORE"), this.bomProject.getRelatedProjectNameByType("DDIC_CORE"), this.bomProject.getRelatedProjectNameByType("IS_CORE"), this.bomProject.getRelatedProjectNameByType("SERVICE_ASSEMBLY"), this.bomProject.getRelatedProjectNameByType("ENTERPRISE_APPLICATION")};
        int i = 0;
        while (i < arrPrjNames.length) {
            IProject resprj;
            if (arrPrjNames[i] != null && ImplementationProvider.isFileIntoProject((resprj = myWorkspaceRoot.getProject(arrPrjNames[i])).getLocation().toString(), strMainImplFile)) {
                return resprj;
            }
            ++i;
        }
        return null;
    }

    private void storeIntoMetaModel() {
        String code = this.getEditorContent();
        if (this.editedObject instanceof IContainCustomCode) {
            IContainCustomCode obj = (IContainCustomCode)((Object)this.editedObject);
            obj.updateCode(code);
            ImportsExtractor newImports = new ImportsExtractor(code);
            int i = 0;
            while (i < this.templateImports.getLength()) {
                newImports.removeImport(this.templateImports.getImportName(i));
                ++i;
            }
            String[] res = new String[newImports.getLength()];
            int i2 = 0;
            while (i2 < res.length) {
                res[i2] = newImports.getImportName(i2);
                ++i2;
            }
            obj.setCustomImports(res);
        }
    }

    private void StoreImportsInto(File file) throws IOException {
        if (this.editedObject instanceof IContainCustomCode) {
            IContainCustomCode obj = (IContainCustomCode)((Object)this.editedObject);
            String[] originalUserImports = obj.getCustomImports();
            ImportsExtractor genImports = null;
            try {
                genImports = new ImportsExtractor(file);
                int i = 0;
                while (i < originalUserImports.length) {
                    genImports.removeImport(originalUserImports[i]);
                    ++i;
                }
            }
            catch (FileNotFoundException ex) {
                genImports = new ImportsExtractor("");
            }
            this.templateImports = genImports;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SourceViewListener
    implements ITextListener {
        SourceViewListener() {
        }

        public void textChanged(TextEvent e) {
            ImplementationProvider.this.isDocumentDirty = true;
            if (ImplementationProvider.this.dirtyCallback != null) {
                ImplementationProvider.this.dirtyCallback.setDirty(true);
            }
        }
    }

    static class GeneratorPartInitException
    extends CAFPartInitException {
        public String objectName;

        public GeneratorPartInitException(String altText, String objectName, Throwable ex) {
            super(ex, altText);
            this.objectName = objectName;
            if (ex == null) {
                throw new CAFRuntimeException("The third argument cannot be null. ");
            }
            if (objectName == null) {
                throw new CAFRuntimeException("The second argument cannot be null. ");
            }
        }

        public void showGeneratorErrorDialog() {
            IStatus status = this.getStatus();
            Throwable realEX = status.getException();
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("IMPL_TAB_CODE_GENERATIONFAILED"), (String)mTextPool.getText("IMPL_TAB_CODE_GENERATIONFAILED_MSG", new String[]{this.objectName, realEX.getMessage()}));
        }
    }

    public static interface INotifyDirtyCallback {
        public void setDirty(boolean var1);
    }
}

