/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ExternalInterfaceEditor;
import com.sap.caf.designer.model.ExternalInterfaceOperationsTreeFilter;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ElementWrapperSelectionConverter;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.IElementWrapperConverter;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;

public class ExternalInterfaceEditorOperationsPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Object[] tableColumnNames = new Object[]{mTextPool.getText("BOM_OPERATIONS_TAB_0001"), mTextPool.getText("BOM_OPERATIONS_TAB_0002")};
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$ExternalInterfaceEditorOperationsPage == null ? (class$com$sap$caf$designer$editors$ExternalInterfaceEditorOperationsPage = ExternalInterfaceEditorOperationsPage.class$("com.sap.caf.designer.editors.ExternalInterfaceEditorOperationsPage")) : class$com$sap$caf$designer$editors$ExternalInterfaceEditorOperationsPage);
    private IWorkbenchWindow window;
    private IGridLayoutPane tabPane;
    private ISapTableViewer tableViewerEIMethods;
    private OperationTableModel defTableModel;
    private Text methodName;
    private Text methodDescription;
    private Combo methodReturnType;
    private MethodTabListener listener = new MethodTabListener();
    private GenericDataModelFilteredTreeViewer operationsViewer;
    private DefaultTreeModel treeModel = null;
    private ISashPane treeViewer;
    private String boName;
    private String projectName;
    private ExternalInterfaceEditor parent = null;
    private Collection methods = null;
    private IStructuredSelection selectionOld = null;
    private IStructuredSelection selection;
    static /* synthetic */ Class class$com$sap$caf$designer$editors$ExternalInterfaceEditorOperationsPage;

    public void createTabContents(IGridLayoutPane tabPane, ExternalInterfaceEditor boe) {
        logger.infoT("Service Operation - createTabContents()." + boe);
        this.parent = boe;
        this.projectName = boe.getProjectName();
        this.boName = boe.getObjectName();
        this.tabPane = tabPane;
        ISashPane outerSashPane = tabPane.addVerticalSashPane(tabPane.createGridLayoutData(4, 4, true, true, 20, 1));
        ISashPane tableSashPane = outerSashPane.addHorizontalSashPane();
        this.tableViewerEIMethods = tableSashPane.addSapTableViewer((TableModel)this.initializeTableModel());
        this.tableViewerEIMethods.getTable().addSelectionListener((SelectionListener)this.listener);
        CellEditor[] celleditors = new CellEditor[]{new TextCellEditor((Composite)this.tableViewerEIMethods.getTable()), new TextCellEditor((Composite)this.tableViewerEIMethods.getTable())};
        this.tableViewerEIMethods.getTableViewer().setCellEditors(celleditors);
        ColumnWeightData c1Layout = new ColumnWeightData(5, true);
        ColumnWeightData c2Layout = new ColumnWeightData(5, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        this.tableViewerEIMethods.getTable().setLayout((Layout)layout);
        this.tableViewerEIMethods.getTable().setLinesVisible(true);
        this.tableViewerEIMethods.getTable().setHeaderVisible(true);
        ISashPane bottomSashPane = outerSashPane.addVerticalSashPane();
        IGridLayoutPane bottomGrid = bottomSashPane.addGridLayoutPane(1, false);
        bottomGrid.addTextLabel(mTextPool.getText("BOM_OPERATIONS_TREE_0001"), bottomGrid.createGridLayoutData(4, 4, 1, 1));
        this.treeViewer = bottomGrid.addHorizontalSashPane(bottomGrid.createGridLayoutData(4, 4, true, true));
        this.createOperationsTree(this.treeViewer, null);
    }

    private String getAttributes(Message message) {
        StringBuffer result = new StringBuffer("");
        if (message != null && message.getMessageParts() != null) {
            Iterator attributesIterator = message.getMessageParts().iterator();
            while (attributesIterator.hasNext()) {
                Attribute attribute = (Attribute)attributesIterator.next();
                String name = attribute.getObjectName();
                String className = attribute.getTypeJavaDdic();
                result.append(" " + name + (attributesIterator.hasNext() ? ";" : ""));
            }
        }
        return result.toString();
    }

    private void createOperationsTree(ISashPane treeViewer, IStructuredSelection selection) {
        String bomSystemName = this.parent.getBOMSystem().getProjectName();
        String applicationName = this.parent.getAppName();
        String serviceName = this.parent.getObjectName();
        String methodName = "";
        Operation currentMethodData = null;
        if (selection != null) {
            SapTableRow currentRow = (SapTableRow)selection.getFirstElement();
            int rowNum = currentRow.getRowNum();
            currentMethodData = (Operation)((List)this.methods).get(rowNum);
            methodName = currentMethodData.getObjectId();
        }
        String[] parameters = new String[]{this.parent.getBaseObject(), bomSystemName, applicationName, serviceName, methodName, ""};
        if (this.operationsViewer == null) {
            this.operationsViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer.getComposite(), new PropertyMap[0], true);
        }
        ExternalInterfaceOperationsTreeFilter filter = new ExternalInterfaceOperationsTreeFilter(bomSystemName, applicationName, serviceName, methodName);
        this.operationsViewer.setFilter((IFilter)filter);
        int i = 0;
        while (i < this.operationsViewer.getRoots().length) {
            this.operationsViewer.removeRoot(this.operationsViewer.getRoots()[i]);
            ++i;
        }
        UniqueName serviceCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "ES Operations Parameters Subdomain", null, mTextPool.getText("BOM_OPERATION_TREE_0001"), parameters);
        Model model = ModelAccess.createModel((UniqueName)serviceCatalog);
        this.operationsViewer.addRoot((PropertyMap)model);
        this.operationsViewer.getTreeViewer().setSorter(null);
        this.operationsViewer.getTreeViewer().expandAll();
    }

    private OperationTableModel initializeTableModel() {
        this.methods = this.parent.getMethodsData();
        Object[][] methodData = new Object[this.methods.size()][tableColumnNames.length];
        int i = 0;
        Iterator methodsIterator = this.methods.iterator();
        while (methodsIterator.hasNext()) {
            Operation currentMethodData = (Operation)methodsIterator.next();
            methodData[i][0] = currentMethodData.getObjectName();
            methodData[i][1] = currentMethodData.getShortText() == null ? "" : currentMethodData.getShortText();
            ++i;
        }
        this.defTableModel = new OperationTableModel(methodData, tableColumnNames);
        return this.defTableModel;
    }

    public void addSelectionProvider(ExternalInterfaceEditor editor) {
        ElementWrapperSelectionConverter converter = new ElementWrapperSelectionConverter((ISelectionProvider)new ExternalOperationSelectionMediator(), new IElementWrapperConverter(){

            public IElementWrapper getWrapper(Object object) {
                if (object instanceof Element) {
                    return new DefaultElementWrapper((Element)object);
                }
                return null;
            }
        });
        editor.getEditorSite().setSelectionProvider((ISelectionProvider)converter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ExternalOperationSelectionMediator
    implements ISelectionProvider,
    ISelectionChangedListener {
        private ISelection selection;
        private HashSet myListeners = new HashSet();

        public ExternalOperationSelectionMediator() {
            ExternalInterfaceEditorOperationsPage.this.tableViewerEIMethods.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            ExternalInterfaceEditorOperationsPage.this.operationsViewer.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setSelection(event.getSelection());
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                ISelectionChangedListener c = (ISelectionChangedListener)it.next();
                c.selectionChanged(event);
            }
        }
    }

    class OperationTableModel
    extends DefaultTableModel {
        public OperationTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Object aValue, int row, int column) {
            try {
                Operation currentMethodData = (Operation)((List)ExternalInterfaceEditorOperationsPage.this.methods).get(row);
                currentMethodData.setShortText("" + aValue);
                super.setValueAt(aValue, row, column);
            }
            catch (Exception e) {
                logger.errorT(e.toString());
                return;
            }
        }
    }

    private class MethodTabListener
    extends SelectionAdapter {
        private MethodTabListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget selectedWidget = e.widget;
            if (selectedWidget == ExternalInterfaceEditorOperationsPage.this.tableViewerEIMethods.getTable()) {
                ExternalInterfaceEditorOperationsPage.this.selection = (IStructuredSelection)ExternalInterfaceEditorOperationsPage.this.tableViewerEIMethods.getTableViewer().getSelection();
                if (!ExternalInterfaceEditorOperationsPage.this.selection.equals(ExternalInterfaceEditorOperationsPage.this.selectionOld)) {
                    ExternalInterfaceEditorOperationsPage.this.createOperationsTree(ExternalInterfaceEditorOperationsPage.this.treeViewer, ExternalInterfaceEditorOperationsPage.this.selection);
                    ExternalInterfaceEditorOperationsPage.this.selectionOld = ExternalInterfaceEditorOperationsPage.this.selection;
                }
            }
        }
    }
}

