/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.ReferenceCounter;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ExternalInterfaceEditorConfigurationPage;
import com.sap.caf.designer.editors.ExternalInterfaceEditorGeneralPage;
import com.sap.caf.designer.editors.ExternalInterfaceEditorInput;
import com.sap.caf.designer.editors.ExternalInterfaceEditorOperationsPage;
import com.sap.caf.designer.editors.IObjectData;
import com.sap.caf.designer.editors.JavaContentOutlinePage;
import com.sap.caf.designer.exception.CAFPartInitException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.utils.DateUtils;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.Entry;
import com.sap.caf.metamodel.EntryImpl;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Properties;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ExternalInterfaceEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ModifyListener,
SelectionListener,
IObjectData {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static String[] buttonsCaption = new String[]{mTextPool.getText("YES"), mTextPool.getText("NO")};
    private static final int PAGE_GENERAL = 0;
    private static final int PAGE_OPERATIONS = 1;
    private static final int RFC_SERVICE = 0;
    public static final int WEB_SERVICE = 1;
    private static Hashtable instances = new Hashtable();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$ExternalInterfaceEditor == null ? (class$com$sap$caf$designer$editors$ExternalInterfaceEditor = ExternalInterfaceEditor.class$("com.sap.caf.designer.editors.ExternalInterfaceEditor")) : class$com$sap$caf$designer$editors$ExternalInterfaceEditor);
    private String description;
    private String logicalSystemName;
    private boolean indexSearch;
    private ExternalInterfaceEditorGeneralPage generalPage;
    private ExternalInterfaceEditorConfigurationPage configurationPage;
    private ExternalInterfaceEditorOperationsPage operationsPage;
    private IGridLayoutPane mainPane;
    private boolean isNewExternalService;
    private BOMSystem bos;
    public String username = System.getProperty("user.name");
    boolean dirty = false;
    private int previousPageIndex = -1;
    private ExternalInterfaceEditorInput externalInterfaceEditorInput;
    private ExternalInterface externalInterface;
    private JavaContentOutlinePage outline;
    private BOMSystem.BOMListener m_BOMListener = null;
    private String objName;
    private boolean isForDelete = false;
    private String _projectName;
    ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        }
    };
    IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
        }
    };
    static /* synthetic */ Class class$com$sap$caf$designer$editors$ExternalInterfaceEditor;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public ExternalInterfaceEditor() {
        ReferenceCounter.increaseReferenceCounter();
    }

    public String getAppName() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getBomSystem().getApplicationName());
    }

    public BOMSystem getBOMSystem() {
        return this.bos;
    }

    public void setDirty(boolean dirty) {
        logger.infoT("dirty? " + dirty);
        if (this.dirty != dirty) {
            this.dirty = dirty;
            if (dirty) {
                MetamodelProvider.setDirtyOn(this.getProjectName());
                this.bos.getModifiedServicesList().objectModified((BaseObject)this.externalInterface);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static ExternalInterfaceEditor getExternalInterfaceEditor(String appName, String objName) {
        String key = appName + ':' + objName;
        return (ExternalInterfaceEditor)instances.get(key);
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ExternalInterfaceEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            return this.outline;
        }
        return super.getAdapter(required);
    }

    public String getBaseObject() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getBaseObject().getObjectName());
    }

    public String getChangedBy() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getLastChangedBy());
    }

    public String getChangedOn() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getLastChangedAt());
    }

    public ExternalInterfaceEditorConfigurationPage getCongigurationPage() {
        return this.configurationPage;
    }

    public String getCreatedBy() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getCreatedBy());
    }

    public String getCreatedOn() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getCreatedAt());
    }

    public String getDescription() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getShortText());
    }

    public boolean isDispose() {
        CTabFolder tabFolder;
        int iNumPages = this.getPageCount();
        if (iNumPages != 0 && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed()) {
            int ic1 = 0;
            while (ic1 < iNumPages) {
                CTabItem item = tabFolder.getItem(ic1);
                if (item == null || item.isDisposed()) {
                    return true;
                }
                ++ic1;
            }
            return false;
        }
        return true;
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 0: {
                this.generalPage.setFocus();
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.generalPage.setFocus();
            }
        }
    }

    public String getGUID() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getObjectId());
    }

    public ExternalInterfaceEditorGeneralPage getGeneralPage() {
        return this.generalPage;
    }

    public boolean getIndexSearch() {
        if (this.isNewExternalService) {
            return this.indexSearch;
        }
        return false;
    }

    public boolean getLocalPersistency() {
        return false;
    }

    public Collection getMethodsData() {
        return this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getOperations();
    }

    public String getObjectName() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getObjectName());
    }

    public String getPackageName() {
        return ExternalInterfaceEditor.nullToEmpty(null);
    }

    public boolean isPageDispose(int iPageIndex) {
        CTabItem item;
        CTabFolder tabFolder;
        if (iPageIndex >= 0 && iPageIndex < this.getPageCount() && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed() && (item = tabFolder.getItem(iPageIndex)) != null) {
            return item.isDisposed();
        }
        return true;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public String getRelease() {
        return ExternalInterfaceEditor.nullToEmpty(null);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getSelAttributes() {
        return ExternalInterfaceEditor.nullToEmpty(null);
    }

    public String getStatus() {
        return ExternalInterfaceEditor.nullToEmpty(null);
    }

    public int getSystemType() {
        return this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getType();
    }

    public String getTechnicalIdentifier() {
        return ExternalInterfaceEditor.nullToEmpty(this.externalInterfaceEditorInput.getCAFExternalInterface().getTechnicalIdentifier());
    }

    public String getVersion() {
        return ExternalInterfaceEditor.nullToEmpty(null);
    }

    public boolean getVersionable() {
        return false;
    }

    public void dispose() {
        if (this.isNewExternalService && !this.isForDelete) {
            MessageDialog dialog = new MessageDialog(null, mTextPool.getText("SAVE_TITLE_0001"), null, mTextPool.getText("ESD_BOWZRD_0001"), 3, buttonsCaption, 0);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                this.bos.deleteBOByName();
                this.setDirty(false);
            }
        }
        this.bos.removeSystemListener(this.m_BOMListener);
        this.generalPage = null;
        this.operationsPage = null;
        this.configurationPage = null;
        String key = this.externalInterfaceEditorInput.getName();
        instances.remove(key);
        ReferenceCounter.decreaseReferenceCounter();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(mTextPool.getText("BOM_ALL_0019"), 3);
        logger.infoT("Start saving..." + this.objName);
        monitor.worked(1);
        this.externalInterface.setShortText(this.generalPage.getDescription());
        this.externalInterface.setLastChangedAt(DateUtils.getTimeStampDateAsString(this.generalPage.getChangedAt()));
        this.externalInterface.setLastChangedBy(this.generalPage.getChangedBy());
        Properties pr = this.externalInterface.getConfiguration().getProperties();
        Collection entries = pr.getEntries();
        boolean added = false;
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!"logicalSystemName".equalsIgnoreCase(entry.getKey())) continue;
            if (this.configurationPage != null) {
                entry.setValue(this.configurationPage.getRfcLogicalSystemName());
            }
            added = true;
        }
        if (!added) {
            MetamodelPackage metamodelPackage = this.bos.getMetamodelPackage();
            Entry newEntry = metamodelPackage.getEntry().createEntry();
            newEntry.setKey("logicalSystemName");
            if (this.configurationPage != null) {
                newEntry.setValue(this.configurationPage.getRfcLogicalSystemName());
            }
            pr.getEntries().add(newEntry);
        }
        this.externalInterface.setLastChangedAt(DateUtils.getTimeStampDateAsString(new Date()));
        this.externalInterface.setLastChangedBy(this.username);
        monitor.worked(2);
        this.setDirty(false);
        this.externalInterfaceEditorInput.getCAFExternalInterface().setNew(false);
        this.isNewExternalService = false;
        monitor.done();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        this.getEditor(0).gotoMarker(marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws CAFPartInitException {
        if (editorInput instanceof ExternalInterfaceEditorInput) {
            this.externalInterfaceEditorInput = (ExternalInterfaceEditorInput)editorInput;
            this.isNewExternalService = this.externalInterfaceEditorInput.getCAFExternalInterface().isNew();
            this._projectName = this.externalInterfaceEditorInput.getCAFExternalInterface().getBomSystem().getProjectName();
            this.description = this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getShortText();
            Properties pr = this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface().getConfiguration().getProperties();
            Collection entries = pr.getEntries();
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                EntryImpl entry = (EntryImpl)i.next();
                if (entry == null || entry.getKey() == null || !entry.getKey().equalsIgnoreCase("logicalSystemName")) continue;
                this.logicalSystemName = ExternalInterfaceEditor.nullToEmpty(entry.getValue());
            }
            this.bos = this.externalInterfaceEditorInput.getCAFExternalInterface().getBomSystem();
            this.externalInterface = this.externalInterfaceEditorInput.getCAFExternalInterface().getExternalInterface();
            this.objName = this.externalInterface.getObjectName();
            if (this.isNewExternalService) {
                logger.infoT("app editor . init isNew=true" + this.objName);
                this.externalInterface.setCreatedBy(this.username);
                this.externalInterface.setCreatedAt(DateUtils.getTimeStampDateAsString(new Date()));
                this.externalInterface.setLastChangedAt(DateUtils.getTimeStampDateAsString(new Date()));
                this.externalInterface.setLastChangedBy(this.username);
                this.externalInterface.setBeanState(new Integer(0));
            }
        } else {
            throw new CAFPartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.m_BOMListener = new BOMSystemListener();
        this.bos.addSystemListener(this.m_BOMListener);
        super.setTitle(this.externalInterface.getObjectName());
        try {
            super.init(site, editorInput);
        }
        catch (PartInitException pie) {
            throw new CAFPartInitException(pie);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setDirty(true);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.setDirty(true);
    }

    public void saveExternalServicesChanges() {
        this.saveDataBeforImplementation();
        this.setDirty(false);
        this.isNewExternalService = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    protected void createPages() {
        this.createPageGeneral();
        this.createPageOperations();
        if (this.getSystemType() == 0) {
            this.createPageConfiguration();
        }
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 0) {
            this.generalPage.setFocus();
        }
        if (newPageIndex == 1) {
            // empty if block
        }
        this.previousPageIndex = newPageIndex;
    }

    void createPageConfiguration() {
        String labelString = mTextPool.getText("BOM_TITLE_0019");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.configurationPage = new ExternalInterfaceEditorConfigurationPage();
        this.configurationPage.createTabContents(this.mainPane, this);
    }

    void createPageGeneral() {
        String labelString = mTextPool.getText("BOM_TITLE_0008");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.generalPage = new ExternalInterfaceEditorGeneralPage();
        this.generalPage.createTabContents(this.mainPane, this);
    }

    void createPageOperations() {
        String labelString = mTextPool.getText("BOM_TITLE_0020");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.operationsPage = new ExternalInterfaceEditorOperationsPage();
        this.operationsPage.createTabContents(this.mainPane, this);
        this.operationsPage.addSelectionProvider(this);
    }

    private static final String nullToEmpty(Object o) {
        return o == null ? "" : o.toString();
    }

    private void deleteEditor() {
        this.dirty = false;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
    }

    private void saveDataBeforImplementation() {
        logger.infoT("Start saving..." + this.objName);
        this.externalInterface.setShortText(this.generalPage.getDescription());
        this.externalInterface.setLastChangedAt(DateUtils.getTimeStampDateAsString(this.generalPage.getChangedAt()));
        this.externalInterface.setLastChangedBy(this.generalPage.getChangedBy());
        Properties pr = this.externalInterface.getConfiguration().getProperties();
        Collection entries = pr.getEntries();
        boolean added = false;
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            EntryImpl entry = (EntryImpl)i.next();
            if (!entry.getKey().equalsIgnoreCase("logicalSystemName")) continue;
            entry.setValue(this.configurationPage.getRfcLogicalSystemName());
            added = true;
        }
        if (!added) {
            MetamodelPackage metamodelPackage = this.bos.getMetamodelPackage();
            Entry newEntry = metamodelPackage.getEntry().createEntry();
            newEntry.setKey("logicalSystemName");
            newEntry.setValue(this.configurationPage.getRfcLogicalSystemName());
            entries.add(newEntry);
        }
        this.externalInterface.setLastChangedAt(DateUtils.getTimeStampDateAsString(new Date()));
        this.externalInterface.setLastChangedBy(this.username);
        this.setDirty(false);
        this.externalInterfaceEditorInput.getCAFExternalInterface().setNew(false);
        this.isNewExternalService = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BOMSystemListener
    implements BOMSystem.BOMListener {
        protected BOMSystemListener() {
        }

        public void systemChanged(BOMSystem.BOMEvent e) {
            switch (e.getType()) {
                case 16: {
                    if (e.getTarget() == null || !(e.getTarget() instanceof CAFExternalInterface)) break;
                    CAFExternalInterface delInt = (CAFExternalInterface)e.getTarget();
                    if (!ExternalInterfaceEditor.this.objName.equals(delInt.getExternalInterface().getObjectName())) break;
                    ExternalInterfaceEditor.this.isForDelete = true;
                    ExternalInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 40: {
                    ExternalInterfaceEditor.this.isForDelete = true;
                    if (ExternalInterfaceEditor.this.isDispose()) {
                        ExternalInterfaceEditor.this.setDirty(false);
                        break;
                    }
                    ExternalInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 5: {
                    String strProjectName;
                    if (ExternalInterfaceEditor.this.isDispose() || !(e.getTarget() instanceof String) || !(strProjectName = (String)e.getTarget()).equals(ExternalInterfaceEditor.this._projectName)) break;
                    ExternalInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 17: {
                    if (!ExternalInterfaceEditor.this.isDispose()) break;
                    break;
                }
                case 1: {
                    if (!ExternalInterfaceEditor.this.dirty) break;
                    ExternalInterfaceEditor.this.saveExternalServicesChanges();
                    break;
                }
                case 4: {
                    if (ExternalInterfaceEditor.this.isDispose()) break;
                    ExternalInterfaceEditor.this.setDirty(false);
                    ExternalInterfaceEditor.this.deleteEditor();
                    break;
                }
            }
        }
    }

    protected class FocusListener
    extends FocusAdapter {
        protected FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
        }
    }
}

