/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.TableName;
import com.sap.caf.designer.structure.TableNameGenerator;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BusinessEntityInterfacePersistencyPage {
    private static final TextPool m_TextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$BusinessEntityInterfacePersistencyPage == null ? (class$com$sap$caf$designer$editors$BusinessEntityInterfacePersistencyPage = BusinessEntityInterfacePersistencyPage.class$("com.sap.caf.designer.editors.BusinessEntityInterfacePersistencyPage")) : class$com$sap$caf$designer$editors$BusinessEntityInterfacePersistencyPage);
    ISapTableViewer tableViewer;
    DefaultTableModel defTableModel = null;
    private BusinessEntityInterfaceEditor parent = null;
    private CAFBusinessEntityInterface cbei = null;
    private BusinessEntityInterface bei = null;
    Table[] tableArrayDisplayed = null;
    private Button LPGroupCheckBox;
    private boolean m_bPersistency;
    private Object[] tabColumnNames = new Object[]{m_TextPool.getText("BOM_PERSISTENCY_0004"), m_TextPool.getText("BOM_PERSISTENCY_0002"), m_TextPool.getText("BOM_PERSISTENCY_0005")};
    static /* synthetic */ Class class$com$sap$caf$designer$editors$BusinessEntityInterfacePersistencyPage;

    BusinessEntityInterfacePersistencyPage() {
    }

    public static IFile getDDicTableFile(IProject pddic, String tableName) {
        String relFilePath = "src/packages/" + tableName + ".dtdbtable";
        Path path = new Path(relFilePath);
        return pddic.getFile((IPath)path);
    }

    public boolean checkIfTableNameEditable(String tableName) {
        IFile tablefile;
        IProject pddic;
        String ddicPrjName;
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (myWorkspaceRoot != null && (ddicPrjName = this.cbei.getBomSystem().getRelatedProjectNameByType("DICT")) != null && ddicPrjName.length() > 0 && (pddic = myWorkspaceRoot.getProject(ddicPrjName)) != null && (tablefile = BusinessEntityInterfacePersistencyPage.getDDicTableFile(pddic, tableName)) != null) {
            boolean bFileInDTR = DtrService.isFileInDtr(pddic, tablefile);
            return !bFileInDTR;
        }
        return true;
    }

    public void createTabContents(IGridLayoutPane tabPane, final BusinessEntityInterfaceEditor boe) {
        this.parent = boe;
        String objName = boe.getObjectName();
        this.cbei = this.parent.getCAFBusinessEntityInterface();
        this.bei = this.parent.getBusinessEntityInterface();
        ISashPane topSashPane = tabPane.addHorizontalSashPane(tabPane.createGridLayoutData(4, 4, false, false, 1, 1));
        IGridLayoutPane leftgridPane = topSashPane.addGridLayoutPane(1, false);
        this.m_bPersistency = this.bei.getBackend() == 0;
        this.LPGroupCheckBox = leftgridPane.addCheckBox(m_TextPool.getText("BOM_PERSISTENCY_0001"), this.m_bPersistency, leftgridPane.createGridLayoutData(4, 2, true, false, 6, 1));
        this.LPGroupCheckBox.setToolTipText(m_TextPool.getText("BOM_PERSISTENCY_0001"));
        this.LPGroupCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BusinessEntityInterfacePersistencyPage.this.m_bPersistency = BusinessEntityInterfacePersistencyPage.this.LPGroupCheckBox.getSelection();
                BusinessEntityInterfacePersistencyPage.this.bei.setBackend(new Integer(BusinessEntityInterfacePersistencyPage.this.m_bPersistency ? 0 : 1));
                BusinessEntityInterfacePersistencyPage.this.cbei.changePersistency(BusinessEntityInterfacePersistencyPage.this.bei.getBackend());
                boe.setDatasourceEnabled(!BusinessEntityInterfacePersistencyPage.this.m_bPersistency);
                BusinessEntityInterfacePersistencyPage.this.refreshTableModel();
            }
        });
        this.LPGroupCheckBox.addSelectionListener((SelectionListener)this.parent);
        this.LPGroupCheckBox.setSelection(this.m_bPersistency);
        ISashPane bottomSashPane = tabPane.addHorizontalSashPane(tabPane.createGridLayoutData(4, 4, true, true, 1, 1));
        IGridLayoutPane groupbottomGrid = bottomSashPane.addGridLayoutPane(10);
        groupbottomGrid.addTextLabel(m_TextPool.getText("BOM_PERSISTENCY_0003"));
        String objNameUpper = objName.toUpperCase();
        if (this.tabColumnNames.length != 3) {
            throw new CAFRuntimeException("Program Error: Unexpected number of columns.");
        }
        this.defTableModel = new DefaultTableModel(this.getTablesData(), this.tabColumnNames){

            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 1: {
                        return BusinessEntityInterfacePersistencyPage.this.checkIfTableNameEditable(BusinessEntityInterfacePersistencyPage.this.getSelectedTableName(row));
                    }
                }
                return false;
            }
        };
        this.defTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int nRow = e.getFirstRow();
                int nCol = e.getColumn();
                switch (nCol) {
                    case 1: {
                        if (!BusinessEntityInterfacePersistencyPage.this.updateTableName(nRow)) break;
                        BusinessEntityInterfacePersistencyPage.this.parent.setDirty(true);
                    }
                }
            }
        });
        this.tableViewer = groupbottomGrid.addSapTableViewer((TableModel)this.defTableModel, groupbottomGrid.createGridLayoutData(4, 4, true, true, 10, 1));
        ColumnWeightData c1Layout = new ColumnWeightData(1, true);
        ColumnWeightData c2Layout = new ColumnWeightData(2, true);
        ColumnWeightData c3Layout = new ColumnWeightData(9, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        layout.addColumnData((ColumnLayoutData)c3Layout);
        this.tableViewer.getTable().setLayout((Layout)layout);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
    }

    public void refreshTableModel() {
        int rowCounter = this.defTableModel.getRowCount();
        int ic1 = rowCounter - 1;
        while (ic1 >= 0) {
            this.defTableModel.removeRow(ic1);
            --ic1;
        }
        Object[][] tabData = this.getTablesData();
        rowCounter = tabData.length;
        ic1 = 0;
        while (ic1 < rowCounter) {
            this.defTableModel.addRow(tabData[ic1]);
            ++ic1;
        }
    }

    DefaultTableModel getTableModel() {
        return this.defTableModel;
    }

    private String getNewTableNameInput(int nRow) {
        return (String)this.defTableModel.getDataVector().elementAt(nRow).elementAt(1);
    }

    private String getNewTablePrefixInput(int nRow) {
        return (String)this.defTableModel.getDataVector().elementAt(nRow).elementAt(0);
    }

    private String getSelectedTableName(int nRow) {
        String tableprefix = this.getNewTablePrefixInput(nRow);
        String selectedTableName = tableprefix + this.getNewTableNameInput(nRow);
        return selectedTableName;
    }

    private Object[][] getTablesData() {
        TreeMap<String, Table> clTableNames = new TreeMap<String, Table>();
        Table mastertable = this.bei.getBusinessEntity().getMasterTable();
        clTableNames.put(mastertable.getTableName(), mastertable);
        List attrs = this.cbei.readCurrentAttributes();
        Iterator objIt = attrs.iterator();
        boolean isLocal = this.bei.getBackend() == 0;
        while (objIt.hasNext()) {
            Table table = null;
            Attribute attr = (Attribute)objIt.next();
            try {
                if (isLocal && CAFBusinessEntityInterface.isComplexAttribute(attr)) {
                    table = ((Field)((Property)attr).getField().iterator().next()).getTable();
                } else if (CAFBusinessEntityInterface.isEntityAttribute(attr)) {
                    table = ((Field)((Property)attr).getField().iterator().next()).getTable();
                } else if (attr instanceof Property && ((Property)attr).isLanguageDependent().booleanValue() && isLocal) {
                    table = CAFBusinessEntityInterface.getLanguageTable(this.bei.getBusinessEntity());
                } else if (attr.getMaxOccurs() < 0 && isLocal) {
                    table = ((Field)((Property)attr).getField().iterator().next()).getTable();
                }
                if (table == null) continue;
                clTableNames.put(table.getTableName(), table);
            }
            catch (Exception ex) {
                logger.errorT("Attribute get table failed:" + (attr == null ? "null" : attr.getObjectName()));
                ex.printStackTrace();
            }
        }
        Object[][] tabData = new Object[clTableNames.size()][this.tabColumnNames.length];
        this.tableArrayDisplayed = new Table[clTableNames.size()];
        Iterator iterTableNames = clTableNames.keySet().iterator();
        int ic1 = 0;
        while (iterTableNames.hasNext()) {
            String tableName = (String)iterTableNames.next();
            TableName tn = new TableName(tableName);
            tabData[ic1][0] = tn.nameprefix;
            tabData[ic1][1] = tn.name;
            Object o = clTableNames.get(tableName);
            Table table = (Table)o;
            tabData[ic1][2] = table.getTableDescription();
            this.tableArrayDisplayed[ic1] = table;
            ++ic1;
        }
        return tabData;
    }

    private boolean updateTableName(int nRow) {
        boolean bResModified = false;
        String newUserInput = this.getNewTableNameInput(nRow).trim().toUpperCase();
        Table table = this.tableArrayDisplayed[nRow];
        String tableprefix = this.getNewTablePrefixInput(nRow);
        String newUserTableName = tableprefix + newUserInput;
        String oldTableName = table.getTableName();
        if (!oldTableName.equals(newUserTableName)) {
            try {
                boolean[] bIterated = new boolean[1];
                String newProposedByTheSystem = this.cbei.createTableName(newUserInput, "", bIterated);
                if (bIterated[0]) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)m_TextPool.getText("BOM_PERSISTENCY_0009"), (String)m_TextPool.getText("BOM_PERSISTENCY_0010"));
                }
                table.setTableName(newProposedByTheSystem);
                this.defTableModel.getDataVector().elementAt(nRow).set(1, newProposedByTheSystem.substring(tableprefix.length()));
                CAFBusinessEntityInterface.unregisterTableName(oldTableName);
                bResModified = true;
            }
            catch (TableNameGenerator.InvalidNameArgument ex) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)m_TextPool.getText("BOM_PERSISTENCY_0006"), (String)m_TextPool.getText("BOM_PERSISTENCY_0007"));
                this.defTableModel.getDataVector().elementAt(nRow).set(1, oldTableName.substring(tableprefix.length()));
            }
            catch (CAFResourceException ex) {
                ((Throwable)((Object)ex)).printStackTrace();
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)m_TextPool.getText("BOM_PERSISTENCY_0006"), (String)m_TextPool.getText("BOM_PERSISTENCY_0008", new String[]{((Throwable)((Object)ex)).getMessage()}));
                this.defTableModel.getDataVector().elementAt(nRow).set(1, oldTableName.substring(tableprefix.length()));
            }
        }
        return bResModified;
    }

    public void refreshPage() {
        this.refreshTableModel();
        this.m_bPersistency = this.bei.getBackend() == 0;
        this.parent.setDatasourceEnabled(!this.m_bPersistency);
        this.LPGroupCheckBox.setSelection(this.m_bPersistency);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

