/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.editors.ReadOnlyTableModel;
import com.sap.caf.designer.model.EntityInterfaceOperationsTreeFilter;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFOperation;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.caf.designer.wizards.MethodWizard;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BusinessEntityInterfaceMethodsPage {
    private IWorkbenchWindow window;
    private IGridLayoutPane tabPane;
    private ISapTableViewer tableViewerBEMethods;
    private ReadOnlyTableModel defTableModel;
    private int selectedMethod = -1;
    private Text methodName;
    private Text methodDescription;
    private Combo methodReturnType;
    private Button addMethodButton;
    private Button removeMethodButton;
    private Button editMethodButton;
    private Button paramTypeBrowseButton;
    private Button addToParamListButton;
    private Button deleteFromParamListButton;
    private DoubleClickListener doubleClickListener = new DoubleClickListener();
    private MethodTabListener listener = new MethodTabListener();
    private String boName;
    private String projectName;
    private BusinessEntityInterfaceEditor parent = null;
    private BusinessEntityInterface bei = null;
    private CAFBusinessEntityInterface cbei = null;
    private BOMSystem bos = null;
    private GenericDataModelFilteredTreeViewer operationsViewer;
    private IStructuredSelection selectionOld = null;
    private IStructuredSelection selection;
    private ISashPane treeViewer;
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Collection RESERVEDOperations = Arrays.asList(CAFBusinessEntityInterface.RESERVEDOperations);
    private static final Object[] tableColumnNames = new Object[]{mTextPool.getText("BOM_METHODWZRD_0018"), mTextPool.getText("BOM_METHODWZRD_0001"), mTextPool.getText("BOM_METHODWZRD_0033"), mTextPool.getText("BOM_METHODWZRD_0011")};
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$editors$BusinessEntityInterfaceMethodsPage == null ? (class$com$sap$caf$designer$editors$BusinessEntityInterfaceMethodsPage = BusinessEntityInterfaceMethodsPage.class$("com.sap.caf.designer.editors.BusinessEntityInterfaceMethodsPage")) : class$com$sap$caf$designer$editors$BusinessEntityInterfaceMethodsPage));
    static /* synthetic */ Class class$com$sap$caf$designer$editors$BusinessEntityInterfaceMethodsPage;

    public void createTabContents(IGridLayoutPane tabPane, BusinessEntityInterfaceEditor boe) {
        this.parent = boe;
        this.bos = this.parent.getBOMSystem();
        this.bei = this.parent.getBusinessEntityInterface();
        this.cbei = this.parent.getCAFBusinessEntityInterface();
        this.projectName = boe.getProjectName();
        this.boName = boe.getObjectName();
        this.tabPane = tabPane;
        ISashPane outerSashPane = tabPane.addVerticalSashPane(tabPane.createGridLayoutData(4, 4, true, true, 20, 1));
        ISashPane topSashPane = outerSashPane.addHorizontalSashPane();
        ISashPane lefttopSashPane = topSashPane.addVerticalSashPane();
        IGridLayoutPane grouplefttopGrid = lefttopSashPane.addGridLayoutPane(10);
        grouplefttopGrid.addTextLabel(mTextPool.getText("BOM_METHODS_0012"), grouplefttopGrid.createGridLayoutData(1, 2, 20, 1));
        IGridLayoutPane methodTopLevelPane = outerSashPane.addGridLayoutPane(mTextPool.getText("BOM_METHODS_0012"), 1, true);
        this.tableViewerBEMethods = grouplefttopGrid.addSapTableViewer((TableModel)this.initializeTableModel(), grouplefttopGrid.createGridLayoutData(4, 4, true, true, 10, 1));
        this.tableViewerBEMethods.getTable().getColumn(0).setWidth(125);
        this.tableViewerBEMethods.getTable().getColumn(2).setWidth(150);
        this.tableViewerBEMethods.getTable().addSelectionListener((SelectionListener)this.listener);
        this.tableViewerBEMethods.getTable().addMouseListener((MouseListener)this.doubleClickListener);
        this.tableViewerBEMethods.getTable().getColumn(3).setWidth(150);
        ISashPane righttopSashPane = topSashPane.addVerticalSashPane();
        IGridLayoutPane grouprighttopGrid = righttopSashPane.addGridLayoutPane(1);
        grouprighttopGrid.addPlaceholder(1, 1);
        this.addMethodButton = grouprighttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0001"), grouprighttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.addMethodButton.addSelectionListener((SelectionListener)new AddButtonListener());
        this.editMethodButton = grouprighttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0012"), grouprighttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.editMethodButton.addSelectionListener((SelectionListener)new EditButtonListener());
        this.removeMethodButton = grouprighttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0006"), grouprighttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.removeMethodButton.addSelectionListener((SelectionListener)new RemoveButtonListener());
        topSashPane.setWeights(new int[]{10, 2});
        ISashPane bottomSashPane = outerSashPane.addVerticalSashPane();
        IGridLayoutPane bottomGrid = bottomSashPane.addGridLayoutPane(1, false);
        bottomGrid.addTextLabel(mTextPool.getText("BOM_OPERATIONS_TREE_0001"), bottomGrid.createGridLayoutData(4, 4, 1, 1));
        this.treeViewer = bottomGrid.addHorizontalSashPane(bottomGrid.createGridLayoutData(4, 4, true, true));
        this.createOperationsTree(this.treeViewer, null);
    }

    private void createOperationsTree(ISashPane treeViewer, IStructuredSelection selection) {
        String bomSystemName = this.parent.getBOMSystem().getProjectName();
        String applicationName = this.parent.getAppName();
        String serviceName = this.parent.getObjectName();
        String methodName = "";
        Operation currentMethodData = null;
        if (selection != null) {
            SapTableRow currentRow = (SapTableRow)selection.getFirstElement();
            int rowNum = currentRow.getRowNum();
            currentMethodData = (Operation)this.bei.getOperations().get(rowNum);
            methodName = currentMethodData.getObjectId();
        }
        String[] parameters = new String[]{this.parent.getBaseObject(), bomSystemName, applicationName, serviceName, methodName, "entityservice"};
        if (this.operationsViewer == null) {
            this.operationsViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer.getComposite(), new PropertyMap[0], true);
        }
        EntityInterfaceOperationsTreeFilter filter = new EntityInterfaceOperationsTreeFilter(bomSystemName, applicationName, serviceName, methodName);
        this.operationsViewer.setFilter((IFilter)filter);
        int i = 0;
        while (i < this.operationsViewer.getRoots().length) {
            this.operationsViewer.removeRoot(this.operationsViewer.getRoots()[i]);
            ++i;
        }
        UniqueName serviceCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Entity Operations Parameters Subdomain", null, mTextPool.getText("BOM_OPERATION_TREE_0001"), parameters);
        Model model = ModelAccess.createModel((UniqueName)serviceCatalog);
        this.operationsViewer.addRoot((PropertyMap)model);
        this.operationsViewer.getTreeViewer().setSorter(null);
        this.operationsViewer.getTreeViewer().expandAll();
    }

    private ReadOnlyTableModel initializeTableModel() {
        int numMethods;
        this.defTableModel = new ReadOnlyTableModel(new Object[0][tableColumnNames.length], tableColumnNames);
        List methods = this.bei.getOperations();
        int n = numMethods = methods == null ? 0 : methods.size();
        if (numMethods > 0) {
            Object[][] methodData = new Object[numMethods][tableColumnNames.length];
            int i = 0;
            while (i < numMethods) {
                Operation m = (Operation)methods.get(i);
                methodData[i][0] = m.getObjectName();
                methodData[i][1] = "public";
                if ("create".equals(m.getObjectName()) || "read".equals(m.getObjectName())) {
                    methodData[i][2] = this.bei.getBusinessEntity().getObjectName();
                } else {
                    Message msg = m.getOutput();
                    if (msg != null) {
                        Attribute attr;
                        List l = null;
                        l = msg.getMessageParts();
                        methodData[i][2] = l.size() > 0 ? ((attr = (Attribute)l.get(0)).getTypeJavaDdic() != null ? attr.getTypeJavaDdic() : (attr.getMaxOccurs() == -1 ? "Collection" : (attr.getReferencedObject() != null ? attr.getReferencedObject().getObjectName() : "void"))) : "void";
                    } else {
                        methodData[i][2] = "void";
                    }
                }
                methodData[i][3] = m.getShortText();
                ++i;
            }
            this.defTableModel = new ReadOnlyTableModel(methodData, tableColumnNames);
        }
        this.defTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                BusinessEntityInterfaceMethodsPage.this.parent.setDirty(true);
            }
        });
        return this.defTableModel;
    }

    public void fillTableMethods() {
        this.tableViewerBEMethods.setTableModel((TableModel)this.initializeTableModel());
    }

    public static void setStatusLineAdd(String methodNameText) {
        StatusLineMessage slm = new StatusLineMessage();
        slm.printMessage(mTextPool.getText("BOM_METHODS_0005", new Object[]{methodNameText}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RemoveButtonListener
    extends SelectionAdapter {
        protected RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection tableSel = (IStructuredSelection)BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTableViewer().getSelection();
            StatusLineMessage slm = new StatusLineMessage();
            String methodNameText = null;
            Object[] selectedOperations = tableSel.toArray();
            try {
                SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
                String methodLine = ((Object)BusinessEntityInterfaceMethodsPage.this.defTableModel.getDataVector().get(tableRow.getRowNum())).toString();
                int index = 0;
                index = methodLine.indexOf(44);
                methodNameText = methodLine.substring(1, index);
            }
            catch (NullPointerException ne) {
                logger.errorT(((Throwable)ne).getMessage());
            }
            if (methodNameText == null) {
                MessageDialog.openInformation(null, (String)mTextPool.getText("BOM_METHODS_0011"), (String)"Please select operation first!");
                return;
            }
            boolean canDeleteOp = true;
            int i = 0;
            while (i < CAFBusinessEntityInterface.RESERVEDOperations.length) {
                if (methodNameText.equals(CAFBusinessEntityInterface.RESERVEDOperations[i])) {
                    canDeleteOp = false;
                }
                ++i;
            }
            if (canDeleteOp) {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("BOM_METHODS_0013", new Object[]{methodNameText}))) {
                    try {
                        SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
                        String methodLine = ((Object)BusinessEntityInterfaceMethodsPage.this.defTableModel.getDataVector().get(tableRow.getRowNum())).toString();
                        int index = 0;
                        index = methodLine.indexOf(44);
                        methodNameText = methodLine.substring(1, index);
                        BusinessEntityInterfaceMethodsPage.this.defTableModel.removeRow(tableRow.getRowNum());
                        Operation opr = BusinessEntityInterfaceMethodsPage.this.cbei.getOperationByName(methodNameText);
                        if (opr != null) {
                            Operation oprFinfByMultipleParams;
                            new CAFOperation(BusinessEntityInterfaceMethodsPage.this.cbei.getBomSystem(), opr).remove();
                            if (!BusinessEntityInterfaceMethodsPage.this.cbei.hasFyndByOperation() && (oprFinfByMultipleParams = BusinessEntityInterfaceMethodsPage.this.cbei.getOperationByName("findByMultipleParameters")) != null) {
                                new CAFOperation(BusinessEntityInterfaceMethodsPage.this.cbei.getBomSystem(), oprFinfByMultipleParams).remove();
                            }
                            BusinessEntityInterfaceMethodsPage.this.bos.notifyCAFObjectChanged(opr, 29);
                        }
                        slm.printMessage(mTextPool.getText("BOM_METHODS_0007", new Object[]{methodNameText}));
                    }
                    catch (NullPointerException ne) {
                        logger.errorT(((Throwable)ne).getMessage());
                    }
                } else {
                    logger.infoT("Deletion cancelled..." + methodNameText);
                    slm.printMessage(mTextPool.getText("BOM_METHODS_0004"));
                }
            } else {
                MessageDialog.openInformation(null, (String)mTextPool.getText("BOM_METHODS_0011"), (String)(mTextPool.getText("BOM_METHODS_0009") + " '" + methodNameText + "' " + mTextPool.getText("BOM_METHODS_0010")));
            }
        }
    }

    protected class EditButtonListener
    extends SelectionAdapter {
        protected EditButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection tableSel = (IStructuredSelection)BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTableViewer().getSelection();
            String objectType = "BO";
            try {
                SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
                String methodLine = ((Object)BusinessEntityInterfaceMethodsPage.this.defTableModel.getDataVector().get(tableRow.getRowNum())).toString();
                int index = 0;
                index = methodLine.indexOf(44);
                String methodNameText = methodLine.substring(1, index);
                if (!RESERVEDOperations.contains(methodNameText)) {
                    String objName = BusinessEntityInterfaceMethodsPage.this.bei.getBusinessEntity().getObjectName();
                    MethodWizard mw = new MethodWizard(methodNameText, BusinessEntityInterfaceMethodsPage.this.parent);
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)mw);
                    dialog.create();
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        StatusLineMessage slm = new StatusLineMessage();
                        slm.printMessage(mTextPool.getText("BOM_METHODS_0006", new Object[]{methodNameText}));
                    } else {
                        StatusLineMessage slm = new StatusLineMessage();
                        slm.printMessage(mTextPool.getText("BOM_METHODS_0004"));
                    }
                } else {
                    MessageDialog.openInformation(null, (String)mTextPool.getText("BOM_METHODS_0011"), (String)(mTextPool.getText("BOM_METHODS_0009") + " '" + methodNameText + "' " + mTextPool.getText("BOM_METHODS_0008")));
                }
            }
            catch (NullPointerException ne) {
                logger.errorT(((Throwable)ne).getMessage());
            }
        }
    }

    protected class AddButtonListener
    extends SelectionAdapter {
        protected AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String objName = BusinessEntityInterfaceMethodsPage.this.bei.getObjectName();
            String methodName = "";
            String objectType = "BO";
            MethodWizard mw = new MethodWizard(methodName, BusinessEntityInterfaceMethodsPage.this.parent);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)mw);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                StatusLineMessage slm = new StatusLineMessage();
                slm.printMessage(mTextPool.getText("BOM_METHODS_0004"));
            }
        }
    }

    private class MethodTabListener
    extends SelectionAdapter
    implements ModifyListener {
        private MethodTabListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget selectedWidget = e.widget;
            if (selectedWidget == BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTable()) {
                BusinessEntityInterfaceMethodsPage.this.selection = (IStructuredSelection)BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTableViewer().getSelection();
                if (!BusinessEntityInterfaceMethodsPage.this.selection.equals(BusinessEntityInterfaceMethodsPage.this.selectionOld)) {
                    BusinessEntityInterfaceMethodsPage.this.createOperationsTree(BusinessEntityInterfaceMethodsPage.this.treeViewer, BusinessEntityInterfaceMethodsPage.this.selection);
                    BusinessEntityInterfaceMethodsPage.this.selectionOld = BusinessEntityInterfaceMethodsPage.this.selection;
                }
            } else if (selectedWidget == BusinessEntityInterfaceMethodsPage.this.removeMethodButton) {
                // empty if block
            }
        }

        public void modifyText(ModifyEvent e) {
            Widget widget = e.widget;
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Widget selectedWidget = e.widget;
            if (selectedWidget == BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTable()) {
                IStructuredSelection tableSel = (IStructuredSelection)BusinessEntityInterfaceMethodsPage.this.tableViewerBEMethods.getTableViewer().getSelection();
                String objectType = "BO";
                try {
                    SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
                    String methodLine = ((Object)BusinessEntityInterfaceMethodsPage.this.defTableModel.getDataVector().get(tableRow.getRowNum())).toString();
                    int index = 0;
                    index = methodLine.indexOf(44);
                    String methodNameText = methodLine.substring(1, index);
                    if (methodNameText.equals("validate")) {
                        MessageDialog.openInformation(null, (String)mTextPool.getText("BOM_METHODS_0011"), (String)(mTextPool.getText("BOM_METHODS_0009") + " '" + methodNameText + "' " + mTextPool.getText("BOM_METHODS_0008")));
                    }
                }
                catch (NullPointerException ne) {
                    logger.errorT(((Throwable)ne).getMessage());
                }
            }
        }
    }
}

