/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.ReferenceCounter;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceAttributesPage;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditorInput;
import com.sap.caf.designer.editors.BusinessEntityInterfaceGeneralPage;
import com.sap.caf.designer.editors.BusinessEntityInterfaceMethodsPage;
import com.sap.caf.designer.editors.BusinessEntityInterfacePermissionsPage;
import com.sap.caf.designer.editors.BusinessEntityInterfacePersistencyPage;
import com.sap.caf.designer.editors.IObjectData;
import com.sap.caf.designer.editors.ImplementationProvider;
import com.sap.caf.designer.editors.JavaContentOutlinePage;
import com.sap.caf.designer.editors.datasource.DatasourcePage;
import com.sap.caf.designer.exception.CAFPartInitException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.utils.DateUtils;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.omg.cwm.objectmodel.core.MOFClass;

public class BusinessEntityInterfaceEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ModifyListener,
SelectionListener,
IObjectData {
    private String objName;
    private String appName;
    private String baseObjName;
    private String ownerName;
    private String[][] selAttributes;
    private boolean localPersistency;
    private boolean indexSearch;
    private static final TextPool mTextPool = TextPool.getInstance();
    private BusinessEntityInterfaceGeneralPage generalPage;
    private BusinessEntityInterfaceAttributesPage attributesPage;
    private BusinessEntityInterfaceMethodsPage methodsPage;
    private BusinessEntityInterfacePersistencyPage m_PersistencyPage;
    private BusinessEntityInterfacePermissionsPage m_PermissionsPage;
    private DatasourcePage datasourcePage;
    private ImplementationProvider m_implp;
    private IGridLayoutPane mainPane;
    private boolean isNewBO;
    private BOMSystem bos;
    public String username = System.getProperty("user.name");
    boolean dirty = false;
    private int previousPageIndex = -1;
    private BusinessEntityInterfaceEditorInput mei;
    private JavaContentOutlinePage outline;
    private BOMSystem.BOMListener m_BOMListener = null;
    private BusinessEntityInterface bei = null;
    private CAFBusinessEntityInterface cbei = null;
    private boolean isForDelete = false;
    private String _projectName;
    private static final int PAGE_GENERAL = 0;
    private static final int PAGE_ATTRIBUTES = 1;
    private static final int PAGE_METHODS = 2;
    private static final int PAGE_PERSISTENCY = 3;
    private static final int PAGE_PROXY = 4;
    private static final int PAGE_PERMISSIONS = 5;
    private static final int PAGE_IMPLEMENTATION = 6;
    private static Hashtable instances = new Hashtable();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$BusinessEntityInterfaceEditor == null ? (class$com$sap$caf$designer$editors$BusinessEntityInterfaceEditor = BusinessEntityInterfaceEditor.class$("com.sap.caf.designer.editors.BusinessEntityInterfaceEditor")) : class$com$sap$caf$designer$editors$BusinessEntityInterfaceEditor);
    ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        }
    };
    IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
        }
    };
    static /* synthetic */ Class class$com$sap$caf$designer$editors$BusinessEntityInterfaceEditor;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public BusinessEntityInterfaceEditor() {
        ReferenceCounter.increaseReferenceCounter();
    }

    void createPageGeneral() {
        String labelString = mTextPool.getText("BOM_TITLE_0008");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.generalPage = new BusinessEntityInterfaceGeneralPage();
        this.generalPage.createTabContents(this.mainPane, this);
    }

    void createPageAttributes() {
        String labelString = mTextPool.getText("BOM_TITLE_0003");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.attributesPage = new BusinessEntityInterfaceAttributesPage();
        this.attributesPage.createTabContents(mainPane, this);
    }

    void createPageMethods() {
        String labelString = mTextPool.getText("BOM_TITLE_0010");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.methodsPage = new BusinessEntityInterfaceMethodsPage();
        this.methodsPage.createTabContents(mainPane, this);
    }

    void createPagePersistency() {
        String labelString = mTextPool.getText("BOM_TITLE_0012");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.m_PersistencyPage = new BusinessEntityInterfacePersistencyPage();
        this.m_PersistencyPage.createTabContents(mainPane, this);
    }

    void createPagePermissions() {
        String labelString = mTextPool.getText("BOM_TITLE_0011");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        PaneFactory.createSimplePane((Composite)composite);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.m_PermissionsPage = new BusinessEntityInterfacePermissionsPage();
        this.m_PermissionsPage.createTabContents(mainPane, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createPageImplementation() {
        String labelString = mTextPool.getText("BOM_TITLE_0009");
        if (this.cbei == null) {
            throw new CAFRuntimeException("Uninitialized CAFBusinessEntityInterface instance");
        }
        this.m_implp = new ImplementationProvider(new NotifyDirtyCallbackImpl(), this.cbei.getBomSystem(), this.cbei, false);
        boolean bSuccess = false;
        try {
            try {
                int index = this.addPage((IEditorPart)this.m_implp, this.mei);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
            catch (PartInitException ex) {
                if (ex instanceof ImplementationProvider.GeneratorPartInitException) {
                    ImplementationProvider.GeneratorPartInitException genEX = (ImplementationProvider.GeneratorPartInitException)ex;
                    genEX.showGeneratorErrorDialog();
                } else {
                    ex.printStackTrace();
                    logger.catching((Throwable)ex);
                }
                Object var6_6 = null;
                if (bSuccess) return;
                Label label = new Label(this.getContainer(), 0);
                label.setText(mTextPool.getText("BOM_ALL_0023"));
                int index = this.addPage((Control)label);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.catching((Throwable)ex);
                Object var6_7 = null;
                if (bSuccess) return;
                Label label = new Label(this.getContainer(), 0);
                label.setText(mTextPool.getText("BOM_ALL_0023"));
                int index = this.addPage((Control)label);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bSuccess) throw throwable;
            Label label = new Label(this.getContainer(), 0);
            label.setText(mTextPool.getText("BOM_ALL_0023"));
            int index = this.addPage((Control)label);
            this.setPageText(index, labelString);
            super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
            throw throwable;
        }
    }

    void createPageDatasource() {
        String labelString = mTextPool.getText("BOM_TITLE_0013");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.datasourcePage = new DatasourcePage();
        this.datasourcePage.createTabContents(mainPane, this);
        this.setDatasourceEnabled(this.bei.getBackend() != 0);
    }

    public void setDatasourceEnabled(boolean state) {
        Control c = this.getControl(4);
        c.setEnabled(state);
    }

    public DatasourcePage getDataSourcePage() {
        return this.datasourcePage;
    }

    protected void createPages() {
        this.createPageGeneral();
        this.createPageAttributes();
        this.createPageMethods();
        this.createPagePersistency();
        this.createPageDatasource();
        this.createPagePermissions();
        this.createPageImplementation();
        this.attributesPage.addSelectionProvider(this);
    }

    public void testMMRPage() {
        String labelString = "MMR View";
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        Tree tree = new Tree(composite, 2820);
        TreeItem treeRoot = new TreeItem(tree, 0);
        treeRoot.setText("MMR");
        Hashtable contexts = new Hashtable();
        this.fillInTreeRecursive(treeRoot, this.bos.getApplication(), new Hashtable());
    }

    public void fillInTree(Tree tree) {
        TreeItem treeItem = null;
        String[] objects = new String[]{"BusinessEntityInterface", "Table", "DataStructure", "Operation"};
        Object[] defs = new Object[]{"getObjectId", "getObjectName", "getTypeJavaDdic", "getRelationType", "getMinOccurs", "getMaxOccurs", "getListType", "getLanguageDependent", "getTimeDependent", "getHollow", "getTransactionType", "getPatternType", "getTableName", "getFieldName", "getBackend", "getBeanState", "getCreatedAt", "getCreatedBy", "getInstancePermission", "getLastChangedAt", "getLastChangedBy", "getLongText", "getShortText", "isAbstract", "isClassifiable", "isCustom", "isSearchAndRetrieval", "isSearchAndRetrieval", "isVersionable"};
        int i = 0;
        while (i < objects.length) {
            treeItem = new TreeItem(tree, 0);
            treeItem.setText(objects[i]);
            try {
                List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel." + objects[i]);
                List objs = this.bos.getConnection().queryM1(typeList, null, true);
                Iterator it = objs.iterator();
                while (it.hasNext()) {
                    Object target = it.next();
                    TreeItem newItem = new TreeItem(treeItem, 0);
                    String text = "";
                    if (target != null) {
                        if (target instanceof MOFClass) {
                            // empty if block
                        }
                        text = target instanceof BaseObject ? text + ((BaseObject)target).getObjectName() : text + target.getClass().getName();
                    }
                    newItem.setText(text);
                    if (defs == null) continue;
                    int k = 0;
                    while (k < defs.length) {
                        String methodName = (String)defs[k];
                        try {
                            Method m = target.getClass().getMethod(methodName, null);
                            Object o = m.invoke(target, null);
                            TreeItem childItem = new TreeItem(newItem, 0);
                            childItem.setText(defs[k] + " = " + (o != null ? o.toString() : "null"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++k;
                    }
                }
            }
            catch (Exception e) {
                logger.errorT("An error occured while drawing tree of MMR objects.Error is:" + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void fillInTreeRecursive(TreeItem parentItem, Object root, Hashtable filter) {
        block12: {
            Object[] defs = new Object[]{"getObjectId", "getObjectName", "getTypeJavaDdic", "getRelationType", "getMinOccurs", "getMaxOccurs", "getListType", "getLanguageDependent", "getTimeDependent", "getHollow", "getField", "getTransactionType", "getPatternType", "getTableName", "getFieldName", "getBackend", "getBeanState", "getCreatedAt", "getCreatedBy", "getInstancePermission", "getLastChangedAt", "getLastChangedBy", "getLongText", "getShortText", "isAbstract", "isClassifiable", "isCustom", "isSearchAndRetrieval", "isSearchAndRetrieval", "isVersionable", "getBaseObjects", "getBusinessEntity", "getMasterTable", "getFields", "getTable", "getAttributes", "getKeys", "getReferencedObject", "getOperations", "getOperationMappings", "getOutput", "getInput", "getFault", "getMessageParts", "getPermission", "getImplicitCheck", "getPermissionName"};
            if (filter.get(root) != null) {
                return;
            }
            filter.put(root, "");
            try {
                TreeItem newItem = new TreeItem(parentItem, 0);
                String text = "";
                if (root != null) {
                    if (root instanceof MOFClass) {
                        // empty if block
                    }
                    text = root instanceof BaseObject ? text + ((BaseObject)root).getObjectName() : text + root.getClass().getName();
                }
                newItem.setText(text);
                if (defs == null) break block12;
                int k = 0;
                while (k < defs.length) {
                    String methodName = (String)defs[k];
                    try {
                        Method m = root.getClass().getMethod(methodName, null);
                        Object o = m.invoke(root, null);
                        TreeItem childItem = new TreeItem(newItem, 0);
                        childItem.setText(methodName + " = " + (o != null ? o.toString() : "null"));
                        if (o instanceof Collection) {
                            Iterator it = ((Collection)o).iterator();
                            while (it.hasNext()) {
                                if (filter.get(o) != null) continue;
                                this.fillInTreeRecursive(childItem, it.next(), filter);
                            }
                        } else if (filter.get(o) == null) {
                            this.fillInTreeRecursive(childItem, o, filter);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                logger.errorT("An internal error has occured while drawing the MMR tree viewer.Error:" + e.getMessage());
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("Saving...", 3);
        logger.infoT("Start saving..." + this.bei.getName());
        this.bei.setShortText(this.generalPage.getDescription());
        this.bei.setLastChangedAt(DateUtils.getTimeStampDateAsString(this.generalPage.getChangedAt()));
        this.bei.setLastChangedBy(this.generalPage.getChangedBy());
        monitor.worked(1);
        this.setDirty(false);
        this.cbei.setNew(false);
        monitor.done();
        this.isNewBO = this.cbei.isNew();
    }

    private void setUIControlValues2Model() {
        logger.infoT("Start transfering values FROM UI control TO Model ..." + this.bei.getName());
        this.bei.setShortText(this.generalPage.getDescription());
        this.bei.setLastChangedAt(DateUtils.getTimeStampDateAsString(this.generalPage.getChangedAt()));
        this.bei.setLastChangedBy(this.generalPage.getChangedBy());
    }

    public void saveBOChanges() {
        this.setUIControlValues2Model();
        if (!this.isPageDispose(0)) {
            this.internalRefreshTabstrips();
        }
        this.setDirty(false);
        this.isNewBO = false;
    }

    private void internalRefreshTabstrips() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        CTabItem item = tabFolder.getItem(0);
        Display display1 = item.getDisplay();
        if (display1 == null || display1.isDisposed()) {
            return;
        }
        display1.syncExec(new Runnable(){

            public void run() {
                BusinessEntityInterfaceEditor.this.generalPage.changeChangedBy(BusinessEntityInterfaceEditor.this.username);
                Date dt1 = new Date();
                BusinessEntityInterfaceEditor.this.generalPage.changeChangedAt(dt1);
            }
        });
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        this.getEditor(0).gotoMarker(marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws CAFPartInitException {
        if (editorInput instanceof BusinessEntityInterfaceEditorInput) {
            this.mei = (BusinessEntityInterfaceEditorInput)editorInput;
            this.bos = this.mei.getCAFBusinessEntityInterface().getBomSystem();
            this.cbei = this.mei.getCAFBusinessEntityInterface();
            this.bei = this.cbei.getBusinesEntityInterface();
            this._projectName = this.bos.getProjectName();
            this.objName = this.bei.getBusinessEntity().getObjectName();
            this.isNewBO = this.cbei.isNew();
            this.appName = this.bos.getApplicationName();
            this.ownerName = "";
            this.localPersistency = this.bei.getBackend() == 0;
            this.indexSearch = false;
            if (this.isNewBO) {
                MetamodelProvider.setDirtyOn(this._projectName);
            }
        } else {
            throw new CAFPartInitException("Invalid Input: Must be IFileEditorInput");
        }
        String key = this.getSelenaObjectKey();
        instances.put(key, this);
        this.m_BOMListener = new BOMSystemListener();
        this.bos.addSystemListener(this.m_BOMListener);
        try {
            super.init(site, editorInput);
        }
        catch (PartInitException pie) {
            throw new CAFPartInitException(pie);
        }
        super.setTitle(this.objName);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newPageIndex) {
        if (this.previousPageIndex == 1) {
            this.attributesPage.resetSelection();
        }
        if (newPageIndex != 0) {
            // empty if block
        }
        if (newPageIndex == 1) {
            // empty if block
        }
        if (newPageIndex == 4) {
            // empty if block
        }
        if (newPageIndex == 3) {
            this.m_PersistencyPage.refreshTableModel();
        }
        if (newPageIndex == 6) {
            this.setUIControlValues2Model();
            this.m_implp.activateSourceDisplay();
        } else {
            this.m_implp.deactivateSourceDisplay();
        }
        this.previousPageIndex = newPageIndex;
        if (this.outline != null) {
            this.outline.setActive(this.isImplementationActive());
        }
    }

    public BOMSystem getBOMSystem() {
        return this.bos;
    }

    public BusinessEntityInterface getBusinessEntityInterface() {
        return this.bei;
    }

    public CAFBusinessEntityInterface getCAFBusinessEntityInterface() {
        return this.cbei;
    }

    public void dispose() {
        try {
            if (this.dirty) {
                this.saveBOChanges();
            }
            Object var2_1 = null;
            this.bos.removeSystemListener(this.m_BOMListener);
            this.generalPage = null;
            this.attributesPage = null;
            this.m_implp = null;
            this.datasourcePage.dispose();
            String key = this.getSelenaObjectKey();
            instances.remove(key);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.bos.removeSystemListener(this.m_BOMListener);
            this.generalPage = null;
            this.attributesPage = null;
            this.m_implp = null;
            this.datasourcePage.dispose();
            String key = this.getSelenaObjectKey();
            instances.remove(key);
            ReferenceCounter.decreaseReferenceCounter();
            super.dispose();
            throw throwable;
        }
        ReferenceCounter.decreaseReferenceCounter();
        super.dispose();
    }

    public String getObjectName() {
        return this.objName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPackageName() {
        return "";
    }

    public String getGUID() {
        return "";
    }

    public String getBaseObject() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public boolean getVersionable() {
        return false;
    }

    public String getOwner() {
        if (this.ownerName != null) {
            return this.ownerName;
        }
        return "";
    }

    public boolean getLocalPersistency() {
        if (this.isNewBO) {
            return this.localPersistency;
        }
        return false;
    }

    public boolean getIndexSearch() {
        if (this.isNewBO) {
            return this.indexSearch;
        }
        return false;
    }

    public String getStatus() {
        return "";
    }

    public String getRelease() {
        return BomPlugin.getDefault().getReleaseFromPreference();
    }

    public String getVersion() {
        return BomPlugin.getDefault().getReleaseFromPreference();
    }

    public String getProjectName() {
        return this._projectName;
    }

    public String getTechnicalIdentifier() {
        return "";
    }

    public String getCreatedBy() {
        return "";
    }

    public String getCreatedOn() {
        return "";
    }

    public String getChangedBy() {
        return "";
    }

    public String getChangedOn() {
        return "";
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.setDirty(true);
    }

    public void modifyText(ModifyEvent e) {
        this.setDirty(true);
    }

    public void widgetSelected(SelectionEvent e) {
        this.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.generalPage.changeChangedAt(new Date());
        this.generalPage.changeChangedBy(System.getProperty("user.name"));
        logger.infoT("dirty? " + dirty);
        if (this.dirty != dirty) {
            this.dirty = dirty;
            if (dirty) {
                MetamodelProvider.setDirtyOn(this.getProjectName());
            }
        }
        this.bos.getModifiedServicesList().objectModified((BaseObject)this.bei);
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean isDirty() {
        return false;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public static BusinessEntityInterfaceEditor getBusinessEntityInterfaceEditor(String appName, String objName) {
        String key = BusinessEntityInterfaceEditor.makeSelenaKey(appName, objName);
        return (BusinessEntityInterfaceEditor)instances.get(key);
    }

    public static BusinessEntityInterfaceEditor getBusinessEntityInterfaceEditor(CAFBusinessEntityInterface bo) {
        return BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(bo.getBomSystem().getApplication().getObjectName(), bo.getBusinesEntityInterface().getBusinessEntity().getObjectName());
    }

    public BusinessEntityInterfaceAttributesPage getAttributesPage() {
        return this.attributesPage;
    }

    public BusinessEntityInterfaceGeneralPage getGeneralPage() {
        return this.generalPage;
    }

    public BusinessEntityInterfaceMethodsPage getMethodsPage() {
        return this.methodsPage;
    }

    public BusinessEntityInterfacePersistencyPage getPersistencyPage() {
        return this.m_PersistencyPage;
    }

    public ImplementationProvider getImpl() {
        return this.m_implp;
    }

    public boolean isImplementationActive() {
        return this.previousPageIndex == 6;
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = BusinessEntityInterfaceEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            try {
                if (this.m_implp != null) {
                    this.outline = new JavaContentOutlinePage(new QueryImplementationActiveImpl(), (IContentOutlinePage)this.m_implp.getAdapter(required));
                }
            }
            catch (Exception e) {
                this.outline = null;
            }
            return this.outline;
        }
        return super.getAdapter(required);
    }

    private void deleteEditor() {
        this.dirty = false;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
    }

    public boolean isDispose() {
        CTabFolder tabFolder;
        int iNumPages = this.getPageCount();
        if (iNumPages != 0 && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed()) {
            int ic1 = 0;
            while (ic1 < iNumPages) {
                CTabItem item = tabFolder.getItem(ic1);
                if (item == null || item.isDisposed()) {
                    return true;
                }
                ++ic1;
            }
            return false;
        }
        return true;
    }

    public boolean isPageDispose(int iPageIndex) {
        CTabItem item;
        CTabFolder tabFolder;
        if (iPageIndex >= 0 && iPageIndex < this.getPageCount() && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed() && (item = tabFolder.getItem(iPageIndex)) != null) {
            return item.isDisposed();
        }
        return true;
    }

    public String getSelenaObjectKey() {
        return BusinessEntityInterfaceEditor.makeSelenaKey(this.appName, this.objName);
    }

    public static String makeSelenaKey(String appName, String objName) {
        return appName + ':' + objName;
    }

    public void setIsNewBO(boolean isNewBO) {
        this.isNewBO = isNewBO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BOMSystemListener
    implements BOMSystem.BOMListener {
        protected BOMSystemListener() {
        }

        public void systemChanged(BOMSystem.BOMEvent e) {
            switch (e.getType()) {
                case 5: {
                    String strProjectName;
                    if (BusinessEntityInterfaceEditor.this.isDispose()) break;
                    if (e.getTarget() instanceof String && (strProjectName = (String)e.getTarget()).equals(BusinessEntityInterfaceEditor.this._projectName)) {
                        BusinessEntityInterfaceEditor.this.deleteEditor();
                        break;
                    }
                    BusinessEntityInterfaceEditor.this.attributesPage.refreshCatalog();
                    break;
                }
                case 19: {
                    if (BusinessEntityInterfaceEditor.this.isDispose()) break;
                    BusinessEntityInterfaceEditor.this.attributesPage.refreshCatalog();
                    break;
                }
                case 22: {
                    CAFBusinessEntityInterface clBO;
                    if (e.getTarget() instanceof CAFBusinessEntityInterface && (clBO = (CAFBusinessEntityInterface)e.getTarget()) == BusinessEntityInterfaceEditor.this.cbei) {
                        BusinessEntityInterfaceEditor.this.isForDelete = true;
                        BusinessEntityInterfaceEditor.this.deleteEditor();
                        break;
                    }
                    BusinessEntityInterfaceEditor.this.attributesPage.refreshCatalog();
                    break;
                }
                case 23: {
                    BusinessEntityInterfaceEditor.this.attributesPage.refreshCatalog();
                    break;
                }
                case 1: {
                    if (!BusinessEntityInterfaceEditor.this.dirty) break;
                    BusinessEntityInterfaceEditor.this.saveBOChanges();
                    break;
                }
                case 4: {
                    ModelTreeViewer.getInstance().setFocus();
                    if (BusinessEntityInterfaceEditor.this.isDispose()) break;
                    BusinessEntityInterfaceEditor.this.attributesPage.refresh();
                    BusinessEntityInterfaceEditor.this.setDirty(false);
                    BusinessEntityInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 40: {
                    BusinessEntityInterfaceEditor.this.isForDelete = true;
                    if (BusinessEntityInterfaceEditor.this.isDispose()) {
                        BusinessEntityInterfaceEditor.this.setDirty(false);
                        break;
                    }
                    BusinessEntityInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 25: 
                case 29: {
                    BusinessEntityInterfaceEditor.this.methodsPage.fillTableMethods();
                }
            }
        }
    }

    private class QueryImplementationActiveImpl
    implements JavaContentOutlinePage.IQueryImplementationActive {
        private QueryImplementationActiveImpl() {
        }

        public boolean isImplementationActive() {
            return BusinessEntityInterfaceEditor.this.isImplementationActive();
        }
    }

    private class NotifyDirtyCallbackImpl
    implements ImplementationProvider.INotifyDirtyCallback {
        private NotifyDirtyCallbackImpl() {
        }

        public void setDirty(boolean isDirty) {
            BusinessEntityInterfaceEditor.this.setDirty(isDirty);
        }
    }

    protected class FocusListener
    extends FocusAdapter {
        protected FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
        }
    }
}

