/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.AttributeRemoveAction;
import com.sap.caf.designer.dnd.ModelDragSourceListener;
import com.sap.caf.designer.dnd.ModelDropTargetListener;
import com.sap.caf.designer.dnd.ModelElementSource;
import com.sap.caf.designer.dnd.ModelElementSourceTransfer;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.editors.IObjectData;
import com.sap.caf.designer.model.sorters.CoreApplicationSorter;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Property;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ElementWrapperSelectionConverter;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.IElementWrapperConverter;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BusinessEntityInterfaceAttributesPage {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$BusinessEntityInterfaceAttributesPage == null ? (class$com$sap$caf$designer$editors$BusinessEntityInterfaceAttributesPage = BusinessEntityInterfaceAttributesPage.class$("com.sap.caf.designer.editors.BusinessEntityInterfaceAttributesPage")) : class$com$sap$caf$designer$editors$BusinessEntityInterfaceAttributesPage);
    private BOMSystem bos;
    private BusinessEntityInterfaceEditor boe;
    private String objName;
    private String projName;
    private String appName;
    private TreeViewer catalogTreeViewer;
    private TreeViewer objectTreeViewer;
    private GenericDataModelFilteredTreeViewer objectModelViewer;
    private GenericDataModelFilteredTreeViewer catalogViewer;
    private UniqueName objectRoot;
    private UniqueName catalog;
    private ElementWrapperSelectionConverter converter = null;
    private CAFBusinessEntityInterface cbei = null;
    private BusinessEntityInterface bei = null;
    static /* synthetic */ Class class$com$sap$caf$designer$editors$BusinessEntityInterfaceAttributesPage;

    BusinessEntityInterfaceAttributesPage() {
    }

    public void setFocus() {
        this.objectTreeViewer.getTree().setFocus();
        this.catalogTreeViewer.getTree().setFocus();
    }

    public void setStatusLine(String attributeName) {
        StatusLineMessage slm = new StatusLineMessage();
        slm.printMessage(mTextPool.getText("BOM_ATTRBT_0001", new Object[]{attributeName}));
    }

    public void addSelectionProvider(BusinessEntityInterfaceEditor editor) {
        if (this.converter == null) {
            this.converter = new ElementWrapperSelectionConverter((ISelectionProvider)new SimpleSelectionMediator(), new IElementWrapperConverter(){

                public IElementWrapper getWrapper(Object object) {
                    if (object instanceof Element) {
                        return new DefaultElementWrapper((Element)object);
                    }
                    return null;
                }
            });
        }
        editor.getEditorSite().setSelectionProvider((ISelectionProvider)this.converter);
    }

    public void createTabContents(IGridLayoutPane mainPane, BusinessEntityInterfaceEditor editor) {
        this.boe = editor;
        this.bos = editor.getBOMSystem();
        this.bei = editor.getBusinessEntityInterface();
        this.cbei = editor.getCAFBusinessEntityInterface();
        this.objName = editor.getObjectName();
        this.projName = editor.getProjectName();
        this.appName = editor.getAppName();
        ISashPane outerSashPane = mainPane.addHorizontalSashPane(mainPane.createGridLayoutData(4, 4, true, true, 21, 1));
        ISashPane leftSashPane = outerSashPane.addVerticalSashPane();
        IGridLayoutPane leftgridPane = leftSashPane.addGridLayoutPane(1, false);
        leftgridPane.addTextLabel(mTextPool.getText("BOM_ATTRBT_0005"), leftgridPane.createGridLayoutData(1, 2, 1, 1));
        ISashPane middleSashPane = outerSashPane.addVerticalSashPane();
        IGridLayoutPane middlegridPane = middleSashPane.addGridLayoutPane(1, false);
        int i = 1;
        while (i <= 10) {
            middlegridPane.addPlaceholder(21, 1);
            ++i;
        }
        Image arrow = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"arrow_right.gif");
        Button addButton = middlegridPane.addPushButton(arrow, mTextPool.getText("BOM_ALL_0001"), middlegridPane.createGridLayoutData(1, 2, 1, 1));
        addButton.addSelectionListener((SelectionListener)new AddButtonListener());
        ISashPane rightSashPane = outerSashPane.addVerticalSashPane();
        IGridLayoutPane rightgridPane = rightSashPane.addGridLayoutPane(1, false);
        rightgridPane.addTextLabel(mTextPool.getText("BOM_ATTRBT_0004"), rightgridPane.createGridLayoutData(1, 2, 1, 1));
        outerSashPane.setWeights(new int[]{10, 1, 10});
        this.objectRoot = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Object Root", "Object Root", this.objName, new String[]{this.appName});
        String[] projectNames = null;
        projectNames = new String[]{this.appName};
        this.catalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Sub Catalog", null, this.appName, projectNames);
        ISashPane treeViewer = leftgridPane.addVerticalSashPane(leftgridPane.createGridLayoutData(4, 4, true, true));
        this.createCatalogViewer(treeViewer);
        treeViewer = rightgridPane.addVerticalSashPane(leftgridPane.createGridLayoutData(4, 4, true, true));
        this.createObjectViewer(treeViewer, editor);
        if (this.bos.getCoreApplication() != null) {
            UniqueName coreCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "ASService Core Catalog", null, this.bos.getCoreApplication().getObjectName(), new String[]{this.projName, this.objName});
            Model coremodel = ModelAccess.createModel((UniqueName)coreCatalog);
            this.catalogViewer.addRoot((PropertyMap)coremodel);
        }
        this.catalogViewer.getTreeViewer().setSorter((ViewerSorter)new CoreApplicationSorter());
        this.objectModelViewer.addRoot((PropertyMap)ModelAccess.createModel((UniqueName)this.objectRoot));
        this.objectTreeViewer.expandToLevel(2);
        this.catalogViewer.addRoot((PropertyMap)ModelAccess.createModel((UniqueName)this.catalog));
        this.catalogTreeViewer.expandToLevel(4);
        this.addSelectionProvider(editor);
        this.setFocus();
        this.objectTreeViewer.setSorter((ViewerSorter)new MyViewerSorter());
        ISashPane rightSashPane2 = outerSashPane.addVerticalSashPane();
        IGridLayoutPane middlerightgridPane = rightSashPane2.addGridLayoutPane(1, false);
        int i2 = 1;
        while (i2 <= 10) {
            middlerightgridPane.addPlaceholder(1, 1);
            ++i2;
        }
        arrow = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"arrow_up.gif");
        Button upButton = middlerightgridPane.addPushButton(arrow, mTextPool.getText("BOM_ATTRBT_0007"), middlerightgridPane.createGridLayoutData(1, 2, 1, 1));
        upButton.addSelectionListener((SelectionListener)new MoveUpButtonListener());
        arrow = SapIdeUtilImages.getImageFromIconsDirectory((IPluginDescriptor)BomPlugin.getDefault().getDescriptor(), (String)"arrow_down.gif");
        Button downButton = middlerightgridPane.addPushButton(arrow, mTextPool.getText("BOM_ATTRBT_0006"), middlerightgridPane.createGridLayoutData(1, 2, 1, 1));
        downButton.addSelectionListener((SelectionListener)new MoveDownButtonListener());
        outerSashPane.setWeights(new int[]{10, 1, 10, 1});
    }

    public void refresh() {
        this.objectTreeViewer.refresh();
        this.objectModelViewer.refresh();
        this.objectTreeViewer.expandAll();
    }

    public void refreshCatalog() {
        this.catalogTreeViewer.refresh();
        this.catalogTreeViewer.expandToLevel(4);
    }

    public void resetSelection() {
    }

    private void createCatalogViewer(ISashPane treeViewer) {
        this.catalogViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer.getComposite(), new PropertyMap[0], true, true);
        this.catalogViewer.setFilter((IFilter)new YesManFilter(){

            public boolean isAvailable(PropertyMap propertyMap) {
                boolean ret = true;
                if (propertyMap instanceof Element) {
                    Element element = (Element)propertyMap;
                    UniqueName uniqueName = element.getUniqueName();
                    String mySubDomain = uniqueName.getSubDomain();
                    if (!uniqueName.getDomain().equals("CAF")) {
                        ret = false;
                    } else if ("Project".equals(mySubDomain) || "Object Root".equals(mySubDomain) || "Value Set Root".equals(mySubDomain) || "ASService Catalog".equals(mySubDomain) || "ES Operations Parameters Subdomain".equals(mySubDomain) || "Entity Operations Parameters Subdomain".equals(mySubDomain) || "Attributes Type Catalog".equals(mySubDomain) || "Create Data Structure".equals(mySubDomain) || "AS Operation Parameters".equals(mySubDomain) || "AS Operation Parameters".equals(mySubDomain) || "Sub Catalog".equals(mySubDomain) && !BusinessEntityInterfaceAttributesPage.this.appName.equals(uniqueName.getParameter(0)) || "ASService Core Catalog".equals(mySubDomain) && !BusinessEntityInterfaceAttributesPage.this.objName.equals(uniqueName.getParameter(1)) || "ASService Core Catalog".equals(mySubDomain) && !BusinessEntityInterfaceAttributesPage.this.projName.equals(uniqueName.getParameter(0))) {
                        ret = false;
                    }
                }
                return ret;
            }
        });
        this.catalogTreeViewer = this.catalogViewer.getTreeViewer();
        DragSource source = new DragSource((Control)this.catalogTreeViewer.getTree(), 20);
        source.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new CatalogRootModelDragSourceListener());
        DropTarget targetCtlg = new DropTarget((Control)this.catalogViewer.getTree(), 18);
        targetCtlg.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        targetCtlg.addDropListener((DropTargetListener)new CatalogRootModelDropTargetListener());
    }

    private void createObjectViewer(ISashPane treeViewer, IObjectData iod) {
        this.objectModelViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer.getComposite(), new PropertyMap[0], true, true);
        this.objectModelViewer.setFilter((IFilter)new YesManFilter(){

            public boolean isAvailable(PropertyMap propertyMap) {
                boolean ret = true;
                if (propertyMap instanceof Element) {
                    Element element = (Element)propertyMap;
                    UniqueName uniqueName = element.getUniqueName();
                    String mySubDomain = uniqueName.getSubDomain();
                    if (!uniqueName.getDomain().equals("CAF")) {
                        ret = false;
                    } else if ("Project".equals(mySubDomain) || "Sub Catalog".equals(mySubDomain) || "Value Set Root".equals(mySubDomain) || "ASService Catalog".equals(mySubDomain) || "ES Operations Parameters Subdomain".equals(mySubDomain) || "Entity Operations Parameters Subdomain".equals(mySubDomain) || "Attributes Type Catalog".equals(mySubDomain) || "Create Data Structure".equals(mySubDomain) || "AS Operation Parameters".equals(mySubDomain) || "ASService Core Catalog".equals(mySubDomain) || "Object Root".equals(mySubDomain) && !uniqueName.equals(BusinessEntityInterfaceAttributesPage.this.objectRoot)) {
                        ret = false;
                    }
                }
                return ret;
            }
        });
        this.objectTreeViewer = this.objectModelViewer.getTreeViewer();
        DropTarget target = new DropTarget((Control)this.objectTreeViewer.getTree(), 20);
        target.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new ObjectRootModelDropTargetListener(iod));
        DragSource sourceObj = new DragSource((Control)this.objectTreeViewer.getTree(), 22);
        sourceObj.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        sourceObj.addDragListener((DragSourceListener)new ObjectRootModelDragSourceListener());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FocusListener
    extends FocusAdapter {
        protected FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            super.focusLost(e);
        }
    }

    protected class SimpleSelectionMediator
    implements ISelectionProvider,
    ISelectionChangedListener {
        private ISelection selection;
        private HashSet myListeners = new HashSet();

        public SimpleSelectionMediator() {
            BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            BusinessEntityInterfaceAttributesPage.this.catalogTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.remove(listener);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setSelection(event.getSelection());
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                ((ISelectionChangedListener)it.next()).selectionChanged(event);
            }
        }
    }

    protected class MoveDownButtonListener
    extends SelectionAdapter {
        protected MoveDownButtonListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void widgetSelected(SelectionEvent e) {
            block11: {
                try {
                    Attribute attr1;
                    DataStructure ds;
                    ISelection selection = BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) return;
                    if (selection.isEmpty()) {
                        return;
                    }
                    Object rightObj = ((IStructuredSelection)selection).getFirstElement();
                    if (!(rightObj instanceof Entity)) return;
                    Entity rightEntity = (Entity)rightObj;
                    String subDomain = rightEntity.getUniqueName().getSubDomain();
                    if (subDomain.equals("Object Root")) break block11;
                    UniqueName un = rightEntity.getUniqueName();
                    String attrName = un.getName();
                    Attribute attr = null;
                    List attributes = null;
                    if (un.getParametersCount() == 2) {
                        attr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(attrName);
                        attributes = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getAttributes();
                    }
                    if (un.getParametersCount() == 3 && (ds = (attr1 = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(un.getParameter(2))).getReferencedObject()) != null) {
                        attr = BusinessEntityInterfaceAttributesPage.this.cbei.getSubAttributeByName(attrName, ds);
                        attributes = ds.getAttributes();
                    }
                    if (BusinessEntityInterfaceAttributesPage.this.cbei.isKeyAttribute(attr)) {
                        List keys = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getKeys();
                        int i = 0;
                        while (i < keys.size() - 1) {
                            if (keys.get(i) == attr) {
                                Object obj = keys.remove(i);
                                keys.add(i + 1, obj);
                                BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                                break;
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < attributes.size() - 1) {
                            if (attributes.get(i) == attr) {
                                Object obj = attributes.remove(i);
                                attributes.add(i + 1, obj);
                                BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                                break;
                            }
                            ++i;
                        }
                    }
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.refresh();
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.expandToLevel(1);
                    return;
                }
                catch (Throwable throwable) {
                    Object var14_6 = null;
                    throw throwable;
                }
            }
        }
    }

    protected class MoveUpButtonListener
    extends SelectionAdapter {
        protected MoveUpButtonListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void widgetSelected(SelectionEvent e) {
            block11: {
                try {
                    Attribute attr1;
                    DataStructure ds;
                    ISelection selection = BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) return;
                    if (selection.isEmpty()) {
                        return;
                    }
                    Object rightObj = ((IStructuredSelection)selection).getFirstElement();
                    if (!(rightObj instanceof Entity)) return;
                    Entity rightEntity = (Entity)rightObj;
                    String subDomain = rightEntity.getUniqueName().getSubDomain();
                    if (subDomain.equals("Object Root")) break block11;
                    UniqueName un = rightEntity.getUniqueName();
                    String attrName = un.getName();
                    Attribute attr = null;
                    List attributes = null;
                    if (un.getParametersCount() == 2) {
                        attr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(attrName);
                        attributes = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getAttributes();
                    }
                    if (un.getParametersCount() == 3 && (ds = (attr1 = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(un.getParameter(2))).getReferencedObject()) != null) {
                        attr = BusinessEntityInterfaceAttributesPage.this.cbei.getSubAttributeByName(attrName, ds);
                        attributes = ds.getAttributes();
                    }
                    if (BusinessEntityInterfaceAttributesPage.this.cbei.isKeyAttribute(attr)) {
                        List keys = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getKeys();
                        int i = 1;
                        while (i < keys.size()) {
                            if (keys.get(i) == attr) {
                                Object obj = keys.remove(i - 1);
                                keys.add(i, obj);
                                BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                                break;
                            }
                            ++i;
                        }
                    } else {
                        int i = 1;
                        while (i < attributes.size()) {
                            if (attributes.get(i) == attr) {
                                Object obj = attributes.remove(i - 1);
                                attributes.add(i, obj);
                                BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                                break;
                            }
                            ++i;
                        }
                    }
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.refresh();
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.expandToLevel(1);
                    return;
                }
                catch (Throwable throwable) {
                    Object var14_6 = null;
                    throw throwable;
                }
            }
        }
    }

    protected class AddButtonListener
    extends SelectionAdapter {
        protected AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            block14: {
                try {
                    Entity leftEntity = null;
                    UniqueName leftName = null;
                    ISelection selection = BusinessEntityInterfaceAttributesPage.this.catalogTreeViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                        return;
                    }
                    Object leftObj = ((IStructuredSelection)selection).getFirstElement();
                    if (leftObj == null || !(leftObj instanceof Entity)) break block14;
                    leftEntity = (Entity)leftObj;
                    leftName = leftEntity.getUniqueName();
                    String subDomain = leftName.getSubDomain();
                    BOMSystem project = BOMSystem.getBOMSystem(leftName.getParameter(0));
                    if (project == null) {
                        return;
                    }
                    CAFBusinessEntityInterface target = null;
                    try {
                        target = subDomain.equals("ASService Catalog Core Busines Entity Service") ? new CAFBusinessEntityInterface(project, (BusinessEntityInterface)project.getCoreBusinessEntities().get(leftName.getName())) : (CAFBusinessEntityInterface)project.getBusinessEntityInterfaces().get(leftName.getName());
                    }
                    catch (Exception exc) {
                        target = null;
                    }
                    if (target == null) {
                        return;
                    }
                    if ("Business Entity Service".equals(subDomain) || "ASService Catalog Core Busines Entity Service".equals(subDomain)) {
                        UniqueName rightName;
                        Object rightObj;
                        Property newAttr = null;
                        selection = BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection) || selection.isEmpty() || !((rightObj = ((IStructuredSelection)selection).getFirstElement()) instanceof Entity) || "Object Field Attribute".equals((rightName = ((Entity)rightObj).getUniqueName()).getSubDomain()) || "Object Complex Attribute".equals(rightName.getSubDomain())) {
                            // empty if block
                        }
                        if (newAttr == null) {
                            String prefix;
                            String newAttrName = prefix = leftName.getName().substring(0, 1).toLowerCase() + leftName.getName().substring(1) + "Ref";
                            int i = 1;
                            while (BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(newAttrName) != null) {
                                newAttrName = prefix + i;
                                ++i;
                            }
                            if (BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(newAttrName) == null) {
                                newAttr = BusinessEntityInterfaceAttributesPage.this.cbei.addEntityAttribute(target.getBusinesEntityInterface(), newAttrName);
                            }
                        }
                        if (newAttr != null) {
                            BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.refresh();
                            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                                Object rightSelectObj = ((IStructuredSelection)selection).getFirstElement();
                                BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.expandToLevel(rightSelectObj, 1);
                            }
                            BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                        }
                    }
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.expandToLevel(1);
                }
                catch (Exception ex) {
                    logger.catching((Throwable)ex);
                }
            }
        }
    }

    protected class CatalogRootModelDropTargetListener
    extends ModelDropTargetListener {
        CatalogRootModelDropTargetListener() {
            super(new String[]{"Object Attribute", "Object Complex Attribute", "Object Field Attribute", "Attribute Field Attribute"});
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            Attribute attr = null;
            Attribute complexParent = null;
            Entity rightEntity = null;
            Object ent = BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.getTree().getSelection()[0].getData();
            if (!(ent instanceof Entity)) {
                return;
            }
            rightEntity = (Entity)ent;
            if ("Attribute Field Attribute".equals(elementSource.subDomain)) {
                complexParent = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(elementSource.getParam(2));
                attr = BusinessEntityInterfaceAttributesPage.this.cbei.getSubAttributeByName(complexParent, elementSource.name);
                if (((Property)attr).isHollow().booleanValue()) {
                    return;
                }
            } else {
                attr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(elementSource.name);
            }
            if (attr != null) {
                boolean canDeleteAttr = true;
                if (CAFBusinessEntityInterface.isDefaultAttribute(attr)) {
                    canDeleteAttr = false;
                }
                List entityOperations = BusinessEntityInterfaceAttributesPage.this.cbei.getBusinesEntityInterface().getOperations();
                Map operations = CAFBusinessEntityInterface.getAssociatedOperations(attr, complexParent, BusinessEntityInterfaceAttributesPage.this.cbei);
                if (!operations.isEmpty()) {
                    canDeleteAttr = false;
                    String msg = CAFBusinessEntityInterface.getReferersNames(operations);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("ASDA.INFO.TITLE"), (String)(mTextPool.getText("ASDA.INFO.NODELETION") + "\n" + msg));
                }
                if (canDeleteAttr) {
                    try {
                        AttributeRemoveAction.removeAttribute(BusinessEntityInterfaceAttributesPage.this.cbei, attr, complexParent != null ? complexParent.getReferencedObject() : null);
                    }
                    catch (Throwable y) {
                        BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                    }
                    com.sap.caf.designer.model.ModelAccess.removeUniqueNameFromCache((Element)rightEntity);
                    BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
                    BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.refresh();
                }
            }
        }
    }

    protected class CatalogRootModelDragSourceListener
    extends ModelDragSourceListener {
        CatalogRootModelDragSourceListener() {
            super(new String[]{"Business Entity Service", "ASService Catalog Core Busines Entity Service"});
        }
    }

    protected class ObjectRootModelDropTargetListener
    extends ModelDropTargetListener {
        IObjectData iod;
        private TreeItem toTreeItem = null;

        public ObjectRootModelDropTargetListener(IObjectData iod) {
            super(new String[]{"Business Entity Service", "ASService Catalog Core Busines Entity Service", "Object Field Attribute", "Object Complex Attribute", "Object Attribute", "Attribute Field Attribute"});
            this.iod = iod;
        }

        public void dragOver(DropTargetEvent event) {
            super.dragOver(event);
            event.feedback |= 2;
        }

        public void drop(DropTargetEvent event) {
            this.toTreeItem = event.item != null && event.item instanceof TreeItem ? (TreeItem)event.item : null;
            super.drop(event);
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            String prefix;
            String newAttrName = null;
            Attribute newAttr = null;
            BOMSystem project = BOMSystem.getBOMSystem(BusinessEntityInterfaceAttributesPage.this.projName);
            if (project == null) {
                return;
            }
            CAFBusinessEntityInterface target = null;
            newAttrName = prefix = elementSource.name.substring(0, 1).toLowerCase() + elementSource.name.substring(1) + "Ref";
            int i = 1;
            while (BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(newAttrName) != null) {
                newAttrName = prefix + i;
                ++i;
            }
            try {
                target = "ASService Catalog Core Busines Entity Service".equals(elementSource.subDomain) ? new CAFBusinessEntityInterface(project, (BusinessEntityInterface)project.getCoreBusinessEntities().get(elementSource.name)) : ("Business Entity Service".equals(elementSource.subDomain) ? (CAFBusinessEntityInterface)project.getBusinessEntityInterfaces().get(elementSource.name) : null);
            }
            catch (Exception exc) {
                target = null;
            }
            try {
                if ("Object Attribute".equals(elementSource.subDomain) || "Object Field Attribute".equals(elementSource.subDomain) || "Object Complex Attribute".equals(elementSource.subDomain)) {
                    newAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(elementSource.name);
                    this.insertBeforeTargetItem(newAttr);
                } else if ("Attribute Field Attribute".equals(elementSource.subDomain)) {
                    Attribute attr1 = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(elementSource.getParam(2));
                    DataStructure ds = attr1.getReferencedObject();
                    if (ds != null) {
                        newAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getSubAttributeByName(elementSource.name, ds);
                    }
                    this.insertSubAttrBeforeTargetItem(newAttr);
                } else {
                    if (target == null) {
                        return;
                    }
                    newAttr = BusinessEntityInterfaceAttributesPage.this.cbei.addEntityAttribute(target.getBusinesEntityInterface(), newAttrName);
                    this.insertBeforeTargetItem(newAttr);
                }
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
            }
            if (newAttr != null) {
                BusinessEntityInterfaceAttributesPage.this.objectTreeViewer.refresh();
                BusinessEntityInterfaceAttributesPage.this.boe.setDirty(true);
            }
        }

        private void insertBeforeTargetItem(Attribute pAttr) {
            if (this.toTreeItem == null || pAttr == null) {
                return;
            }
            Entity rightEntity = null;
            if (!(this.toTreeItem.getData() instanceof Entity)) {
                return;
            }
            rightEntity = (Entity)this.toTreeItem.getData();
            UniqueName un = rightEntity.getUniqueName();
            String subDomain = un.getSubDomain();
            if (subDomain.equals("Object Root")) {
                return;
            }
            List allAttributes = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getAttributes();
            if (BusinessEntityInterfaceAttributesPage.this.cbei.isKeyAttribute(pAttr)) {
                allAttributes = BusinessEntityInterfaceAttributesPage.this.bei.getBusinessEntity().getKeys();
            }
            Attribute targetAttr = null;
            if ("Attribute Field Attribute".equals(un.getSubDomain())) {
                Attribute complexTargetParent;
                targetAttr = complexTargetParent = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(un.getParameter(2));
            } else if ("Object Attribute".equals(un.getSubDomain()) || "Object Complex Attribute".equals(un.getSubDomain()) || "Object Field Attribute".equals(un.getSubDomain())) {
                targetAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(un.getName());
            }
            if (targetAttr == null) {
                return;
            }
            int targetIndex = -1;
            int sourceIndex = -1;
            Object nextObj = null;
            int attri = 0;
            attri = 0;
            while (attri < allAttributes.size()) {
                nextObj = allAttributes.get(attri);
                if (nextObj instanceof Property) {
                    if (targetAttr == nextObj) {
                        targetIndex = attri;
                    }
                    if (pAttr == nextObj) {
                        sourceIndex = attri;
                    }
                }
                ++attri;
            }
            if (sourceIndex >= 0 && targetIndex >= 0) {
                int whereIndx = sourceIndex >= targetIndex ? targetIndex : targetIndex - 1;
                allAttributes.remove(pAttr);
                allAttributes.add(whereIndx, pAttr);
            }
        }

        private void insertSubAttrBeforeTargetItem(Attribute pSubAttr) {
            if (this.toTreeItem == null || pSubAttr == null) {
                return;
            }
            Entity rightEntity = null;
            if (!(this.toTreeItem.getData() instanceof Entity)) {
                return;
            }
            rightEntity = (Entity)this.toTreeItem.getData();
            Attribute targetAttr = null;
            Attribute targetParentAttr = null;
            UniqueName targetUN = null;
            if (this.toTreeItem != null && this.toTreeItem.getData() instanceof Entity && ((Entity)this.toTreeItem.getData()).getUniqueName().getParametersCount() == 3) {
                targetUN = ((Entity)this.toTreeItem.getData()).getUniqueName();
                targetParentAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getAttributeByName(targetUN.getParameter(2));
                DataStructure ds = targetParentAttr.getReferencedObject();
                if (ds != null) {
                    targetAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getSubAttributeByName(targetUN.getName(), ds);
                }
            }
            List attributes = null;
            Attribute parentAttr = BusinessEntityInterfaceAttributesPage.this.cbei.getComplexParent(pSubAttr);
            DataStructure ds = parentAttr.getReferencedObject();
            if (ds != null) {
                attributes = ds.getAttributes();
            }
            if (!parentAttr.equals(targetParentAttr)) {
                return;
            }
            int targetIndex = -1;
            int sourceIndex = -1;
            Object nextObj = null;
            int attri = 0;
            attri = 0;
            while (attri < attributes.size()) {
                nextObj = attributes.get(attri);
                if (nextObj instanceof Property) {
                    if (targetAttr == nextObj) {
                        targetIndex = attri;
                    }
                    if (pSubAttr == nextObj) {
                        sourceIndex = attri;
                    }
                }
                ++attri;
            }
            if (targetIndex >= 0 && sourceIndex >= 0) {
                int whereIndx = sourceIndex >= targetIndex ? targetIndex : targetIndex - 1;
                attributes.remove(pSubAttr);
                attributes.add(whereIndx, pSubAttr);
            }
        }
    }

    protected class ObjectRootModelDragSourceListener
    extends ModelDragSourceListener {
        public ObjectRootModelDragSourceListener() {
            super(new String[]{"Object Attribute", "Object Complex Attribute", "Object Field Attribute", "Attribute Field Attribute"});
        }
    }

    class MyViewerSorter
    extends ViewerSorter {
        MyViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return -10;
        }
    }
}

