/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dnd.ModelDragSourceListener;
import com.sap.caf.designer.dnd.ModelDropTargetListener;
import com.sap.caf.designer.dnd.ModelElementSource;
import com.sap.caf.designer.dnd.ModelElementSourceTransfer;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.editors.ReadOnlyTableModel;
import com.sap.caf.designer.model.ASDependencyTreeFilter;
import com.sap.caf.designer.model.ASOperationParametersTreeFilter;
import com.sap.caf.designer.model.sorters.OperationTreeSorter;
import com.sap.caf.designer.model.sorters.OperationTypeRepositoryTreeSorter;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFOperation;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.caf.designer.views.BOMTreeUtil;
import com.sap.caf.designer.wizards.OperationWizard;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.ElementWrapperSelectionConverter;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.IElementWrapperConverter;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ApplicationServiceOperationsPage {
    private UniqueName objectRoot;
    private UniqueName catalog;
    private UniqueName operation;
    private IWorkbenchWindow window;
    private IGridLayoutPane tabPane;
    private ISapTableViewer tableViewerAsOperations;
    private ISashPane treeViewerAsOperationShash;
    private IStructuredSelection selection;
    private ReadOnlyTableModel defTableModel;
    private int selectedOperation = -1;
    private Operation currentOperation;
    private Button addMethodButton;
    private Button removeMethodButton;
    private Button editMethodButton;
    private Button paramTypeBrowseButton;
    private Button addToParamListButton;
    private Button deleteFromParamListButton;
    private DoubleClickListener doubleClickListener = new DoubleClickListener();
    private MethodTabListener listener = new MethodTabListener();
    private String appservName;
    private String projectName;
    private ApplicationInterfaceEditor parent = null;
    private GenericDataModelFilteredTreeViewer treeViewerleft;
    private ISapTreeViewer treeViewerright;
    private GenericDataModelFilteredTreeViewer operationsViewer;
    private CAFApplicationInterface mCafApplInt;
    private DefaultTreeModel defTreeModel;
    private HashMap operEntitycontains = new HashMap();
    private Button addInputbutt;
    private Button addOutpbutt;
    private Button addFaultbutt;
    private Button remParamtbutt;
    private static final TextPool mTextPool = TextPool.getInstance();
    public static String[] permition = new String[]{mTextPool.getText("ASOP.Disabled_1"), mTextPool.getText("ASOP.Enabled_2")};
    public static String[] transactionTypes = new String[]{mTextPool.getText("ASOP.Required_3"), mTextPool.getText("ASOP.RequiresNew_4"), mTextPool.getText("ASOP.Mandatory_5"), mTextPool.getText("ASOP.NotSupported_6"), mTextPool.getText("ASOP.Supports_7"), mTextPool.getText("ASOP.Never_8")};
    public static String[] transactionTypesSimple = new String[]{mTextPool.getText("ASI_OPERATION_WIZARD_OPERATION_TRANSACTION_TYPE_MANDATORY"), mTextPool.getText("ASI_OPERATION_WIZARD_OPERATION_TRANSACTION_TYPE_OPTIONAL")};
    public static String[] patternsTypes = new String[]{mTextPool.getText("ASOP.CUSTOM_9"), mTextPool.getText("ASOP.CREATE_10"), mTextPool.getText("ASOP.READ_11"), mTextPool.getText("ASOP.UPDATE_12"), mTextPool.getText("ASOP.DELETE_13"), mTextPool.getText("ASOP.FINDBY_14"), "", "", mTextPool.getText("ASOP.EXTRACTOR_15")};
    private static final Object[] tableColumnNames = new Object[]{mTextPool.getText("ASI_OPERTAB_0001"), mTextPool.getText("ASI_OPERTAB_0002"), mTextPool.getText("ASI_OPERTAB_0005"), mTextPool.getText("ASI_OPERTAB_0006"), mTextPool.getText("ASI_OPERTAB_0007")};
    public static String[] atrListType = new String[]{mTextPool.getText("ASOP.unsorted_20"), mTextPool.getText("ASOP.sorted_21"), mTextPool.getText("ASOP.none_22")};
    private ArrayList operations = new ArrayList();
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$designer$editors$ApplicationServiceOperationsPage == null ? (class$com$sap$caf$designer$editors$ApplicationServiceOperationsPage = ApplicationServiceOperationsPage.class$("com.sap.caf.designer.editors.ApplicationServiceOperationsPage")) : class$com$sap$caf$designer$editors$ApplicationServiceOperationsPage));
    static /* synthetic */ Class class$com$sap$caf$designer$editors$ApplicationServiceOperationsPage;

    public void createTabContents(IGridLayoutPane tabPane, ApplicationInterfaceEditor aseditor) {
        logger.infoT("Service Operation - createTabContents()." + this.appservName);
        this.parent = aseditor;
        this.projectName = aseditor.getProjectName();
        this.appservName = aseditor.getObjectName();
        this.tabPane = tabPane;
        this.mCafApplInt = aseditor.getCAFApplicationInterface();
        ISashPane outerSashPane = tabPane.addVerticalSashPane(tabPane.createGridLayoutData(4, 4, true, true, 1, 1));
        ISashPane outerSashPane1 = outerSashPane.addHorizontalSashPane();
        ISashPane outerSashPane2 = outerSashPane.addHorizontalSashPane();
        ISashPane outerSashPane3 = outerSashPane.addHorizontalSashPane();
        outerSashPane1.addTextLabel(mTextPool.getText("ASI_OPERTAB_0000"));
        this.tableViewerAsOperations = outerSashPane2.addSapTableViewer((TableModel)this.initializeTableModel());
        this.tableViewerAsOperations.getTable().getColumn(0).setWidth(125);
        this.tableViewerAsOperations.getTable().getColumn(1).setWidth(150);
        this.tableViewerAsOperations.getTable().getColumn(2).setWidth(125);
        this.tableViewerAsOperations.getTable().getColumn(3).setWidth(125);
        this.tableViewerAsOperations.getTable().getColumn(4).setWidth(125);
        this.tableViewerAsOperations.getTable().addSelectionListener((SelectionListener)this.listener);
        this.tableViewerAsOperations.getTable().addMouseListener((MouseListener)this.doubleClickListener);
        ISashPane righttopPane = outerSashPane2.addVerticalSashPane();
        IGridLayoutPane righttopGrid = righttopPane.addGridLayoutPane(1, false);
        this.addMethodButton = righttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0001"), righttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.addMethodButton.addSelectionListener((SelectionListener)new AddButtonListener());
        this.editMethodButton = righttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0012"), righttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.editMethodButton.addSelectionListener((SelectionListener)new EditButtonListener());
        this.removeMethodButton = righttopGrid.addPushButton(mTextPool.getText("BOM_ALL_0006"), righttopGrid.createGridLayoutData(4, 1, 1, 1));
        this.removeMethodButton.addSelectionListener((SelectionListener)new RemoveButtonListener());
        outerSashPane2.setWeights(new int[]{10, 1});
        ISashPane firstbottomSashPane = outerSashPane3.addVerticalSashPane();
        IGridLayoutPane firstbottomGrid = firstbottomSashPane.addGridLayoutPane(1, false);
        IGridLayoutPane secondbottomGridAdd = outerSashPane3.addGridLayoutPane(1, false);
        ISashPane fakesash = secondbottomGridAdd.addHorizontalSashPane();
        fakesash.addTextLabel("");
        IGridLayoutPane addAsGridd = secondbottomGridAdd.addGridLayoutPane(1, false);
        addAsGridd.addTextLabel("Add as...");
        ISashPane thirdbottomSashPane = outerSashPane3.addVerticalSashPane();
        IGridLayoutPane thirdtbottomGrid = thirdbottomSashPane.addGridLayoutPane(1, false);
        firstbottomGrid.addTextLabel(mTextPool.getText("ASI_OPERWZRD_0013"), firstbottomGrid.createGridLayoutData(4, 4, 1, 1));
        ISashPane treeViewer1 = firstbottomGrid.addVerticalSashPane(firstbottomGrid.createGridLayoutData(4, 4, true, true));
        logger.infoT(" left tree  " + this.appservName);
        UniqueName serviceCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "Attributes Type Catalog", null, "Catalog", new String[]{this.mCafApplInt.getBomSystem().getProjectName(), this.mCafApplInt.getApplicationInterface().getObjectName(), ""});
        this.treeViewerleft = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer1.getComposite(), new PropertyMap[0], true, true);
        ArrayList<String> treeSubdomains = new ArrayList<String>();
        treeSubdomains.add("Attributes Type Catalog");
        treeSubdomains.add("Data Structures");
        treeSubdomains.add("Data Structure");
        treeSubdomains.add("Core Data Structure");
        treeSubdomains.add("Data Object");
        treeSubdomains.add("Java Types");
        treeSubdomains.add("Java Type Package");
        treeSubdomains.add("Java Type");
        treeSubdomains.add("Fault Messages");
        treeSubdomains.add("Core Fault Messages");
        treeSubdomains.add("Current Fault Messages");
        treeSubdomains.add("Core Fault Message");
        treeSubdomains.add("Fault Message");
        treeSubdomains.add("Core Data Structures");
        treeSubdomains.add("Current Data Structures");
        this.treeViewerleft.setFilter((IFilter)new ASDependencyTreeFilter(this.projectName, this.mCafApplInt.getApplicationInterface().getObjectName(), treeSubdomains, ""));
        this.treeViewerleft.getTreeViewer().setSorter((ViewerSorter)new OperationTypeRepositoryTreeSorter());
        Model model = ModelAccess.createModel((UniqueName)serviceCatalog);
        this.treeViewerleft.addRoot((PropertyMap)model);
        this.treeViewerleft.getTreeViewer().expandToLevel(2);
        this.addInputbutt = addAsGridd.addPushButton(mTextPool.getText("ASOP.ASI_OPERWZRD_0014"), mTextPool.getText("ASI_OPERWZRD_0014"), addAsGridd.createGridLayoutData(4, 1, 1, 1));
        this.addInputbutt.addSelectionListener((SelectionListener)new AddInputParameterButtonListener());
        this.addOutpbutt = addAsGridd.addPushButton(mTextPool.getText("ASOP.ASI_OPERWZRD_0015"), mTextPool.getText("ASI_OPERWZRD_0015"), addAsGridd.createGridLayoutData(4, 1, 1, 1));
        this.addOutpbutt.addSelectionListener((SelectionListener)new AddOutputParameterButtonListener());
        this.addFaultbutt = addAsGridd.addPushButton(mTextPool.getText("ASOP.Fault_36"), mTextPool.getText("ASOP.as_Fault_37"), addAsGridd.createGridLayoutData(4, 1, 1, 1));
        this.addFaultbutt.addSelectionListener((SelectionListener)new AddFaultMsgButtonListener());
        addAsGridd.addPlaceholder();
        this.remParamtbutt = addAsGridd.addPushButton(mTextPool.getText("ASOP.ASI_OPERWZRD_0016"), mTextPool.getText("ASI_OPERWZRD_0016"), addAsGridd.createGridLayoutData(4, 1, 1, 1));
        this.remParamtbutt.addSelectionListener((SelectionListener)new RemoveParameterButtonListener());
        thirdtbottomGrid.addTextLabel(mTextPool.getText("ASI_OPERWZRD_0017"), thirdtbottomGrid.createGridLayoutData(4, 4, 1, 1));
        this.treeViewerAsOperationShash = thirdtbottomGrid.addVerticalSashPane(thirdtbottomGrid.createGridLayoutData(4, 4, true, true));
        this.createOperationsTree(this.treeViewerAsOperationShash, null);
        logger.infoT(" End operation page   " + this.appservName);
        outerSashPane3.setWeights(new int[]{20, 5, 20});
        outerSashPane.setWeights(new int[]{1, 7, 10});
        this.addSelectionProvider();
        DragSource source = new DragSource((Control)this.treeViewerleft.getTree(), 20);
        source.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new ModelDragSourceListener(new String[]{"Data Structure", "Core Data Structure", "Data Object", "Java Type", "Fault Message", "Core Fault Message"}));
        DropTarget targetCtlg = new DropTarget((Control)this.treeViewerleft.getTree(), 2);
        targetCtlg.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        targetCtlg.addDropListener((DropTargetListener)new RepositoryModelDropTargetListener(new String[]{"AS Operation Exception", "AS Operation Input Parameter", "AS Operation Output Parameter"}));
        DropTarget target = new DropTarget((Control)this.operationsViewer.getTree(), 20);
        target.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new OperationsModelDropTargetListener(new String[]{"Data Structure", "Core Data Structure", "Data Object", "Java Type", "Fault Message", "Core Fault Message"}));
        DragSource sourceObj = new DragSource((Control)this.operationsViewer.getTree(), 22);
        sourceObj.setTransfer(new Transfer[]{ModelElementSourceTransfer.getInstance()});
        sourceObj.addDragListener((DragSourceListener)new ModelDragSourceListener(new String[]{"AS Operation Exception", "AS Operation Input Parameter", "AS Operation Output Parameter"}));
    }

    public static Integer getOperationTransactionType(int simpleType) {
        int result = 0;
        switch (simpleType) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 4;
                break;
            }
            case 2: {
                result = 3;
            }
        }
        return new Integer(result);
    }

    public static Integer getOperationTransactionSimpleType(int fullType) {
        int result = 0;
        switch (fullType) {
            case 0: {
                result = 0;
                break;
            }
            case 4: {
                result = 1;
            }
        }
        return new Integer(result);
    }

    private ReadOnlyTableModel initializeTableModel() {
        List mmroperations = this.mCafApplInt.getApplicationInterface().getOperations();
        Object[][] methodData = new Object[mmroperations.size()][5];
        boolean enabledRemotlyEnabled = false;
        int i = 0;
        while (i < mmroperations.size()) {
            Operation operation = (Operation)mmroperations.get(i);
            this.operations.add(operation);
            methodData[i][0] = operation.getObjectName();
            methodData[i][1] = operation.getLongText();
            methodData[i][2] = transactionTypesSimple[ApplicationServiceOperationsPage.getOperationTransactionSimpleType(operation.getTransactionType())];
            methodData[i][3] = permition[operation.getPermission().getImplicitCheck()];
            methodData[i][4] = patternsTypes[operation.getPatternType()];
            if (this.checkIOparameters(operation)) {
                enabledRemotlyEnabled = true;
                this.operEntitycontains.put(operation.getObjectName(), new Boolean(true));
            } else {
                this.operEntitycontains.put(operation.getObjectName(), new Boolean(false));
            }
            ++i;
        }
        this.defTableModel = new ReadOnlyTableModel(methodData, tableColumnNames);
        if (enabledRemotlyEnabled) {
            this.parent.getGeneralPage().setDisabledRemotlyEnabledCheckBox();
        }
        return this.defTableModel;
    }

    private void openEditOperation(IStructuredSelection tableSel) {
        try {
            SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
            Operation op = (Operation)this.operations.get(tableRow.getRowNum());
            OperationWizard mw = new OperationWizard(this.parent, this.mCafApplInt, op);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)mw);
            dialog.create();
            dialog.open();
            StatusLineMessage slm = new StatusLineMessage();
            slm.printMessage(mTextPool.getText("BOM_METHODS_0006", new Object[]{op.getObjectName()}));
        }
        catch (NullPointerException ne) {
            logger.errorT("EditButtonListener exception" + ((Throwable)ne).getMessage());
            ne.printStackTrace();
        }
    }

    public void refreshOperationTable(Operation operation) {
        if (this.operations.contains(operation)) {
            int rowNumb = this.operations.indexOf(operation);
            this.defTableModel.setValueAt(operation.getLongText(), rowNumb, 1);
            this.defTableModel.setValueAt(transactionTypesSimple[ApplicationServiceOperationsPage.getOperationTransactionSimpleType(operation.getTransactionType())], rowNumb, 2);
            this.defTableModel.setValueAt(permition[operation.getPermission().getImplicitCheck()], rowNumb, 3);
            this.defTableModel.setValueAt(patternsTypes[operation.getPatternType()], rowNumb, 4);
            this.doSelection();
            this.selectedOperation = rowNumb;
        } else {
            Object[] operationData = new Object[5];
            this.operations.add(operation);
            operationData[0] = operation.getObjectName();
            operationData[1] = operation.getLongText();
            operationData[2] = transactionTypesSimple[ApplicationServiceOperationsPage.getOperationTransactionSimpleType(operation.getTransactionType())];
            operationData[3] = permition[operation.getPermission().getImplicitCheck()];
            operationData[4] = patternsTypes[operation.getPatternType()];
            this.defTableModel.addRow(operationData);
            this.tableViewerAsOperations.getTable().setSelection(this.operations.size() - 1);
            this.doSelection();
            this.operEntitycontains.put(operation.getObjectName(), new Boolean(false));
        }
        this.tableViewerAsOperations.getTable().setFocus();
    }

    public void refreshTree() {
        this.treeViewerleft.getTreeViewer().refresh();
        this.operationsViewer.getTreeViewer().refresh();
    }

    public void refreshParameterTree() {
        this.operationsViewer.refresh();
        this.operationsViewer.getTreeViewer().getTree().deselectAll();
        this.operationsViewer.getTreeViewer().refresh(true);
    }

    public void setParameterTreeFocus() {
        this.operationsViewer.getTreeViewer().getTree().setFocus();
    }

    public void setCatalogTreeFocus() {
        this.treeViewerleft.getTreeViewer().getTree().setFocus();
    }

    private Operation getSelectedOperation() {
        Object rightObj;
        Operation result = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerAsOperations.getTableViewer().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() && (rightObj = selection.getFirstElement()) instanceof SapTableRow) {
            SapTableRow selectedRow = (SapTableRow)rightObj;
            if (this.defTableModel.getRowCount() >= selectedRow.getRowNum()) {
                result = (Operation)this.operations.get(selectedRow.getRowNum());
            }
        }
        return result;
    }

    private void doSelection() {
        this.selection = (IStructuredSelection)this.tableViewerAsOperations.getTableViewer().getSelection();
        this.createOperationsTree(this.treeViewerAsOperationShash, this.selection);
        if (this.selection == null || !(this.selection instanceof IStructuredSelection) || this.selection.isEmpty()) {
            return;
        }
        Object rightObj = this.selection.getFirstElement();
        if (rightObj instanceof SapTableRow) {
            SapTableRow selectedRow = (SapTableRow)rightObj;
            if (this.defTableModel.getRowCount() >= selectedRow.getRowNum()) {
                this.currentOperation = (Operation)this.operations.get(selectedRow.getRowNum());
                this.selectedOperation = selectedRow.getRowNum();
                logger.infoT("MethodTabListener- Set the currentOperation name=" + this.currentOperation.getObjectName());
                if (this.currentOperation.getPatternType() != null) {
                    switch (this.currentOperation.getPatternType()) {
                        case 0: {
                            this.setButtonAccess(true, true, true, true);
                            break;
                        }
                        case 1: {
                            this.setButtonAccess(false, false, true, true);
                            break;
                        }
                        case 2: {
                            this.setButtonAccess(false, false, true, true);
                            break;
                        }
                        case 3: {
                            this.setButtonAccess(false, false, true, true);
                            break;
                        }
                        case 4: {
                            this.setButtonAccess(false, false, true, true);
                            break;
                        }
                        case 5: {
                            this.setButtonAccess(false, false, true, true);
                            break;
                        }
                        case 8: {
                            this.setButtonAccess(false, false, false, false);
                        }
                    }
                }
            }
        } else {
            logger.infoT("Set the currentOperation to null!!!" + this.appservName);
            this.currentOperation = null;
            this.selectedOperation = -1;
        }
    }

    private void setButtonAccess(boolean inputBtnEnabled, boolean outputBtnEnabled, boolean faultBtnEnabled, boolean removeBtnEnabled) {
        if (this.addInputbutt != null) {
            this.addInputbutt.setEnabled(inputBtnEnabled);
        }
        if (this.addOutpbutt != null) {
            this.addOutpbutt.setEnabled(outputBtnEnabled);
        }
        if (this.addFaultbutt != null) {
            this.addFaultbutt.setEnabled(faultBtnEnabled);
        }
        if (this.remParamtbutt != null) {
            this.remParamtbutt.setEnabled(removeBtnEnabled);
        }
    }

    private void createOperationsTree(ISashPane treeViewer, IStructuredSelection selection) {
        String bomSystemName = this.projectName;
        String applicationName = BOMSystem.getBOMSystem(this.projectName).getApplicationName();
        String serviceName = this.parent.getObjectName();
        String methodName = "";
        Operation currentMethodData = null;
        if (selection != null) {
            SapTableRow currentRow = (SapTableRow)selection.getFirstElement();
            int rowNum = currentRow.getRowNum();
            currentMethodData = (Operation)this.operations.get(rowNum);
            methodName = currentMethodData.getObjectId();
        }
        String rootNodename = mTextPool.getText("BOM_OPERATION_TREE_0001");
        if (currentMethodData != null) {
            rootNodename = currentMethodData.getObjectName();
        }
        if (currentMethodData == null || currentMethodData != null && !currentMethodData.equals((Object)this.currentOperation)) {
            String[] parameters = new String[]{"", bomSystemName, applicationName, serviceName, methodName, "appserv"};
            if (this.operationsViewer == null) {
                this.operationsViewer = (GenericDataModelFilteredTreeViewer)BOMTreeUtil.createTreeViewer(treeViewer.getComposite(), new PropertyMap[0], true);
            }
            ArrayList<String> ioParametersSubdomainst = new ArrayList<String>();
            ioParametersSubdomainst.add("AS Operation Parameters");
            ioParametersSubdomainst.add("AS Operation Exception");
            ioParametersSubdomainst.add("AS Operation Exceptions");
            ioParametersSubdomainst.add("AS Operation Input Parameters");
            ioParametersSubdomainst.add("AS Operation Input Parameter");
            ioParametersSubdomainst.add("AS Operation Output Parameter");
            ioParametersSubdomainst.add("AS Operation Output Parameters");
            ASOperationParametersTreeFilter filter = new ASOperationParametersTreeFilter(parameters, ioParametersSubdomainst);
            this.operationsViewer.setFilter((IFilter)filter);
            int i = 0;
            while (i < this.operationsViewer.getRoots().length) {
                this.operationsViewer.removeRoot(this.operationsViewer.getRoots()[i]);
                ++i;
            }
            UniqueName serviceCatalog = com.sap.caf.designer.model.ModelAccess.createUniqueName("CAF", "AS Operation Parameters", null, rootNodename, parameters);
            Model model = ModelAccess.createModel((UniqueName)serviceCatalog);
            this.operationsViewer.addRoot((PropertyMap)model);
            this.operationsViewer.getTreeViewer().setSorter((ViewerSorter)new OperationTreeSorter(currentMethodData));
            this.operationsViewer.getTreeViewer().expandToLevel(3);
            this.operationsViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    Entity element = (Entity)selection.getFirstElement();
                    if (element != null) {
                        UniqueName uniqueName = element.getUniqueName();
                        Operation selOperation = ApplicationServiceOperationsPage.this.getSelectedOperation();
                        if (uniqueName != null && uniqueName.getSubDomain() != null && (uniqueName.getSubDomain().equals("AS Operation Input Parameter") || uniqueName.getSubDomain().equals("AS Operation Output Parameter") || uniqueName.getSubDomain().equals("AS Operation Input Parameters") || uniqueName.getSubDomain().equals("AS Operation Output Parameters") || uniqueName.getSubDomain().equals("AS Operation Exceptions"))) {
                            if (selOperation != null && selOperation.getPatternType() != null) {
                                switch (selOperation.getPatternType()) {
                                    case 0: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(true, true, true, true);
                                        break;
                                    }
                                    case 1: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, false);
                                        break;
                                    }
                                    case 2: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, false);
                                        break;
                                    }
                                    case 3: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, false);
                                        break;
                                    }
                                    case 4: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, false);
                                        break;
                                    }
                                    case 5: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, false);
                                        break;
                                    }
                                    case 8: {
                                        ApplicationServiceOperationsPage.this.setButtonAccess(false, false, false, false);
                                    }
                                }
                            }
                        } else if (uniqueName.getSubDomain() != null && uniqueName.getSubDomain().equals("AS Operation Exception") && selOperation != null && selOperation.getPatternType() != null) {
                            switch (selOperation.getPatternType()) {
                                case 0: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(true, true, true, true);
                                    break;
                                }
                                case 1: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, true);
                                    break;
                                }
                                case 2: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, true);
                                    break;
                                }
                                case 3: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, true);
                                    break;
                                }
                                case 4: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, true);
                                    break;
                                }
                                case 5: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, true, true);
                                    break;
                                }
                                case 8: {
                                    ApplicationServiceOperationsPage.this.setButtonAccess(false, false, false, false);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    private boolean addOutputParameter() {
        boolean result = false;
        logger.infoT("addOutputParameter(), currentOperation=" + this.currentOperation);
        ISelection selection = this.treeViewerleft.getTreeViewer().getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return result;
        }
        Object rightObj = ((IStructuredSelection)selection).getFirstElement();
        if (rightObj instanceof Entity) {
            Entity rightEntity = (Entity)rightObj;
            UniqueName un = rightEntity.getUniqueName();
            String subDomain = un.getSubDomain();
            String[] unParams = new String[un.getParametersCount()];
            int i = 0;
            while (i < un.getParametersCount()) {
                unParams[i] = un.getParameter(i);
                ++i;
            }
            result = this.addOutputParameter(un.getName(), un.getSubDomain(), unParams);
        }
        return result;
    }

    private boolean addOutputParameter(String unName, String unSubDomain, String[] unParams) {
        boolean result = false;
        if (!(unSubDomain.equals("Java Type") || unSubDomain.equals("Data Object") || unSubDomain.equals("Core Data Structure") || unSubDomain.equals("Data Structure"))) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)mTextPool.getText("ASOP._67"), (String)mTextPool.getText("ASOP.Selected_item_is_not_appropriate_type_!_68"));
            return result;
        }
        if (this.currentOperation == null) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", (String)mTextPool.getText("ASOP.Select_the_Operation_from_the_table_!_63"));
        } else {
            String error = null;
            if (this.currentOperation.getOutput() != null && this.currentOperation.getOutput().getMessageParts() != null && this.currentOperation.getOutput().getMessageParts().size() >= 1) {
                error = mTextPool.getText("ASOP.Just_one_Output_parameter_can_be_created_!_64");
            }
            if (error == null) {
                this.createParameter(unName, unSubDomain, unParams, false);
                result = true;
            } else {
                MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", error);
            }
        }
        return result;
    }

    private boolean addInputParameter() {
        logger.infoT("addInputParameter() " + this.appservName);
        boolean result = false;
        ISelection selection = this.treeViewerleft.getTreeViewer().getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return result;
        }
        Object rightObj = ((IStructuredSelection)selection).getFirstElement();
        if (rightObj instanceof Entity) {
            Entity rightEntity = (Entity)rightObj;
            UniqueName un = rightEntity.getUniqueName();
            String subDomain = un.getSubDomain();
            String[] unParams = new String[un.getParametersCount()];
            int i = 0;
            while (i < un.getParametersCount()) {
                unParams[i] = un.getParameter(i);
                ++i;
            }
            result = this.addInputParameter(un.getName(), subDomain, unParams);
        }
        return result;
    }

    private boolean addInputParameter(String unName, String unSubDomain, String[] unParams) {
        boolean result = false;
        if (!(unSubDomain.equals("Java Type") || unSubDomain.equals("Data Object") || unSubDomain.equals("Core Data Structure") || unSubDomain.equals("Data Structure"))) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)mTextPool.getText("ASOP._67"), (String)mTextPool.getText("ASOP.Selected_item_is_not_appropriate_type_!_68"));
            return result;
        }
        if (this.currentOperation == null) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", (String)mTextPool.getText("ASOP.Select_the_Operation_from_the_table_!_70"));
        } else {
            this.createParameter(unName, unSubDomain, unParams, true);
            result = true;
        }
        return result;
    }

    private boolean addFaultMsg() {
        boolean result = false;
        ISelection selection = this.treeViewerleft.getTreeViewer().getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return result;
        }
        Object rightObj = ((IStructuredSelection)selection).getFirstElement();
        if (rightObj instanceof Entity) {
            Entity rightEntity = (Entity)rightObj;
            String subDomain = rightEntity.getUniqueName().getSubDomain();
            UniqueName un = rightEntity.getUniqueName();
            String unname = un.getName();
            result = this.addFaultMsg(unname, subDomain, BOMSystem.getBOMSystem(un.getParameter(0)).getApplicationName());
        }
        return result;
    }

    private boolean addFaultMsg(String unname, String subDomain, String appname) {
        boolean result = false;
        if (!subDomain.equals("Fault Message") && !subDomain.equals("Core Fault Message")) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", (String)mTextPool.getText("ASOP.Selected_item_is_not_Exception_type_!_72"));
            return result;
        }
        if (this.currentOperation == null) {
            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", (String)mTextPool.getText("ASOP.Select_the_Operation_from_the_table_!_74"));
        } else {
            Object inputatr = null;
            String error = null;
            String originFNObjectName = this.getOriginFMObjectName(appname, subDomain, unname);
            if (this.currentOperation.getFault() != null && !this.currentOperation.getFault().isEmpty()) {
                Iterator iter = this.currentOperation.getFault().iterator();
                while (iter.hasNext()) {
                    FaultMessage fm = (FaultMessage)iter.next();
                    if (!fm.getObjectName().equals(originFNObjectName)) continue;
                    error = mTextPool.getText("ASOP.The_operation_already_contains__75") + unname + mTextPool.getText("ASOP._Exception_76");
                }
            }
            if (error == null) {
                this.createFaultMsg(unname, originFNObjectName);
                result = true;
            } else {
                MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", error);
            }
        }
        return result;
    }

    private String getOriginFMObjectName(UniqueName un) {
        String appname = BOMSystem.getBOMSystem(this.projectName).getApplicationName();
        if ("Core Fault Message".equals(un.getSubDomain())) {
            appname = "caf.core";
        }
        String result = EntityNamesStringUtil.restoreCoreFaultPackagesSP4(un.getName(), appname);
        return result;
    }

    private String getOriginFMObjectName(String appname, String subdomain, String name) {
        if ("Core Fault Message".equals(subdomain)) {
            appname = "caf.core";
        }
        String result = EntityNamesStringUtil.restoreCoreFaultPackagesSP4(name, appname);
        return result;
    }

    private void createFaultMsg(UniqueName un) {
        this.createFaultMsg(un.getName(), this.getOriginFMObjectName(un));
    }

    private void createFaultMsg(String name, String originFNObjectName) {
        FaultMessage fm = null;
        fm = originFNObjectName.indexOf("caf.core") < 0 ? (FaultMessage)this.mCafApplInt.getBomSystem().getApplicationFaultMessages().get(originFNObjectName) : (FaultMessage)this.mCafApplInt.getBomSystem().getCoreFaults().get(originFNObjectName);
        this.currentOperation.getFault().add(fm);
        this.parent.setDirty(true);
        this.operationsViewer.getTreeViewer().refresh();
    }

    private void createParameter(UniqueName un, boolean isInput) {
        String[] params = new String[un.getParametersCount()];
        int i = 0;
        while (i < un.getParametersCount()) {
            params[i] = un.getParameter(i);
            ++i;
        }
        this.createParameter(un.getName(), un.getSubDomain(), params, isInput);
    }

    private void createParameter(String unName, String unSubdomain, String[] unParams, boolean isInput) {
        if (this.currentOperation != null) {
            logger.infoT("createParameter currentOperation name=" + this.currentOperation.getObjectName());
            boolean isSimpleType = false;
            MetamodelPackage mpackage = this.mCafApplInt.getBomSystem().getMetamodelPackage();
            Attribute atr = mpackage.getAttribute().createAttribute();
            atr.setObjectId(atr.refMofId());
            if (unSubdomain.equals("Data Object")) {
                CAFBusinessEntityInterface cafbei = (CAFBusinessEntityInterface)this.mCafApplInt.getBomSystem().getBusinessEntityInterfaces().get(unName);
                DataObject do_ = null;
                do_ = cafbei != null ? cafbei.getBusinesEntityInterface().getBusinessEntity() : ((BusinessEntityInterface)this.mCafApplInt.getBomSystem().getCoreBusinessEntities().get(unName)).getBusinessEntity();
                atr.setReferencedObject((DataStructure)do_);
                this.parent.getGeneralPage().setDisabledRemotlyEnabledCheckBox();
                this.operEntitycontains.put(this.currentOperation.getObjectName(), new Boolean(true));
            } else if (unSubdomain.equals("Data Structure")) {
                atr.setReferencedObject((DataStructure)this.mCafApplInt.getBomSystem().getApplicationDataStructures().get(unName));
            } else if (unSubdomain.equals("Core Data Structure")) {
                atr.setReferencedObject((DataStructure)this.mCafApplInt.getBomSystem().getCoreDataStructures().get(unName));
            } else {
                atr.setTypeJavaDdic(unParams[unParams.length - 1] + "." + unName);
                isSimpleType = true;
            }
            atr.setListType(new Integer(2));
            atr.setMaxOccurs(new Integer(1));
            int tablRowNum = this.operations.indexOf(this.currentOperation);
            Message inoutmesg = null;
            if (isInput) {
                inoutmesg = this.currentOperation.getInput();
                if (inoutmesg == null) {
                    inoutmesg = mpackage.getMessage().createMessage();
                    this.currentOperation.setInput(inoutmesg);
                }
                if (isSimpleType) {
                    atr.setObjectName(EntityNamesStringUtil.getAttributeSimpleTypeName(this.currentOperation.getInput().getMessageParts()));
                } else {
                    atr.setObjectName(EntityNamesStringUtil.getAttributeDSName(unName, this.currentOperation.getInput().getMessageParts()));
                }
                this.currentOperation.getInput().getMessageParts().add(atr);
            } else {
                inoutmesg = this.currentOperation.getOutput();
                if (inoutmesg == null) {
                    inoutmesg = mpackage.getMessage().createMessage();
                    this.currentOperation.setOutput(inoutmesg);
                }
                atr.setObjectName(mTextPool.getText("ASOP.Response_79"));
                this.currentOperation.getOutput().getMessageParts().add(atr);
            }
            this.parent.setDirty(true);
            this.operationsViewer.getTreeViewer().refresh();
        }
    }

    private void removeParameter(UniqueName un) {
        this.removeParameter(un.getName(), un.getSubDomain());
    }

    private void removeParameter(String name, String subDomain) {
        block8: {
            block10: {
                String atrName;
                block11: {
                    block9: {
                        atrName = name;
                        if (this.currentOperation != null) {
                            logger.infoT("remove param widjet selected currentOperation name=" + this.currentOperation.getObjectName() + " and subdomain=" + subDomain);
                        }
                        if (this.currentOperation == null) break block8;
                        int tablRowNum = this.operations.indexOf(this.currentOperation);
                        if (!subDomain.equals("AS Operation Input Parameter")) break block9;
                        Attribute atr = this.findAttributeByName(this.currentOperation.getInput().getMessageParts(), atrName);
                        if (atr == null) {
                            return;
                        }
                        try {
                            this.currentOperation.getInput().getMessageParts().remove(atr);
                        }
                        catch (Exception e) {
                            logger.errorT("An error has occured while removing parameter with name:" + name);
                            e.printStackTrace();
                        }
                        atr.refDelete();
                        if (this.checkIOparameters(this.currentOperation)) break block10;
                        this.parent.getGeneralPage().setEnabledRemotlyEnabledCheckBox();
                        break block10;
                    }
                    if (!subDomain.equals("AS Operation Output Parameter")) break block11;
                    Attribute atr = this.findAttributeByName(this.currentOperation.getOutput().getMessageParts(), atrName);
                    this.currentOperation.getOutput().getMessageParts().remove(atr);
                    atr.refDelete();
                    this.operEntitycontains.put(this.currentOperation.getObjectName(), new Boolean(this.checkIOparameters(this.currentOperation)));
                    Iterator iterator = this.operEntitycontains.values().iterator();
                    boolean hasBEoi = false;
                    while (iterator.hasNext()) {
                        if (!((Boolean)iterator.next()).booleanValue()) continue;
                        hasBEoi = true;
                        break;
                    }
                    if (hasBEoi) break block10;
                    this.parent.getGeneralPage().setEnabledRemotlyEnabledCheckBox();
                    break block10;
                }
                if (subDomain.equals("AS Operation Exception")) {
                    String faultName = EntityNamesStringUtil.restoreCoreFaultPackages2(atrName);
                    Iterator exceptions = this.currentOperation.getFault().iterator();
                    while (exceptions.hasNext()) {
                        FaultMessage fault = (FaultMessage)exceptions.next();
                        if (!faultName.equals(fault.getObjectName())) continue;
                        if (this.currentOperation.getPermission().getImplicitCheck() == 1 && fault.getObjectName().equals(OperationWizard.PERMISSION_EXCEPRION_NAME)) {
                            MessageDialog.openError((Shell)this.parent.getSite().getShell(), (String)"", (String)mTextPool.getText("OPER_FAULT_ERROR"));
                            return;
                        }
                        this.currentOperation.getFault().remove(fault);
                        break;
                    }
                }
            }
            this.parent.setDirty(true);
            this.operationsViewer.getTreeViewer().refresh();
        }
    }

    private boolean checkIOparameters(Operation aOperation) {
        if (aOperation.getInput() != null && this.checkIOparameters(aOperation.getInput().getMessageParts())) {
            return true;
        }
        return aOperation.getOutput() != null && this.checkIOparameters(aOperation.getOutput().getMessageParts());
    }

    private boolean checkIOparameters(List aParameters) {
        if (aParameters != null) {
            Iterator iparameters = aParameters.iterator();
            while (iparameters.hasNext()) {
                Attribute attribute = (Attribute)iparameters.next();
                DataStructure ds = attribute.getReferencedObject();
                if (ds == null || !(ds instanceof DataObject)) continue;
                return true;
            }
        }
        return false;
    }

    private int indexOfAttribute(List mesageparts, String attrName) {
        int i = 0;
        while (i < mesageparts.size()) {
            Attribute atribute = (Attribute)mesageparts.get(i);
            if (attrName.equals(atribute.getObjectName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Attribute findAttributeByName(List mesageparts, String attrName) {
        int i = 0;
        while (i < mesageparts.size()) {
            Attribute atribute = (Attribute)mesageparts.get(i);
            if (attrName.equals(atribute.getObjectName())) {
                return atribute;
            }
            ++i;
        }
        return null;
    }

    public void addSelectionProvider() {
        ElementWrapperSelectionConverter converter = new ElementWrapperSelectionConverter((ISelectionProvider)new OperationSelectionMediator(), new IElementWrapperConverter(){

            public IElementWrapper getWrapper(Object object) {
                if (object instanceof Element) {
                    DefaultElementWrapper dump = new DefaultElementWrapper((Element)object);
                    return dump;
                }
                return null;
            }
        });
        this.parent.getSite().setSelectionProvider((ISelectionProvider)converter);
    }

    public void setFocus() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RepositoryModelDropTargetListener
    extends ModelDropTargetListener {
        public RepositoryModelDropTargetListener(String[] subdomains) {
            super(subdomains);
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 0;
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            String subDomain = elementSource.subDomain;
            if (!ApplicationServiceOperationsPage.this.remParamtbutt.getEnabled()) {
                return;
            }
            if (!(subDomain.equals("AS Operation Input Parameter") || subDomain.equals("AS Operation Output Parameter") || subDomain.equals("AS Operation Exception"))) {
                return;
            }
            ApplicationServiceOperationsPage.this.removeParameter(elementSource.name, subDomain);
        }
    }

    protected class OperationsModelDropTargetListener
    extends ModelDropTargetListener {
        private TreeItem toTreeItem = null;

        public OperationsModelDropTargetListener(String[] subdomains) {
            super(subdomains);
        }

        public void dragOver(DropTargetEvent event) {
            super.dragOver(event);
            event.feedback |= 1;
        }

        public void drop(DropTargetEvent event) {
            this.toTreeItem = event.item != null && event.item instanceof TreeItem ? (TreeItem)event.item : null;
            super.drop(event);
        }

        protected void dropTypedSource(ModelElementSource elementSource) {
            if (this.toTreeItem.getData() instanceof Entity) {
                String dropContainerSubdomain = ((Entity)this.toTreeItem.getData()).getUniqueName().getSubDomain();
                if (!"AS Operation Exceptions".equals(dropContainerSubdomain) && !"AS Operation Input Parameters".equals(dropContainerSubdomain) && !"AS Operation Output Parameters".equals(dropContainerSubdomain) && this.toTreeItem.getParentItem() != null && this.toTreeItem.getParentItem().getData() instanceof Entity) {
                    dropContainerSubdomain = ((Entity)this.toTreeItem.getParentItem().getData()).getUniqueName().getSubDomain();
                }
                String[] params = new String[elementSource.getParamsCount()];
                int i = 0;
                while (i < elementSource.getParamsCount()) {
                    params[i] = elementSource.getParam(i);
                    ++i;
                }
                if ("AS Operation Exceptions".equals(dropContainerSubdomain) && ApplicationServiceOperationsPage.this.addFaultbutt.getEnabled()) {
                    ApplicationServiceOperationsPage.this.addFaultMsg(elementSource.name, elementSource.subDomain, BOMSystem.getBOMSystem(elementSource.getParam(0)).getApplicationName());
                } else if ("AS Operation Input Parameters".equals(dropContainerSubdomain) && ApplicationServiceOperationsPage.this.addInputbutt.getEnabled()) {
                    ApplicationServiceOperationsPage.this.addInputParameter(elementSource.name, elementSource.subDomain, params);
                } else if ("AS Operation Output Parameters".equals(dropContainerSubdomain) && ApplicationServiceOperationsPage.this.addOutpbutt.getEnabled()) {
                    ApplicationServiceOperationsPage.this.addOutputParameter(elementSource.name, elementSource.subDomain, params);
                }
            }
        }
    }

    protected class RemoveParameterButtonListener
    extends SelectionAdapter {
        protected RemoveParameterButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            logger.infoT("RemoveParameterButtonListener widjetselected " + ApplicationServiceOperationsPage.this.appservName);
            ISelection selection = ApplicationServiceOperationsPage.this.operationsViewer.getTreeViewer().getSelection();
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                return;
            }
            Object rightObj = ((IStructuredSelection)selection).getFirstElement();
            if (rightObj instanceof Entity) {
                Entity rightEntity = (Entity)rightObj;
                String subDomain = rightEntity.getUniqueName().getSubDomain();
                if (!(subDomain.equals("AS Operation Input Parameter") || subDomain.equals("AS Operation Output Parameter") || subDomain.equals("AS Operation Exception"))) {
                    return;
                }
                UniqueName un = rightEntity.getUniqueName();
                ApplicationServiceOperationsPage.this.removeParameter(un);
            }
        }
    }

    protected class AddFaultMsgButtonListener
    extends SelectionAdapter {
        protected AddFaultMsgButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean bl = ApplicationServiceOperationsPage.this.addFaultMsg();
        }
    }

    protected class AddInputParameterButtonListener
    extends SelectionAdapter {
        protected AddInputParameterButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            logger.infoT("AddInputParameterButtonListener widjetselected " + ApplicationServiceOperationsPage.this.appservName);
            ApplicationServiceOperationsPage.this.addInputParameter();
        }
    }

    protected class AddOutputParameterButtonListener
    extends SelectionAdapter {
        protected AddOutputParameterButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            logger.infoT("AddOutputParameterButtonListener widjetselected, currentOperation=" + ApplicationServiceOperationsPage.this.currentOperation);
            ApplicationServiceOperationsPage.this.addOutputParameter();
        }
    }

    private class MethodTabListener
    extends SelectionAdapter {
        private MethodTabListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget selectedWidget = e.widget;
            if (selectedWidget == ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTable()) {
                ApplicationServiceOperationsPage.this.doSelection();
            }
        }
    }

    protected class OperationSelectionMediator
    implements ISelectionProvider,
    ISelectionChangedListener {
        private ISelection selection;
        private HashSet myListeners = new HashSet();

        public OperationSelectionMediator() {
            ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            ApplicationServiceOperationsPage.this.treeViewerleft.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            ApplicationServiceOperationsPage.this.operationsViewer.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.myListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setSelection(event.getSelection());
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                ((ISelectionChangedListener)it.next()).selectionChanged(event);
            }
        }
    }

    protected class RemoveButtonListener
    extends SelectionAdapter {
        protected RemoveButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            StatusLineMessage slm = new StatusLineMessage();
            IStructuredSelection tableSel = (IStructuredSelection)ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTableViewer().getSelection();
            SapTableRow tableRow = (SapTableRow)tableSel.getFirstElement();
            String operationName = (String)ApplicationServiceOperationsPage.this.defTableModel.getValueAt(tableRow.getRowNum(), 0);
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("ASI_METHODS_0013", new Object[]{operationName}))) {
                try {
                    new CAFOperation(ApplicationServiceOperationsPage.this.mCafApplInt.getBomSystem(), (Operation)ApplicationServiceOperationsPage.this.operations.get(tableRow.getRowNum())).remove();
                    ApplicationServiceOperationsPage.this.operEntitycontains.remove(((Operation)ApplicationServiceOperationsPage.this.operations.get(tableRow.getRowNum())).getObjectName());
                    ApplicationServiceOperationsPage.this.operations.remove(tableRow.getRowNum());
                    ApplicationServiceOperationsPage.this.defTableModel.removeRow(tableRow.getRowNum());
                    ApplicationServiceOperationsPage.this.parent.setDirty(true);
                    slm.printMessage(mTextPool.getText("BOM_METHODS_0007", new Object[]{operationName}));
                    ApplicationServiceOperationsPage.this.currentOperation = null;
                    ApplicationServiceOperationsPage.this.selectedOperation = -1;
                    ApplicationServiceOperationsPage.this.createOperationsTree(ApplicationServiceOperationsPage.this.treeViewerAsOperationShash, null);
                }
                catch (Exception ne) {
                    logger.errorT(ne.getMessage());
                }
            } else {
                logger.infoT("Deletion cancelled..." + ApplicationServiceOperationsPage.this.appservName);
                slm.printMessage(mTextPool.getText("BOM_METHODS_0004"));
            }
        }
    }

    protected class EditButtonListener
    extends SelectionAdapter {
        protected EditButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IStructuredSelection tableSel = (IStructuredSelection)ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTableViewer().getSelection();
            if (tableSel.isEmpty()) {
                return;
            }
            ApplicationServiceOperationsPage.this.openEditOperation(tableSel);
        }
    }

    protected class AddButtonListener
    extends SelectionAdapter {
        protected AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            StatusLineMessage slm = new StatusLineMessage();
            OperationWizard ow = new OperationWizard(ApplicationServiceOperationsPage.this.parent, ApplicationServiceOperationsPage.this.mCafApplInt, null);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)ow);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 1) {
                slm.printMessage(mTextPool.getText("BOM_METHODS_0004"));
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            logger.infoT(" DoubleClickListener. mouseDoubleClick" + ApplicationServiceOperationsPage.this.appservName);
            Widget selectedWidget = e.widget;
            if (selectedWidget == ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTable()) {
                IStructuredSelection tableSel = (IStructuredSelection)ApplicationServiceOperationsPage.this.tableViewerAsOperations.getTableViewer().getSelection();
                if (tableSel.isEmpty()) {
                    return;
                }
                ApplicationServiceOperationsPage.this.openEditOperation(tableSel);
            }
        }
    }
}

