/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.ReferenceCounter;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.ApplicationInterfaceEditorInput;
import com.sap.caf.designer.editors.ApplicationServiceDependencesPage;
import com.sap.caf.designer.editors.ApplicationServiceGeneral;
import com.sap.caf.designer.editors.ApplicationServiceOperationsPage;
import com.sap.caf.designer.editors.ImplementationProvider;
import com.sap.caf.designer.editors.JavaContentOutlinePage;
import com.sap.caf.designer.exception.CAFPartInitException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.utils.DateUtils;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ApplicationInterfaceEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ModifyListener,
SelectionListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static String[] buttonsCaption = new String[]{mTextPool.getText("YES"), mTextPool.getText("NO")};
    private static final int PAGE_GENERAL = 0;
    private static final int PAGE_DEPENDENCY = 1;
    private static final int PAGE_OPERATIONS = 2;
    private static final int PAGE_IMPLEMENTATION = 3;
    private static Hashtable instances = new Hashtable();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$editors$ApplicationInterfaceEditor == null ? (class$com$sap$caf$designer$editors$ApplicationInterfaceEditor = ApplicationInterfaceEditor.class$("com.sap.caf.designer.editors.ApplicationInterfaceEditor")) : class$com$sap$caf$designer$editors$ApplicationInterfaceEditor);
    private ApplicationInterface asi;
    private CAFApplicationInterface cafAsi;
    private String objName;
    private String appName;
    private ApplicationServiceGeneral m_generalPage;
    private ApplicationServiceDependencesPage m_dependencesPage;
    private ApplicationServiceOperationsPage m_OperationsPage;
    private ImplementationProvider m_implp;
    private IGridLayoutPane mainPane;
    private boolean isForDelete = false;
    private BOMSystem bmsystem;
    public String username = System.getProperty("user.name");
    boolean dirty = false;
    private int previousPageIndex = -1;
    private ApplicationInterfaceEditorInput asiinputeditor;
    private JavaContentOutlinePage outline = null;
    private BOMSystem.BOMListener m_BOMListener = null;
    private String _projectName;
    static /* synthetic */ Class class$com$sap$caf$designer$editors$ApplicationInterfaceEditor;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public ApplicationInterfaceEditor() {
        ReferenceCounter.increaseReferenceCounter();
    }

    public String getAppName() {
        return this.appName;
    }

    public static ApplicationInterfaceEditor getApplicationInterfaceEditor(String appName, String objName) {
        String key = ApplicationInterfaceEditor.makeSelenaKey(appName, objName);
        return (ApplicationInterfaceEditor)((Object)instances.get(key));
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = ApplicationInterfaceEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            try {
                if (this.m_implp != null) {
                    this.outline = new JavaContentOutlinePage(new QueryImplementationActiveImpl(), (IContentOutlinePage)this.m_implp.getAdapter(required));
                }
            }
            catch (Exception e) {
                this.outline = null;
            }
            return this.outline;
        }
        return super.getAdapter(required);
    }

    public ApplicationInterface getApplicationInterface() {
        return this.asi;
    }

    public BOMSystem getBOMSystem() {
        return this.bmsystem;
    }

    public CAFApplicationInterface getCAFApplicationInterface() {
        return this.cafAsi;
    }

    public void setDirty(boolean dirty) {
        if (dirty) {
            this.bmsystem.getModifiedServicesList().objectModified((BaseObject)this.asi);
        }
        this._setDirty(dirty);
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isDispose() {
        CTabFolder tabFolder;
        int iNumPages = this.getPageCount();
        if (iNumPages != 0 && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed()) {
            int ic1 = 0;
            while (ic1 < iNumPages) {
                CTabItem item = tabFolder.getItem(ic1);
                if (item == null || item.isDisposed()) {
                    return true;
                }
                ++ic1;
            }
            return false;
        }
        return true;
    }

    public void setFocus() {
        switch (this.getActivePage()) {
            case 0: {
                this.m_generalPage.setFocus();
                break;
            }
            case 2: {
                this.m_OperationsPage.setFocus();
                break;
            }
            case 1: {
                this.m_dependencesPage.setFocus();
            }
        }
    }

    public ApplicationServiceGeneral getGeneralPage() {
        return this.m_generalPage;
    }

    public ImplementationProvider getImpl() {
        return this.m_implp;
    }

    public boolean isImplementationActive() {
        return this.previousPageIndex == 3;
    }

    public String getObjectName() {
        return this.objName;
    }

    public ApplicationServiceOperationsPage getOperationPage() {
        return this.m_OperationsPage;
    }

    public boolean isPageDispose(int iPageIndex) {
        CTabItem item;
        CTabFolder tabFolder;
        if (iPageIndex >= 0 && iPageIndex < this.getPageCount() && (tabFolder = (CTabFolder)this.getContainer()) != null && !tabFolder.isDisposed() && (item = tabFolder.getItem(iPageIndex)) != null) {
            return item.isDisposed();
        }
        return true;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        try {
            if (this.dirty) {
                this.saveBOChanges();
            }
            Object var2_1 = null;
            this.bmsystem.removeSystemListener(this.m_BOMListener);
            this.m_generalPage = null;
            this.m_dependencesPage = null;
            this.m_OperationsPage = null;
            this.m_implp = null;
            String key = this.getSelenaObjectKey();
            instances.remove(key);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.bmsystem.removeSystemListener(this.m_BOMListener);
            this.m_generalPage = null;
            this.m_dependencesPage = null;
            this.m_OperationsPage = null;
            this.m_implp = null;
            String key = this.getSelenaObjectKey();
            instances.remove(key);
            ReferenceCounter.decreaseReferenceCounter();
            super.dispose();
            throw throwable;
        }
        ReferenceCounter.decreaseReferenceCounter();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveBOChanges();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        this.getEditor(0).gotoMarker(marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws CAFPartInitException {
        logger.infoT("ApplicationInterfaceEditor .init" + editorInput.getName());
        try {
            String key = null;
            if (editorInput instanceof ApplicationInterfaceEditorInput) {
                this.asiinputeditor = (ApplicationInterfaceEditorInput)editorInput;
                this.cafAsi = this.asiinputeditor.getCAFApplicationInterface();
                this.bmsystem = this.asiinputeditor.getCAFApplicationInterface().getBomSystem();
                this.asi = this.asiinputeditor.getCAFApplicationInterface().getApplicationInterface();
                this._projectName = this.bmsystem.getProjectName();
                this.objName = this.asi.getObjectName();
                if (this.cafAsi.isNew()) {
                    logger.infoT("app editor . init AS isNew =true" + editorInput.getName());
                    this.asi.setCreatedBy(this.username);
                    this.asi.setCreatedAt(DateUtils.getTimeStampDateAsString(new Date()));
                    this.asi.setLastChangedAt(DateUtils.getTimeStampDateAsString(new Date()));
                    this.asi.setLastChangedBy(this.username);
                    this.asi.setBeanState(new Integer(0));
                    this.asi.setRemoteEnabled(new Boolean(false));
                    MetamodelProvider.setDirtyOn(this._projectName);
                } else {
                    this.asi.setLastChangedAt(DateUtils.getTimeStampDateAsString(new Date()));
                    this.asi.setLastChangedBy(this.username);
                }
            } else {
                throw new CAFPartInitException("Invalid Input: Must be IFileEditorInput");
            }
            this.appName = this.bmsystem.getApplicationName();
            key = this.getSelenaObjectKey();
            instances.put(key, this);
            this.m_BOMListener = new BOMSystemListener();
            this.bmsystem.addSystemListener(this.m_BOMListener);
            super.init(site, editorInput);
            super.setTitle(this.objName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.catching((Throwable)e);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setDirty(true);
    }

    public static void refreshImplementation() {
        Iterator aseinst = instances.values().iterator();
        while (aseinst.hasNext()) {
            ((ApplicationInterfaceEditor)((Object)aseinst.next())).setDirty(true);
        }
    }

    public static void refreshInstances() {
        Iterator aseinst = instances.values().iterator();
        while (aseinst.hasNext()) {
            ((ApplicationInterfaceEditor)((Object)aseinst.next())).refresh();
        }
    }

    public String getSelenaObjectKey() {
        return ApplicationInterfaceEditor.makeSelenaKey(this.appName, this.objName);
    }

    public static String makeSelenaKey(String appName, String objName) {
        return appName + ':' + objName;
    }

    public void refreshOperations(Operation operation) {
        this.m_OperationsPage.refreshOperationTable(operation);
        this.setDirty(true);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.setDirty(true);
    }

    public void saveBOChanges() {
        logger.infoT("Start saving..." + this.asi);
        this.setUIControlValues2Model();
        this.m_implp.saveImplementation();
        if (!this.isPageDispose(0)) {
            this.internalRefreshTabstrips();
        }
        this.setDirty(false);
        this.cafAsi.setNew(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.setDirty(true);
    }

    protected void createPages() {
        try {
            this.createPageGeneral();
            this.createDependencyPage();
            this.createPageOperations();
            this.createPageImplementation();
        }
        catch (Throwable e) {
            logger.catching(e);
            e.printStackTrace();
        }
        this.m_OperationsPage.addSelectionProvider();
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    protected void pageChange(int newPageIndex) {
        if (this.previousPageIndex == 1) {
            this.m_dependencesPage.setFocus();
        }
        if (newPageIndex != 0) {
            this.m_generalPage.setFocus();
        }
        if (newPageIndex == 2) {
            this.m_OperationsPage.setFocus();
        }
        if (newPageIndex == 3) {
            this.setUIControlValues2Model();
            this.m_implp.activateSourceDisplay();
        } else {
            this.m_implp.deactivateSourceDisplay();
        }
        this.previousPageIndex = newPageIndex;
        if (this.outline != null) {
            this.outline.setActive(this.isImplementationActive());
        }
    }

    void createDependencyPage() {
        String labelString = mTextPool.getText("AIE.Dependencies_8");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        PaneFactory.createSimplePane((Composite)composite);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.m_dependencesPage = new ApplicationServiceDependencesPage();
        this.m_dependencesPage.createTabContents(mainPane, this);
    }

    void createPageGeneral() {
        String labelString = mTextPool.getText("BOM_TITLE_0008");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.m_generalPage = new ApplicationServiceGeneral();
        this.m_generalPage.createTabContents(this.mainPane, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createPageImplementation() {
        String labelString = mTextPool.getText("BOM_TITLE_0009");
        if (this.cafAsi == null) {
            throw new CAFRuntimeException("Uninitialized CAFApplicationInterface instance");
        }
        this.m_implp = new ImplementationProvider(new NotifyDirtyCallbackImpl(), this.cafAsi.getBomSystem(), this.cafAsi, true);
        boolean bSuccess = false;
        try {
            try {
                int index = this.addPage((IEditorPart)this.m_implp, this.asiinputeditor);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
            catch (PartInitException ex) {
                if (ex instanceof ImplementationProvider.GeneratorPartInitException) {
                    ImplementationProvider.GeneratorPartInitException genEX = (ImplementationProvider.GeneratorPartInitException)ex;
                    genEX.showGeneratorErrorDialog();
                } else {
                    ex.printStackTrace();
                    logger.catching((Throwable)ex);
                }
                Object var6_6 = null;
                if (bSuccess) return;
                Label label = new Label(this.getContainer(), 0);
                label.setText(mTextPool.getText("BOM_ALL_0023"));
                int index = this.addPage((Control)label);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.catching((Throwable)ex);
                Object var6_7 = null;
                if (bSuccess) return;
                Label label = new Label(this.getContainer(), 0);
                label.setText(mTextPool.getText("BOM_ALL_0023"));
                int index = this.addPage((Control)label);
                this.setPageText(index, labelString);
                super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bSuccess) throw throwable;
            Label label = new Label(this.getContainer(), 0);
            label.setText(mTextPool.getText("BOM_ALL_0023"));
            int index = this.addPage((Control)label);
            this.setPageText(index, labelString);
            super.setPageImage(index, SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_REFERENCE_LIST));
            throw throwable;
        }
    }

    void createPageOperations() {
        String labelString = mTextPool.getText("AIE.Operations_7");
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)1);
        PaneFactory.createSimplePane((Composite)composite);
        int index = this.addPage((Control)composite);
        this.setPageText(index, labelString);
        this.m_OperationsPage = new ApplicationServiceOperationsPage();
        this.m_OperationsPage.createTabContents(mainPane, this);
    }

    private void setUIControlValues2Model() {
        logger.infoT("Start transfering values FROM UI control TO Model ..." + this.asi);
        this.asi.setShortText(this.m_generalPage.getDescription());
        this.asi.setBeanState(this.m_generalPage.getStatefulService());
        this.asi.setRemoteEnabled(this.m_generalPage.getRemotlyEnabled());
    }

    private void _setDirty(boolean dirty) {
        logger.infoT("dirty? " + dirty);
        if (this.dirty != dirty) {
            this.dirty = dirty;
            if (dirty) {
                MetamodelProvider.setDirtyOn(this.getProjectName());
            }
        }
    }

    private void deleteEditor() {
        this.dirty = false;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
    }

    private void internalRefreshTabstrips() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        CTabItem item = tabFolder.getItem(0);
        Display display1 = item.getDisplay();
        if (display1 == null || display1.isDisposed()) {
            return;
        }
        display1.syncExec(new Runnable(){

            public void run() {
                ApplicationInterfaceEditor.this.m_generalPage.changeChangedBy(ApplicationInterfaceEditor.this.username);
                Date dt1 = new Date();
                ApplicationInterfaceEditor.this.m_generalPage.changeChangedAt(DateUtils.getDateDateAsString(dt1), DateUtils.getTimeDateAsString(dt1));
            }
        });
    }

    private MOFInterface lookupIninterface(String aName) {
        CAFBaseObject cafInterf = (CAFBaseObject)this.bmsystem.getApplicationInterfaces().get(aName);
        if (cafInterf != null) {
            return ((CAFApplicationInterface)cafInterf).getApplicationInterface();
        }
        cafInterf = (CAFBusinessEntityInterface)this.bmsystem.getBusinessEntityInterfaces().get(aName);
        if (cafInterf != null) {
            return ((CAFBusinessEntityInterface)cafInterf).getBusinesEntityInterface();
        }
        cafInterf = (CAFBaseObject)this.bmsystem.getExternalInterfaces().get(aName);
        if (cafInterf != null) {
            return ((CAFExternalInterface)cafInterf).getExternalInterface();
        }
        return null;
    }

    private void refresh() {
        this.m_OperationsPage.refreshTree();
        this.m_dependencesPage.refreshTree();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class BOMSystemListener
    implements BOMSystem.BOMListener {
        protected BOMSystemListener() {
        }

        public void systemChanged(BOMSystem.BOMEvent e) {
            switch (e.getType()) {
                case 10: {
                    if (e.getTarget() == null || !(e.getTarget() instanceof CAFApplicationInterface)) break;
                    CAFApplicationInterface delInt = (CAFApplicationInterface)e.getTarget();
                    if (ApplicationInterfaceEditor.this.objName.equals(delInt.getApplicationInterface().getObjectName())) {
                        ApplicationInterfaceEditor.this.isForDelete = true;
                        ApplicationInterfaceEditor.this.deleteEditor();
                        break;
                    }
                    ApplicationInterfaceEditor.this.m_dependencesPage.refreshTab((MOFInterface)delInt.getApplicationInterface());
                    break;
                }
                case 11: {
                    ApplicationInterfaceEditor.this.m_dependencesPage.refreshTab(null);
                    break;
                }
                case 7: {
                    if (e.getTarget() == null || !(e.getTarget() instanceof CAFApplicationInterface)) break;
                    CAFApplicationInterface delInt = (CAFApplicationInterface)e.getTarget();
                    if (ApplicationInterfaceEditor.this.objName.equals(delInt.getApplicationInterface().getObjectName())) break;
                    ApplicationInterfaceEditor.this.m_dependencesPage.refreshTab((MOFInterface)delInt.getApplicationInterface());
                    break;
                }
                case 23: {
                    if (e.getTarget() == null || !(e.getTarget() instanceof CAFBusinessEntityInterface)) break;
                    CAFBusinessEntityInterface delInt = (CAFBusinessEntityInterface)e.getTarget();
                    ApplicationInterfaceEditor.this.m_dependencesPage.refreshTab((MOFInterface)delInt.getBusinesEntityInterface());
                    ApplicationInterfaceEditor.this.m_OperationsPage.refreshTree();
                    break;
                }
                case 17: {
                    if (e.getTarget() == null || !(e.getTarget() instanceof CAFExternalInterface)) break;
                    CAFExternalInterface delInt = (CAFExternalInterface)e.getTarget();
                    ApplicationInterfaceEditor.this.m_dependencesPage.refreshTab((MOFInterface)delInt.getExternalInterface());
                    ApplicationInterfaceEditor.this.m_OperationsPage.refreshTree();
                    ApplicationInterfaceEditor.this.setDirty(true);
                    break;
                }
                case 5: {
                    String strProjectName;
                    if (ApplicationInterfaceEditor.this.isDispose() || !(e.getTarget() instanceof String) || !(strProjectName = (String)e.getTarget()).equals(ApplicationInterfaceEditor.this._projectName)) break;
                    ApplicationInterfaceEditor.this.deleteEditor();
                    break;
                }
                case 1: {
                    logger.infoT("ApplicationInterfaceEditor1 " + ApplicationInterfaceEditor.this.asi);
                    if (ApplicationInterfaceEditor.this.dirty) {
                        ApplicationInterfaceEditor.this.saveBOChanges();
                    }
                    ApplicationInterfaceEditor.this.cafAsi.setNew(false);
                    ApplicationInterfaceEditor.this.setDirty(false);
                    break;
                }
                case 2: {
                    logger.infoT("ApplicationInterfaceEditor2 " + ApplicationInterfaceEditor.this.asi);
                    ModelTreeViewer.getInstance().setFocus();
                    if (ApplicationInterfaceEditor.this.isDispose()) break;
                    ApplicationInterfaceEditor.this.m_OperationsPage.refreshParameterTree();
                    break;
                }
                case 4: {
                    logger.infoT("ApplicationInterfaceEditor4 " + ApplicationInterfaceEditor.this.asi);
                    if (!ApplicationInterfaceEditor.this.isDispose()) {
                        ApplicationInterfaceEditor.this.setDirty(false);
                        ApplicationInterfaceEditor.this.deleteEditor();
                    }
                    ModelTreeViewer.getInstance().setFocus();
                    break;
                }
                case 40: {
                    ApplicationInterfaceEditor.this.isForDelete = true;
                    if (ApplicationInterfaceEditor.this.isDispose()) {
                        ApplicationInterfaceEditor.this.setDirty(false);
                        break;
                    }
                    ApplicationInterfaceEditor.this.deleteEditor();
                }
            }
        }
    }

    private class QueryImplementationActiveImpl
    implements JavaContentOutlinePage.IQueryImplementationActive {
        private QueryImplementationActiveImpl() {
        }

        public boolean isImplementationActive() {
            return ApplicationInterfaceEditor.this.isImplementationActive();
        }
    }

    private class NotifyDirtyCallbackImpl
    implements ImplementationProvider.INotifyDirtyCallback {
        private NotifyDirtyCallbackImpl() {
        }

        public void setDirty(boolean isDirty) {
            ApplicationInterfaceEditor.this._setDirty(isDirty);
        }
    }
}

