/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.dtr;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrDialog;
import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.DialogWindow;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.login.UserValidator;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DtrService
implements IResourceChangeListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$dtr$DtrService == null ? (class$com$sap$caf$designer$dtr$DtrService = DtrService.class$("com.sap.caf.designer.dtr.DtrService")) : class$com$sap$caf$designer$dtr$DtrService);
    private boolean m_hasPopUp = true;
    private BOMSystem m_bomsystem = null;
    private IVfsActivity m_vfsActivity = null;
    private IProject cafproject = null;
    private IWorkbenchWindow window = null;
    private DAVTeamProvider teamProvider = null;
    private IDevelopmentComponentNode dcNode = null;
    private IVfsWorkspace m_VfsWorkspace = null;
    private Map m_createResources = null;
    private Map m_updateResources = null;
    private Map m_deleteResources = null;
    private String m_projectName = "";
    private boolean callFinalize = true;
    private static List skipList = new ArrayList();
    static /* synthetic */ Class class$com$sap$caf$designer$dtr$DtrService;
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$repository$RepositoryServices;

    public DtrService(boolean hasPopUp, BOMSystem bomsystem) {
        this.m_hasPopUp = hasPopUp;
        this.m_bomsystem = bomsystem;
        this.m_projectName = this.m_bomsystem.getProjectName();
        this.cafproject = this.m_bomsystem.getPhysicalProjectByType("MMR_CORE");
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (!DtrService.isLocalConfiguration(this.cafproject) && this.isLogged(this.cafproject)) {
            this.teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)this.cafproject);
            this.dcNode = this.getDcNode(this.cafproject);
            try {
                this.m_VfsWorkspace = this.dcNode.getConfiguration().getWorkspaceOfCompartment(this.dcNode.getCompartmentName(), false);
            }
            catch (Exception e) {
                logger.errorT("An error has occured while creating an instance of clas DTRService.Error is:" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static boolean isFileInDtr(IProject project, IFile file) {
        if (DtrService.isLocalConfiguration(project)) {
            return false;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrService.getVfsActivityRecordedFolderItem(project, file);
        if (vfsActivityRecordedFolderItem == null) {
            return false;
        }
        return vfsActivityRecordedFolderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY;
    }

    public void setHasPopUp(boolean hasPopUp) {
        this.m_hasPopUp = hasPopUp;
    }

    public boolean getHasPopUp() {
        return this.m_hasPopUp;
    }

    public static boolean isLocalConfiguration(IProject aProject) {
        IDevelopmentConfiguration devConfig = DtrService.getDcConfiguration(aProject);
        return devConfig == null || devConfig.isLocalConfiguration();
    }

    public boolean isLogged(IProject aProject) {
        logger.infoT("isLogginToDTRServer in" + aProject.getName());
        IDevelopmentConfiguration devConfig = DtrService.getDcConfiguration(aProject);
        return UserValidator.isDefaultServerOnline();
    }

    public void finalizeModifications() {
        if (!this.callFinalize) {
            return;
        }
        if (this.cafproject == null || DtrService.getDcConfiguration(this.cafproject) == null || DtrService.isLocalConfiguration(this.cafproject)) {
            return;
        }
        if (!(this.m_createResources != null && !this.m_createResources.isEmpty() || this.m_updateResources != null && !this.m_updateResources.isEmpty() || this.m_deleteResources != null && !this.m_deleteResources.isEmpty())) {
            return;
        }
        if (this.m_VfsWorkspace == null) {
            this.getTeamProvider(this.cafproject);
        }
        this.getActivity();
        this.updateResources(false, false);
        this.createResources(false);
        this.deleteResources(false);
        this.m_updateResources = null;
        this.m_deleteResources = null;
        this.m_createResources = null;
        this.m_hasPopUp = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyResourceModifications(Map createResources, Map updateResources, Map deleteResources) {
        this.callFinalize = true;
        if (this.cafproject == null || DtrService.getDcConfiguration(this.cafproject) == null || DtrService.isLocalConfiguration(this.cafproject)) {
            return this.callFinalize;
        }
        if (!(createResources != null && !createResources.isEmpty() || updateResources != null && !updateResources.isEmpty() || deleteResources != null && !deleteResources.isEmpty())) {
            return this.callFinalize;
        }
        if (!this.isLogged(this.cafproject)) {
            if (!this.checkForReadOnlyFiles(updateResources) && !this.checkForReadOnlyFiles(deleteResources)) {
                this.callFinalize = true;
                this.addToDTRReplicatorList(createResources, updateResources, deleteResources);
                return this.callFinalize;
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DTR_INFO_TITLE"), (String)mTextPool.getText("DTR_READ_ONLY_INFO"));
            boolean isLogged = this.logonToDtr();
            if (!isLogged) {
                this.reload();
                this.callFinalize = false;
                return this.callFinalize;
            }
        } else if (!this.isProjectUnderSourceControl()) {
            this.addToDTRReplicatorList(createResources, updateResources, deleteResources);
            return this.callFinalize;
        }
        this.m_deleteResources = this.cloneMap(deleteResources);
        this.m_updateResources = this.cloneMap(updateResources);
        this.m_createResources = this.cloneMap(createResources);
        this.updateResources(true, true);
        if (!(this.m_createResources != null && !this.m_createResources.isEmpty() || this.m_updateResources != null && !this.m_updateResources.isEmpty() || this.m_deleteResources != null && !this.m_deleteResources.isEmpty())) {
            this.callFinalize = true;
            return this.callFinalize;
        }
        if (this.m_hasPopUp) {
            DtrDialog dialog = new DtrDialog(this.m_projectName, deleteResources, updateResources, createResources);
            dialog.open();
        }
        try {
            if (this.m_VfsWorkspace == null || this.m_VfsWorkspace.getVersionedFileSystemManager().isReleased()) {
                this.getTeamProvider(this.cafproject);
            }
        }
        catch (Exception e) {
            logger.errorT("Exc " + e.getMessage());
            this.getTeamProvider(this.cafproject);
        }
        this.getActivity();
        boolean result = this.updateResources(true, false);
        if (!result) {
            this.callFinalize = false;
            return this.callFinalize;
        }
        result = this.createResources(true);
        if (!result) {
            this.callFinalize = false;
            return this.callFinalize;
        }
        result = this.deleteResources(true);
        if (!result) {
            this.callFinalize = false;
            return this.callFinalize;
        }
        this.callFinalize = true;
        return this.callFinalize;
    }

    private static IDevelopmentConfiguration getDcConfiguration(IProject aProject) {
        IDevelopmentConfiguration devConfig;
        block8: {
            logger.infoT("getDcCongiguration in aProject" + (aProject == null ? "null project" : aProject.getName()));
            IDCExtendedProject dcPrj = null;
            IDevelopmentComponentNode dcNode = null;
            devConfig = null;
            try {
                if (!DCProjectInfo.isDCProject((IProject)aProject)) break block8;
                dcPrj = (IDCExtendedProject)aProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                IFile file = aProject.getFile(".dcdef");
                if (file.exists()) {
                    try {
                        IDCProxy _dcProxy = DevelopmentConfigurationFactory.getInstance().getDCFromFile(file.getLocation().toFile());
                        if (_dcProxy == null) {
                            return null;
                        }
                    }
                    catch (DevConfigException e) {
                        logger.errorT("Could not get the DC configuration for project:" + aProject.getName() + "The error is:" + e.getMessage());
                        return null;
                    }
                }
                if ((devConfig = dcPrj.getConfiguration()) != null) {
                    return devConfig;
                }
                dcNode = dcPrj.getDCNode();
                if (dcNode != null) {
                    return dcNode.getConfiguration();
                }
            }
            catch (CoreException e) {
                logger.errorT("getDcCongiguration, CoreException occurs" + e.getMessage());
                e.printStackTrace();
            }
        }
        return devConfig;
    }

    public IVfsActivity getActivity() {
        this.getTeamProvider(this.cafproject);
        boolean isOpen = false;
        try {
            if (this.m_vfsActivity != null) {
                isOpen = this.m_vfsActivity.isOpen();
            }
        }
        catch (Throwable e1) {
            logger.infoT("Could not get new activiry for workspace " + e1.getMessage());
            try {
                this.getTeamProvider(this.cafproject);
            }
            catch (Throwable tr) {
                logger.errorT("Could not get TeamProvider for cafproject " + tr);
            }
        }
        if (this.m_vfsActivity != null && isOpen) {
            return this.m_vfsActivity;
        }
        if (!this.m_hasPopUp) {
            this.m_vfsActivity = this.m_VfsWorkspace.getCurrentActivity();
            logger.infoT("workspace.getCurrentActivity()   " + this.m_vfsActivity);
            return this.m_vfsActivity;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SelectActivityDialog selectActivityDialog = new SelectActivityDialog(shell, this.m_VfsWorkspace);
        int selectActivityDialogResult = selectActivityDialog.open();
        if (selectActivityDialogResult != 0) {
            try {
                this.m_vfsActivity = this.m_VfsWorkspace.getDefaultActivity();
            }
            catch (VfsException e) {
                MetamodelCoreEclipsePlugin.internalError((Class)(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = DtrService.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices), (String)"getActivity", (String)"getDefaultActivity failed", (Throwable)e, (boolean)false);
            }
            if (this.m_vfsActivity == null) {
                try {
                    this.m_vfsActivity = this.m_VfsWorkspace.createDefaultActivity();
                }
                catch (Exception e) {
                    logger.errorT("An error occured while getting activity.Error is:" + e.getMessage());
                    e.printStackTrace();
                }
            }
            return this.m_vfsActivity;
        }
        IVfsActivity[] activities = selectActivityDialog.getActivitySelection();
        this.m_vfsActivity = activities != null && activities.length > 0 ? activities[0] : null;
        return this.m_vfsActivity;
    }

    private IDevelopmentComponentNode getDcNode(IProject aProject) {
        IDCExtendedProject dcPrj = null;
        IDevelopmentComponentNode dcNode = null;
        try {
            if (DCProjectInfo.isDCProject((IProject)aProject)) {
                dcPrj = (IDCExtendedProject)aProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                dcNode = dcPrj.getDCNode();
            }
        }
        catch (CoreException e) {
            logger.errorT("getDcCongiguration, CoreException occurs" + e.getMessage());
            e.printStackTrace();
        }
        return dcNode;
    }

    public DAVTeamProvider getTeamProvider(IProject cafproject) {
        this.teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)cafproject);
        this.dcNode = this.getDcNode(cafproject);
        try {
            this.m_VfsWorkspace = DtrService.getDcConfiguration(cafproject).getWorkspaceOfCompartment(this.dcNode.getCompartmentName(), false);
        }
        catch (Exception e) {
            logger.errorT("Error occured.Could not get team provider for project " + cafproject.getName());
            e.printStackTrace();
        }
        return this.teamProvider;
    }

    private IVfsActivityRecordedFolderItem getVfsActivityRecordedFolderItem(DAVTeamProvider teamProvider, IFile file) {
        if (teamProvider == null) {
            return null;
        }
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
        if (vfsFolderItem == null) {
            return null;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = vfsFolderItem.asActivityRecordedFolderItem();
        if (vfsActivityRecordedFolderItem == null) {
            return null;
        }
        return vfsActivityRecordedFolderItem;
    }

    private static IVfsActivityRecordedFolderItem getVfsActivityRecordedFolderItem(IProject aProject, IFile file) {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)aProject);
        if (teamProvider == null) {
            return null;
        }
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem((IResource)file);
        if (vfsFolderItem == null) {
            return null;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = vfsFolderItem.asActivityRecordedFolderItem();
        if (vfsActivityRecordedFolderItem == null) {
            return null;
        }
        return vfsActivityRecordedFolderItem;
    }

    private boolean createResources(boolean notification) {
        boolean result = true;
        if (this.m_createResources == null) {
            return true;
        }
        Iterator iPrTypesToAdd = this.m_createResources.keySet().iterator();
        while (iPrTypesToAdd.hasNext()) {
            Collection resourceAdd;
            String prTypesToAdd = (String)iPrTypesToAdd.next();
            IProject project = this.m_bomsystem.getPhysicalProjectByType(prTypesToAdd);
            if (this.dtrCreateAction(notification, project, resourceAdd = (Collection)this.m_createResources.get(prTypesToAdd))) continue;
            result = false;
        }
        return result;
    }

    private boolean deleteResources(boolean notification) {
        boolean result = true;
        if (this.m_deleteResources == null) {
            return true;
        }
        Iterator iPrTypesToDelete = this.m_deleteResources.keySet().iterator();
        while (iPrTypesToDelete.hasNext()) {
            Collection resourceDel;
            String prTypesToDelete = (String)iPrTypesToDelete.next();
            IProject project = this.m_bomsystem.getPhysicalProjectByType(prTypesToDelete);
            if (this.dtrDeleteAction(notification, project, resourceDel = (Collection)this.m_deleteResources.get(prTypesToDelete))) continue;
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dtrCreateAction(boolean notification, IProject project, Collection filesForCreation) {
        ArrayList<IFile> listForUncheckout;
        ArrayList<IFile> listForEdit;
        ArrayList<IFile> listForCreation;
        boolean success;
        block13: {
            if (filesForCreation == null) {
                return true;
            }
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.open();
            IProgressMonitor progressMonitor = dialog.getProgressMonitor();
            progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), filesForCreation.size());
            success = true;
            Iterator iterator = filesForCreation.iterator();
            listForCreation = new ArrayList<IFile>();
            listForEdit = new ArrayList<IFile>();
            listForUncheckout = new ArrayList<IFile>();
            try {
                try {
                    if (this.teamProvider == null) {
                        this.teamProvider = this.getTeamProvider(project);
                    }
                    while (iterator.hasNext()) {
                        progressMonitor.worked(1);
                        String resourcePath = (String)iterator.next();
                        logger.infoT("makeFilesToAdd  in 6 " + resourcePath);
                        IFile file = project.getFile((IPath)new Path(resourcePath));
                        logger.infoT("makeFilesToAdd  in 7 " + file);
                        if (!DtrService.shouldBeAddedToDTR(file)) continue;
                        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                        if (vfsActivityRecordedFolderItem == null) {
                            logger.infoT("makeFilesToAdd in 8 vfsActivityRecordedFolderItem is NULL!!!!" + project.getName());
                            continue;
                        }
                        logger.infoT("makeFilesToAdd  in 9" + project.getName());
                        VfsFolderItemActivityState state = vfsActivityRecordedFolderItem.getActivityState();
                        logger.infoT("----------------------Add------------------------- state  " + state);
                        if (notification) {
                            if (state != VfsFolderItemActivityState.NOT_CHECKED_OUT || vfsActivityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) continue;
                            listForEdit.add(file);
                            continue;
                        }
                        if (state == VfsFolderItemActivityState.NOT_CHECKED_OUT && vfsActivityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            listForCreation.add(file);
                            continue;
                        }
                        if (state != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) continue;
                        listForUncheckout.add(file);
                        listForCreation.add(file);
                    }
                }
                catch (Throwable th) {
                    logger.errorT(th.getMessage());
                    Object var16_17 = null;
                    if (dialog != null) {
                        dialog.close();
                    }
                    break block13;
                }
                Object var16_16 = null;
                if (dialog == null) break block13;
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (dialog == null) throw throwable;
                dialog.close();
                throw throwable;
            }
            dialog.close();
        }
        if (listForUncheckout.size() > 0) {
            this.uncheckout(listForUncheckout);
        }
        if (listForEdit.size() > 0 && !(success = this.checkout(listForEdit))) {
            return false;
        }
        if (listForCreation.size() <= 0) return success;
        return this.addFilesToSourceControl(listForCreation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dtrDeleteAction(boolean notification, IProject project, Collection filesForDeletion) {
        boolean success;
        ArrayList<IFile> listForUncheckout;
        ArrayList<IFile> listForDeletion;
        block20: {
            if (filesForDeletion == null) {
                return true;
            }
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.open();
            IProgressMonitor progressMonitor = dialog.getProgressMonitor();
            progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), filesForDeletion.size());
            listForDeletion = new ArrayList<IFile>();
            listForUncheckout = new ArrayList<IFile>();
            success = true;
            try {
                try {
                    if (this.teamProvider == null) {
                        this.teamProvider = this.getTeamProvider(project);
                    }
                    Iterator iterator = filesForDeletion.iterator();
                    while (true) {
                        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem;
                        block22: {
                            VfsFolderItemActivityState state;
                            IFile file;
                            block21: {
                                if (!iterator.hasNext()) {
                                    logger.infoT("makeFilesToDelete listForUncheckout.size()=" + listForUncheckout.size() + "; listForDeletion.size()=" + listForDeletion.size());
                                    break;
                                }
                                progressMonitor.worked(1);
                                String resourcePath = (String)iterator.next();
                                logger.infoT("makeFilesTodelete resourcePath=" + resourcePath);
                                file = project.getFile((IPath)new Path(resourcePath));
                                logger.infoT("makeFilesTodelete file==null?-->" + (file == null));
                                if (!DtrService.shouldBeAddedToDTR(file)) continue;
                                vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                                logger.infoT("makeFilesTodelete vfsActivityRecordedFolderItem==null?" + (vfsActivityRecordedFolderItem == null));
                                if (vfsActivityRecordedFolderItem == null) continue;
                                logger.infoT("makeFilesTodelete  9" + project.getName());
                                state = vfsActivityRecordedFolderItem.getActivityState();
                                logger.infoT("--------------DELETE------------------ state  " + state);
                                if (!notification) break block21;
                                if (state == VfsFolderItemActivityState.NOT_CHECKED_OUT && vfsActivityRecordedFolderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                                    listForDeletion.add(file);
                                    break block22;
                                } else if (state == VfsFolderItemActivityState.CHECKED_OUT_FOR_EDIT) {
                                    listForUncheckout.add(file);
                                    listForDeletion.add(file);
                                }
                                break block22;
                            }
                            if (state == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) {
                                listForUncheckout.add(file);
                                new NullProgressMonitor().subTask("uncheckout " + file.getFullPath().toString());
                            }
                        }
                        try {
                            if (!vfsActivityRecordedFolderItem.getParent().isEmpty()) continue;
                            vfsActivityRecordedFolderItem.getParent().refreshState();
                            vfsActivityRecordedFolderItem.getParent().refreshFolderItems();
                        }
                        catch (VfsException e) {
                            logger.errorT("An error has occured while deleting DTR action item.Error is:" + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable th) {
                    logger.errorT(th.getMessage());
                    Object var16_18 = null;
                    if (dialog != null) {
                        dialog.close();
                    }
                    break block20;
                }
                Object var16_17 = null;
                if (dialog == null) break block20;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                if (dialog == null) throw throwable;
                dialog.close();
                throw throwable;
            }
            dialog.close();
        }
        if (listForUncheckout.size() > 0 && !(success = this.uncheckout(listForUncheckout))) {
            return false;
        }
        if (listForDeletion.size() > 0) {
            success = this.checkoutAndDelete(listForDeletion);
        }
        try {
            this.m_vfsActivity.refresh();
            return success;
        }
        catch (VfsException e) {
            logger.errorT("Could not delete DTR action instance.Error is:" + e.getMessage());
            e.printStackTrace();
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dtrUpdateAction(boolean notification, IProject project, Collection filesForEdit) {
        ArrayList<IFile> listForCreation;
        ArrayList<IFile> listForEdit;
        boolean success;
        block12: {
            if (filesForEdit == null) {
                return true;
            }
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.open();
            IProgressMonitor progressMonitor = dialog.getProgressMonitor();
            progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), filesForEdit.size());
            success = true;
            listForEdit = new ArrayList<IFile>();
            listForCreation = new ArrayList<IFile>();
            try {
                try {
                    if (this.teamProvider == null) {
                        this.teamProvider = this.getTeamProvider(project);
                    }
                    Iterator iterator = filesForEdit.iterator();
                    while (true) {
                        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem;
                        if (!iterator.hasNext()) {
                            logger.infoT("makeFilesToUpdate listForEdit.size()=" + listForEdit.size() + "      list for creation " + listForCreation.size());
                            break;
                        }
                        progressMonitor.worked(1);
                        String resourcePath = (String)iterator.next();
                        logger.infoT("makeFilesToUpdate resourcePath=" + resourcePath);
                        IFile file = project.getFile((IPath)new Path(resourcePath));
                        logger.infoT("makeFilesToUpdate file==null?-->" + (file == null));
                        if (!DtrService.shouldBeAddedToDTR(file) || (vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file)) == null) continue;
                        logger.infoT("makeFilesToUpdate  9" + project.getName());
                        VfsFolderItemActivityState state = vfsActivityRecordedFolderItem.getActivityState();
                        logger.infoT("------------------Update-------------- state  " + state);
                        if (notification) {
                            if (state != VfsFolderItemActivityState.NOT_CHECKED_OUT || vfsActivityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) continue;
                            listForEdit.add(file);
                            continue;
                        }
                        if (state != VfsFolderItemActivityState.NOT_CHECKED_OUT || vfsActivityRecordedFolderItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) continue;
                        listForCreation.add(file);
                    }
                }
                catch (Throwable th) {
                    logger.errorT(th.getMessage());
                    Object var15_16 = null;
                    if (dialog != null) {
                        dialog.close();
                    }
                    break block12;
                }
                Object var15_15 = null;
                if (dialog == null) break block12;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (dialog == null) throw throwable;
                dialog.close();
                throw throwable;
            }
            dialog.close();
        }
        if (listForEdit.size() > 0 && !(success = this.checkout(listForEdit))) {
            return false;
        }
        if (listForCreation.size() <= 0) return success;
        return this.addFilesToSourceControl(listForCreation);
    }

    private boolean removeCheckouted(IProject project, Map.Entry currentUpdateProjectName, Collection filesForEdit) {
        boolean success = true;
        if (this.teamProvider == null) {
            this.teamProvider = this.getTeamProvider(project);
        }
        Iterator iterator = filesForEdit.iterator();
        ArrayList<String> removeList = new ArrayList<String>();
        while (iterator.hasNext()) {
            VfsFolderItemActivityState state;
            IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem;
            String resourcePath = (String)iterator.next();
            IFile file = project.getFile((IPath)new Path(resourcePath));
            if (!DtrService.shouldBeAddedToDTR(file) || (vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file)) == null || (state = vfsActivityRecordedFolderItem.getActivityState()) == VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
            removeList.add(resourcePath);
        }
        Collection resourceUpdate = (Collection)currentUpdateProjectName.getValue();
        if (resourceUpdate != null) {
            Iterator it = removeList.iterator();
            while (it.hasNext()) {
                resourceUpdate.remove(it.next());
            }
        }
        return resourceUpdate == null || resourceUpdate.isEmpty();
    }

    private boolean updateResources(boolean notification, boolean removeAlreadyCheckouted) {
        boolean result = true;
        if (this.m_updateResources == null) {
            return true;
        }
        Iterator iPrTypesToUpdate = this.m_updateResources.entrySet().iterator();
        while (iPrTypesToUpdate.hasNext()) {
            Map.Entry currentUpdateProjectName = iPrTypesToUpdate.next();
            String prTypesToUpdate = (String)currentUpdateProjectName.getKey();
            IProject project = this.m_bomsystem.getPhysicalProjectByType(prTypesToUpdate);
            Collection resourceUpdate = (Collection)this.m_updateResources.get(prTypesToUpdate);
            if (removeAlreadyCheckouted) {
                if (!this.removeCheckouted(project, currentUpdateProjectName, resourceUpdate)) continue;
                iPrTypesToUpdate.remove();
                continue;
            }
            if (this.dtrUpdateAction(notification, project, resourceUpdate)) continue;
            result = false;
        }
        return result;
    }

    private boolean checkForReadOnlyFiles(Map resources) {
        if (resources == null) {
            return false;
        }
        Iterator iPrTypes = resources.keySet().iterator();
        while (iPrTypes.hasNext()) {
            String prTypes = (String)iPrTypes.next();
            IProject project = this.m_bomsystem.getPhysicalProjectByType(prTypes);
            Collection resourceColl = (Collection)resources.get(prTypes);
            Iterator iterator = resourceColl.iterator();
            while (iterator.hasNext()) {
                String resourcePath = (String)iterator.next();
                IFile file = project.getFile((IPath)new Path(resourcePath));
                if (!file.exists() || !file.isReadOnly()) continue;
                logger.infoT("WARNING: Can not perform changes, there is a read only file : " + file.getName());
                return true;
            }
        }
        return false;
    }

    private void reload() {
        try {
            this.m_bomsystem.rollbackReloadSystem();
            MetamodelProvider.setDirty(this.m_bomsystem.getProjectName(), false);
            ModelTreeViewer.deepRefreshInstances();
            ModelTreeViewer.refreshInstances();
        }
        catch (CAFResourceException e) {
            ((Throwable)((Object)e)).printStackTrace();
            logger.errorT("Exc: " + (Object)((Object)e));
        }
    }

    private boolean logonToDtr() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, (Shell)shell);
        return this.isLogged(this.cafproject);
    }

    private boolean isProjectUnderSourceControl() {
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)this.cafproject);
        return teamProvider != null;
    }

    private void addToDTRReplicatorList(Map createResources, Map updateResources, Map deleteResources) {
        String fullPath;
        String resourcePath;
        Iterator iterator;
        Collection resourceColl;
        String prTypes;
        Iterator iPrTypes;
        if (createResources != null) {
            iPrTypes = createResources.keySet().iterator();
            while (iPrTypes.hasNext()) {
                prTypes = (String)iPrTypes.next();
                resourceColl = (Collection)createResources.get(prTypes);
                iterator = resourceColl.iterator();
                while (iterator.hasNext()) {
                    resourcePath = (String)iterator.next();
                    fullPath = this.m_bomsystem.getGeneratedFilesList().getFullPath(resourcePath, prTypes);
                    this.m_bomsystem.getDTRReplicatorList().addToList(fullPath);
                }
            }
        }
        if (updateResources != null) {
            iPrTypes = updateResources.keySet().iterator();
            while (iPrTypes.hasNext()) {
                prTypes = (String)iPrTypes.next();
                resourceColl = (Collection)updateResources.get(prTypes);
                iterator = resourceColl.iterator();
                while (iterator.hasNext()) {
                    resourcePath = (String)iterator.next();
                    if (!resourcePath.startsWith("/GeneratedFilesList.")) continue;
                    fullPath = this.m_bomsystem.getGeneratedFilesList().getFullPath(resourcePath, prTypes);
                    this.m_bomsystem.getDTRReplicatorList().addToList(fullPath);
                }
            }
        }
        if (deleteResources != null) {
            iPrTypes = deleteResources.keySet().iterator();
            while (iPrTypes.hasNext()) {
                prTypes = (String)iPrTypes.next();
                resourceColl = (Collection)deleteResources.get(prTypes);
                iterator = resourceColl.iterator();
                while (iterator.hasNext()) {
                    resourcePath = (String)iterator.next();
                    fullPath = this.m_bomsystem.getGeneratedFilesList().getFullPath(resourcePath, prTypes);
                    this.m_bomsystem.getDTRReplicatorList().removeFormList(fullPath);
                }
            }
        }
    }

    private static boolean shouldBeAddedToDTR(IFile file) {
        return file != null && !skipList.contains(file.getName());
    }

    public static boolean shouldBeAddedToDTR(String sFile) {
        return sFile != null && !skipList.contains(sFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkout(List files) {
        String message;
        boolean result;
        block16: {
            ProgressMonitorDialog dialog;
            block15: {
                boolean bl;
                block14: {
                    IVfsActivity vfsActivity = null;
                    result = true;
                    message = "";
                    dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.open();
                    IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                    progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), files.size());
                    try {
                        try {
                            Iterator it = files.iterator();
                            while (it.hasNext()) {
                                IFile file = (IFile)it.next();
                                if (!file.exists() || !file.isReadOnly()) continue;
                                IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                                if (vfsActivityRecordedFolderItem != null) {
                                    if (vfsActivity == null) {
                                        vfsActivity = this.getActivity();
                                    }
                                    if (vfsActivity == null) {
                                        dialog.close();
                                        bl = false;
                                        Object var12_13 = null;
                                        if (dialog == null) return bl;
                                        break block14;
                                    }
                                    progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_CHECKOUT", new Object[]{file.getName()}));
                                    try {
                                        vfsActivityRecordedFolderItem.checkOutForEdit(vfsActivity, true);
                                    }
                                    catch (Exception e) {
                                        message = message + mTextPool.getText("DTR_ERROR_CHECKOUT") + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                                        result = false;
                                    }
                                }
                                progressMonitor.worked(1);
                            }
                            break block15;
                        }
                        catch (Throwable e) {
                            logger.errorT(e.getMessage());
                            Object var12_15 = null;
                            if (dialog != null) {
                                dialog.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (dialog != null) {
                            dialog.close();
                        }
                        throw throwable;
                    }
                }
                dialog.close();
                return bl;
            }
            Object var12_14 = null;
            if (dialog != null) {
                dialog.close();
            }
        }
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addFilesToSourceControl(List files) {
        String message;
        boolean result;
        block18: {
            ProgressMonitorDialog dialog;
            block17: {
                boolean bl;
                block16: {
                    IVfsActivity vfsActivity = null;
                    result = true;
                    message = "";
                    dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.open();
                    IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                    progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), files.size());
                    try {
                        try {
                            Iterator iterator = files.iterator();
                            while (iterator.hasNext()) {
                                IFile file = (IFile)iterator.next();
                                IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                                if (vfsActivityRecordedFolderItem != null) {
                                    if (vfsActivity == null) {
                                        vfsActivity = this.getActivity();
                                    }
                                    if (vfsActivity == null) {
                                        dialog.close();
                                        bl = false;
                                        Object var12_13 = null;
                                        if (dialog == null) return bl;
                                        break block16;
                                    }
                                    progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_ADD", new Object[]{file.getName()}));
                                    if (file.isReadOnly()) {
                                        message = message + mTextPool.getText("DTR_ERROR_ADD_READONLY") + file.getFullPath().toString() + "\n";
                                        result = false;
                                    } else {
                                        try {
                                            vfsActivityRecordedFolderItem.createAndCheckout(vfsActivity);
                                        }
                                        catch (VfsException e) {
                                            message = message + mTextPool.getText("DTR_ERROR_ADD") + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                                            result = false;
                                        }
                                    }
                                }
                                progressMonitor.worked(1);
                            }
                            break block17;
                        }
                        catch (Throwable th) {
                            logger.errorT(th.getMessage());
                            Object var12_15 = null;
                            if (dialog != null) {
                                dialog.close();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (dialog != null) {
                            dialog.close();
                        }
                        throw throwable;
                    }
                }
                dialog.close();
                return bl;
            }
            Object var12_14 = null;
            if (dialog != null) {
                dialog.close();
            }
        }
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkoutAndDelete(List files) {
        String message;
        boolean result;
        block16: {
            ProgressMonitorDialog dialog;
            block15: {
                boolean bl;
                block14: {
                    IVfsActivity vfsActivity = null;
                    result = true;
                    message = "";
                    dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.open();
                    IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                    progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), files.size());
                    try {
                        try {
                            Iterator it = files.iterator();
                            while (it.hasNext()) {
                                IFile file = (IFile)it.next();
                                if (!file.exists() || !file.isReadOnly()) continue;
                                IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                                if (vfsActivityRecordedFolderItem != null) {
                                    if (vfsActivity == null) {
                                        vfsActivity = this.getActivity();
                                    }
                                    if (vfsActivity == null) {
                                        dialog.close();
                                        bl = false;
                                        Object var12_13 = null;
                                        if (dialog == null) return bl;
                                        break block14;
                                    }
                                    progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_DELETE", new Object[]{file.getName()}));
                                    try {
                                        vfsActivityRecordedFolderItem.checkOutAndDelete(vfsActivity);
                                    }
                                    catch (Exception e) {
                                        message = message + mTextPool.getText("DTR_ERROR_DELETE") + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                                        result = false;
                                    }
                                }
                                progressMonitor.worked(1);
                            }
                            break block15;
                        }
                        catch (Throwable th) {
                            logger.errorT(th.getMessage());
                            Object var12_15 = null;
                            if (dialog != null) {
                                dialog.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (dialog != null) {
                            dialog.close();
                        }
                        throw throwable;
                    }
                }
                dialog.close();
                return bl;
            }
            Object var12_14 = null;
            if (dialog != null) {
                dialog.close();
            }
        }
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uncheckout(List files) {
        String message;
        boolean result;
        block16: {
            ProgressMonitorDialog dialog;
            block15: {
                boolean bl;
                block14: {
                    IVfsActivity vfsActivity = null;
                    result = true;
                    message = "";
                    dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    dialog.open();
                    IProgressMonitor progressMonitor = dialog.getProgressMonitor();
                    progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), files.size());
                    try {
                        try {
                            Iterator it = files.iterator();
                            while (it.hasNext()) {
                                IFile file = (IFile)it.next();
                                if (!file.exists()) continue;
                                IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = this.getVfsActivityRecordedFolderItem(this.teamProvider, file);
                                if (vfsActivityRecordedFolderItem != null) {
                                    if (vfsActivity == null) {
                                        vfsActivity = this.getActivity();
                                    }
                                    if (vfsActivity == null) {
                                        dialog.close();
                                        bl = false;
                                        Object var12_13 = null;
                                        if (dialog == null) return bl;
                                        break block14;
                                    }
                                    progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_UNCHECKOUT", new Object[]{file.getName()}));
                                    try {
                                        vfsActivityRecordedFolderItem.uncheckout(vfsActivity);
                                    }
                                    catch (Exception e) {
                                        message = message + mTextPool.getText("DTR_ERROR_UNCHECKOUT") + e.getMessage() + " " + file.getFullPath().toString() + "\n";
                                        result = false;
                                    }
                                }
                                progressMonitor.worked(1);
                            }
                            break block15;
                        }
                        catch (Throwable th) {
                            logger.errorT(th.getMessage());
                            Object var12_15 = null;
                            if (dialog != null) {
                                dialog.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (dialog != null) {
                            dialog.close();
                        }
                        throw throwable;
                    }
                }
                dialog.close();
                return bl;
            }
            Object var12_14 = null;
            if (dialog != null) {
                dialog.close();
            }
        }
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        }
        return result;
    }

    private Map cloneMap(Map map) {
        if (map == null) {
            return null;
        }
        HashMap clonedMap = new HashMap();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object keyObj = it.next();
            Collection valueObj = this.cloneCollection(map.get(keyObj));
            if (valueObj == null) continue;
            clonedMap.put(keyObj, valueObj);
        }
        return clonedMap;
    }

    private Collection cloneCollection(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Collection)) {
            logger.infoT("Map value isn't Collection!!!!!!!");
            return null;
        }
        Collection coll = (Collection)obj;
        ArrayList cloneCollection = new ArrayList();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            cloneCollection.add(next);
        }
        return cloneCollection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        skipList.add("DTRReplicatorList.bckp");
        skipList.add("DTRReplicatorList.orig");
    }
}

