/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.dtr;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DtrDialog
extends Dialog {
    private static final TextPool mTextPool = TextPool.getInstance();
    private Text mTextField = null;
    Map resourceToDelete;
    Map resourceToUpdate;
    Map resourceToAdd;
    String projectName;

    public DtrDialog(String projectName, Map resourceToDelete, Map resourceToUpdate, Map resourceToAdd) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.resourceToAdd = resourceToAdd;
        this.resourceToUpdate = resourceToUpdate;
        this.resourceToDelete = resourceToDelete;
        this.projectName = projectName;
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(mTextPool.getText("DTR_INFO_TITLE"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)parentComposite.getLayout()).numColumns = 2;
        Image image = JFaceResources.getImageRegistry().get("dialog_info_image");
        if (image != null) {
            Label label = new Label(parentComposite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        IGridLayoutPane userArea = PaneFactory.createGridLayoutPane((Composite)parentComposite, (int)1);
        GridData userAreaData = new GridData(1808);
        userArea.setLayoutData((Object)userAreaData);
        IGridLayoutData gridLayoutData = userArea.createGridLayoutData(4, 4, true, false);
        this.mTextField = userArea.addTextPane(this.createMessage(this.resourceToDelete, this.resourceToUpdate, this.resourceToAdd), true, false, gridLayoutData);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 350;
        gridData.widthHint = 500;
        this.mTextField.setLayoutData((Object)gridData);
        return parentComposite;
    }

    private Collection getCollection(Map resourceChanged) {
        ArrayList coll = new ArrayList();
        if (resourceChanged != null && !resourceChanged.isEmpty()) {
            Iterator iPrTypes = resourceChanged.keySet().iterator();
            while (iPrTypes.hasNext()) {
                String prTypes = (String)iPrTypes.next();
                Collection tmp = (Collection)resourceChanged.get(prTypes);
                if (tmp == null) continue;
                coll.addAll(tmp);
            }
        }
        return coll;
    }

    private String getMsg(Collection coll, String info) {
        String msg = "";
        if (!coll.isEmpty()) {
            msg = msg + info + "\n";
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                String tmp;
                String sFile = (String)it.next();
                if (sFile == null || sFile.lastIndexOf("/") == -1 || !DtrService.shouldBeAddedToDTR(tmp = sFile.substring(sFile.lastIndexOf("/") + 1))) continue;
                msg = msg + sFile + "\n ";
            }
            msg = msg + "\n ";
        }
        return msg;
    }

    private String createMessage(Map resourceToDelete, Map resourceToUpdate, Map resourceToAdd) {
        Collection resourceDel = this.getCollection(resourceToDelete);
        Collection resourceUpd = this.getCollection(resourceToUpdate);
        Collection resourceAdd = this.getCollection(resourceToAdd);
        String msg = "";
        msg = msg + this.getMsg(resourceAdd, mTextPool.getText("DTR_INFO_NEW"));
        msg = msg + this.getMsg(resourceUpd, mTextPool.getText("DTR_INFO_UPDATE"));
        msg = msg + this.getMsg(resourceDel, mTextPool.getText("DTR_INFO_DELETE"));
        msg = mTextPool.getText("DTR_PROJECT_INFO", new Object[]{this.projectName}) + "\n \n" + msg;
        return msg;
    }
}

