/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.dtr;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.NamereservationUtil;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddDCsAndFilesToSourceControl {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$dtr$AddDCsAndFilesToSourceControl == null ? (class$com$sap$caf$designer$dtr$AddDCsAndFilesToSourceControl = AddDCsAndFilesToSourceControl.class$("com.sap.caf.designer.dtr.AddDCsAndFilesToSourceControl")) : class$com$sap$caf$designer$dtr$AddDCsAndFilesToSourceControl);
    static /* synthetic */ Class class$com$sap$caf$designer$dtr$AddDCsAndFilesToSourceControl;

    public static boolean addToSourceControl(DtrService dtrService, IProject project) {
        block26: {
            IDevelopmentComponentNode dcNode = ComponentUtil.getDCNode((IProject)project);
            IDCProxy dcInfo = null;
            try {
                dcInfo = dcNode.getDCProxy();
            }
            catch (Exception e2) {
                return false;
            }
            IVfsWorkspace workspace = AddDCsAndFilesToSourceControl.getWorkspace(dcNode);
            if (workspace == null) {
                return false;
            }
            try {
                IVfsActivity activity = dtrService.getActivity();
                if (activity == null) {
                    return false;
                }
                AllocationState nameState = null;
                String resName = NamereservationUtil.getDCReservationName((IDevelopmentComponentNode)dcNode);
                NameAllocator allocator = NameServerUtil.getNameAllocator((IProject)project);
                if (allocator != null) {
                    try {
                        if (NamereservationUtil.isDCReserved((Object)resName, (NameAllocator)allocator)) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)mTextPool.getText("DC_RESERVED", new Object[]{resName}));
                            return false;
                        }
                    }
                    catch (Exception e) {
                        logger.errorT("Name is reserved : " + e.getMessage());
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
                        return false;
                    }
                    try {
                        if (allocator != null && resName != null) {
                            nameState = NamereservationUtil.reserveDC((Object)resName, (NameAllocator)allocator);
                        }
                    }
                    catch (Throwable e) {
                        logger.errorT("Problem while reserving name " + e.getMessage());
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
                        return false;
                    }
                }
                boolean success = false;
                try {
                    dcInfo.addToSourceControl(activity);
                    success = true;
                }
                catch (Exception e) {
                    logger.errorT("Problem while adding to source control " + e.getMessage());
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
                    return false;
                }
                boolean nameinDtrReserved = false;
                if (success && allocator != null && nameState != null) {
                    try {
                        IVfsFile dcdefFile = dcInfo.getComponentDefinitionVfsFile();
                        if (dcdefFile == null) {
                            success = false;
                        } else {
                            nameinDtrReserved = NamereservationUtil.reserveDCinDTR((IVfsFile)dcdefFile, (String)resName, (AllocationState)nameState, (NameAllocator)allocator, (IVfsActivity)activity);
                        }
                    }
                    catch (Throwable e) {
                        logger.errorT("Setting of DTR Properties failed " + e.getMessage());
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
                        return false;
                    }
                }
                if (!success || !nameinDtrReserved) {
                    try {
                        if (allocator != null && resName != null) {
                            NamereservationUtil.revertDCReservation((Object)resName, (NameAllocator)allocator);
                        }
                        break block26;
                    }
                    catch (Throwable e) {
                        logger.errorT("Name Reservation Reverting failed " + e.getMessage());
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
                        return false;
                    }
                }
                try {
                    DCProjectUtil.setDTRTeamProviderForProject((IDevelopmentComponentNode)dcNode);
                }
                catch (Throwable e1) {
                    logger.errorT("Sharing of Project with DTR failed " + e1.getMessage());
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e1.getMessage());
                    return false;
                }
            }
            catch (Throwable ex) {
                logger.errorT("DC Add to Source Control failed " + ex.getMessage());
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private static IVfsWorkspace getWorkspace(IDevelopmentComponentNode dcNode) {
        if (dcNode == null) {
            return null;
        }
        boolean active = !dcNode.IsInactive();
        IDevelopmentConfiguration configuration = dcNode.getConfiguration();
        Compartment compartment = dcNode.getCompartment();
        if (configuration != null && compartment != null) {
            try {
                return configuration.getWorkspaceOfCompartment(compartment.getName(), active);
            }
            catch (Exception e) {
                logger.errorT("Getting Workspace failed " + e.getMessage());
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("DC_ERROR_TITLE"), (String)e.getMessage());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

