/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.dnd;

import com.sap.caf.designer.dnd.ModelElementSource;
import com.sap.caf.designer.dnd.ModelElementSourceTransfer;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ModelDragSourceListener
implements DragSourceListener {
    public static String TABLE_ROW_SUBDOMAIN = "TABLE_ROW_SUBDOMAIN";
    private static final boolean DEBUG = true;
    private HashSet sourceSubDomainSet;

    public ModelDragSourceListener() {
        this(new String[]{"Business Object", "Value Object", "Object Field Attribute", "Object Attribute"});
    }

    public ModelDragSourceListener(String[] sourceSubDomains) {
        this.sourceSubDomainSet = new HashSet<String>(Arrays.asList(sourceSubDomains));
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit || event.detail != 0) {
            // empty if block
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (ModelElementSourceTransfer.getInstance().isSupportedType(event.dataType)) {
            DragSource source = (DragSource)event.getSource();
            Object items = null;
            items = source.getControl() instanceof Tree ? ((Tree)source.getControl()).getSelection() : (source.getControl() instanceof Table ? ((Table)source.getControl()).getSelection() : null);
            if (items == null || ((TreeItem[])items).length == 0) {
                return;
            }
            ModelElementSource[] elementSources = new ModelElementSource[((TreeItem[])items).length];
            int i = 0;
            while (i < ((TreeItem[])items).length) {
                final Object obj = items[i].getData();
                UniqueName uniqueName = null;
                if (obj instanceof Entity) {
                    uniqueName = ((Entity)obj).getUniqueName();
                    elementSources[i] = new ModelElementSource(uniqueName);
                } else if (obj instanceof SapTableRow) {
                    uniqueName = new UniqueName(){

                        public String getDomain() {
                            return null;
                        }

                        public String getSubDomain() {
                            return TABLE_ROW_SUBDOMAIN;
                        }

                        public String getLocation() {
                            return null;
                        }

                        public String getName() {
                            return ((SapTableRow)obj).toString();
                        }

                        public int getParametersCount() {
                            return 1;
                        }

                        public String getParameter(int arg0) {
                            if (arg0 == 0) {
                                return "" + ((SapTableRow)obj).getRowNum();
                            }
                            return null;
                        }

                        public UniqueName getParentUniqueName() {
                            return null;
                        }
                    };
                    elementSources[i] = new ModelElementSource(uniqueName);
                }
                ++i;
            }
            event.data = elementSources;
        }
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        DragSource source = (DragSource)event.getSource();
        Object items = null;
        items = source.getControl() instanceof Tree ? ((Tree)source.getControl()).getSelection() : (source.getControl() instanceof Table ? ((Table)source.getControl()).getSelection() : null);
        if (items == null || ((TreeItem[])items).length == 0) {
            return;
        }
        int i = 0;
        while (i < ((TreeItem[])items).length) {
            Object obj = items[i].getData();
            if (obj instanceof Entity) {
                UniqueName uniqueName = ((Entity)obj).getUniqueName();
                String subDomain = uniqueName.getSubDomain();
                if (!this.sourceSubDomainSet.contains(subDomain)) {
                    return;
                }
            } else if (!(obj instanceof SapTableRow)) {
                return;
            }
            ++i;
        }
        event.doit = true;
    }
}

