/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.structure.BOMSystem;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.deploy.DeployerFactory;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.j2ee.ui.core.deploy.IDeployer;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.UserDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;

public class SDMDeployAction
implements IElementSingleAction {
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$caf$designer$actions$SDMDeployAction == null ? (class$com$sap$caf$designer$actions$SDMDeployAction = SDMDeployAction.class$("com.sap.caf.designer.actions.SDMDeployAction")) : class$com$sap$caf$designer$actions$SDMDeployAction));
    private static IDeployer sdmDeployer = DeployerFactory.getSDMDeployer();
    private static final String DISPLAY_INFO = "Deploy";
    private static final String DISPLAY_NAME = "Deploy to J2EE engine";
    private static final String DESCRIPTION = "Deploy an archive with the SDM to the SAP J2EE engine";
    private final ICategory DEFAULT_CATEGORY = Category.createDisplayableCategory((ICategory)Category.OTHERS, (String)"Deploy an archive with the SDM to the SAP J2EE engine", (String)"Deploy to J2EE engine", (String)"Deploy", null);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$SDMDeployAction;

    public SDMDeployAction() {
        if (sdmDeployer == null) {
            tracer.fatal("SDM deployer not available -> No deployment possible !!" + sdmDeployer);
        }
    }

    public boolean isAvailable(Element element) {
        boolean availableFlag = true;
        return availableFlag;
    }

    public ICategory getCategory() {
        return this.DEFAULT_CATEGORY;
    }

    public List getDeployableFiles(BOMSystem bos) {
        String[] prjTypes = new String[]{"MMR", "DICT", "WDP_PROJECT", "UME_PROJECT", "ENTERPRISE_APPLICATION"};
        ArrayList<IFile> deployableFiles = new ArrayList<IFile>();
        HashMap relPrj = bos.getRelatedProjects();
        Iterator it = relPrj.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
        }
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < prjTypes.length) {
            try {
                Path prjPath;
                File folder;
                IProject prj;
                String projectName = bos.getRelatedProjectNameByType(prjTypes[i]);
                IFolder archiveFolder = null;
                if (projectName != null && (prj = myWorkspaceRoot.getProject(projectName)) != null && (folder = (archiveFolder = prj.getFolder((IPath)(prjPath = new Path("gen/default/deploy")))).getLocation().toFile()) != null) {
                    File[] files = folder.listFiles();
                    int j = 0;
                    while (j < files.length) {
                        Path filePath = new Path("gen/default/deploy/" + files[j].getName());
                        IFile archiveFile = prj.getFile((IPath)filePath);
                        deployableFiles.add(archiveFile);
                        ++j;
                    }
                }
            }
            catch (Exception e) {
                tracer.fatal("Error while reading deployable files for this project.The error is:" + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        return deployableFiles;
    }

    public boolean isEnabled(Element element) {
        boolean enabledFlag = true;
        return enabledFlag;
    }

    public void run(Element element) {
        String projectName = element.getUniqueName().getParameter(0);
        BOMSystem bos = BOMSystem.getBOMSystem(projectName);
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        List deployableFiles = this.getDeployableFiles(bos);
        boolean allDeployedOK = true;
        int i = 0;
        while (i < deployableFiles.size()) {
            IFile archiveFile = (IFile)deployableFiles.get(i);
            if (sdmDeployer != null && archiveFile != null) {
                if (sdmDeployer.canDeployAsync(archiveFile)) {
                    try {
                        sdmDeployer.deployAsync(archiveFile, tracer);
                    }
                    catch (DeploymentException ex) {
                        allDeployedOK = false;
                        UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Could not deploy succesfully", (String)("The deployment of the archive failed with an exception !\n(" + ex.getMessage() + ")" + "\nPlease check the error log for further informations."));
                        tracer.error("Deployment Exception is arise" + element, (Throwable)ex);
                    }
                } else {
                    allDeployedOK = false;
                    UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Cannot deploy", (String)"The deployment of the archive is already running !\nPlease wait until it is finished (watch the Deploy Output View).");
                }
            }
            ++i;
        }
    }

    private IFile getArchiveFile(Element element) {
        IFile archiveFile = null;
        IJ2eeProject prj = J2eeElementManager.getJ2eeProject((Element)element.getModel());
        if (prj instanceof IRepresentArchive) {
            IRepresentArchive archivePrj = (IRepresentArchive)prj;
            archiveFile = archivePrj.getArchiveLocationFullPath();
            if (!archiveFile.exists()) {
                tracer.error("Problems during deployment, archive file does not exist !" + (archiveFile != null ? archiveFile.getName() : archiveFile.toString()));
            }
        } else {
            tracer.error("Can not deploy: no valid archive-project !" + (prj != null ? prj.getName() : prj.toString()));
        }
        return archiveFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

