/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.status.Message;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectValidateAction
extends BaseSingleAction {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$ProjectValidateAction == null ? (class$com$sap$caf$designer$actions$ProjectValidateAction = ProjectValidateAction.class$("com.sap.caf.designer.actions.ProjectValidateAction")) : class$com$sap$caf$designer$actions$ProjectValidateAction);
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$caf$designer$actions$ProjectValidateAction;

    public ProjectValidateAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        logger.infoT("Validating... Uniquename: " + uniqueName.getName());
        logger.infoT("Validating... Uniquename: " + uniqueName.getParameter(0));
        BOMSystem bos = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(window.getShell());
            GenerationProcess process = new GenerationProcess(bos, window);
            pmd.run(false, false, (IRunnableWithProgress)process);
            if (process.getGenerationMonitor().getStatus().hasErrors()) {
                throw new CAFBaseException(((Message)process.getGenerationMonitor().getStatus().getMessages().get(0)).getText());
            }
            if (bos.getStatus().hasErrors()) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("VALIDATE_PROJECT_FINISHED_TITLE"), (String)mTextPool.getText("VALIDATE_PROJECT_FINISHED_MESSAGE_FAILURE"));
            } else {
                MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("VALIDATE_PROJECT_FINISHED_TITLE"), (String)mTextPool.getText("VALIDATE_PROJECT_FINISHED_MESSAGE_SUCCESS"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.catching((Throwable)ex);
            MessageDialog.openError((Shell)window.getShell(), (String)mTextPool.getText("VALIDATE_PROJECT_APPLICATION_TITLE_FAIL"), (String)mTextPool.getText("VALIDATE_PROJECT_APPLICATION_MSG_FAIL", new String[]{ex.getMessage()}));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GenerationProcess
    implements IRunnableWithProgress {
        GenerationMonitor gmonitor = null;
        BOMSystem bos = null;
        IWorkbenchWindow window;

        public GenerationProcess(BOMSystem bos, IWorkbenchWindow widnow) {
            this.bos = bos;
            this.window = widnow;
        }

        public GenerationMonitor getGenerationMonitor() {
            return this.gmonitor;
        }

        public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
            this.gmonitor = new GenerationMonitor(monitor);
            Object generationStatus = null;
            this.bos.validate();
            this.bos.refreshStatus();
            monitor.subTask("");
            monitor.beginTask(mTextPool.getText("VALIDATE_PROJECT_SYNCHRONIZING_PROJECTS"), 100);
            int i = 200;
            while (this.window.getShell().getDisplay().readAndDispatch()) {
                if ((i += 20) > 100) {
                    i = 0;
                    monitor.beginTask(mTextPool.getText("VALIDATE_PROJECT_SYNCHRONIZING_PROJECTS"), 100);
                }
                monitor.worked(20);
            }
            monitor.worked(100);
            monitor.done();
            if (generationStatus != null) {
                throw new CAFInvocationTargetException(null);
            }
        }
    }
}

