/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.action.ICategory;
import javax.resource.ResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectReloadAction
extends BaseSingleAction {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$ProjectReloadAction == null ? (class$com$sap$caf$designer$actions$ProjectReloadAction = ProjectReloadAction.class$("com.sap.caf.designer.actions.ProjectReloadAction")) : class$com$sap$caf$designer$actions$ProjectReloadAction);
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$caf$designer$actions$ProjectReloadAction;

    public ProjectReloadAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        try {
            String projectName = element.getUniqueName().getParameter(0).trim();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            BOMSystem bos = BOMSystem.getBOMSystem(projectName);
            bos.rollbackSystem();
            MetamodelProvider.setDirty(projectName, false);
            if (!DtrService.isLocalConfiguration(project)) {
                bos.checkWorkspaceForChanges();
            }
            ModelTreeViewer.refreshInstances();
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

