/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectGenerateWDAction
extends BaseSingleAction {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$ProjectGenerateWDAction == null ? (class$com$sap$caf$designer$actions$ProjectGenerateWDAction = ProjectGenerateWDAction.class$("com.sap.caf.designer.actions.ProjectGenerateWDAction")) : class$com$sap$caf$designer$actions$ProjectGenerateWDAction);
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$caf$designer$actions$ProjectGenerateWDAction;

    public ProjectGenerateWDAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        logger.infoT("Creating WebDynPro Model... Uniquename: " + uniqueName.getName());
        logger.infoT("Creating WebDynPro Model... Uniquename: " + uniqueName.getParameter(0));
        BOMSystem bos = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bos.getPhysicalProjectByType("MMR_CORE");
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(window.getShell());
            GenerationProcess process = new GenerationProcess(bos, window);
            pmd.run(false, false, (IRunnableWithProgress)process);
            MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("PROJECT_CREATE_WD_MODEL_TITLE_SUCCESS"), (String)mTextPool.getText("PROJECT_CREATE_WD_MODEL_MSG_SUCCESS"));
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)window.getShell(), (String)mTextPool.getText("PROJECT_CREATE_WD_MODEL_TITLE_FAIL"), (String)mTextPool.getText("PROJECT_CREATE_WD_MODELMSG_FAIL", new String[]{ex.getMessage()}));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GenerationProcess
    implements IRunnableWithProgress {
        GenerationMonitor gmonitor = null;
        BOMSystem bos = null;
        IWorkbenchWindow window;

        public GenerationProcess(BOMSystem bos, IWorkbenchWindow widnow) {
            this.bos = bos;
            this.window = widnow;
        }

        public GenerationMonitor getGenerationMonitor() {
            return this.gmonitor;
        }

        public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
            this.gmonitor = new GenerationMonitor(monitor);
            Object generationStatus = null;
            try {
                this.bos.generateWDModel(this.gmonitor, this.bos.getResourceChangeListener());
            }
            catch (GeneratorException e) {
                e.printStackTrace();
                throw new CAFInvocationTargetException((Throwable)((Object)e));
            }
            catch (GeneratorNotificationException e) {
                e.printStackTrace();
                throw new CAFInvocationTargetException((Throwable)((Object)e));
            }
            monitor.subTask("");
            monitor.beginTask(mTextPool.getText("GENERATE_PROJECT_SYNCHRONIZING_PROJECTS"), 100);
            int i = 200;
            while (this.window.getShell().getDisplay().readAndDispatch()) {
                if ((i += 20) > 100) {
                    i = 0;
                    monitor.beginTask(mTextPool.getText("GENERATE_PROJECT_SYNCHRONIZING_PROJECTS"), 100);
                }
                monitor.worked(20);
            }
            monitor.worked(100);
            monitor.done();
            if (generationStatus != null) {
                throw new CAFInvocationTargetException(null);
            }
        }
    }
}

