/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.status.Message;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ProjectGenerateAllAction
extends BaseSingleAction {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$ProjectGenerateAllAction == null ? (class$com$sap$caf$designer$actions$ProjectGenerateAllAction = ProjectGenerateAllAction.class$("com.sap.caf.designer.actions.ProjectGenerateAllAction")) : class$com$sap$caf$designer$actions$ProjectGenerateAllAction);
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$caf$designer$actions$ProjectGenerateAllAction;

    public ProjectGenerateAllAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        return true;
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        logger.infoT("Generating... Uniquename: " + uniqueName.getName());
        logger.infoT("Generating... Uniquename: " + uniqueName.getParameter(0));
        BOMSystem bos = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bos.getPhysicalProjectByType("MMR_CORE");
        if (bos.getApplicationInterfaces().size() == 0 && bos.getBusinessEntityInterfaces().size() == 0 && bos.getExternalInterfaces().size() == 0) {
            MessageDialog.openWarning((Shell)window.getShell(), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_TITLE_FAIL"), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_MSG_NO_EJB"));
            return;
        }
        ProjectGenerateAllAction.generateCodeUIAction(bos);
    }

    public static void generateCodeUIAction(BOMSystem bos) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            ProjectGenerateAllAction.run(bos);
            MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_TITLE_SUCCESS"), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_MSG_SUCCESS"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.catching((Throwable)ex);
            MessageDialog.openError((Shell)window.getShell(), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_TITLE_FAIL"), (String)mTextPool.getText("GENERATE_PROJECT_APPLICATION_MSG_FAIL", new String[]{ex.getMessage()}));
        }
    }

    public static void run(BOMSystem bos) throws CAFBaseException {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(window.getShell());
            GenerationProcess process = new GenerationProcess(bos, window);
            pmd.run(false, false, (IRunnableWithProgress)process);
            if (process.getGenerationMonitor().getStatus().hasErrors()) {
                throw new CAFBaseException(((Message)process.getGenerationMonitor().getStatus().getMessages().get(0)).getText());
            }
        }
        catch (Exception ex) {
            throw new CAFBaseException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GenerationProcess
    implements IRunnableWithProgress {
        GenerationMonitor gmonitor = null;
        BOMSystem bos = null;
        IWorkbenchWindow window;

        public GenerationProcess(BOMSystem bos, IWorkbenchWindow widnow) {
            this.bos = bos;
            this.window = widnow;
        }

        public GenerationMonitor getGenerationMonitor() {
            return this.gmonitor;
        }

        public void run(IProgressMonitor monitor) throws CAFInvocationTargetException {
            this.gmonitor = new GenerationMonitor(monitor);
            Object generationStatus = null;
            try {
                this.bos.generateAll(this.gmonitor);
            }
            catch (GeneratorException e) {
                logger.errorT("An error has occured while generating projects.Error is:" + e.getMessage());
                e.printStackTrace();
            }
            catch (GeneratorNotificationException e) {
                logger.errorT("An error has occured while nottifying generation process of projects.Error is:" + e.getMessage());
                e.printStackTrace();
            }
            monitor.subTask("");
            monitor.beginTask(mTextPool.getText("GENERATE_PROJECT_SYNCHRONIZING_PROJECTS"), 100);
            int i = 200;
            if (generationStatus != null) {
                throw new CAFInvocationTargetException(null);
            }
        }
    }
}

