/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.InterfaceOperationAssociation;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationFaultMessageAssociation;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FaultMesageDeleteAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();

    public FaultMesageDeleteAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        return uniqueName.getLocation().equals("Attributes Type Catalog") && uniqueName.getSubDomain().equals("Fault Message");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        MetamodelPackage mpackage = bomSystem.getMetamodelPackage();
        OperationFaultMessageAssociation operationFaultMessageAssociation = mpackage.getOperationFaultMessageAssociation();
        InterfaceOperationAssociation interfaceOperationAssociation = mpackage.getInterfaceOperationAssociation();
        TreeMap<String, String> faultMap = new TreeMap<String, String>();
        HashMap<Operation, FaultMessage> allAtr = new HashMap<Operation, FaultMessage>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean isReferenced = false;
        FaultMessage faultMessage = (FaultMessage)bomSystem.getApplicationFaultMessages().get(EntityNamesStringUtil.restoreCoreFaultPackagesSP4(uniqueName.getName(), bomSystem.getApplicationName()));
        List lst = operationFaultMessageAssociation.getOperation(faultMessage);
        if (lst == null || lst.isEmpty()) {
            if (MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("FMDA.DELETE"))) {
                bomSystem.getApplicationFaultMessages().remove(EntityNamesStringUtil.restoreCoreFaultPackagesSP4(uniqueName.getName(), bomSystem.getApplicationName()));
                this.deleteFaultMessage(faultMessage, bomSystem, false);
            }
        } else {
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                Operation operation = (Operation)it.next();
                String operName = operation.getObjectName();
                String appServ = interfaceOperationAssociation.getMOFInterface(operation).getObjectName();
                faultMap.put(appServ + ":" + operName, operName);
                allAtr.put(operation, faultMessage);
            }
            isReferenced = true;
        }
        String msg = mTextPool.getText("FMDA.INFO") + "\n";
        if (!faultMap.isEmpty()) {
            msg = msg + "\n " + this.getNames(faultMap);
        }
        msg = msg + "\n\n" + mTextPool.getText("FMDA.DELETE.ALL");
        if (isReferenced && MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("FMDA.INFO.TITLE"), (String)msg)) {
            bomSystem.getApplicationFaultMessages().remove(EntityNamesStringUtil.restoreCoreFaultPackagesSP4(uniqueName.getName(), bomSystem.getApplicationName()));
            Iterator allIt = allAtr.keySet().iterator();
            while (allIt.hasNext()) {
                Operation currOper = (Operation)allIt.next();
                currOper.getFault().remove(faultMessage);
            }
            this.deleteFaultMessage(faultMessage, bomSystem, true);
        }
    }

    private String getNames(Map map) {
        String msg = "";
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String appServ = (String)it.next();
            msg = msg + (msg.equals("") ? "" : "; ") + appServ;
        }
        return msg;
    }

    private void deleteFaultMessage(FaultMessage fm, BOMSystem bm, boolean isRefered) {
        if (fm == null) {
            return;
        }
        bm.getModifiedServicesList().objectGenerated((BaseObject)fm);
        fm.refDelete();
        MetamodelProvider.setDirtyOn(bm.getProjectName());
        if (isRefered) {
            ApplicationInterfaceEditor.refreshImplementation();
        }
        ApplicationInterfaceEditor.refreshInstances();
    }
}

