/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.ExternalInterfaceEditorInput;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExternalInterfaceEditAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();

    public ExternalInterfaceEditAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getLocation().equals("Project");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bos = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Object ownerName = null;
        boolean localPersistency = false;
        boolean indexSearch = false;
        Object selAttributes = null;
        try {
            HashMap c = bos.getExternalInterfaces();
            CAFExternalInterface bei = (CAFExternalInterface)c.get(uniqueName.getName());
            ExternalInterfaceEditorInput eInput = new ExternalInterfaceEditorInput(bei);
            IWorkbenchPage workbenchActivePage = window.getActivePage();
            if (workbenchActivePage != null) {
                String sId = "com.sap.caf.designer.editors.ExternalInterfaceEditor";
                if (uniqueName != null && uniqueName.getParametersCount() > 0 && "ExternalRfcService".equals(uniqueName.getParameter(uniqueName.getParametersCount() - 1))) {
                    sId = "com.sap.caf.designer.editors.ExternalInterfaceEditorRfc";
                }
                workbenchActivePage.openEditor((IEditorInput)eInput, sId);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)window.getShell(), (String)mTextPool.getText("EXT_ERR_MSG_0001"), (String)e.getMessage());
        }
    }
}

