/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;

public class DcUpdateActionImpl
extends Action {
    private static final TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$caf$designer$actions$DcUpdateActionImpl == null ? (class$com$sap$caf$designer$actions$DcUpdateActionImpl = DcUpdateActionImpl.class$("com.sap.caf.designer.actions.DcUpdateActionImpl")) : class$com$sap$caf$designer$actions$DcUpdateActionImpl));
    private static final TextPool textPool = TextPool.getInstance();
    private Element element;
    static /* synthetic */ Class class$com$sap$caf$designer$actions$DcUpdateActionImpl;

    public DcUpdateActionImpl(Element element) {
        this.element = element;
    }

    public void run() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.element.getUniqueName().getParameter(0));
        if (newProject != null) {
            DcUpdateActionImpl.updateCAFProjects(newProject);
        }
    }

    public static void updateCAFProjects(IProject newProject) {
        if (newProject != null) {
            DcUpdateActionImpl.updateDCProject(newProject);
            BOMSystem bos = BOMSystem.getBOMSystem(newProject.getName());
            DcUpdateActionImpl.updateDCProject(bos.getPhysicalProjectByType("MMR"));
            DcUpdateActionImpl.updateDCProject(bos.getPhysicalProjectByType("DICT"));
            DcUpdateActionImpl.updateDCProject(bos.getPhysicalProjectByType("EJB"));
        }
    }

    private static void updateDCProject(IProject project) {
        if (project != null && project.exists()) {
            DevelopmentComponent dc;
            IDCExtendedProject dcPrj;
            try {
                dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                dc = dcPrj.getDCNode().getDCProxy().getComponent();
            }
            catch (CoreException e) {
                dcPrj = null;
                dc = null;
            }
            catch (DevConfigException e) {
                dcPrj = null;
                dc = null;
            }
            if (dc != null) {
                IDCProxy dcProxy;
                try {
                    dcProxy = dcPrj.getDCNode().getDCProxy();
                }
                catch (DevConfigException e) {
                    theTracer.warning(textPool.getText("DC_0001", new String[]{dcPrj.getDCNode().getName()}), (Throwable)e);
                    dcProxy = null;
                }
                try {
                    if (dcProxy != null) {
                        DCProjectUtil.updateProject((IDevelopmentConfiguration)dcProxy.getDevelopmentConfiguration(), (DevelopmentComponent)dc);
                    }
                }
                catch (InvocationTargetException e) {
                    theTracer.warning(textPool.getText("DC_0002", new String[]{dcProxy.getName()}), (Throwable)e);
                }
                catch (InterruptedException e) {
                    theTracer.warning(textPool.getText("DC_0002", new String[]{dcProxy.getName()}), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

