/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.exception.CAFInterruptedException;
import com.sap.caf.designer.exception.CAFInvocationTargetException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.ide.eclipse.component.core.DCProject;
import com.sap.ide.eclipse.component.core.SelectDCsDialog;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.dc.AbstractDcMultiAction;
import com.sap.ide.eclipse.component.provider.actions.dcproject.AbstractDCMultiProjectAction;
import com.sap.ide.eclipse.component.provider.actions.dcproject.BuildAction;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.buildtool.IBuildResult;
import com.sap.tc.devconf.BuildException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class DcBuildAction
extends AbstractDCMultiProjectAction
implements IWorkbenchWindowActionDelegate {
    private static final TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$caf$designer$actions$DcBuildAction == null ? (class$com$sap$caf$designer$actions$DcBuildAction = DcBuildAction.class$("com.sap.caf.designer.actions.DcBuildAction")) : class$com$sap$caf$designer$actions$DcBuildAction));
    private static final TextPool textPool = TextPool.getInstance();
    public static final int SINGLE_BUILD = 0;
    public static final int RECURSIVE_BUILD = 1;
    public static final int RECURSIVE_REBUILD = 2;
    protected static ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
    private List dcList;
    static /* synthetic */ Class class$com$sap$caf$designer$actions$DcBuildAction;

    public boolean isAvailable(Element[] el) {
        if (el == null) {
            return false;
        }
        int i = 0;
        while (i < el.length) {
            IDCExtendedProject dcPrj;
            Element element = el[i];
            try {
                IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getUniqueName().getParameter(0));
                dcPrj = newProject == null ? null : (IDCExtendedProject)newProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            }
            catch (CoreException e) {
                dcPrj = null;
            }
            if (dcPrj == null) {
                return false;
            }
            IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
            if (dcNode != null && (dcNode.isLocalOnlySource() || dcNode.isSynchedAsSource())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ICategory getCategory() {
        IExtendedDisplayableCategory category = (IExtendedDisplayableCategory)Category.createDisplayableCategory((ICategory)ComponentCategoryImage.CATEGORY__DC_PROJECT2, (String)"Business Object Modeller DC action.1", (String)((IExtendedDisplayableCategory)ComponentCategoryImage.CATEGORY__DC_PROJECT_BUILD).getName(), (String)((IExtendedDisplayableCategory)ComponentCategoryImage.CATEGORY__DC_PROJECT_BUILD).getName(), (Image)((IExtendedDisplayableCategory)ComponentCategoryImage.CATEGORY__DC_PROJECT_BUILD).getImage());
        category.setSubCategory(true);
        return category;
    }

    public static Object getObject(Element element) {
        UniqueName unName = element.getUniqueName();
        UniqueName unName2 = ModelAccess.createUniqueName((String)unName.getDomain(), (String)unName.getSubDomain(), (String)unName.getName().trim());
        if (element != null) {
            return ObjectUtil.getObject((UniqueName)element.getModel().getUniqueName(), (UniqueName)unName2);
        }
        return null;
    }

    public static IDevelopmentConfiguration getParentDevConf(Element element) {
        Element e = DcBuildAction.getParentDevConfElement(element);
        if (e != null) {
            return (IDevelopmentConfiguration)DcBuildAction.getObject(e);
        }
        return null;
    }

    public static Element getParentDevConfElement(Element element) {
        while (element != null && !(DcBuildAction.getObject(element) instanceof IDevelopmentConfiguration)) {
            element = ObjectUtil.getComponentParent((Element)element);
        }
        return element;
    }

    public static void optimizeBuildList(Map buildDependenciesMap, Collection haveToBuildDCCollection, IDCProxy orderedDC, IBuildResult buildResult) {
        BuildAction.optimizeBuildList((Map)buildDependenciesMap, (Collection)haveToBuildDCCollection, (IDCProxy)orderedDC, (IBuildResult)buildResult);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action, final int buildKind) {
        block35: {
            if (this.dcList == null || this.dcList.isEmpty()) {
                return;
            }
            ArrayList forBuildDCList = new ArrayList();
            ((AbstractDcMultiAction)this).devConfSet = this.collectConfigurations(this.dcList.toArray(new Element[this.dcList.size()]), forBuildDCList);
            if (!Util.saveSensitiveEditors((Collection)((AbstractDcMultiAction)this).devConfSet)) {
                return;
            }
            final HashSet<IProject> projectSet = new HashSet<IProject>();
            Util.showUserOutputViewer();
            ArrayList<IDCProxy> originalSelection = new ArrayList<IDCProxy>();
            HashSet<IDCProxy> defaultSelectSet = new HashSet<IDCProxy>();
            final HashMap<IDCProxy, List<IDCProxy>> buildDependenciesMap = new HashMap<IDCProxy, List<IDCProxy>>();
            ArrayList<IDCProxy> proxyList = new ArrayList<IDCProxy>();
            Iterator it = forBuildDCList.iterator();
            while (it.hasNext()) {
                BOMSystem bos;
                IDCExtendedProject dcPrj;
                Element dcElement = (Element)it.next();
                ArrayList<IDCExtendedProject> projects = new ArrayList<IDCExtendedProject>();
                try {
                    IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(dcElement.getUniqueName().getParameter(0));
                    if (newProject != null) {
                        dcPrj = (IDCExtendedProject)newProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                        bos = BOMSystem.getBOMSystem(newProject.getName());
                    } else {
                        dcPrj = null;
                        bos = null;
                    }
                }
                catch (CoreException e) {
                    dcPrj = null;
                    bos = null;
                }
                if (dcPrj != null) {
                    projects.add(dcPrj);
                }
                if (bos != null) {
                    IDCExtendedProject dcProj = this.getDCNature(bos.getRelatedProjectNameByType("DICT"));
                    if (dcProj != null) {
                        projects.add(dcProj);
                    }
                    if ((dcProj = this.getDCNature(bos.getRelatedProjectNameByType("EJB"))) != null) {
                        projects.add(dcProj);
                    }
                    if ((dcProj = this.getDCNature(bos.getRelatedProjectNameByType("ENTERPRISE_APPLICATION"))) != null) {
                        projects.add(dcProj);
                    }
                    if ((dcProj = this.getDCNature(bos.getRelatedProjectNameByType("WDP_PROJECT"))) != null) {
                        projects.add(dcProj);
                    }
                    if ((dcProj = this.getDCNature(bos.getRelatedProjectNameByType("UME_PROJECT"))) != null) {
                        projects.add(dcProj);
                    }
                }
                int j = 0;
                while (j < projects.size()) {
                    IDevelopmentComponentNode dcNode = ((IDCExtendedProject)projects.get(j)).getDCNode();
                    if (dcNode == null) {
                        theTracer.warning(textPool.getText("DC_0003", new String[]{dcElement.getUniqueName().toString()}));
                    } else {
                        IDCProxy dcProxy;
                        try {
                            dcProxy = dcNode.getDCProxy();
                        }
                        catch (DevConfigException e) {
                            dcProxy = null;
                            theTracer.warning(textPool.getText("DC_0001", new String[]{dcNode.getName()}), (Throwable)e);
                        }
                        if (dcProxy != null) {
                            if (dcProxy.isDirty()) {
                                defaultSelectSet.add(dcProxy);
                            }
                            originalSelection.add(dcProxy);
                            proxyList.add(dcProxy);
                            IDCProxy[] proxiesForRecBuild = null;
                            try {
                                proxiesForRecBuild = dcProxy.listDCProxiesForRecursiveMake();
                                if (proxiesForRecBuild != null) {
                                    buildDependenciesMap.put(dcProxy, Arrays.asList(proxiesForRecBuild));
                                }
                            }
                            catch (BuildException e) {
                                theTracer.warning(textPool.getText("DC_0015", new String[]{dcProxy.getName()}), (Throwable)e);
                            }
                            if ((buildKind == 1 || buildKind == 2) && proxiesForRecBuild != null) {
                                int i = 0;
                                while (i < proxiesForRecBuild.length) {
                                    IProject prj;
                                    if (proxiesForRecBuild[i].isDirty() && !defaultSelectSet.contains(proxiesForRecBuild[i])) {
                                        defaultSelectSet.add(proxiesForRecBuild[i]);
                                        Collection userDCs = this.listRecursiveUsers(proxiesForRecBuild[i]);
                                        defaultSelectSet.addAll(userDCs);
                                    }
                                    if ((prj = DCProjectUtil.getProject((IDCProxy)proxiesForRecBuild[i])) != null && prj.exists() && prj.isOpen()) {
                                        projectSet.add(prj);
                                    }
                                    proxyList.add(proxiesForRecBuild[i]);
                                    ++i;
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            HashSet myProxySet = new HashSet(proxyList);
            final ArrayList<Object> selectedProxies = new ArrayList<Object>();
            SelectDCsDialog dialog = SelectDCsDialog.newSelectDCsDialog(null, (String)textPool.getText("DC_0004"), (String)textPool.getText("DC_0005"), myProxySet, originalSelection, null);
            dialog.initializeOptions(textPool.getText("DC_0006"), true, null, false);
            dialog.setInitialElementSelections(new ArrayList(defaultSelectSet));
            int returnValue = dialog.open();
            if (returnValue == 0) {
                selectedProxies.addAll(Arrays.asList(dialog.getResult()));
            } else if (returnValue == 1) {
                return;
            }
            if (selectedProxies.isEmpty()) {
                return;
            }
            final boolean ignoreDirtyFlag = !dialog.isOptionSelected();
            DcBuildAction.saveAllDCProjects(selectedProxies);
            ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(ComponentProviderPlugin.getPlugin().getMyShell());
            try {
                progressMonitor.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws CAFInvocationTargetException, CAFInterruptedException {
                        try {
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            monitor.beginTask(textPool.getText("DC_0009"), 110);
                            ((AbstractDcMultiAction)DcBuildAction.this).devConfSet = DcBuildAction.buildDCsForDevConfig(((AbstractDcMultiAction)DcBuildAction.this).devConfSet, selectedProxies, buildDependenciesMap, (IProgressMonitor)new SubProgressMonitor(monitor, 100), ignoreDirtyFlag, buildKind);
                            monitor.subTask(textPool.getText("DC_0010"));
                            Util.updateGenFolder((IProject[])projectSet.toArray(new IProject[projectSet.size()]));
                            if (DcBuildAction.this.shouldUpdateProject()) {
                                DcBuildAction.super.updateDCProjects((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            }
                        }
                        catch (InterruptedException iex) {
                            throw new CAFInterruptedException(iex);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                theTracer.error(textPool.getText("DC_0011"), (Throwable)e);
            }
            catch (InterruptedException e) {
                Util.updateGenFolder((IProject[])projectSet.toArray(new IProject[projectSet.size()]));
                if (!this.shouldUpdateProject()) break block35;
                this.updateDCProjects((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void run(IAction action) {
        this.run(action, 1);
    }

    public static void saveAllDCProjects(Collection dcList) {
        BuildAction.saveAllDCProjects((Collection)dcList);
    }

    public static void saveAllProjectResources(Collection projects) {
        BuildAction.saveAllProjectResources((Collection)projects);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.dcList = new ArrayList();
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext()) {
                IProject selectedProject;
                Object obj = it.next();
                if (obj instanceof IProject) {
                    selectedProject = (IProject)obj;
                } else {
                    if (!(obj instanceof IJavaProject)) continue;
                    selectedProject = ((IJavaProject)obj).getProject();
                }
                Element myDcNodeElement = ObjectUtil.getDCNodeElement((IProject)selectedProject);
                if (myDcNodeElement == null) continue;
                this.dcList.add(myDcNodeElement);
            }
        }
        if (!this.dcList.isEmpty()) {
            action.setEnabled(this.isAvailable(this.dcList.toArray(new Element[this.dcList.size()])));
        } else {
            action.setEnabled(false);
        }
    }

    public boolean shouldUpdateProject() {
        return true;
    }

    protected IAction getDCAction(Element el) {
        return null;
    }

    protected IAction getDCAction(Element element, IDevelopmentComponentNode dcNode) {
        return this.getDCAction(element);
    }

    protected Set collectConfigurations(Element[] myElements, List availableElementList) {
        HashSet<IDevelopmentConfiguration> result = new HashSet<IDevelopmentConfiguration>();
        int i = 0;
        while (i < myElements.length) {
            Element element = myElements[i];
            if (this.isAvailable(new Element[]{element})) {
                if (availableElementList != null) {
                    availableElementList.add(element);
                }
                if (this.shouldUpdateProject()) {
                    IDCExtendedProject dcPrj;
                    try {
                        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(element.getUniqueName().getParameter(0));
                        dcPrj = newProject != null ? (IDCExtendedProject)newProject.getNature("com.sap.ide.eclipse.component.provider.dcnature") : null;
                    }
                    catch (CoreException e) {
                        dcPrj = null;
                    }
                    if (dcPrj != null) {
                        IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
                        try {
                            result.add(dcNode.getDCProxy().getDevelopmentConfiguration());
                        }
                        catch (DevConfigException e) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected boolean hasBusyIndicator() {
        return true;
    }

    private IDCExtendedProject getDCNature(String projectName) {
        IDCExtendedProject retVal;
        try {
            IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            retVal = newProject != null && newProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature") ? (IDCExtendedProject)newProject.getNature("com.sap.ide.eclipse.component.provider.dcnature") : null;
        }
        catch (CoreException e) {
            retVal = null;
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set buildDCsForDevConfig(Set devConfigSet, Collection myProxySet, Map buildDependenciesMap, IProgressMonitor monitor, boolean ignoreDirtyFlag, int buildKind) throws CAFInterruptedException {
        int oldStatus = 0;
        float currentStatus = 0.0f;
        float step = 100 / myProxySet.size();
        monitor.beginTask(textPool.getText("DC_0012"), 100);
        HashSet<IDevelopmentConfiguration> affectedDevConfigSet = new HashSet<IDevelopmentConfiguration>();
        try {
            Iterator it2;
            Iterator it = devConfigSet.iterator();
            block14: while (true) {
                if (!it.hasNext()) {
                    it2 = myProxySet.iterator();
                    break;
                }
                IDevelopmentConfiguration devConfig = (IDevelopmentConfiguration)it.next();
                IDCProxy[] orderedDCs = devConfig.getBuildOrderOfDCsAvailableAsSource(true);
                int i = 0;
                while (true) {
                    if (i >= orderedDCs.length) continue block14;
                    if (monitor.isCanceled()) {
                        monitor.subTask("");
                        throw new CAFInterruptedException();
                    }
                    if (myProxySet.contains(orderedDCs[i])) {
                        myProxySet.remove(orderedDCs[i]);
                        if (ignoreDirtyFlag || orderedDCs[i].isDirty()) {
                            IBuildResult buildResult;
                            block32: {
                                DCProject prj;
                                Object var18_25;
                                monitor.subTask(textPool.getText("DC_0013", new String[]{orderedDCs[i].getName(), orderedDCs[i].getVendor()}));
                                buildResult = null;
                                try {
                                    try {
                                        String buildVariant = Util.getBuildVariant((IDevelopmentConfiguration)orderedDCs[i].getDevelopmentConfiguration(), (String)orderedDCs[i].getCompartment().getName());
                                        buildResult = orderedDCs[i].make(buildVariant, null, null);
                                    }
                                    catch (BuildException e) {
                                        theTracer.warning(textPool.getText("DC_0007", new String[]{orderedDCs[i].getName()}), (Throwable)e);
                                        var18_25 = null;
                                        affectedDevConfigSet.add(orderedDCs[i].getDevelopmentConfiguration());
                                        prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)orderedDCs[i]));
                                        if (prj != null) {
                                            prj.notifyBuild();
                                        }
                                        break block32;
                                    }
                                    catch (Exception e) {
                                        theTracer.warning(textPool.getText("DC_0007", new String[]{orderedDCs[i].getName()}), (Throwable)e);
                                        var18_25 = null;
                                        affectedDevConfigSet.add(orderedDCs[i].getDevelopmentConfiguration());
                                        prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)orderedDCs[i]));
                                        if (prj != null) {
                                            prj.notifyBuild();
                                        }
                                        break block32;
                                    }
                                    var18_25 = null;
                                    affectedDevConfigSet.add(orderedDCs[i].getDevelopmentConfiguration());
                                }
                                catch (Throwable throwable) {
                                    var18_25 = null;
                                    affectedDevConfigSet.add(orderedDCs[i].getDevelopmentConfiguration());
                                    prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)orderedDCs[i]));
                                    if (prj != null) {
                                        prj.notifyBuild();
                                    }
                                    throw throwable;
                                }
                                prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)orderedDCs[i]));
                                if (prj != null) {
                                    prj.notifyBuild();
                                }
                            }
                            DcBuildAction.optimizeBuildList(buildDependenciesMap, myProxySet, orderedDCs[i], buildResult);
                        }
                        if ((int)(currentStatus += step) > oldStatus) {
                            monitor.worked((int)currentStatus - oldStatus);
                            oldStatus = (int)currentStatus;
                        }
                    }
                    ++i;
                }
                break;
            }
            while (it2.hasNext()) {
                block33: {
                    if (monitor.isCanceled()) {
                        monitor.subTask("");
                        throw new CAFInterruptedException();
                    }
                    IDCProxy dcProxy = (IDCProxy)it2.next();
                    if (ignoreDirtyFlag || dcProxy.isDirty()) {
                        DCProject prj;
                        Object var21_28;
                        monitor.subTask(textPool.getText("DC_0013", new String[]{dcProxy.getName(), dcProxy.getVendor()}));
                        try {
                            try {
                                String buildVariant = Util.getBuildVariant((IDevelopmentConfiguration)dcProxy.getDevelopmentConfiguration(), (String)dcProxy.getCompartment().getName());
                                dcProxy.make(buildVariant, null, null);
                            }
                            catch (BuildException e) {
                                theTracer.warning(textPool.getText("DC_0007", new String[]{dcProxy.getName()}), (Throwable)e);
                                var21_28 = null;
                                affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                                prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)dcProxy));
                                if (prj != null) {
                                    prj.notifyBuild();
                                }
                                break block33;
                            }
                            catch (Exception e) {
                                theTracer.warning(textPool.getText("DC_0007", new String[]{dcProxy.getName()}), (Throwable)e);
                                var21_28 = null;
                                affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                                prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)dcProxy));
                                if (prj != null) {
                                    prj.notifyBuild();
                                }
                                break block33;
                            }
                            var21_28 = null;
                            affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                        }
                        catch (Throwable throwable) {
                            var21_28 = null;
                            affectedDevConfigSet.add(dcProxy.getDevelopmentConfiguration());
                            prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)dcProxy));
                            if (prj != null) {
                                prj.notifyBuild();
                            }
                            throw throwable;
                        }
                        prj = DCProjectUtil.getDCProject((IProject)DCProjectUtil.getProject((IDCProxy)dcProxy));
                        if (prj != null) {
                            prj.notifyBuild();
                        }
                    }
                }
                if ((int)(currentStatus += step) <= oldStatus) continue;
                monitor.worked((int)currentStatus - oldStatus);
                oldStatus = (int)currentStatus;
            }
        }
        catch (RuntimeException e) {
            theTracer.error(textPool.getText("DC_0014"), (Throwable)e);
        }
        catch (DevConfigException e) {
            theTracer.error(textPool.getText("DC_0014"), (Throwable)e);
        }
        catch (SyncException e) {
            theTracer.error(textPool.getText("DC_0014"), (Throwable)e);
        }
        monitor.subTask("");
        return affectedDevConfigSet;
    }

    private Collection listRecursiveUsers(IDCProxy proxy) {
        IDevelopmentComponentRef[] result;
        HashSet<IDCProxy> collection = new HashSet<IDCProxy>();
        try {
            result = proxy.listLocalAtBuildTimeUsersRecursively(true);
        }
        catch (DevConfigException e) {
            theTracer.warning(textPool.getText("DC_0008"), (Throwable)e);
            result = null;
        }
        catch (SyncException e) {
            theTracer.warning(textPool.getText("DC_0008"), (Throwable)e);
            result = null;
        }
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                IDevelopmentComponentRef ref = result[i];
                if (ref != null) {
                    IDCProxy foundProxy;
                    try {
                        foundProxy = proxy.getDevelopmentConfiguration().getDCProxyLocally(ref.getCompartment(), ref.getVendor(), ref.getName());
                    }
                    catch (DevConfigException e) {
                        theTracer.warning(textPool.getText("DC_0008"), (Throwable)e);
                        foundProxy = null;
                    }
                    if (foundProxy != null) {
                        collection.add(foundProxy);
                    }
                }
                ++i;
            }
        }
        return collection;
    }

    public void run(Element[] elements) {
        this.dcList = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            if (this.isAvailable(new Element[]{element})) {
                this.dcList.add(element);
            }
            ++i;
        }
        this.run((IAction)null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

