/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFDataStructure;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.AttributeObjectAssociation;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.InterfaceOperationAssociation;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MessageAttributeAssociation;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.ObjectAttributeAssociation;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DataStructureDeleteAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$DataStructureDeleteAction == null ? (class$com$sap$caf$designer$actions$DataStructureDeleteAction = DataStructureDeleteAction.class$("com.sap.caf.designer.actions.DataStructureDeleteAction")) : class$com$sap$caf$designer$actions$DataStructureDeleteAction);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$DataStructureDeleteAction;

    public DataStructureDeleteAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getLocation().equals("Attributes Type Catalog");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        MetamodelPackage mpackage = bomSystem.getMetamodelPackage();
        AttributeObjectAssociation attributeObjectAssociation = mpackage.getAttributeObjectAssociation();
        ObjectAttributeAssociation objectAttributeAssociation = mpackage.getObjectAttributeAssociation();
        MessageAttributeAssociation messageAttributeAssociation = mpackage.getMessageAttributeAssociation();
        InterfaceOperationAssociation interfaceOperationAssociation = mpackage.getInterfaceOperationAssociation();
        DataStructure dataStructure = (DataStructure)bomSystem.getApplicationDataStructures().get(uniqueName.getName());
        Collection coll = attributeObjectAssociation.getObject(dataStructure);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean isReferenced = false;
        boolean constrain = false;
        TreeMap<String, String> inputMap = new TreeMap<String, String>();
        TreeMap<String, String> outputMap = new TreeMap<String, String>();
        TreeMap<String, String> dsMap = new TreeMap<String, String>();
        TreeMap<String, String> dsConstrainMap = new TreeMap<String, String>();
        HashMap<Attribute, List> allAtr = new HashMap<Attribute, List>();
        if (coll == null || coll.isEmpty()) {
            if (MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("DSDA.DELETE"))) {
                bomSystem.getApplicationDataStructures().remove(uniqueName.getName());
                bomSystem.getModifiedServicesList().objectGenerated((BaseObject)dataStructure);
                new CAFDataStructure(bomSystem, dataStructure).remove();
                MetamodelProvider.setDirtyOn(bomSystem.getProjectName());
                ApplicationInterfaceEditor.refreshInstances();
            }
        } else {
            Iterator iteratorOnDSAssociation = attributeObjectAssociation.getObject(dataStructure).iterator();
            while (iteratorOnDSAssociation.hasNext()) {
                DataStructure ds;
                Attribute atr = (Attribute)iteratorOnDSAssociation.next();
                List lstMsg = messageAttributeAssociation.getMessage(atr);
                if (lstMsg != null && !lstMsg.isEmpty()) {
                    Iterator msgIterator = lstMsg.iterator();
                    while (msgIterator.hasNext()) {
                        Collection outputColl;
                        Message msg = (Message)msgIterator.next();
                        allAtr.put(atr, msg.getMessageParts());
                        Collection inputColl = msg.getInputMessageOperation();
                        if (inputColl != null && !inputColl.isEmpty()) {
                            Iterator inputIt = inputColl.iterator();
                            while (inputIt.hasNext()) {
                                Operation oper = (Operation)inputIt.next();
                                String operName = oper.getObjectName();
                                String appServ = interfaceOperationAssociation.getMOFInterface(oper).getObjectName();
                                inputMap.put(appServ + ":" + operName, operName);
                            }
                        }
                        if ((outputColl = msg.getOutputMessageOperation()) == null || outputColl.isEmpty()) continue;
                        Iterator outputIt = outputColl.iterator();
                        while (outputIt.hasNext()) {
                            Operation oper = (Operation)outputIt.next();
                            String operName = oper.getObjectName();
                            String appServ = interfaceOperationAssociation.getMOFInterface(oper).getObjectName();
                            outputMap.put(appServ + ":" + operName, operName);
                        }
                    }
                }
                if ((ds = objectAttributeAssociation.getObject(atr)) != null) {
                    allAtr.put(atr, ds.getAttributes());
                    dsMap.put(ds.getObjectName(), ds.getObjectName());
                    List atrList = ds.getAttributes();
                    if (atrList != null && !atrList.isEmpty()) {
                        int atrLstSize = atrList.size();
                        int numberOfOccurrence = 0;
                        Iterator it = atrList.iterator();
                        while (it.hasNext()) {
                            try {
                                Attribute attr = (Attribute)it.next();
                                DataStructure dstr = attr.getReferencedObject();
                                if (dstr == null || !dataStructure.getObjectName().equals(dstr.getObjectName())) continue;
                                ++numberOfOccurrence;
                            }
                            catch (Exception e) {
                                logger.errorT("Could not delete DataStructure.The error is :" + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        if (numberOfOccurrence == atrLstSize) {
                            dsConstrainMap.put(ds.getObjectName(), ds.getObjectName());
                            constrain = true;
                        }
                    }
                }
                isReferenced = true;
            }
            if (isReferenced && constrain) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("DSDA.INFO.TITLE"), (String)(mTextPool.getText("DSDA.INFO.NODELETION") + "\n" + this.getNames(dsConstrainMap)));
            } else if (isReferenced) {
                String msg = mTextPool.getText("DSDA.INFO") + "\n";
                if (!inputMap.isEmpty()) {
                    msg = msg + "\n" + mTextPool.getText("DSDA.INFO.INPUT") + " " + this.getNames(inputMap);
                }
                if (!outputMap.isEmpty()) {
                    msg = msg + "\n" + mTextPool.getText("DSDA.INFO.OUTPUT") + " " + this.getNames(outputMap);
                }
                if (!dsMap.isEmpty()) {
                    msg = msg + "\n" + mTextPool.getText("DSDA.INFO.DS") + " " + this.getNames(dsMap);
                }
                msg = msg + "\n\n\n" + mTextPool.getText("DSDA.DELETE.ALL");
                if (MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("DSDA.INFO.TITLE"), (String)msg)) {
                    bomSystem.getApplicationDataStructures().remove(uniqueName.getName());
                    Iterator allIt = allAtr.keySet().iterator();
                    while (allIt.hasNext()) {
                        Attribute currAtr = (Attribute)allIt.next();
                        Collection atrColl = (Collection)allAtr.get(currAtr);
                        atrColl.remove(currAtr);
                        currAtr.refDelete();
                    }
                    bomSystem.getModifiedServicesList().objectGenerated((BaseObject)dataStructure);
                    dataStructure.refDelete();
                    MetamodelProvider.setDirtyOn(bomSystem.getProjectName());
                    ApplicationInterfaceEditor.refreshImplementation();
                    ApplicationInterfaceEditor.refreshInstances();
                }
            }
        }
    }

    private String getNames(Map map) {
        String msg = "";
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String appServ = (String)it.next();
            msg = msg + (msg.equals("") ? "" : "; ") + appServ;
        }
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

