/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.actions.DTRActionsProvider;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.DialogWindow;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.ui.PlatformUI;

public class DTRSyncAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private ICategory myCategory = Category.createDisplayableCategory((ICategory)DTRActionsProvider.myDTRCategory, (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_1"), (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_1"), (String)mTextPool.getText("DTR_MENU_ITEM_DESCRIPT_1_1"), null, (boolean)true, (int)0);

    public DTRSyncAction(IExtendedDisplayableCategory aCategory) {
        super((ICategory)aCategory);
    }

    public boolean isAvailable(Element[] elements) {
        return true;
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        return BluebirdPlugin.getDAVTeamProvider((IResource)iProject) != null && bomSystem.getResourceChangeListener().isLogged(iProject);
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        Iterator projKeys = bomSystem.getRelatedProjects().keySet().iterator();
        IVfsFolderItem[] ivfsFolderItems = new IVfsFolderItem[bomSystem.getRelatedProjects().size()];
        int i = 0;
        while (projKeys.hasNext()) {
            String projType = (String)projKeys.next();
            String prjName = (String)bomSystem.getRelatedProjects().get(projType);
            IProject iProject = bomSystem.getPhysicalProjectByType(projType);
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)iProject);
            if (teamProvider == null) continue;
            ivfsFolderItems[i] = teamProvider.getFolderItem((IResource)iProject);
            if (ivfsFolderItems[i] == null) continue;
            ++i;
        }
        if (ivfsFolderItems == null) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK_SYNC"), ivfsFolderItems.length);
        String message = "";
        boolean result = true;
        int j = 0;
        while (j < ivfsFolderItems.length) {
            if (ivfsFolderItems[j] != null && ivfsFolderItems[j].asActivityRecordedFolderItem().getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                try {
                    ivfsFolderItems[j].sync();
                }
                catch (Exception e) {
                    message = message + mTextPool.getText("DTR_ERROR_SYNC") + e.getMessage() + " " + ivfsFolderItems[j].getName() + "\n";
                    result = false;
                }
                progressMonitor.worked(1);
            }
            ++j;
        }
        dialog.close();
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        } else {
            try {
                bomSystem.checkWorkspaceForChanges();
                ModelTreeViewer.deepRefreshInstances();
                ModelTreeViewer.refreshInstances();
            }
            catch (CAFResourceException e) {
                new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), "Problem occurs with refreshing MetaData.").open();
            }
        }
    }

    public ICategory getCategory() {
        return this.myCategory;
    }
}

