/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.actions.DTRActionsProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.DialogWindow;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.ui.PlatformUI;

public class DTREditExclusiveAction
extends BaseSingleAction {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$DTREditExclusiveAction == null ? (class$com$sap$caf$designer$actions$DTREditExclusiveAction = DTREditExclusiveAction.class$("com.sap.caf.designer.actions.DTREditExclusiveAction")) : class$com$sap$caf$designer$actions$DTREditExclusiveAction);
    private static final TextPool mTextPool = TextPool.getInstance();
    private ICategory myCategory = Category.createDisplayableCategory((ICategory)DTRActionsProvider.myDTRCategory, (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_2"), (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_2"), (String)mTextPool.getText("DTR_MENU_ITEM_DESCRIPT_1_2"), null, (boolean)true, (int)1);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$DTREditExclusiveAction;

    public DTREditExclusiveAction(IExtendedDisplayableCategory aCategory) {
        super((ICategory)aCategory);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        return BluebirdPlugin.getDAVTeamProvider((IResource)iProject) != null && bomSystem.getResourceChangeListener().isLogged(iProject);
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        Iterator projKeys = bomSystem.getRelatedProjects().keySet().iterator();
        ArrayList<IVfsActivityRecordedFolderItem> fileItems = new ArrayList<IVfsActivityRecordedFolderItem>();
        ArrayList<IVfsActivityRecordedFolderItem> folderItems = new ArrayList<IVfsActivityRecordedFolderItem>();
        int i = 0;
        while (projKeys.hasNext()) {
            String projType = (String)projKeys.next();
            String prjName = (String)bomSystem.getRelatedProjects().get(projType);
            IProject iProject = bomSystem.getPhysicalProjectByType(projType);
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)iProject);
            try {
                IResource[] recourse = iProject.members();
                int j = 0;
                while (j < recourse.length) {
                    IVfsFolderItem folderitem;
                    if (!".classpath".equals(recourse[j].getName()) && !".project".equals(recourse[j].getName()) && (folderitem = teamProvider.getFolderItem(recourse[j])) != null) {
                        if (recourse[j] instanceof IFile) {
                            if (folderitem.asActivityRecordedFolderItem().getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                                fileItems.add(folderitem.asActivityRecordedFolderItem());
                            }
                        } else if (recourse[j] instanceof IFolder) {
                            folderItems.add(folderitem.asActivityRecordedFolderItem());
                        }
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                logger.errorT("A CoreException occured during DTR Edit exlusive action.Message is : " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.errorT("An Exception occured during DTR Edit exlusive action.Message is : " + e.getMessage());
            }
            ++i;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK"), folderItems.size() + fileItems.size());
        String message = "";
        boolean result = true;
        Iterator it = ((AbstractList)fileItems).iterator();
        while (it.hasNext()) {
            IVfsFolderItem folderitem = (IVfsFolderItem)it.next();
            progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_EXCLUSIVE_CHECKOUT") + folderitem.getLocalPath());
            try {
                folderitem.asActivityRecordedFolderItem().asFile().checkOutForEdit(bomSystem.getResourceChangeListener().getActivity(), true);
            }
            catch (Exception e) {
                message = message + mTextPool.getText("DTR_ERROR_CHECKOUT") + e.getMessage() + " " + folderitem.getLocalPath() + "\n";
                result = false;
            }
            progressMonitor.worked(1);
        }
        it = ((AbstractList)folderItems).iterator();
        while (it.hasNext()) {
            IVfsFolderItem folderitem = (IVfsFolderItem)it.next();
            progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_EXCLUSIVE_CHECKOUT") + folderitem.getLocalPath());
            try {
                folderitem.asActivityRecordedFolderItem().asFolder().checkOutForEdit(bomSystem.getResourceChangeListener().getActivity(), 100, true);
            }
            catch (Exception e) {
                message = message + mTextPool.getText("DTR_ERROR_CHECKOUT") + e.getMessage() + " " + folderitem.getLocalPath() + "\n";
                result = false;
            }
            progressMonitor.worked(1);
        }
        dialog.close();
        if (!result) {
            message = mTextPool.getText("DTR_ERROR_EXPLANATION") + "\n\n" + message;
            new DialogWindow(mTextPool.getText("DTR_ERROR_MESSAGE"), message).open();
        }
    }

    public ICategory getCategory() {
        return this.myCategory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

