/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.actions.DTRActionsProvider;
import com.sap.caf.designer.dtr.AddDCsAndFilesToSourceControl;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.tools.velocity.utils.FileUtils;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.ui.PlatformUI;

public class DTRAddLocalChangesAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private ICategory myCategory = Category.createDisplayableCategory((ICategory)DTRActionsProvider.myDTRCategory, (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_3"), (String)mTextPool.getText("DTR_MENU_ITEM_LABLE_1_3"), (String)mTextPool.getText("DTR_MENU_ITEM_DESCRIPT_1_3"), null, (boolean)true, (int)2);

    public DTRAddLocalChangesAction(IExtendedDisplayableCategory aCategory) {
        super((ICategory)aCategory);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        return !DtrService.isLocalConfiguration(iProject) && bomSystem.getResourceChangeListener().isLogged(iProject);
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        Iterator projKeys = bomSystem.getRelatedProjects().keySet().iterator();
        boolean success = true;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.open();
        IProgressMonitor progressMonitor = dialog.getProgressMonitor();
        progressMonitor.beginTask(mTextPool.getText("DTR_PROGRESS_MONITOR_TASK_ADD_DC"), 6);
        while (projKeys.hasNext()) {
            String projType = (String)projKeys.next();
            String prjName = (String)bomSystem.getRelatedProjects().get(projType);
            IProject iProject = bomSystem.getPhysicalProjectByType(projType);
            DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)iProject);
            if (teamProvider != null) continue;
            progressMonitor.subTask(mTextPool.getText("DTR_PROGRESS_MONITOR_ADD", new Object[]{prjName}));
            boolean isOk = AddDCsAndFilesToSourceControl.addToSourceControl(bomSystem.getResourceChangeListener(), iProject);
            progressMonitor.worked(1);
            if (isOk) continue;
            success = false;
        }
        dialog.close();
        if (success) {
            boolean result;
            Iterator it = bomSystem.getDTRReplicatorList().getFileList().iterator();
            HashMap createResources = null;
            if (it != null) {
                createResources = new HashMap();
                while (it.hasNext()) {
                    String relPath = (String)it.next();
                    String[] dcPathAndType = bomSystem.getGeneratedFilesList().getDCPathAndTypeFromRelativePath(relPath);
                    FileUtils.addPathToMap(dcPathAndType, createResources);
                }
            }
            if (result = bomSystem.getResourceChangeListener().notifyResourceModifications(createResources, null, null)) {
                bomSystem.getResourceChangeListener().finalizeModifications();
                bomSystem.getDTRReplicatorList().clearList();
            }
        }
    }

    public ICategory getCategory() {
        return this.myCategory;
    }
}

