/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BusinessEntityInterfaceDeleteAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$BusinessEntityInterfaceDeleteAction == null ? (class$com$sap$caf$designer$actions$BusinessEntityInterfaceDeleteAction = BusinessEntityInterfaceDeleteAction.class$("com.sap.caf.designer.actions.BusinessEntityInterfaceDeleteAction")) : class$com$sap$caf$designer$actions$BusinessEntityInterfaceDeleteAction);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$BusinessEntityInterfaceDeleteAction;

    public BusinessEntityInterfaceDeleteAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getLocation().equals("Project");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bomsystem = BOMSystem.getBOMSystem(element.getUniqueName().getParameter(0));
        IProject iProject = bomsystem.getPhysicalProjectByType("MMR_CORE");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineMessage slm = new StatusLineMessage();
        if (MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("BOM_BONAVIGATOR_0001"))) {
            HashMap beis = bomsystem.getBusinessEntityInterfaces();
            CAFBusinessEntityInterface cafbei = (CAFBusinessEntityInterface)beis.get(uniqueName.getName());
            BusinessEntityInterface bei = cafbei.getBusinesEntityInterface();
            Iterator aeis = bomsystem.getApplicationInterfaces().values().iterator();
            while (aeis.hasNext()) {
                CAFApplicationInterface cafAppServ = (CAFApplicationInterface)aeis.next();
                if (!cafAppServ.getApplicationInterface().getUsedInterfaces().contains(bei)) continue;
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("ASI.Action_can_not_be_performed"), (String)(mTextPool.getText("ASI.Interface_is_used") + cafAppServ.getApplicationInterface().getObjectName() + mTextPool.getText("ASI.can_not_be_deleted")));
                return;
            }
            Iterator beisi = beis.values().iterator();
            while (beisi.hasNext()) {
                CAFBusinessEntityInterface cafBE = (CAFBusinessEntityInterface)beisi.next();
                Iterator attributes = cafBE.getBusinesEntityInterface().getBusinessEntity().getAttributes().iterator();
                if (cafBE.getBusinesEntityInterface().equals((Object)bei)) continue;
                while (attributes.hasNext()) {
                    Attribute attr = (Attribute)attributes.next();
                    if (attr.getReferencedObject() == null || !attr.getReferencedObject().equals((Object)bei.getBusinessEntity())) continue;
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("ASI.Action_can_not_be_performed"), (String)(mTextPool.getText("BE.DELETION.IMPOSIBLE") + cafBE.getBusinesEntityInterface().getBusinessEntity().getObjectName() + mTextPool.getText("BE.Interface")));
                    return;
                }
            }
            try {
                bomsystem.notifyDeleteBussinesEntityServiceBefore(cafbei);
                cafbei.remove();
                beis.remove(uniqueName.getName());
                bomsystem.notifyDeleteBussinesEntityServiceAfter(cafbei);
                bomsystem.getModifiedServicesList().objectGenerated((BaseObject)bei);
            }
            catch (Exception e) {
                logger.errorT("Could not delete Entity Service " + e.getMessage());
                e.printStackTrace();
            }
            MetamodelProvider.setDirtyOn(uniqueName.getParameter(0));
            slm.printMessage(mTextPool.getText("BOM_STATUSLINE_0002") + " " + uniqueName.getName() + " " + mTextPool.getText("BOM_STATUSLINE_0004") + ".");
        } else {
            logger.infoT("Deletion cancelled..." + uniqueName.getParameter(0));
            slm.printMessage(mTextPool.getText("BOM_STATUSLINE_0006") + " " + uniqueName.getName() + " " + mTextPool.getText("BOM_STATUSLINE_0005") + ".");
        }
        ModelTreeViewer.refreshInstances();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

