/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.model.ModelAccess;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.AttributeObjectAssociation;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.ObjectAttributeAssociation;
import com.sap.caf.metamodel.ObjectCompoundAssociation;
import com.sap.caf.metamodel.Property;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AttributeRemoveAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$AttributeRemoveAction == null ? (class$com$sap$caf$designer$actions$AttributeRemoveAction = AttributeRemoveAction.class$("com.sap.caf.designer.actions.AttributeRemoveAction")) : class$com$sap$caf$designer$actions$AttributeRemoveAction);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$AttributeRemoveAction;

    public AttributeRemoveAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        DataStructure ds;
        UniqueName un = element.getUniqueName();
        String name = un.getName();
        if (CAFBusinessEntityInterface.isDefaultAttributeName(name)) {
            return element.getUniqueName().getSubDomain().equals("Attribute Field Attribute");
        }
        BusinessEntityInterfaceEditor editor = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(element.getUniqueName().getParameter(0), element.getUniqueName().getParameter(1));
        CAFBusinessEntityInterface cbei = editor.getCAFBusinessEntityInterface();
        Attribute attrParent = null;
        Property attribute = null;
        return un.getParametersCount() != 3 || (ds = (attrParent = cbei.getAttributeByName(un.getParameter(2))).getReferencedObject()) == null || (attribute = (Property)cbei.getSubAttributeByName(name, ds)).isHollow() == false;
    }

    public void run(Element element) {
        block10: {
            BusinessEntityInterfaceEditor editor = null;
            try {
                String projectName = BOMSystem.getProjectNameFromAppName(element.getUniqueName().getParameter(0));
                BOMSystem bomSystem = BOMSystem.getBOMSystem(projectName);
                boolean dirty = true;
                if (element instanceof Entity) {
                    DataStructure ds;
                    Entity rightEntity = (Entity)element;
                    String subDomain = rightEntity.getUniqueName().getSubDomain();
                    if (subDomain.equals("Object Root")) {
                        return;
                    }
                    UniqueName un = rightEntity.getUniqueName();
                    String objName = un.getName();
                    String boName = un.getParameter(1);
                    String appName = un.getParameter(0);
                    String attrName = objName + "." + un.getName();
                    editor = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(appName, boName);
                    BOMSystem bos = editor.getBOMSystem();
                    if (bos == null) {
                        return;
                    }
                    HashMap c = bos.getBusinessEntityInterfaces();
                    CAFBusinessEntityInterface cbei = (CAFBusinessEntityInterface)c.get(boName);
                    Attribute attr = null;
                    if (un.getParametersCount() == 2) {
                        attr = cbei.getAttributeByName(objName);
                    }
                    DataStructure subDS = null;
                    Attribute attrParent = null;
                    if (un.getParametersCount() == 3 && (ds = (attrParent = cbei.getAttributeByName(un.getParameter(2))).getReferencedObject()) != null) {
                        attr = cbei.getSubAttributeByName(objName, ds);
                        subDS = ds;
                    }
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (attr != null) {
                        boolean canDelete = false;
                        Map operations = CAFBusinessEntityInterface.getAssociatedOperations(attr, attrParent, cbei);
                        canDelete = operations.isEmpty();
                        if (canDelete) {
                            AttributeRemoveAction.removeAttribute(cbei, attr, subDS);
                            ModelAccess.removeUniqueNameFromCache((Element)rightEntity);
                            editor.setDirty(true);
                            editor.getAttributesPage().refresh();
                        } else {
                            MessageDialog.openInformation((Shell)window.getShell(), (String)mTextPool.getText("ASDA.INFO.TITLE"), (String)(mTextPool.getText("ASDA.INFO.NODELETION") + "\n" + CAFBusinessEntityInterface.getReferersNames(operations)));
                        }
                    }
                    break block10;
                }
                return;
            }
            catch (Exception ex) {
                logger.catching((Throwable)ex);
                editor.setDirty(true);
                editor.getAttributesPage().refresh();
            }
        }
    }

    public static void removeAttribute(CAFBusinessEntityInterface cbei, Attribute attr, DataStructure subDS) {
        BOMSystem bomSystem = cbei.getBomSystem();
        DataObject entDS = cbei.getBusinesEntityInterface().getBusinessEntity();
        ObjectAttributeAssociation oaaAttrs = bomSystem.getMetamodelPackage().getObjectAttributeAssociation();
        DataStructure ds1 = oaaAttrs.getObject(attr);
        boolean b1 = oaaAttrs.refLinkExists((RefObject)ds1, (RefObject)attr);
        AttributeObjectAssociation aoaRef = bomSystem.getMetamodelPackage().getAttributeObjectAssociation();
        DataStructure ds2 = aoaRef.getReferencedObject(attr);
        ObjectCompoundAssociation ocaKeys = bomSystem.getMetamodelPackage().getObjectCompoundAssociation();
        DataStructure ds3 = ocaKeys.getObject(attr);
        boolean b3 = ocaKeys.refLinkExists((RefObject)ds2, (RefObject)attr);
        List attrList = null;
        attrList = subDS != null ? subDS.getAttributes() : (entDS.getKeys().contains(attr) ? entDS.getKeys() : entDS.getAttributes());
        int pos = -1;
        if (b1) {
            oaaAttrs.refRemoveLink((RefObject)ds1, (RefObject)attr);
        }
        if (b3) {
            ocaKeys.refRemoveLink((RefObject)ds3, (RefObject)attr);
        }
        cbei.deleteAttribute(attr);
        int i = 0;
        while (i < attrList.size()) {
            if (attrList.get(i) == attr) {
                pos = i;
                break;
            }
            ++i;
        }
        attrList.remove(pos);
        attr.refDelete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

