/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.wizards.AttributeWizard;
import com.sap.caf.metamodel.Property;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class AttributeAttributeCreateAction
extends BaseSingleAction {
    private static final int UNKNOWN_ACTION = -1;
    private static final int ACTION_FOR_BO = 0;
    private static final int ACTION_FOR_VS = 1;
    private static final TextPool mTextPool = TextPool.getInstance();
    private int actionType;

    public AttributeAttributeCreateAction(ICategory category) {
        super(category);
        String descripton = category.getDescription();
        this.actionType = (mTextPool.getText("BOM_MENU_0002") + "Create Subattribute").equals(descripton) ? 0 : ("Delete Attribute".equals(descripton) ? 1 : -1);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        String projName = BOMSystem.getProjectNameFromAppName(uniqueName.getParameter(0));
        String objName = uniqueName.getParameter(1);
        BusinessEntityInterfaceEditor editor = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(element.getUniqueName().getParameter(0), element.getUniqueName().getParameter(1));
        CAFBusinessEntityInterface cbei = editor.getCAFBusinessEntityInterface();
        Property complex = (Property)cbei.getAttributeByName(uniqueName.getName());
        return !complex.isHollow().booleanValue();
        {
        }
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        String projName = BOMSystem.getProjectNameFromAppName(uniqueName.getParameter(0));
        BOMSystem bos = BOMSystem.getBOMSystem(projName);
        IProject iProject = bos.getPhysicalProjectByType("MMR_CORE");
        String objName = uniqueName.getParameter(1);
        switch (this.actionType) {
            case 0: {
                String attrType = "AttributeAttribute";
                AttributeWizard aw = new AttributeWizard(element, attrType, uniqueName.getName());
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)aw);
                dialog.create();
                dialog.open();
                break;
            }
        }
    }
}

