/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.editors.ApplicationInterfaceEditorInput;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ApplicationInterfaceEditAction
extends BaseSingleAction {
    public ApplicationInterfaceEditAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getLocation().equals("Project");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        BOMSystem bos = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bos.getPhysicalProjectByType("MMR_CORE");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean localPersistency = false;
        boolean indexSearch = false;
        try {
            HashMap c = bos.getApplicationInterfaces();
            CAFApplicationInterface bei = (CAFApplicationInterface)c.get(uniqueName.getName());
            ApplicationInterfaceEditorInput eInput = new ApplicationInterfaceEditorInput(bei);
            IWorkbenchPage workbenchActivePage = window.getActivePage();
            if (workbenchActivePage != null) {
                workbenchActivePage.openEditor((IEditorInput)eInput, "com.sap.caf.designer.editors.ApplicationInterfaceEditor");
            }
        }
        catch (PartInitException e1) {
            MessageDialog.openError((Shell)window.getShell(), (String)TextPool.getInstance().getText("ASI.Editor_could_not_be_opened_1"), (String)e1.getMessage());
        }
    }
}

