/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.actions;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.BaseSingleAction;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.metamodel.BaseObject;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.action.ICategory;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ApplicationInterfaceDeleteAction
extends BaseSingleAction {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$actions$ApplicationInterfaceDeleteAction == null ? (class$com$sap$caf$designer$actions$ApplicationInterfaceDeleteAction = ApplicationInterfaceDeleteAction.class$("com.sap.caf.designer.actions.ApplicationInterfaceDeleteAction")) : class$com$sap$caf$designer$actions$ApplicationInterfaceDeleteAction);
    static /* synthetic */ Class class$com$sap$caf$designer$actions$ApplicationInterfaceDeleteAction;

    public ApplicationInterfaceDeleteAction(ICategory category) {
        super(category);
    }

    public boolean isEnabled(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        return uniqueName.getLocation().equals("Project");
    }

    public void run(Element element) {
        UniqueName uniqueName = element.getUniqueName();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineMessage slm = new StatusLineMessage();
        BOMSystem bomSystem = BOMSystem.getBOMSystem(uniqueName.getParameter(0));
        IProject iProject = bomSystem.getPhysicalProjectByType("MMR_CORE");
        if (MessageDialog.openConfirm((Shell)window.getShell(), (String)mTextPool.getText("BOM_BONAVIGATOR_0002"), (String)mTextPool.getText("ASI_BONAVIGATOR_0001"))) {
            HashMap asis = bomSystem.getApplicationInterfaces();
            CAFApplicationInterface cafAS = (CAFApplicationInterface)asis.get(uniqueName.getName());
            Iterator aeis = asis.values().iterator();
            while (aeis.hasNext()) {
                CAFApplicationInterface cafAppServ = (CAFApplicationInterface)aeis.next();
                if (!cafAppServ.getApplicationInterface().getUsedInterfaces().contains(cafAS.getApplicationInterface())) continue;
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)mTextPool.getText("ASI.Action_can_not_be_performed"), (String)(mTextPool.getText("ASI.ASInterface_is_used") + cafAppServ.getApplicationInterface().getObjectName() + mTextPool.getText("ASI.can_not_be_deleted")));
                return;
            }
            bomSystem.notifyRemoveApplicationServiceBefore(cafAS);
            bomSystem.getModifiedServicesList().objectGenerated((BaseObject)cafAS.getApplicationInterface());
            cafAS.remove();
            asis.remove(uniqueName.getName());
            bomSystem.notifyRemoveApplicationServiceAfter(cafAS);
            MetamodelProvider.setDirtyOn(uniqueName.getParameter(0));
            slm.printMessage(mTextPool.getText("ASI_STATUSLINE_0002") + " " + uniqueName.getName() + " " + mTextPool.getText("BOM_STATUSLINE_0004") + ".");
        } else {
            logger.infoT("Deletion cancelled..." + uniqueName.getParameter(0));
            slm.printMessage(mTextPool.getText("BOM_STATUSLINE_0006") + " " + uniqueName.getName() + " " + mTextPool.getText("BOM_STATUSLINE_0005") + ".");
        }
        ModelTreeViewer.refreshInstances();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

