/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer;

import com.sap.caf.designer.BomResourceAccessor;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPoolBase;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.tc.logging.Location;

public class TextPool
extends TextPoolBase {
    protected static TextPool mTextPool;
    private static String LABEL_SEMICOLON;
    private static final Location logger;
    static /* synthetic */ Class class$com$sap$caf$designer$TextPool;

    public static final TextPool getInstance() {
        if (mTextPool == null) {
            mTextPool = new TextPool();
        }
        return mTextPool;
    }

    public String getText(String textId) {
        String localizedText = null;
        try {
            localizedText = new LocalizableTextFormatter(BomResourceAccessor.getInstance(), textId).format();
            if (localizedText.startsWith("<--Localization failed")) {
                localizedText = textId;
            }
        }
        catch (LocalizationException localizationException) {
            // empty catch block
        }
        return localizedText;
    }

    public String getText(String textId, boolean withSemicolon) {
        if (withSemicolon) {
            return this.getText(textId) + LABEL_SEMICOLON;
        }
        return this.getText(textId);
    }

    public String getText(String textId, Object[] parms) {
        String localizedText = null;
        try {
            localizedText = new LocalizableTextFormatter(BomResourceAccessor.getInstance(), textId, parms).format();
            if (localizedText.startsWith("<--Localization failed")) {
                localizedText = textId;
            }
        }
        catch (LocalizationException e) {
            logger.errorT("An error occured while trying to get text for textID " + textId);
        }
        return localizedText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LABEL_SEMICOLON = ":";
        logger = Logger.getLocation(class$com$sap$caf$designer$TextPool == null ? (class$com$sap$caf$designer$TextPool = TextPool.class$("com.sap.caf.designer.TextPool")) : class$com$sap$caf$designer$TextPool);
    }
}

