/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer;

import com.sap.caf.designer.DecoratorImages;
import java.util.Vector;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    private static ImageRegistry registry = new ImageRegistry(Display.getDefault());
    private Image baseImage_;
    private Point sizeOfImage_;
    private Vector imageKey_;
    private DecoratorImages decoratorImage_;

    public OverlayImageIcon(Image baseImage, DecoratorImages decoratorImage, Vector imageKey) {
        this.baseImage_ = baseImage;
        this.decoratorImage_ = decoratorImage;
        this.imageKey_ = imageKey;
        this.sizeOfImage_ = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    public Image getImage() {
        String key = this.generateImageRegistryKey();
        Image decoratedImage = registry.get(key);
        if (decoratedImage == null) {
            decoratedImage = this.createImage();
            registry.put(key, decoratedImage);
        }
        return decoratedImage;
    }

    protected Point getSize() {
        return this.sizeOfImage_;
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        this.drawImage(this.baseImage_.getImageData(), 0, 0);
        int[] locations = this.organizeImages();
        int i = 0;
        while (i < this.imageKey_.size()) {
            ImageData imageData = this.decoratorImage_.getImageData((String)this.imageKey_.get(i));
            switch (locations[i]) {
                case 0: {
                    this.drawImage(imageData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(imageData, this.sizeOfImage_.x - imageData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(imageData, 0, this.sizeOfImage_.y - imageData.height);
                    break;
                }
                case 3: {
                    this.drawImage(imageData, this.sizeOfImage_.x - imageData.width, this.sizeOfImage_.y - imageData.height);
                }
            }
            ++i;
        }
    }

    private String generateImageRegistryKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.baseImage_.hashCode());
        int i = 0;
        while (i < this.imageKey_.size()) {
            buffer.append(":");
            buffer.append(this.imageKey_.elementAt(i));
            ++i;
        }
        return buffer.toString();
    }

    private int[] organizeImages() {
        int[] locations = new int[this.imageKey_.size()];
        int i = 0;
        while (i < this.imageKey_.size()) {
            String imageKeyValue = (String)this.imageKey_.get(i);
            if (imageKeyValue.equals("Lock")) {
                locations[i] = 0;
            }
            if (imageKeyValue.equals("Key")) {
                locations[i] = 3;
            }
            if (imageKeyValue.equals("Error")) {
                locations[i] = 2;
            }
            ++i;
        }
        return locations;
    }
}

