/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.rdc.slimpl;

import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.rdc.api.IDCDependency;
import com.sap.tc.webdynpro.rdc.api.IDCMetaData;
import com.sap.tc.webdynpro.rdc.api.IDO;
import com.sap.tc.webdynpro.rdc.api.IPP;
import com.sap.tc.webdynpro.rdc.slimpl.RDCRuntimeException;
import com.sap.tc.webdynpro.rdc.slimpl.SLDC;
import com.sap.tc.webdynpro.rdc.slimpl.SLDCDependency;
import com.sap.tc.webdynpro.rdc.slimpl.SLDO;
import com.sap.tc.webdynpro.rdc.slimpl.SLPP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class SLDCMetaData
implements IDCMetaData {
    private static final Location logger = Location.getLocation((String)(class$com$sap$tc$webdynpro$rdc$slimpl$SLDCMetaData == null ? (class$com$sap$tc$webdynpro$rdc$slimpl$SLDCMetaData = SLDCMetaData.class$("com.sap.tc.webdynpro.rdc.slimpl.SLDCMetaData")) : class$com$sap$tc$webdynpro$rdc$slimpl$SLDCMetaData).getName());
    private DevelopmentComponent dc = null;
    private SLDC dco = null;
    static /* synthetic */ Class class$com$sap$tc$webdynpro$rdc$slimpl$SLDCMetaData;

    protected SLDCMetaData(SLDC dc) {
        this.dco = dc;
        this.load();
    }

    public IPP[] getPublicParts() {
        try {
            Map map = this.dc.getPublicParts();
            Object[] pps = map.entrySet().toArray();
            IPP[] ipps = new IPP[pps.length];
            int i = 0;
            while (i < pps.length) {
                ipps[i] = new SLPP((PublicPart)pps[i]);
                ++i;
            }
            return ipps;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IPP addPublicPart(String name) {
        PublicPart pp = ComponentFactory.createPublicPart((String)name, (DevelopmentComponent)this.dc);
        pp.setPurpose(PublicPart.Purpose.COMPILATION);
        return new SLPP(pp);
    }

    public void deletePublicPart(IPP publicPart) {
        try {
            this.dc.getPublicParts().remove(publicPart.getName());
        }
        catch (Exception e) {
            this.raiseException(e, publicPart.getName(), "deletePublicPart");
        }
    }

    public IDCDependency[] getDependencies() {
        try {
            Object[] deps = this.dc.getDependencies().toArray();
            IDCDependency[] ideps = new IDCDependency[deps.length];
            int i = 0;
            while (i < deps.length) {
                ideps[i] = new SLDCDependency((Dependency)deps[i]);
                ++i;
            }
            return ideps;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IDCDependency addDependency(String targetVendor, String targetDCName, String targetPPName) {
        Dependency dep = ComponentFactory.createDependency((PPReference)new PPReference(targetPPName, new DCReference(targetDCName, targetVendor)), (DevelopmentComponent)this.dc);
        dep.setAtBuildTime(true);
        dep.setAtDesignTime(true);
        dep.setAtDeployTime(true);
        dep.setAtRunTime(true);
        return new SLDCDependency(dep);
    }

    public void deleteDependency(IDCDependency dependency) {
        List ents = this.dc.getDependencies();
        SLDCDependency sldep = (SLDCDependency)dependency;
        if (ents != null) {
            int i = 0;
            while (i < ents.size()) {
                Dependency ent = (Dependency)ents.get(i);
                if (sldep.equals(ent)) {
                    ents.remove(i);
                    return;
                }
                ++i;
            }
        }
        throw new RuntimeException("Could not find dependency " + dependency);
    }

    public void save() {
        try {
            this.dc.serialize((DCOutputProvider)new SLDCOutputProvider());
        }
        catch (Exception e) {
            this.raiseException(e, this.dc.getName(), "save");
        }
    }

    private void load() {
        SLDCInputProvider in = new SLDCInputProvider();
        try {
            this.dc = ComponentFactory.initialize((DCInputProvider)in, (boolean)true);
        }
        catch (Exception e) {
            this.raiseException(e, this.dco.getName(), "load");
        }
    }

    private void raiseException(Exception e, String entityName, String methodName) {
        throw new RDCRuntimeException("[" + methodName + "] for Entity " + entityName + " failed. ", e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.webdynpro.rdc.slimpl").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_designtime_coupling/java/com/sap/tc/webdynpro/rdc/slimpl/SLDCMetaData.java#2 $");
    }

    private class SLDCOutputProvider
    implements DCOutputProvider {
        IDO def = null;

        private SLDCOutputProvider() {
            this.def = SLDCMetaData.this.dco.getDO(".dcdef");
        }

        public PPOutputProvider getPPOutputProvider(String publicPartName) {
            return new SLPPOutputProvider(publicPartName);
        }

        public OutputStream getStreamForDC() throws ProviderException {
            return new ByteArrayOutputStream();
        }

        public void releaseStream(OutputStream stream) {
            try {
                if (stream != null) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)stream;
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    SLDCMetaData.this.dco.checkout(this.def);
                    this.def.setContent((InputStream)is, (long)baos.size());
                    stream.close();
                }
            }
            catch (IOException e) {
                Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to close an input stream in runtime-designtime coupling.", (Throwable)e);
            }
        }
    }

    private class SLDCInputProvider
    implements DCInputProvider {
        IDO def = null;

        private SLDCInputProvider() {
            this.def = SLDCMetaData.this.dco.getDO(".dcdef");
        }

        public PPInputProvider getPPInputProvider(String publicPartName) throws ProviderException {
            return new SLPPInputProvider(publicPartName);
        }

        public String[] getPublicParts() throws ProviderException {
            SLDO sldef = (SLDO)SLDCMetaData.this.dco.getDO("def");
            return sldef.getFolderContentFiles();
        }

        public InputStream getStreamForDC() throws ProviderException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.def.getContent((OutputStream)baos);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            return is;
        }

        public void releaseStream(InputStream stream) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to close an input stream in runtime-designtime coupling.", (Throwable)e);
            }
        }
    }

    private class SLPPInputProvider
    implements PPInputProvider {
        IDO def = null;

        private SLPPInputProvider(String publicPartName) {
            this.def = SLDCMetaData.this.dco.getDO("def/" + publicPartName + ".pp");
        }

        public InputStream getStreamForPublicPart() throws ProviderException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.def.getContent((OutputStream)baos);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            return is;
        }

        public void releaseStream(InputStream stream) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to close an input stream in runtime-designtime coupling.", (Throwable)e);
            }
        }
    }

    private class SLPPOutputProvider
    implements PPOutputProvider {
        IDO def = null;

        private SLPPOutputProvider(String publicPartName) {
            this.def = SLDCMetaData.this.dco.getDO("def/" + publicPartName + ".pp");
        }

        public OutputStream getStreamForPublicPart() throws ProviderException {
            return new ByteArrayOutputStream();
        }

        public void releaseStream(OutputStream stream) {
            try {
                if (stream != null) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)stream;
                    ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                    SLDCMetaData.this.dco.checkout(this.def);
                    this.def.setContent((InputStream)is, (long)baos.size());
                    stream.close();
                }
            }
            catch (IOException e) {
                Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to close an input stream in runtime-designtime coupling.", (Throwable)e);
            }
        }
    }
}

