/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.smime;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.SubjectAltName;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

public class TrustVerifier {
    protected Hashtable a = new Hashtable();
    private static final boolean b = false;

    public boolean verifyChain(iaik.x509.X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            throw new NullPointerException("Cannot verify null cert chain!");
        }
        try {
            int n = x509CertificateArray.length;
            int n2 = 0;
            while (n2 < n - 1) {
                if (this.a(x509CertificateArray[n2], x509CertificateArray[n2 + 1])) {
                    return true;
                }
                ++n2;
            }
            iaik.x509.X509Certificate x509Certificate = x509CertificateArray[n - 1];
            if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
                if (this.a(x509Certificate, x509Certificate)) {
                    return true;
                }
            } else {
                iaik.x509.X509Certificate x509Certificate2 = this.getTrustedIssuerCert(x509Certificate);
                if (this.a(x509Certificate, x509Certificate2)) {
                    return true;
                }
                if (x509Certificate2 != null && this.isTrustedCertificate(x509Certificate2)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return this.size() == 0;
    }

    private boolean a(iaik.x509.X509Certificate x509Certificate, iaik.x509.X509Certificate x509Certificate2) throws Exception {
        if (this.isTrustedCertificate(x509Certificate)) {
            return true;
        }
        x509Certificate.checkValidity();
        if (x509Certificate2 != null) {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        return false;
    }

    public int size() {
        return this.a.size();
    }

    public boolean removeTrustedCertificate(iaik.x509.X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        try {
            Object var2_2 = null;
            var2_2 = this.a.remove(x509Certificate.getSubjectDN());
            if (var2_2 != null) {
                return true;
            }
            return this.a.remove(new IssuerAndSerialNumber((X509Certificate)x509Certificate)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isTrustedCertificate(iaik.x509.X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("Cannot check null certificate!");
        }
        iaik.x509.X509Certificate x509Certificate2 = null;
        x509Certificate2 = (iaik.x509.X509Certificate)this.a.get(x509Certificate.getSubjectDN());
        if (x509Certificate2 != null) {
            return x509Certificate2.equals(x509Certificate);
        }
        x509Certificate2 = (iaik.x509.X509Certificate)this.a.get(new IssuerAndSerialNumber((X509Certificate)x509Certificate));
        if (x509Certificate2 == null) {
            return false;
        }
        return x509Certificate2.equals(x509Certificate);
    }

    private boolean a(iaik.x509.X509Certificate x509Certificate) {
        try {
            BasicConstraints basicConstraints = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (basicConstraints != null && basicConstraints.ca()) {
                return true;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {}
        if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            try {
                x509Certificate.verify();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public iaik.x509.X509Certificate getTrustedIssuerCert(iaik.x509.X509Certificate x509Certificate) {
        iaik.x509.X509Certificate x509Certificate2 = (iaik.x509.X509Certificate)this.a.get(x509Certificate.getIssuerDN());
        return x509Certificate2;
    }

    public Enumeration getTrustedCertificates() {
        return this.a.elements();
    }

    public boolean checkEMail(String string, iaik.x509.X509Certificate x509Certificate) {
        GeneralNames generalNames;
        Name name = (Name)x509Certificate.getSubjectDN();
        String string2 = name.getRDN(ObjectID.emailAddress);
        if (string2 != null) {
            return string.equals(string2);
        }
        SubjectAltName subjectAltName = null;
        try {
            subjectAltName = (SubjectAltName)x509Certificate.getExtension(SubjectAltName.oid);
        }
        catch (Exception exception) {
            subjectAltName = null;
        }
        if (subjectAltName != null && (generalNames = subjectAltName.getGeneralNames()) != null) {
            Enumeration enumeration = generalNames.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != GeneralName.rfc822Name || !string.equals(string2 = (String)generalName.getName())) continue;
                System.out.println("Email addresses correct!");
                break;
            }
        }
        if (string2 == null) {
            return this.a(x509Certificate);
        }
        return false;
    }

    public void addTrustedCertificate(iaik.x509.X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("Cannot add a null certificate!");
        }
        if (this.a(x509Certificate)) {
            this.a.put(x509Certificate.getSubjectDN(), x509Certificate);
            return;
        }
        this.a.put(new IssuerAndSerialNumber((X509Certificate)x509Certificate), x509Certificate);
    }
}

