/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr.adapter;

import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class TraceIMessage {
    private static Hashtable sTypes;

    public static String traceIPorttype(IPorttype porttype) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Porttype: " + porttype.getName() + "\n");
        for (int i = 0; i < porttype.getOperationCount(); ++i) {
            IOperation operation = porttype.getOperation(i);
            buffer.append("Operation: " + operation.getName() + "\n");
            if (operation.getInputOperationpart() != null) {
                buffer.append("input : " + operation.getInputOperationpart().getName() + "\n");
                buffer.append(TraceIMessage.traceIMessage(operation.getInputOperationpart().getMessage()));
            }
            if (operation.getOutputOperationpart() != null) {
                buffer.append("output : " + operation.getOutputOperationpart().getName() + "\n");
                buffer.append(TraceIMessage.traceIMessage(operation.getOutputOperationpart().getMessage()));
            }
            if (operation.getFaultOperationpartEnumeration() == null) continue;
            for (int j = 0; j < operation.getFaultOperationpartCount(); ++j) {
                buffer.append("fault : " + operation.getFaultOperationpart(j).getName() + "\n");
                buffer.append(TraceIMessage.traceIMessage(operation.getFaultOperationpart(j).getMessage()));
            }
        }
        return buffer.toString();
    }

    public static String traceIMessage(IMessage message) {
        int depth = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Message " + message.getName() + "\n");
        ++depth;
        for (int i = 0; i < message.getMessagepartCount(); ++i) {
            IMessagepart messagePart = message.getMessagepart(i);
            TraceIMessage.insert(buffer, " ", depth * 2);
            buffer.append("messagePart " + messagePart.getName() + "\n");
            ArrayList<IStructure> list = new ArrayList<IStructure>();
            list.add(messagePart.getStructure());
            TraceIMessage.traceIStructures(depth + 1, buffer, list);
        }
        return buffer.toString();
    }

    private static void traceIStructures(int depth, StringBuffer buffer, Collection structures) {
        Iterator iter = structures.iterator();
        while (iter.hasNext()) {
            IStructure structure = (IStructure)iter.next();
            if (structure instanceof IElement) {
                TraceIMessage.traceIElement(structures, depth, buffer, (IElement)structure);
            }
            if (structure instanceof IComplexType) {
                TraceIMessage.traceIComplexType(structures, depth, buffer, (IComplexType)structure);
            }
            if (structure instanceof ISimpleType) {
                TraceIMessage.traceISimpleType(depth, buffer, (ISimpleType)structure);
            }
            buffer.append("\n");
            TraceIMessage.insert(buffer, "-", 20);
            buffer.append("\n");
        }
    }

    private static void traceIElement(Collection structures, int depth, StringBuffer buffer, IElement element) {
        TraceIMessage.insert(buffer, " ", depth * 2);
        buffer.append("IElement " + element.getName() + " - minOccurs : " + element.getMinOccurs() + ", maxOccurs : " + element.getMaxOccurs() + "\n");
        IType type = element.getType();
        if (type instanceof IComplexType) {
            TraceIMessage.traceIComplexType(structures, depth + 1, buffer, (IComplexType)type);
        }
        if (type instanceof ISimpleType) {
            TraceIMessage.traceISimpleType(depth + 1, buffer, (ISimpleType)type);
        }
    }

    private static void traceIComplexType(Collection structures, int depth, StringBuffer buffer, IComplexType complexType) {
        TraceIMessage.insert(buffer, " ", depth * 2);
        buffer.append("IComplexType ");
        switch (complexType.getMode()) {
            case 1: {
                buffer.append("MODE_ALL");
                break;
            }
            case 2: {
                buffer.append("MODE_CHOICE");
                break;
            }
            case 3: {
                buffer.append("MODE_SEQUENCE");
            }
        }
        buffer.append("\n");
        for (int i = 0; i < complexType.getElementCount(); ++i) {
            IElement element = complexType.getElement(i);
            if (!(element.getType() instanceof ISimpleType) && sTypes.containsValue(element.getType())) {
                TraceIMessage.insert(buffer, " ", (depth + 1) * 2);
                buffer.append(element.getName() + ", minOccurs : " + element.getMinOccurs() + ", maxOccurs : " + (element.getMaxOccurs() == 0 ? "unbounded" : Integer.toString(element.getMaxOccurs())) + "\n");
                continue;
            }
            TraceIMessage.traceIElement(structures, depth + 1, buffer, element);
        }
    }

    private static void traceISimpleType(int depth, StringBuffer buffer, ISimpleType simpleType) {
        TraceIMessage.insert(buffer, " ", depth * 2);
        buffer.append("Simple type - base: " + simpleType.getBase() + ", totalDigits:" + simpleType.getTotalDigits() + ", fractionDigits:" + simpleType.getFractionDigits() + ", maxLength:" + simpleType.getMaxLength());
        if (simpleType.getConstantCount() > 0) {
            buffer.append("\n  ");
            TraceIMessage.insert(buffer, " ", depth * 2);
            buffer.append("Constants: ");
        }
        Enumeration enumeration = simpleType.getConstantEnumeration();
        while (enumeration.hasMoreElements()) {
            buffer.append(((ISimpleTypeValue)enumeration.nextElement()).getValue() + ", ");
        }
        if (simpleType.getPatternCount() > 0) {
            buffer.append("\n  ");
            TraceIMessage.insert(buffer, " ", depth * 2);
            buffer.append("Patterns: ");
        }
        enumeration = simpleType.getPatternEnumeration();
        while (enumeration.hasMoreElements()) {
            buffer.append(enumeration.nextElement().toString() + ", ");
        }
        buffer.append("\n");
    }

    private static void insert(StringBuffer buffer, String str, int size) {
        for (int i = 0; i < size; ++i) {
            buffer.append(str);
        }
    }
}

