/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr.adapter;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.mapping.api.IMappingRule;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.mmr.adapter.MMServiceRetrievalAdapter;
import com.sap.caf.mp.mmr.adapter.TraceIMessage;
import java.util.Enumeration;

public class Test {
    public static void main(String[] args) {
        Test.testIdsRetrieval();
    }

    public static void testIdsRetrieval() {
        Object curID;
        MMServiceRetrievalAdapter adapter = new MMServiceRetrievalAdapter();
        Enumeration resultIds = null;
        System.out.println("BEGIN-----------------Message IDs---------------------------");
        resultIds = Test.getMessageIds(adapter);
        int index = 0;
        while (resultIds.hasMoreElements()) {
            curID = resultIds.nextElement();
            if (curID != null) {
                System.out.println("\tMessage ID: " + curID.toString());
                IMessage message = Test.getMessageInstance(adapter, (String)curID);
            } else {
                System.out.println("NULL ID for element with index " + index);
            }
            ++index;
        }
        System.out.println("END-----------------Message IDs---------------------------");
        System.out.println("BEGIN-----------------Port Type IDs---------------------------");
        resultIds = Test.getPorttypeIds(adapter);
        index = 0;
        while (resultIds.hasMoreElements()) {
            curID = resultIds.nextElement();
            if (curID != null) {
                System.out.println("\tPort Type ID: " + curID.toString());
                IPorttype porttype = Test.getPortTypeInstance(adapter, (String)curID);
                System.out.println("\t\tPort Type: " + porttype.toString());
                System.out.println(TraceIMessage.traceIPorttype(porttype));
            } else {
                System.out.println("NULL ID for element with index " + index);
            }
            ++index;
        }
        System.out.println("END-----------------Port Type IDs---------------------------");
        System.out.println("BEGIN-----------------Service Definition IDs---------------------------");
        resultIds = Test.getServiceDefinitionIds(adapter);
        index = 0;
        while (resultIds.hasMoreElements()) {
            curID = resultIds.nextElement();
            if (curID != null) {
                System.out.println("\tService Definition ID: " + curID.toString());
                IServiceDefinition sd = Test.getServiceDefinitionInstance(adapter, (String)curID);
                System.out.println("\t\tService Definition ID: " + sd.toString());
            } else {
                System.out.println("NULL ID for element with index " + index);
            }
            ++index;
        }
        System.out.println("END-----------------Service Definition IDs---------------------------");
        System.out.println("BEGIN-----------------Mapping Rule IDs---------------------------");
        resultIds = Test.getMappingRuleIds(adapter);
        index = 0;
        while (resultIds.hasMoreElements()) {
            curID = resultIds.nextElement();
            if (curID != null) {
                System.out.println("\tMapping Rule ID: " + curID.toString());
                IMappingRule mappingRule = Test.getMappingRuleInstance(adapter, (String)curID);
                System.out.println("\t\tMapping Rule ID: " + mappingRule.toString());
            } else {
                System.out.println("NULL ID for element with index " + index);
            }
            ++index;
        }
        System.out.println("END-----------------Mapping Rule IDs---------------------------");
    }

    private static Enumeration getMessageIds(MMServiceRetrievalAdapter aAdapter) {
        Enumeration result;
        try {
            result = aAdapter.getMessageIds();
        }
        catch (EngineException exc) {
            result = null;
        }
        return result;
    }

    private static Enumeration getPorttypeIds(MMServiceRetrievalAdapter aAdapter) {
        Enumeration result;
        try {
            result = aAdapter.getPorttypeIds();
        }
        catch (EngineException exc) {
            result = null;
        }
        return result;
    }

    private static Enumeration getServiceDefinitionIds(MMServiceRetrievalAdapter aAdapter) {
        Enumeration result;
        try {
            result = aAdapter.getServiceDefinitionIds();
        }
        catch (EngineException exc) {
            result = null;
        }
        return result;
    }

    private static Enumeration getMappingRuleIds(MMServiceRetrievalAdapter aAdapter) {
        Enumeration result;
        try {
            result = aAdapter.readMappingRuleIds();
        }
        catch (EngineException exc) {
            result = null;
        }
        return result;
    }

    private static IMappingRule getMappingRuleInstance(MMServiceRetrievalAdapter aAdapter, String id) {
        IMappingRule result;
        try {
            result = aAdapter.readMappingRule(id);
        }
        catch (EngineException exc) {
            result = null;
        }
        catch (InvocationException exc) {
            result = null;
        }
        return result;
    }

    private static IServiceDefinition getServiceDefinitionInstance(MMServiceRetrievalAdapter aAdapter, String id) {
        IServiceDefinition result;
        try {
            result = aAdapter.readServiceDefinition(id);
        }
        catch (EngineException exc) {
            result = null;
        }
        catch (InvocationException exc) {
            result = null;
        }
        return result;
    }

    private static IPorttype getPortTypeInstance(MMServiceRetrievalAdapter aAdapter, String id) {
        IPorttype result;
        try {
            result = aAdapter.readPorttype(id);
        }
        catch (EngineException exc) {
            result = null;
        }
        catch (InvocationException exc) {
            result = null;
        }
        return result;
    }

    private static IMessage getMessageInstance(MMServiceRetrievalAdapter aAdapter, String id) {
        IMessage result;
        try {
            result = aAdapter.readMessage(id);
        }
        catch (EngineException exc) {
            result = null;
        }
        catch (InvocationException exc) {
            result = null;
        }
        return result;
    }
}

