/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr.adapter;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.mp.mmr.adapter.SimpleTypeNotFoundException;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class SimpleTypeMapping {
    private static Hashtable simpleTypeMapping = new Hashtable();
    private static String EXCEPTION_MESSAGE = "The type provided is not present in the mapping table!";
    private static String typePrefix = "com.sap.caf.base.";
    static /* synthetic */ Class class$com$sap$caf$mp$mmr$adapter$SimpleTypeMapping;

    public static int getSimpleTypeBase(String coreTypeJavaDDic) throws SimpleTypeNotFoundException {
        Integer i = (Integer)simpleTypeMapping.get(coreTypeJavaDDic);
        if (i == null) {
            throw new SimpleTypeNotFoundException(EXCEPTION_MESSAGE);
        }
        return i;
    }

    public static int getSimpleTypeBase(Attribute coreAttribute) throws SimpleTypeNotFoundException {
        int result = 12;
        String javaDDicType = coreAttribute.getTypeJavaDdic();
        IBroker broker = null;
        IDataType dataType = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Locale locale = Locale.getDefault();
        DdDictionaryPool pool = DdDictionaryPool.getInstance();
        try {
            broker = pool.createBroker(cl, locale);
            dataType = broker.getDataType(javaDDicType);
            result = SimpleTypeMapping.convertIDataTypeToMPSimpleType(dataType);
        }
        catch (DdException ex) {
            // empty catch block
        }
        return result;
    }

    private static int convertIDataTypeToMPSimpleType(IDataType dataType) {
        int result = 12;
        if (dataType.isSimpleType()) {
            ISimpleType simpleType = (ISimpleType)dataType;
            String buildInType = simpleType.getBuiltInType();
            if (buildInType.equals(ISimpleType.TYPE_BINARY.getName())) {
                result = 1;
            } else if (buildInType.equals(ISimpleType.TYPE_BOOLEAN.getName())) {
                result = 2;
            } else if (buildInType.equals(ISimpleType.TYPE_DATE.getName())) {
                result = 4;
            } else if (buildInType.equals(ISimpleType.TYPE_DECIMAL.getName())) {
                result = 5;
            } else if (buildInType.equals(ISimpleType.TYPE_DOUBLE.getName())) {
                result = 6;
            } else if (buildInType.equals(ISimpleType.TYPE_FLOAT.getName())) {
                result = 7;
            } else if (buildInType.equals(ISimpleType.TYPE_INTEGER.getName())) {
                result = 8;
            } else if (buildInType.equals(ISimpleType.TYPE_LONG.getName())) {
                result = 10;
            } else if (buildInType.equals(ISimpleType.TYPE_SHORT.getName())) {
                result = 11;
            } else if (buildInType.equals(ISimpleType.TYPE_STRING.getName())) {
                result = 12;
            } else if (buildInType.equals(ISimpleType.TYPE_TIME.getName())) {
                result = 13;
            } else if (buildInType.equals(ISimpleType.TYPE_TIMESTAMP.getName())) {
                result = 14;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream stream = null;
        Properties properties = new Properties();
        try {
            try {
                URL url = (class$com$sap$caf$mp$mmr$adapter$SimpleTypeMapping == null ? (class$com$sap$caf$mp$mmr$adapter$SimpleTypeMapping = SimpleTypeMapping.class$("com.sap.caf.mp.mmr.adapter.SimpleTypeMapping")) : class$com$sap$caf$mp$mmr$adapter$SimpleTypeMapping).getResource("simple_type_mapping.properties");
                stream = url.openStream();
                properties.load(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            try {
                simpleTypeMapping.put(key, new Integer(Integer.parseInt(value)));
            }
            catch (NumberFormatException e1) {}
        }
    }
}

