/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.reader.ReadableLog;
import com.sap.tc.logging.tools.lv.LVFormatter;
import com.sap.tc.logging.tools.lv.LVOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class LVReader {
    private static final Location console = Location.getLocation("std");
    private static final String LISTFORMATTER_VERSION_TAG = "#1.5";
    private static final String SPACE = " ";
    private static final int ALIGN_LEFT = 1;
    private static final int ALIGN_CENTER = 2;
    private static final int ALIGN_RIGHT = 3;
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    private static final boolean debug = false;
    private LVOptions lvOptions = null;
    private boolean isStdOut = false;
    private boolean isStdError = false;
    private File[] logDirectory;
    private IReadLog[] file;
    private static PrintWriter out;
    private final ListFormatter formatter = new ListFormatter();

    public LVReader(LVOptions lvOptions) {
        this.lvOptions = lvOptions;
        out = lvOptions.outSystem;
        this.init();
    }

    private void init() {
        Vector<IReadLog> fileList = new Vector<IReadLog>();
        int i = 0;
        while (i < this.lvOptions.readFileName.length) {
            File logDirFile = new File(this.lvOptions.readFileName[i]);
            if (!logDirFile.exists()) {
                this.lvOptions.outSystem.println("Error: invalid path/filename to server log . Directory/file does not exist.");
                this.lvOptions.outSystem.println(LVOptions.help);
            } else {
                File[] fileForRead = null;
                fileForRead = logDirFile.isDirectory() ? logDirFile.listFiles() : new File[]{logDirFile};
                int fCnt = 0;
                while (fCnt < fileForRead.length) {
                    try {
                        if (fileForRead[fCnt].isFile()) {
                            fileList.add(ReadableLog.createFileReadLog(new FileLog(fileForRead[fCnt].toString())));
                        }
                    }
                    catch (Exception ex) {
                        this.lvOptions.outSystem.println(ex.getMessage());
                    }
                    ++fCnt;
                }
            }
            ++i;
        }
        if (!fileList.isEmpty()) {
            this.file = fileList.toArray(new IReadLog[0]);
        }
        if (this.lvOptions.outFileName != null) {
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(this.lvOptions.outFileName)));
            }
            catch (Throwable th) {
                this.lvOptions.outSystem.println("invalid outfile option '" + this.lvOptions.outFileName + "'");
                this.lvOptions.outSystem.println(LVOptions.help);
            }
        }
    }

    public void read() throws Exception {
        if (this.lvOptions.isTail) {
            int i = 0;
            while (i < this.file.length) {
                this.file[i].open();
                this.file[i].moveToEOF();
                ++i;
            }
        }
        while (true) {
            this.readRecords();
            if (this.lvOptions.isBatchMode) {
                return;
            }
            Thread.sleep(400L);
        }
    }

    public LVOptions getLVOptions() {
        return this.lvOptions;
    }

    protected void setLVOptions(LVOptions lvOptions) {
        this.lvOptions = lvOptions;
    }

    public void readRecords() throws Exception {
        int i = 0;
        String fileIndex = null;
        ILoggingResultSet rs = null;
        i = 0;
        while (i < this.file.length) {
            if (this.lvOptions.isMarker) {
                fileIndex = this.file.length > 1 ? "F:" + (i + 1) + "/" + this.file.length + " -" : null;
            }
            this.file[i].open();
            while (!this.file[i].isEOF()) {
                rs = this.file[i].readNext();
                if (rs.getSize() <= 0) continue;
                this.parseMSG(fileIndex, (LogRecord)rs.getResults().get(0), true);
            }
            ++i;
        }
    }

    private void parseMSG(String fileIndex, LogRecord record, boolean isLoggingAPI) {
        if (record == null) {
            return;
        }
        try {
            if (isLoggingAPI) {
                isLoggingAPI = false;
            } else {
                record = this.isStdOut ? console.infoT("[stdout] " + record.getMsgClear()) : (this.isStdError ? console.errorT("[stderr] " + record.getMsgClear()) : console.infoT("[std] " + record.getMsgClear()));
            }
            this.printRecord(fileIndex, record);
        }
        catch (Exception ex) {
            console.traceThrowableT(500, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"printing message"}, (Throwable)ex);
        }
    }

    void printRecord(String fileIndex, LogRecord record) {
        Date date = record.getTime();
        boolean width = false;
        boolean printRec = true;
        if (this.lvOptions.filSeverity > 0 && record.getSeverity() < this.lvOptions.filSeverity) {
            return;
        }
        if (this.lvOptions.filDate != null && date.compareTo(new Date(this.lvOptions.filDate)) != 0) {
            return;
        }
        if (this.lvOptions.filLocation != null && !record.getLocationName().equalsIgnoreCase(this.lvOptions.filLocation)) {
            return;
        }
        if (this.lvOptions.filCategory != null && !LVFormatter.getCategory(record).equalsIgnoreCase(this.lvOptions.filCategory)) {
            return;
        }
        StringBuffer buf = new StringBuffer(this.lvOptions.format);
        int patternLen = this.lvOptions.format.length();
        if (fileIndex != null) {
            LVFormatter.printString(fileIndex, 9, 1);
        }
        out.println(this.lvOptions.formatter.format(record));
        out.flush();
    }
}

