/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.tools.lv.CmdOption;
import com.sap.tc.logging.tools.lv.LVActionConstants;
import com.sap.tc.logging.tools.lv.LVFormatPattern;
import com.sap.tc.logging.tools.lv.LVFormatter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class LVOptions
extends LVActionConstants
implements Cloneable {
    private static String EMPTY_STRING = "";
    public int action = -1;
    public static final String DEFAULT_FORMAT = "%d %t %s %m";
    public static final int DEF_SEVERITY_WIDTH = 8;
    public static final int DEF_GUID_WIDTH = 35;
    public static final int DEF_LOCATION_WIDTH = 35;
    public static final int DEF_CATEGORY_WIDTH = 35;
    public int filSeverity;
    public String filLocation;
    public String filCategory;
    public String filDate;
    public String outFileName = null;
    public String[] readFileName = null;
    public String format = "%d %t %s %m";
    public boolean isTail = false;
    public volatile boolean isBatchMode = true;
    public boolean isMarker = false;
    public PrintWriter outSystem;
    public LVFormatter formatter = new LVFormatter("%d %t %s %m");
    static HashMap optionPrefixes = new HashMap();
    public static final String help;

    public void parseNoNamePrefix(CmdOption option) {
        this.readFileName = new String[option.size()];
        int i = 0;
        while (i < option.size()) {
            this.readFileName[i] = option.getValueAt(i);
            ++i;
        }
        this.action = 2;
    }

    public void parseEventlog(CmdOption option) {
        Location loc = Location.getLocation("com.sap.tc.logging");
        loc.setEffectiveSeverity(0);
        Category.SYS_LOGGING.setEffectiveSeverity(0);
    }

    public void parseVersion(CmdOption option) {
        this.action = 0;
    }

    public void parseHelp(CmdOption option) {
        this.action = 1;
    }

    public Object clone() {
        LVOptions cloneMe = new LVOptions();
        return cloneMe;
    }

    public void parseBatch(CmdOption option) {
        this.isBatchMode = option.getValueAt(0).equalsIgnoreCase("true") && !this.isTail;
    }

    public void parseTail(CmdOption option) {
        this.isTail = true;
        this.isBatchMode = false;
    }

    public void parseMarker(CmdOption option) {
        this.isMarker = true;
    }

    public void parseOut(CmdOption option) {
        if (option.size() == 0) {
            this.outFileName = null;
            this.parseError(option, "Missing the output file name!");
        } else {
            this.outFileName = option.getValueAt(0);
        }
        this.isBatchMode = true;
    }

    public void parseFormat(CmdOption option) {
        if (option.size() == 0) {
            this.format = DEFAULT_FORMAT;
            this.parseError(option, "Missing the Format value! Default format (%d %t %s %m) is used!");
        } else {
            StringBuffer tmpBuffer = new StringBuffer();
            Iterator iter = option.getValues();
            while (iter.hasNext()) {
                tmpBuffer.append((String)iter.next());
            }
            this.format = tmpBuffer.toString();
        }
        this.formatter = new LVFormatter(this.format);
    }

    public void parseLocation(CmdOption option) {
        if (option.size() == 0) {
            this.filLocation = null;
            this.parseError(option, "Missing the filtering Location value!");
        } else {
            this.filLocation = option.getValueAt(0);
        }
    }

    public void parseCategory(CmdOption option) {
        if (option.size() == 0) {
            this.filCategory = null;
            this.parseError(option, "Missing the filtering Category value!");
        } else {
            this.filCategory = option.getValueAt(0);
        }
    }

    public void parseDate(CmdOption option) {
        if (option.size() == 0) {
            this.filDate = null;
            this.parseError(option, "Missing the filtering Date value!");
        } else {
            this.filDate = option.getValueAt(0);
        }
    }

    public void parseSeverity(CmdOption option) {
        if (option.size() == 0) {
            this.filSeverity = 701;
            this.parseError(option, "Missing the filtering Severity value");
        } else {
            try {
                this.filSeverity = Severity.parse(option.getValueAt(0));
            }
            catch (IllegalArgumentException ex) {
                this.filSeverity = 701;
                this.parseError(option, ex.getMessage());
            }
        }
    }

    void parseMessage(String txt, CmdOption option, String msg) {
        System.err.println(txt + ": Option " + option.getName() + ": " + msg);
    }

    void parseWarning(CmdOption option, String msg) {
        this.parseMessage("Warning", option, msg);
    }

    void parseError(CmdOption option, String msg) {
        this.parseMessage("Error", option, msg);
        System.exit(1);
    }

    static {
        optionPrefixes.put("O", "out");
        optionPrefixes.put("B", "batch");
        optionPrefixes.put("T", "tail");
        optionPrefixes.put("F", "format");
        optionPrefixes.put("M", "marker");
        optionPrefixes.put("L", "location");
        optionPrefixes.put("C", "category");
        optionPrefixes.put("D", "date");
        optionPrefixes.put("S", "severity");
        optionPrefixes.put("E", "eventlog");
        optionPrefixes.put("H", "help");
        optionPrefixes.put("V", "version");
        help = "Options:\n\nGeneral:\n  <dir/s or logfile/s>\n  path to the server log directory or file. Multiple values must be separated by comma.\n  If dir, contents of all files under dir are dumped.\n -m[arker]\n   Provide an additional info data about a source from where LogRecord's were read\n   the file marker number represent an index number of the file in the list of files.\n   If only the one file is spec. for reading, this flag will be ignored.\n -o[utfile] <filename>\n   the filename where to write the output.\n   Always writes the complete file and terminates automatic.\n   Setting/value for -b[atch] = on\n  -t[ail]\n   Reading starts with the next new message line (new LogRecord).\n   This option does not work in J2EE cmd console!\n   Setting/value for -b[atch] = off\n  -e[ventlog]\n   Enable Logging API log.\n   Logging API messages will be written to the logging.log file\n  -h[elp]\n   print this help text.\n  -v[ersion]\n   print version info.\n" + LVFormatPattern.help + "Filter:\n" + "  -l[ocation]\n" + "   print the messages with the given location name\n" + "  -c[ategory]\n" + "   print the messages with the given category name\n" + "  -d[ate]\n" + "   print the messages with the given date value\n" + "  -s[everity] <value>  MIN|DEBUG|PATH|INFO|WARNING|ERROR|FATAL\n" + "   display only records with severity >= value\n" + "\n";
    }
}

