/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FileLogHeader;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.reader.FileReadLog;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReaderLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ReadableLog
extends FileLog
implements IReadableLog {
    private static String strLoc = "-ReadableLog";
    IReadLog source = null;

    public ReadableLog(String pattern) {
        this.source = ReadableLog.createFileReadLog(new FileLog(pattern));
    }

    private ReadableLog(FileLog fileLog) {
        this.source = ReadableLog.createFileReadLog(fileLog);
    }

    public static IReadLog createFileReadLog(FileLog fileLog) {
        return new FileReadLog(fileLog);
    }

    public static IReadableLog createReadableLog(FileLog fileLog) {
        FileLogHeader header = null;
        try {
            header = new FileLogHeader(fileLog);
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(400, ReaderLogger.ReaderLocation, strLoc, MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{fileLog.getName()});
            ReaderLogger.catchingIntByAPI(ex);
        }
        if (header == null) {
            header = (FileLogHeader)fileLog.getLogHeader();
        }
        ReadableLog rLogcopy = new ReadableLog(fileLog);
        rLogcopy.setPattern(fileLog.getPattern());
        rLogcopy.setName(fileLog.getName());
        rLogcopy.setDescription(header.getDescription());
        rLogcopy.setFormatter(header.getFormatter());
        rLogcopy.setRotation(header.getFileSetLimit(), header.getFileSetSize());
        rLogcopy.setLogHeader(fileLog.getLogHeader());
        rLogcopy.setEncoding(fileLog.getEncoding());
        rLogcopy.setMode(fileLog.getMode());
        rLogcopy.setFooter(fileLog.getFooter());
        return rLogcopy;
    }

    public IReadableLog createReadableLog() {
        IReadableLog rLogcopy = ReadableLog.createReadableLog(this);
        return rLogcopy;
    }

    public void close() {
        try {
            this.closeInt();
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(400, ReaderLogger.ReaderLocation, strLoc + "[close()]", MSGCollection.LOGGING_MSG_ID_CLOSE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_CLOSE_EXCEPTION, new String[]{this.getName()});
            ReaderLogger.catchingIntByAPI(ex);
            this.handleException(ex, 0);
        }
    }

    public ILoggingResultSet readLatestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet = null;
        try {
            this.source.open();
            this.source.moveToEOF();
            return this.source.readPrevious(numberOfRecords);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
            return resultSet;
        }
    }

    public ILoggingResultSet readOldestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet = null;
        try {
            this.source.open();
            this.source.moveToBOF();
            return this.source.readNext(numberOfRecords);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
            return resultSet;
        }
    }

    public ILoggingResultSet readPrevMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        if (this.source == null) {
            resultSet = (LogRecordResultSet)this.readLatestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readPrevious(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readNextMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        if (this.source == null) {
            resultSet = (LogRecordResultSet)this.readOldestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readNext(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            resultSet = (LogRecordResultSet)((FileReadLog)this.source).searchNext(searchTokens, true);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            resultSet = (LogRecordResultSet)((FileReadLog)this.source).searchNext(searchTokens, !ignoreCase);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return null;
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return null;
    }

    public boolean areLoggingAttributesEditable() {
        Collection existingLogs = LoggingManager.getLoggingManager().getAllLogs();
        return existingLogs.contains(this);
    }

    public long length() {
        return this.getFileLength();
    }

    public String getFileBeingCurrentlyRead() {
        return ((FileLog)this.source.getLogSource()).findEndOfFileSet();
    }

    public long getFilePointer() throws IOException {
        return this.source.getBookMark();
    }

    public void seek(long filePointer) throws IOException {
        try {
            this.source.seek(filePointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getLastModified() throws IOException {
        long result = -1L;
        result = new File(((FileLog)this.source.getLogSource()).findEndOfFileSet()).lastModified();
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected synchronized void openInt() throws IOException {
        try {
            this.source.open();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void closeInt() throws IOException {
        try {
            this.source.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList readLatestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readLatestMsgRecords(numMsg).getResults();
    }

    public ArrayList readOldestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readOldestMsgRecords(numMsg).getResults();
    }

    public ArrayList readPrevRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readPrevMsgRecords(numMsg).getResults();
    }

    public ArrayList readNextRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readNextMsgRecords(numMsg).getResults();
    }
}

