/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.reader.ReaderLogger;

class LocalBuffer
extends ExceptionHandling {
    private static String strLoc = "-LocalBuffer";
    private static final int INIT_VALUE = -1;
    public static final int NEXT = 1;
    public static final int PREVIOUS = -1;
    public static final int NONE = -2;
    private static final int MAX_EXTEND_COUNTER = 50;
    public static final int DEFAULT_BUFFER_SIZE = 8128;
    public static final int DEFAULT_CHUNK_SIZE = 81280;
    private byte[] buffer = new byte[8128];
    private byte[] bufferHelper = new byte[8128];
    private byte[] chunk = new byte[81280];
    private byte[] emptyChunk = new byte[81280];
    private int extendCounter = 0;
    private int buffCurrPos = 0;
    private int buffCurrSize = -1;
    private int chunkSize = 0;
    private int chunkOffset = -1;
    private int chunkSumSize = 0;
    private boolean chunkBOL;
    private boolean chunkEOL;
    private int latestDirection = -2;

    protected LocalBuffer() {
    }

    public void loadBuffer(int buffSize) {
        if (buffSize < 0) {
            return;
        }
        try {
            System.arraycopy(this.bufferHelper, 0, this.buffer, 0, buffSize);
            this.setCurrentSize(buffSize);
        }
        catch (Exception ex) {
            ExceptionManager.UNEXPECTED_EXCEPTION(ReaderLogger.ReaderLocation, strLoc + "[loadBuffer(...)]", new String[]{"loading buffer"}, ex);
        }
    }

    public boolean hasNext() {
        return this.buffCurrPos >= 0 && this.buffCurrPos < this.buffCurrSize;
    }

    public boolean hasPrevious() {
        return this.buffCurrPos >= 0;
    }

    public byte next() {
        byte value = -1;
        try {
            this.latestDirection = 1;
            value = this.buffer[this.buffCurrPos];
            ++this.chunkSize;
            if (value == 10 || value == -1) {
                this.chunkBOL = this.chunkSize > 1 || this.chunkSumSize > 0;
                this.chunkEOL = true;
            }
            if (this.chunkOffset == -1) {
                this.chunkOffset = this.buffCurrPos;
            }
            ++this.buffCurrPos;
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(400, ReaderLogger.ReaderLocation, strLoc + "[next(...)]", MSGCollection.LOGGING_MSG_ID_READ_BUFFER, MSGCollection.LOGGING_MSG_STR_READ_BUFFER, new String[]{"" + (this.buffCurrPos - 1)});
            ReaderLogger.catchingIntByAPI(ex);
            this.chunkBOL = true;
        }
        return value;
    }

    public byte previous() {
        byte value = -1;
        try {
            this.latestDirection = -1;
            value = this.buffer[this.buffCurrPos];
            ++this.chunkSize;
            if (value == 10 || value == -1) {
                if (this.chunkSize > 1) {
                    this.chunkBOL = true;
                    --this.chunkSize;
                } else {
                    --this.buffCurrPos;
                }
                this.chunkEOL = true;
            } else {
                this.chunkOffset = this.buffCurrPos--;
            }
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(400, ReaderLogger.ReaderLocation, strLoc + "[previous(...)]", MSGCollection.LOGGING_MSG_ID_READ_BUFFER, MSGCollection.LOGGING_MSG_STR_READ_BUFFER, new String[]{"" + (this.buffCurrPos - 1)});
            ReaderLogger.catchingIntByAPI(ex);
            this.chunkBOL = true;
        }
        return value;
    }

    public boolean isChunkComplete() {
        return this.chunkBOL && this.chunkEOL;
    }

    public byte[] getChunk() {
        byte[] tmpChunk = this.getChunkInt();
        this.chunkOffset = -1;
        this.chunkSize = 0;
        return tmpChunk;
    }

    private byte[] getChunkInt() {
        if (this.chunkSize == 0) {
            return this.chunk;
        }
        boolean chunkEOLPos = false;
        try {
            ++this.extendCounter;
            if (this.chunk.length < this.chunkSumSize + this.chunkSize) {
                byte[] tmpNewChunk = new byte[this.chunk.length * 2];
                System.arraycopy(this.chunk, 0, tmpNewChunk, 0, this.chunk.length);
                this.chunk = tmpNewChunk;
                this.extendCounter = 0;
            }
            if (this.latestDirection == 1) {
                System.arraycopy(this.buffer, this.chunkOffset, this.chunk, this.chunkSumSize, this.chunkSize);
            } else if (this.latestDirection == -1) {
                if (this.chunkOffset < 0) {
                    this.chunkOffset = 0;
                }
                System.arraycopy(this.chunk, 0, this.chunk, this.chunkSize, this.chunkSumSize);
                System.arraycopy(this.buffer, this.chunkOffset, this.chunk, 0, this.chunkSize);
            }
            this.chunkSumSize += this.chunkSize;
            this.chunkBOL = false;
            this.chunkEOL = false;
        }
        catch (Exception ex) {
            ExceptionManager.UNEXPECTED_EXCEPTION(ReaderLogger.ReaderLocation, strLoc + "[chunk(...)]", new String[]{"creating message chunks"}, ex);
        }
        return this.chunk;
    }

    public byte[] getChunks() {
        byte[] finalChunk = null;
        if (this.chunkSumSize > 0) {
            finalChunk = new byte[this.chunkSumSize];
            System.arraycopy(this.chunk, 0, finalChunk, 0, this.chunkSumSize);
        }
        return finalChunk;
    }

    public byte[] getBuffHelper() {
        return this.bufferHelper;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getChunksSize() {
        return this.chunkSumSize;
    }

    public int getBookMark() {
        return this.buffCurrPos > 0 && this.hasNext() ? this.buffCurrPos : 0;
    }

    public int size() {
        return this.buffCurrSize < 0 ? 0 : this.buffCurrSize;
    }

    public void setLatestDirection(int direction) {
        if (direction < -1) {
            direction = -1;
        }
        if (direction > 1) {
            direction = 1;
        }
        if (direction == 0) {
            direction = 1;
        }
        this.latestDirection = direction;
    }

    public int getLatestDirection() {
        return this.latestDirection;
    }

    public boolean isLatestDirectionEqual(int direction) {
        return this.latestDirection == direction;
    }

    public void reset() {
        if (this.chunkSumSize <= 0) {
            return;
        }
        this.chunkSize = 0;
        this.chunkSumSize = 0;
        this.chunkOffset = -1;
        if (this.extendCounter >= 50 && this.chunk.length > 81280) {
            byte[] byArray = new byte[81280];
        } else {
            System.arraycopy(this.emptyChunk, 0, this.chunk, 0, 81280);
        }
    }

    public void reInit() {
        this.buffCurrPos = -1;
        this.buffCurrSize = -1;
        this.latestDirection = -2;
    }

    private void mergeBuffers(byte[] newBuffer, int buffSize) throws Exception {
        byte[] tmpBuffer = null;
        int newSize = 0;
        newSize = this.chunkSize + buffSize;
        if (newSize < 8128) {
            newSize = 8128;
        }
        tmpBuffer = new byte[newSize];
        if (this.latestDirection == 1) {
            System.arraycopy(this.buffer, this.chunkOffset, tmpBuffer, 0, this.chunkSize);
            System.arraycopy(newBuffer, 0, tmpBuffer, this.chunkSize, buffSize);
            this.buffCurrSize = this.chunkSize + buffSize;
            this.buffCurrPos = this.chunkSize++;
            this.chunkOffset = 0;
        } else if (this.latestDirection == -1) {
            System.arraycopy(this.buffer, 0, tmpBuffer, this.chunkOffset, this.chunkOffset - this.buffCurrPos);
            System.arraycopy(newBuffer, 0, tmpBuffer, 0, buffSize);
            this.buffCurrSize = this.chunkSize + buffSize;
            this.buffCurrPos = buffSize - 1;
            this.chunkOffset = -1;
        }
        this.buffer = tmpBuffer;
    }

    private void setCurrentSize(int value) {
        this.buffCurrSize = value;
        this.chunkOffset = -1;
        this.buffCurrPos = 0;
        this.chunkEOL = false;
        this.chunkBOL = false;
        if (this.latestDirection == -1) {
            this.buffCurrPos = this.buffCurrSize > 0 ? this.buffCurrSize - 1 : -1;
        }
    }
}

