/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileReader {
    private RandomAccessFile source;
    private FileLog fileLog;
    private String currLineVal;

    public FileReader(FileLog fileLog) throws FileNotFoundException {
        this.source = new RandomAccessFile(fileLog.getFileName(), "r");
        this.fileLog = fileLog;
    }

    public void moveToBOF() throws IOException {
        this.source.seek(0L);
    }

    public void moveToEOF() throws IOException {
        this.source.seek(this.source.length());
    }

    public void moveNext() {
        StringBuffer prevLine = new StringBuffer();
        StringBuffer nextLine = new StringBuffer();
        try {
            while (this.source.getFilePointer() < this.source.length()) {
                String lineVal = this.source.readLine();
                boolean isStart = this.fileLog.getFormatter().isStartMessage(lineVal);
                boolean isEnd = lineVal.indexOf("\\#", lineVal.length() - 4) == -1 && lineVal.indexOf("#", lineVal.length() - 2) != -1;
                nextLine.setLength(0);
                nextLine.append(this.source.readLine());
                if (isStart) {
                    if (prevLine.length() > 0) {
                        this.currLineVal = prevLine.toString();
                        return;
                    }
                    prevLine.setLength(0);
                    prevLine.append((Object)nextLine);
                    continue;
                }
                if (isEnd) {
                    prevLine.append("\n");
                    prevLine.append((Object)nextLine);
                    this.currLineVal = prevLine.toString();
                    return;
                }
                if (prevLine.length() > 0) {
                    prevLine.append("\n");
                    prevLine.append((Object)nextLine);
                    continue;
                }
                this.currLineVal = nextLine.toString();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prevLine.length() > 0) {
            this.currLineVal = prevLine.toString();
        }
    }

    public void movePrevious() {
    }

    public int seek(long filePointer) {
        try {
            this.source.seek(filePointer);
            return 0;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public int find(String pattern) {
        return -1;
    }

    public String readLine() {
        return this.currLineVal;
    }
}

