/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.HelperLib;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileCloseException;
import com.sap.tc.logging.exceptions.FileDataException;
import com.sap.tc.logging.exceptions.FileOpenException;
import com.sap.tc.logging.exceptions.LoggingBaseException;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.reader.LocalBuffer;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReadLog;
import com.sap.tc.logging.reader.ReaderLogger;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.Arrays;

public class FileReadLog
extends ReadLog {
    private static String strLoc = "-FileReadLog";
    private static final int DIRECTION_NEXT = 1;
    private static final int DIRECTION_PREVIOUS = -1;
    private static final int MODE_MIN = 0;
    public static final int MODE_SINGLE_FILE = 1;
    public static final int MODE_FILE_SET = 2;
    private static final int MODE_MAX = 3;
    private RandomAccessFile source;
    private String fileName;
    private Formatter fileFormatter;
    private int fileHeaderSize;
    private int fileFooterSize;
    private int fileMode;
    private int delimiterSize;
    private int[] delimiter;
    private int[] delimiterEmpty;
    private boolean isDelSorted = true;
    private int lastChunksSize;
    private LocalBuffer buffData;

    public FileReadLog(FileLog fileLog) {
        if (fileLog == null) {
            throw new NullPointerException();
        }
        this.init(fileLog);
    }

    public boolean isBOF() throws DataException {
        String rollBackValue = null;
        try {
            boolean result = this.isBOFInt();
            if (result && this.isInFileSetMode()) {
                rollBackValue = new String(this.fileName);
                String filePath = ((FileLog)this.getLogSource()).findBeginningOfFileSet();
                if (!filePath.equalsIgnoreCase(this.fileName)) {
                    this.fileName = filePath;
                    this.close();
                    this.open();
                    this.moveToEOF();
                    result = this.isBOFInt();
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new FileDataException(this.fileName, ex);
        }
        catch (LoggingBaseException ex) {
            rollBackValue = this.fileName;
            return true;
        }
    }

    public boolean isEOF() throws DataException {
        String rollBackValue = null;
        try {
            boolean result = this.isEOFInt();
            if (result && this.isInFileSetMode()) {
                rollBackValue = new String(this.fileName);
                String filePath = ((FileLog)this.getLogSource()).findEndOfFileSet();
                if (!filePath.equalsIgnoreCase(this.fileName)) {
                    this.fileName = filePath;
                    this.close();
                    this.open();
                    this.moveToBOF();
                    result = this.isBOFInt();
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new FileDataException(this.fileName, ex);
        }
        catch (LoggingBaseException ex) {
            rollBackValue = this.fileName;
            return true;
        }
    }

    public void moveToBOF() throws DataException {
        try {
            if (this.source != null) {
                this.source.seek(this.fileHeaderSize);
                this.buffData.reInit();
            }
            this.buffData.setLatestDirection(1);
        }
        catch (IOException ex) {
            throw new FileDataException(this.fileName, ex);
        }
    }

    public void moveToEOF() throws DataException {
        try {
            if (this.source != null) {
                this.source.seek(this.source.length() - (long)this.fileFooterSize);
                this.buffData.reInit();
            }
            this.buffData.setLatestDirection(-1);
        }
        catch (IOException ex) {
            throw new FileDataException(this.fileName, ex);
        }
    }

    public ILoggingResultSet readNext() throws DataException {
        return this.readNext(1);
    }

    public ILoggingResultSet readNext(int numberOfRecords) throws DataException {
        LogRecordResultSet resultSet;
        block5: {
            if (numberOfRecords < 0) {
                numberOfRecords = 0;
            }
            resultSet = new LogRecordResultSet();
            try {
                this.open();
                if (this.isEOF()) break block5;
                int i = 0;
                while (i < numberOfRecords) {
                    LogRecord lr = this.fileFormatter.parseMsg(this.readNextInt());
                    if (lr != null) {
                        resultSet.add(lr);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                throw new FileDataException(this.fileName, ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readPrevious() throws DataException {
        return this.readPrevious(1);
    }

    public ILoggingResultSet readPrevious(int numberOfRecords) throws DataException {
        LogRecordResultSet resultSet;
        block4: {
            resultSet = new LogRecordResultSet();
            try {
                this.open();
                if (this.isBOF()) break block4;
                int i = 0;
                while (i < numberOfRecords) {
                    LogRecord lr = this.fileFormatter.parseMsg(this.readPreviousInt());
                    if (lr != null) {
                        resultSet.add(lr);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                resultSet.setException(new FileDataException(this.fileName, ex));
            }
        }
        return resultSet;
    }

    public synchronized int getMode() {
        return this.fileMode;
    }

    public synchronized void setMode(int mode) {
        this.fileMode = mode > 0 && mode < 3 ? mode : 1;
    }

    public boolean isInFileSetMode() {
        return this.fileMode == 2;
    }

    public synchronized long getBookMark() {
        try {
            return this.getBookMarkInt();
        }
        catch (Exception ex) {
            ExceptionManager.UNEXPECTED_EXCEPTION(ReaderLogger.ReaderLocation, strLoc + "[getBookMark()]", new String[]{this.fileName}, ex);
            return -1L;
        }
    }

    public void seek(long filePointer) throws DataException {
        try {
            this.source.seek(filePointer);
        }
        catch (IOException ex) {
            throw new FileDataException(this.fileName, ex);
        }
    }

    public long find(String condition) throws DataException {
        int operaterID = 0;
        String operater = null;
        int i = 0;
        while (i < condition.length()) {
            operater = condition.substring(i, i + 1);
            operaterID = HelperLib.parseOperator(operater);
            if (operaterID > 0 && i + 1 < condition.length()) {
                String multiOperater = condition.substring(i, i + 2);
                int multiOperaterID = HelperLib.parseOperator(multiOperater);
                if (multiOperaterID <= 0) break;
                operaterID = multiOperaterID;
                operater = multiOperater;
                break;
            }
            ++i;
        }
        if (operaterID < 0) {
            return -1L;
        }
        int endFieldNamePos = condition.indexOf(operater);
        if (!(this.fileFormatter instanceof ListFormatter)) {
            return -1L;
        }
        int fieldIndex = 0;
        String fieldName = condition.substring(0, endFieldNamePos).trim();
        if (!ListFormatter.getFields().containsKey(fieldName)) {
            return -1L;
        }
        fieldIndex = (Integer)ListFormatter.getFields().get(fieldName);
        String compareStr = condition.substring(endFieldNamePos + operater.length());
        while (!this.isEOF()) {
            String filedStr;
            byte[] msgChunk = this.readNextInt();
            if (msgChunk == null || msgChunk.length == 0) continue;
            int startFieldPos = this.delimiter[fieldIndex] + 1;
            int endFieldPos = 0;
            if (fieldIndex + 1 < this.delimiterSize) {
                endFieldPos = this.delimiter[fieldIndex + 1];
            }
            if (endFieldPos == 0) {
                endFieldPos = msgChunk.length;
            }
            if (!ListFormatter.compareField(fieldIndex, operaterID, filedStr = new String(msgChunk, startFieldPos, endFieldPos -= startFieldPos), compareStr)) continue;
            return this.getBookMark();
        }
        return -1L;
    }

    public ILoggingResultSet search(String condition) throws DataException {
        return null;
    }

    protected void openInt() throws FileOpenException {
        if (this.source == null) {
            try {
                this.source = new RandomAccessFile(this.fileName, "r");
                this.buffData = new LocalBuffer();
                this.delimiter = new int[150];
                this.delimiterEmpty = new int[150];
                this.setCurrFilePointer(0L);
            }
            catch (Exception ex) {
                throw new FileOpenException(this.fileName, ex);
            }
        }
    }

    protected void closeInt() throws FileCloseException {
        if (this.source != null) {
            try {
                this.source.close();
            }
            catch (IOException ex) {
                throw new FileCloseException(this.fileName, ex);
            }
            this.source = null;
        }
    }

    public ILoggingResultSet searchNext(String[] searchTokens, boolean isCaseSensitive) throws DataException {
        LogRecordResultSet resultSet = new LogRecordResultSet();
        if (searchTokens == null || searchTokens.length == 0) {
            return resultSet;
        }
        this.moveToBOF();
        String token = null;
        try {
            this.open();
            while (!this.isEOF()) {
                byte[] resultChunk = this.readNextInt();
                String resultStr = new String(resultChunk, 0, this.buffData.getChunksSize());
                if (!isCaseSensitive) {
                    resultStr = resultStr.toUpperCase();
                }
                int i = 0;
                while (i < searchTokens.length) {
                    token = searchTokens[i];
                    if (!isCaseSensitive) {
                        token = token.toUpperCase();
                    }
                    if (resultStr.indexOf(token) > 0) {
                        LogRecord lr = this.fileFormatter.parseMsg(resultChunk);
                        if (lr != null) {
                            resultSet.add(lr);
                        } else {
                            throw new FileDataException(this.fileName, new ParseException("Parsing error...", 0));
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new FileDataException(this.fileName, ex);
        }
        return resultSet;
    }

    private void init(FileLog fileLog) {
        this.setLogSource(fileLog);
        this.fileName = fileLog.getPath();
        this.fileFormatter = fileLog.getLogHeader().getFormatter();
        this.fileHeaderSize = fileLog.getHeader().length();
        this.fileFooterSize = fileLog.getFooter().length();
    }

    private byte[] readNextInt() {
        Object finalChunk = null;
        this.delimiterSize = 0;
        System.arraycopy(this.delimiterEmpty, 0, this.delimiter, 0, this.delimiterEmpty.length);
        try {
            this.buffData.reset();
            if (this.buffData.isLatestDirectionEqual(-1)) {
                if (!this.isBOF()) {
                    this.seek(this.getBookMarkInt() + (long)this.lastChunksSize + 1L);
                }
                this.buffData.reInit();
            }
            byte[] chunk = this.readNextChunk();
            if (this.buffData.getChunksSize() > 0) {
                this.findStartMsgByteChunks(chunk);
                this.findEndMsgByteChunks(chunk);
            }
            this.lastChunksSize = this.buffData.getChunksSize();
        }
        catch (Exception ex) {
            ExceptionManager.UNEXPECTED_EXCEPTION(ReaderLogger.ReaderLocation, strLoc + "[readNextInt()]", new String[]{this.fileName}, ex);
        }
        return this.buffData.getChunks();
    }

    private byte[] readPreviousInt() {
        Object finalChunk = null;
        this.delimiterSize = 0;
        System.arraycopy(this.delimiterEmpty, 0, this.delimiter, 0, this.delimiterEmpty.length);
        try {
            this.buffData.reset();
            if (this.buffData.isLatestDirectionEqual(1)) {
                if (!this.isEOF()) {
                    this.seek(this.getBookMarkInt() - (long)this.lastChunksSize - 2L);
                }
                this.buffData.reInit();
            }
            byte[] chunk = this.readPreviousChunk();
            if (this.buffData.getChunksSize() > 0) {
                this.findStartMsgByteChunks(chunk);
                this.findEndMsgByteChunks(chunk);
            }
            this.lastChunksSize = this.buffData.getChunksSize();
        }
        catch (Exception ex) {
            ExceptionManager.UNEXPECTED_EXCEPTION(ReaderLogger.ReaderLocation, strLoc + "[readPreviousInt()]", new String[]{this.fileName}, ex);
        }
        return this.buffData.getChunks();
    }

    private void findStartMsgByteChunks(byte[] chunk) throws Exception {
        int rightDirection = this.buffData.getLatestDirection();
        while (!this.fileFormatter.isStartMsg(this.buffData.getChunksSize(), chunk)) {
            chunk = this.buffData.isLatestDirectionEqual(1) && this.buffData.getChunksSize() < 6 ? this.readNextChunk() : this.readPreviousChunk();
            if (chunk == null) break;
        }
        this.buffData.setLatestDirection(rightDirection);
        this.sortingDelimiters();
    }

    private void findEndMsgByteChunks(byte[] chunk) throws Exception {
        int rightDirection = this.buffData.getLatestDirection();
        while (!this.fileFormatter.isCompleteMessage(this.buffData.getChunksSize(), chunk, this.delimiterSize, this.delimiter)) {
            chunk = this.readNextChunk();
            if (chunk == null) break;
        }
        this.buffData.setLatestDirection(rightDirection);
    }

    private byte[] readNextChunk() throws Exception {
        boolean isMasked = false;
        do {
            if (!this.buffData.hasNext()) {
                if (this.buffData.getChunkSize() > 0) {
                    return this.buffData.getChunk();
                }
                this.fillBufferForward();
            }
            while (this.buffData.hasNext()) {
                byte value = this.buffData.next();
                if (this.buffData.isChunkComplete()) {
                    return this.buffData.getChunk();
                }
                switch (value) {
                    case 92: {
                        isMasked = true;
                        break;
                    }
                    case 35: {
                        if (!isMasked) {
                            this.delimiter[this.delimiterSize++] = this.buffData.getChunkSize() + this.buffData.getChunksSize();
                        }
                        isMasked = false;
                        break;
                    }
                    default: {
                        isMasked = false;
                    }
                }
            }
        } while (!this.isEOFInt());
        return this.buffData.getChunk();
    }

    private byte[] readPreviousChunk() throws Exception {
        boolean isMasked = false;
        do {
            if (!this.buffData.hasPrevious()) {
                if (this.buffData.getChunkSize() > 0) {
                    return this.buffData.getChunk();
                }
                this.fillBufferBackward();
            }
            while (this.buffData.hasPrevious()) {
                byte value = this.buffData.previous();
                if (this.buffData.isChunkComplete()) {
                    return this.buffData.getChunk();
                }
                switch (value) {
                    case 92: {
                        isMasked = true;
                        break;
                    }
                    case 35: {
                        if (!isMasked) {
                            this.delimiter[this.delimiterSize++] = (this.buffData.getChunkSize() - 1 + this.buffData.getChunksSize()) * -1;
                        }
                        isMasked = false;
                        this.isDelSorted = false;
                        break;
                    }
                    default: {
                        isMasked = false;
                    }
                }
            }
        } while (!this.isBOFInt());
        return this.buffData.getChunk();
    }

    private void fillBufferForward() throws IOException {
        this.buffData.setLatestDirection(1);
        this.buffData.loadBuffer(this.source.read(this.buffData.getBuffHelper(), 0, 8128));
    }

    private void fillBufferBackward() throws IOException {
        int tmpBufferSize = 8128;
        long currFilePointer = this.getBookMarkInt();
        if (currFilePointer - (long)tmpBufferSize <= 0L) {
            tmpBufferSize = (int)currFilePointer - this.fileHeaderSize;
            currFilePointer = 0L;
            this.setCurrFilePointer(currFilePointer);
        } else {
            this.setCurrFilePointer(currFilePointer -= 8128L);
        }
        this.buffData.setLatestDirection(-1);
        this.buffData.loadBuffer(this.source.read(this.buffData.getBuffHelper(), 0, tmpBufferSize));
        this.setCurrFilePointer(currFilePointer);
    }

    private void setCurrFilePointer(long value) throws IOException {
        if (value <= 0L) {
            value = this.fileHeaderSize;
        } else if (value >= this.source.length() - (long)this.fileFooterSize) {
            value = this.source.length() - (long)this.fileFooterSize;
        }
        this.source.seek(value);
    }

    private long getCurrFilePointer() throws IOException {
        if (this.getBookMarkInt() <= (long)this.fileHeaderSize) {
            this.source.seek(this.fileHeaderSize);
            return 0L;
        }
        if (this.getBookMarkInt() > this.source.length() - (long)this.fileFooterSize) {
            this.source.seek(this.source.length() - (long)this.fileFooterSize);
        }
        return this.getBookMarkInt();
    }

    private long getBookMarkInt() throws IOException {
        if (this.buffData.isLatestDirectionEqual(1)) {
            return this.source.getFilePointer() - (long)this.buffData.getBookMark();
        }
        return this.source.getFilePointer() + (long)this.buffData.getBookMark();
    }

    private boolean isBOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.getBookMarkInt() - (long)this.fileHeaderSize <= 0L;
    }

    private boolean isEOFInt() throws IOException {
        if (this.source == null) {
            return true;
        }
        return this.source.length() - (long)this.fileFooterSize == this.getBookMarkInt();
    }

    private void sortingDelimiters() {
        if (this.isDelSorted) {
            return;
        }
        int i = 0;
        while (i < this.delimiterSize) {
            if (this.delimiter[i] < 0) {
                this.delimiter[i] = this.buffData.getChunksSize() - this.delimiter[i] * -1;
            }
            ++i;
        }
        Arrays.sort(this.delimiter);
        System.arraycopy(this.delimiter, this.delimiter.length - this.delimiterSize, this.delimiter, 0, this.delimiterSize);
    }
}

