/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.MSGCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class StreamLog
extends Log {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$StreamLog == null ? (class$com$sap$tc$logging$StreamLog = StreamLog.class$("com.sap.tc.logging.StreamLog")) : class$com$sap$tc$logging$StreamLog);
    private OutputStream stream;
    private OutputStreamWriter out;
    private String enc;
    static /* synthetic */ Class class$com$sap$tc$logging$StreamLog;

    protected StreamLog() {
        this((String)null, (Formatter)new ListFormatter());
    }

    protected StreamLog(Formatter formatter) {
        this((String)null, formatter);
    }

    protected StreamLog(String enc, Formatter formatter) {
        super(formatter);
        this.stream = null;
        this.out = null;
        this.enc = null;
    }

    public StreamLog(OutputStream stream) {
        this(stream, (Formatter)new ListFormatter());
    }

    public StreamLog(OutputStream stream, Formatter formatter) {
        super(formatter);
        this.stream = stream;
        this.enc = null;
        try {
            this.openInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StreamLog(OutputStream stream, String enc) throws UnsupportedEncodingException {
        this(stream, enc, new ListFormatter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamLog(OutputStream stream, String enc, Formatter formatter) throws UnsupportedEncodingException {
        super(formatter);
        this.stream = stream;
        this.enc = enc;
        try {
            try {
                this.openInt();
            }
            catch (IOException ex) {
                Object var6_5 = null;
                if (this.out != null) return;
                if (enc != null) return;
                throw new UnsupportedEncodingException();
            }
            Object var6_4 = null;
            if (this.out != null) return;
            if (enc != null) return;
            throw new UnsupportedEncodingException();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.out != null || enc != null) throw throwable;
            throw new UnsupportedEncodingException();
        }
    }

    public synchronized String getEncoding() {
        return this.enc;
    }

    public synchronized void setEncoding(String enc) {
        this.enc = enc;
        try {
            this.openInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected synchronized boolean isClosedInt() {
        return this.out == null && this.stream == null;
    }

    protected synchronized OutputStream getOutputStream() {
        return this.stream;
    }

    protected synchronized void writeInt(String s) throws Exception {
        if (this.out != null) {
            this.out.write(s);
        }
    }

    protected synchronized void flushInt() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected synchronized void openInt() throws IOException {
        if (this.stream != null) {
            if (this.enc != null) {
                try {
                    this.out = new OutputStreamWriter(this.stream, this.enc);
                }
                catch (UnsupportedEncodingException ex) {
                    APILogger.logIntByAPI(400, classLoc, "openInt()]", MSGCollection.LOGGING_MSG_ID_UNSUPPORTED_ENCODING, MSGCollection.LOGGING_MSG_STR_UNSUPPORTED_ENCODING, new String[]{this.enc});
                    this.handleException(ex, 5);
                    this.out = new OutputStreamWriter(this.stream);
                    this.enc = this.out.getEncoding();
                }
            } else {
                this.out = new OutputStreamWriter(this.stream);
                this.enc = this.out.getEncoding();
            }
        } else {
            this.out = null;
        }
    }

    protected synchronized void closeInt() throws IOException {
        this.flushInt();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    synchronized void setOutputStream(OutputStream stream) {
        this.stream = stream;
        try {
            this.openInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

