/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.CreateLogfileEvent;
import com.sap.tc.logging.CreateLogfileListener;
import com.sap.tc.logging.EventDispatcher;
import com.sap.tc.logging.EventListener;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.NewLogListener;
import com.sap.tc.logging.OverwriteLogfileEvent;
import com.sap.tc.logging.OverwriteLogfileListener;
import com.sap.tc.logging.ReleaseLogEvent;
import com.sap.tc.logging.ReleaseLogListener;
import com.sap.tc.logging.RemoveLogEvent;
import com.sap.tc.logging.RemoveLogListener;
import com.sap.tc.logging.ResetLogControllerListener;
import com.sap.tc.logging.interfaces.IRPPublisher;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class LoggingManager
extends ExceptionHandling
implements EventDispatcher {
    private static final String INVALID_LISTENER_TYPE = "Invalid listener type";
    private ThreadLocalInfo thrLocals = new ThreadLocalInfo();
    private static LoggingManager manager = null;
    private static IRPPublisher runPropPub = null;
    private static Location classLoc = null;
    private List newLogListeners = new Vector();
    private List removeLogListeners = new Vector();
    private List overwriteLogfileListeners = new Vector();
    private List createLogfileListeners = new Vector();
    private List resetLogControllerListener = new Vector();
    private List releaseLogListener = new Vector();
    private HashMap locs = new HashMap();
    private HashMap categories = new HashMap();
    static /* synthetic */ Class class$com$sap$tc$logging$LoggingManager;
    static /* synthetic */ Class class$com$sap$tc$logging$Category;
    static /* synthetic */ Class class$com$sap$tc$logging$Configurator;
    static /* synthetic */ Class class$com$sap$tc$logging$ConsoleLog;
    static /* synthetic */ Class class$com$sap$tc$logging$FileLog;
    static /* synthetic */ Class class$com$sap$tc$logging$Formatter;
    static /* synthetic */ Class class$com$sap$tc$logging$GUId;
    static /* synthetic */ Class class$com$sap$tc$logging$ListFormatter;
    static /* synthetic */ Class class$com$sap$tc$logging$Location;
    static /* synthetic */ Class class$com$sap$tc$logging$Log;
    static /* synthetic */ Class class$com$sap$tc$logging$LogController;
    static /* synthetic */ Class class$com$sap$tc$logging$LogRecord;
    static /* synthetic */ Class class$com$sap$tc$logging$MsgType;
    static /* synthetic */ Class class$com$sap$tc$logging$PropertiesConfigurator;
    static /* synthetic */ Class class$com$sap$tc$logging$Severity;
    static /* synthetic */ Class class$com$sap$tc$logging$StreamLog;
    static /* synthetic */ Class class$com$sap$tc$logging$TraceFormatter;
    static /* synthetic */ Class class$com$sap$tc$logging$XMLFormatter;

    private LoggingManager() {
    }

    public static synchronized LoggingManager getLoggingManager() {
        if (manager == null) {
            manager = new LoggingManager();
            LoggingManager.init();
            Category.SYS_LOGGING = Category.getCategoryInt("/System/Logging");
        }
        return manager;
    }

    public static void registerRuntimePropertiesPublisher(IRPPublisher runPropPublisher) {
        runPropPub = runPropPublisher;
    }

    public void addListener(EventListener listener) throws IllegalArgumentException {
        List list;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            list = this.newLogListeners;
            synchronized (list) {
                this.newLogListeners.add(listener);
            }
            isFounded = true;
            Collection existingLogs = this.getAllLogs();
            if (existingLogs != null) {
                Iterator logIter = existingLogs.iterator();
                while (logIter.hasNext()) {
                    try {
                        Log _log = (Log)logIter.next();
                        if (_log instanceof ConsoleLog) continue;
                        ((NewLogListener)listener).handleEvent(new NewLogEvent(_log));
                    }
                    catch (Exception ex) {
                        Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[addListener(EventListener listener)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                        Category.SYS_LOGGING.catchingIntByAPI(ex);
                        this.handleException(ex, 0);
                    }
                }
            }
        }
        if (listener instanceof RemoveLogListener) {
            list = this.removeLogListeners;
            synchronized (list) {
                this.removeLogListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            list = this.overwriteLogfileListeners;
            synchronized (list) {
                this.overwriteLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            list = this.createLogfileListeners;
            synchronized (list) {
                this.createLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            list = this.resetLogControllerListener;
            synchronized (list) {
                this.resetLogControllerListener.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            list = this.releaseLogListener;
            synchronized (list) {
                this.releaseLogListener.add(listener);
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    public void removeListener(EventListener listener) throws IllegalArgumentException {
        List list;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            list = this.newLogListeners;
            synchronized (list) {
                this.newLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof RemoveLogListener) {
            list = this.removeLogListeners;
            synchronized (list) {
                this.removeLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            list = this.overwriteLogfileListeners;
            synchronized (list) {
                this.overwriteLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            list = this.createLogfileListeners;
            synchronized (list) {
                this.createLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            list = this.resetLogControllerListener;
            synchronized (list) {
                this.resetLogControllerListener.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            list = this.releaseLogListener;
            synchronized (list) {
                this.releaseLogListener.remove(listener);
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    public Collection getAllLogs() {
        HashMap hashMap;
        Object[] lcs;
        HashSet existingLogs = new HashSet();
        if (this.locs != null) {
            lcs = null;
            hashMap = this.locs;
            synchronized (hashMap) {
                lcs = this.locs.values().toArray();
            }
            int i = 0;
            while (i < lcs.length) {
                existingLogs.addAll(((LogController)lcs[i]).getAllLogs());
                ++i;
            }
        }
        if (this.locs != null) {
            lcs = null;
            hashMap = this.categories;
            synchronized (hashMap) {
                lcs = this.categories.values().toArray();
            }
            int i = 0;
            while (i < lcs.length) {
                existingLogs.addAll(((LogController)lcs[i]).getAllLogs());
                ++i;
            }
        }
        return existingLogs;
    }

    public synchronized void reset() {
        HashMap hashMap = this.locs;
        synchronized (hashMap) {
            this.locs.clear();
        }
        Object[] tmpLC = this.categories.values().toArray();
        int i = 0;
        while (i < tmpLC.length) {
            this.release((LogController)tmpLC[i]);
            ++i;
        }
        LoggingManager.init();
    }

    protected void notifyAddLog(Log newLog) {
        if (this.newLogListeners.isEmpty()) {
            return;
        }
        if (newLog instanceof ConsoleLog) {
            return;
        }
        Object[] lsnArray = null;
        NewLogEvent evt = new NewLogEvent(newLog);
        List list = this.newLogListeners;
        synchronized (list) {
            lsnArray = this.newLogListeners.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((NewLogListener)lsnArray[i]).handleEvent(evt);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyAddLog(Log newLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    protected void notifyRemoveLog(Log removeLog) {
        if (this.removeLogListeners.isEmpty()) {
            return;
        }
        if (removeLog instanceof ConsoleLog) {
            return;
        }
        if (this.isBeingAttached(removeLog)) {
            return;
        }
        Object[] lsnArray = null;
        RemoveLogEvent evt = new RemoveLogEvent(removeLog);
        List list = this.removeLogListeners;
        synchronized (list) {
            lsnArray = this.removeLogListeners.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((RemoveLogListener)lsnArray[i]).handleEvent(evt);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyRemoveLog(Log removeLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the RemoveLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    protected void notifyOverwriteLogfile(FileLog fileLog) {
        if (this.overwriteLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        OverwriteLogfileEvent evt = new OverwriteLogfileEvent(fileLog);
        List list = this.overwriteLogfileListeners;
        synchronized (list) {
            lsnArray = this.overwriteLogfileListeners.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((OverwriteLogfileListener)lsnArray[i]).handleEvent(evt);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyOverwriteLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the OverwriteLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    protected void notifyReleaseLogfile(FileLog fileLog) {
        if (this.releaseLogListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        ReleaseLogEvent evt = new ReleaseLogEvent(fileLog);
        List list = this.releaseLogListener;
        synchronized (list) {
            lsnArray = this.releaseLogListener.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((ReleaseLogListener)lsnArray[i]).handleEvent(evt);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyReleaseLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ReleaseLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    protected void notifyCreateLogfile(String filename, int limit, int cnt) {
        if (this.createLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        CreateLogfileEvent evt = new CreateLogfileEvent(filename, limit, cnt);
        List list = this.createLogfileListeners;
        synchronized (list) {
            lsnArray = this.createLogfileListeners.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((CreateLogfileListener)lsnArray[i]).handleEvent(evt);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyCreateLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the CreateLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    protected void notifyLogControllerReset(LogController logController, boolean isResetTree) {
        if (this.resetLogControllerListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        List list = this.resetLogControllerListener;
        synchronized (list) {
            lsnArray = this.resetLogControllerListener.toArray();
        }
        int i = 0;
        while (i < lsnArray.length) {
            try {
                ((ResetLogControllerListener)lsnArray[i]).handleEvent(logController, isResetTree);
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyLogControllerReset(LogController logController, boolean isResetTree)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ResetLogControllerListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
            ++i;
        }
    }

    static IRPPublisher getRuntimePropertiesPublisher() {
        return runPropPub;
    }

    Location getLocation(String name) {
        LinkedList parts = this.calculateNames('.', name);
        return this.getLocation(name, parts);
    }

    Category getCategory(String name) {
        LinkedList parts = this.calculateNames('/', name);
        return this.getCategory(name, parts);
    }

    void release(LogController controller) {
        if (controller instanceof Location) {
            HashMap hashMap = this.locs;
            synchronized (hashMap) {
                this.locs.remove(controller.getName());
            }
        }
        if (!this.isPredefCategory(controller.getName())) {
            HashMap hashMap = this.categories;
            synchronized (hashMap) {
                this.categories.remove(controller.getName());
            }
        }
    }

    LogRecord getRecord() {
        return this.thrLocals.getRecord();
    }

    void setRecord(LogRecord rec) {
        this.thrLocals.setRecord(rec);
    }

    private boolean isPredefCategory(String name) {
        return Category.PREDEF_CATEGORIES.containsKey(name);
    }

    private static void init() {
        classLoc = Location.getLocation(class$com$sap$tc$logging$LoggingManager == null ? (class$com$sap$tc$logging$LoggingManager = LoggingManager.class$("com.sap.tc.logging.LoggingManager")) : class$com$sap$tc$logging$LoggingManager);
        Location.getLocation(class$com$sap$tc$logging$Category == null ? (class$com$sap$tc$logging$Category = LoggingManager.class$("com.sap.tc.logging.Category")) : class$com$sap$tc$logging$Category);
        Location.getLocation(class$com$sap$tc$logging$Configurator == null ? (class$com$sap$tc$logging$Configurator = LoggingManager.class$("com.sap.tc.logging.Configurator")) : class$com$sap$tc$logging$Configurator);
        Location.getLocation(class$com$sap$tc$logging$ConsoleLog == null ? (class$com$sap$tc$logging$ConsoleLog = LoggingManager.class$("com.sap.tc.logging.ConsoleLog")) : class$com$sap$tc$logging$ConsoleLog);
        Location.getLocation(class$com$sap$tc$logging$FileLog == null ? (class$com$sap$tc$logging$FileLog = LoggingManager.class$("com.sap.tc.logging.FileLog")) : class$com$sap$tc$logging$FileLog);
        Location.getLocation(class$com$sap$tc$logging$Formatter == null ? (class$com$sap$tc$logging$Formatter = LoggingManager.class$("com.sap.tc.logging.Formatter")) : class$com$sap$tc$logging$Formatter);
        Location.getLocation(class$com$sap$tc$logging$GUId == null ? (class$com$sap$tc$logging$GUId = LoggingManager.class$("com.sap.tc.logging.GUId")) : class$com$sap$tc$logging$GUId);
        Location.getLocation(class$com$sap$tc$logging$ListFormatter == null ? (class$com$sap$tc$logging$ListFormatter = LoggingManager.class$("com.sap.tc.logging.ListFormatter")) : class$com$sap$tc$logging$ListFormatter);
        Location.getLocation(class$com$sap$tc$logging$Location == null ? (class$com$sap$tc$logging$Location = LoggingManager.class$("com.sap.tc.logging.Location")) : class$com$sap$tc$logging$Location);
        Location.getLocation(class$com$sap$tc$logging$Log == null ? (class$com$sap$tc$logging$Log = LoggingManager.class$("com.sap.tc.logging.Log")) : class$com$sap$tc$logging$Log);
        Location.getLocation(class$com$sap$tc$logging$LogController == null ? (class$com$sap$tc$logging$LogController = LoggingManager.class$("com.sap.tc.logging.LogController")) : class$com$sap$tc$logging$LogController);
        Location.getLocation(class$com$sap$tc$logging$LogRecord == null ? (class$com$sap$tc$logging$LogRecord = LoggingManager.class$("com.sap.tc.logging.LogRecord")) : class$com$sap$tc$logging$LogRecord);
        Location.getLocation(class$com$sap$tc$logging$MsgType == null ? (class$com$sap$tc$logging$MsgType = LoggingManager.class$("com.sap.tc.logging.MsgType")) : class$com$sap$tc$logging$MsgType);
        Location.getLocation(class$com$sap$tc$logging$PropertiesConfigurator == null ? (class$com$sap$tc$logging$PropertiesConfigurator = LoggingManager.class$("com.sap.tc.logging.PropertiesConfigurator")) : class$com$sap$tc$logging$PropertiesConfigurator);
        Location.getLocation(class$com$sap$tc$logging$Severity == null ? (class$com$sap$tc$logging$Severity = LoggingManager.class$("com.sap.tc.logging.Severity")) : class$com$sap$tc$logging$Severity);
        Location.getLocation(class$com$sap$tc$logging$StreamLog == null ? (class$com$sap$tc$logging$StreamLog = LoggingManager.class$("com.sap.tc.logging.StreamLog")) : class$com$sap$tc$logging$StreamLog);
        Location.getLocation(class$com$sap$tc$logging$TraceFormatter == null ? (class$com$sap$tc$logging$TraceFormatter = LoggingManager.class$("com.sap.tc.logging.TraceFormatter")) : class$com$sap$tc$logging$TraceFormatter);
        Location.getLocation(class$com$sap$tc$logging$XMLFormatter == null ? (class$com$sap$tc$logging$XMLFormatter = LoggingManager.class$("com.sap.tc.logging.XMLFormatter")) : class$com$sap$tc$logging$XMLFormatter);
    }

    Location getLocation(String locName, LinkedList components) {
        try {
            String name = ((String)components.getLast()).trim();
            Location loc = (Location)this.locs.get(name);
            if (loc == null) {
                if (components.size() == 1) {
                    loc = new Location(name);
                } else {
                    components.removeLast();
                    loc = new Location(name, this.getLocation(name, components));
                }
                HashMap hashMap = this.locs;
                synchronized (hashMap) {
                    this.locs.put(name, loc);
                }
            }
            return loc;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Location : " + locName);
        }
    }

    private Category getCategory(String catName, LinkedList components) {
        try {
            String name = (String)components.getLast();
            Category category = (Category)this.categories.get(name);
            if (category == null) {
                if (components.size() == 1) {
                    category = new Category(name);
                } else {
                    components.removeLast();
                    category = new Category(name, this.getCategory(name, components));
                }
                HashMap hashMap = this.categories;
                synchronized (hashMap) {
                    this.categories.put(name, category);
                }
            }
            return category;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Category : " + catName);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private LinkedList calculateNames(char delimiter, String name) {
        StringBuffer myFinal = new StringBuffer(0);
        LinkedList<String> components = new LinkedList<String>();
        int pos = -1;
        int length = 0;
        boolean isAdded = false;
        if (delimiter == '.') {
            myFinal.append("");
            components.add(myFinal.toString());
        }
        length = name.length();
        int i = 0;
        while (i < length) {
            block20: {
                char curr;
                block21: {
                    block19: {
                        curr = name.charAt(i);
                        if (curr != delimiter) break block19;
                        switch (curr) {
                            case '/': {
                                if (pos != 0) {
                                    if (pos != 1) break;
                                    pos = 0;
                                }
                                break block20;
                            }
                            case '.': {
                                if (pos >= 1) {
                                    if (pos != 1) break;
                                    pos = 0;
                                }
                                break block20;
                            }
                        }
                        if (myFinal.length() > 0) {
                            components.add(myFinal.toString());
                            isAdded = true;
                        } else {
                            components.add(String.valueOf(curr));
                        }
                        pos = 0;
                        break block21;
                    }
                    if (curr == '\'' || curr == '/' || curr == '.') break block20;
                }
                if (this.isCharacterAllowed(curr, pos, i == length - 1) || pos > 1 && !Character.isJavaIdentifierStart(curr) || Character.isJavaIdentifierStart(curr)) {
                    myFinal.append(curr);
                    ++pos;
                    isAdded = false;
                } else if (pos > 0 && i != length - 1) {
                    myFinal.append("x");
                    isAdded = false;
                }
            }
            ++i;
        }
        if (!isAdded && myFinal.length() > 0) {
            if (this.isCharacterAllowed(myFinal.charAt(myFinal.length() - 1), 0, false)) {
                myFinal.deleteCharAt(myFinal.length() - 1);
            }
            components.add(myFinal.toString());
        }
        return components;
    }

    private boolean isCharacterAllowed(char value, int pos, boolean isLast) {
        switch (value) {
            case '.': {
                return pos == 0 && !isLast;
            }
            case '/': {
                return !isLast;
            }
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected boolean isBeingAttached(Log aLog) {
        return this.getAllLogs().contains(aLog);
    }

    static Category getLog() {
        return Category.SYS_LOGGING;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ThreadLocalInfo
    extends ThreadLocal {
        ThreadLocalInfo() {
        }

        protected Object initialValue() {
            return new Locals();
        }

        public LogRecord getRecord() {
            return ((Locals)super.get()).getRecord();
        }

        public void setRecord(LogRecord rec) {
            ((Locals)super.get()).setRecord(rec);
        }
    }

    private static class Locals {
        private LogRecord rec = null;

        private Locals() {
        }

        public LogRecord getRecord() {
            return this.rec;
        }

        public void setRecord(LogRecord rec) {
            this.rec = rec;
        }
    }
}

