/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.GroupFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.IObjectInfo;
import com.sap.tc.logging.interfaces.ISATChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public abstract class LogController
extends ExceptionHandling
implements IObjectInfo {
    private static Location classLoc = Location.getLocation("com.sap.tc.logging.LogController");
    static final String MSG_GRP_NAME = null;
    static final String MSG_GRP_DESC = null;
    static final String MSG_SUB_LOC = null;
    static final Object[] MSG_ARGS = null;
    static final LogController[] MSG_RELATIVES = null;
    private static final int MAX_NUMBER_OF_OPEN_GROUP = 5;
    static final String NO_RELATIVE_EMSG = "No relative";
    static final String NO_RELATIVES_EMSG = "No relatives";
    static final String NO_LOG_EMSG = "No log";
    static final String NO_FILTER_EMSG = "No filter";
    static final String MSG_ASSERT = "Assertion failed: {0}";
    static final String MSG_THROWING = "Throwing {0}";
    static final String MSG_CATCHING = "Caught {0}";
    static final String NULL_STRING = "<null>";
    static final String POINTER = " \n[EXCEPTION]\n ";
    ThreadLocalInfo thrLocals;
    private String lcName;
    private String lcDescription;
    private String logVerInUse;
    private LogController parent;
    private LinkedList children = new LinkedList();
    private volatile String resourceBundleName = null;
    private volatile boolean resourceBundleSet = false;
    private volatile ClassLoader classLoader = null;
    private volatile boolean classLoaderSet = false;
    private volatile Collection logs = new HashSet();
    private volatile Collection filters;
    private volatile boolean parentLocalLogs = false;
    private volatile int minSeverity = 0;
    private volatile int maxSeverity = 701;
    private volatile int prevMinSeverity = 0;
    private volatile int prevMaxSeverity = 701;
    volatile int effSeverity = 701;
    private Relations relations = new Relations();
    private Regarders regarders = new Regarders();
    private volatile int minEffRelationSeverity = 701;
    private int loggedSumCnt = 0;
    private int loggedCnt = 0;
    private boolean groupInUse = false;
    private static ISATChecker isActivityTracking;
    private int groupSize = 5;
    private static final Relation standardRelation;

    LogController(String name) {
        this.lcName = name;
        this.parent = null;
    }

    LogController(String name, LogController parent) {
        this.lcName = name;
        this.parent = parent;
        parent.addChild(this);
        this.initializeSeverities();
        this.initializeLogs();
    }

    public void release() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Regarders regarders;
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).release();
            }
            Regarders regarders2 = regarders = this.getRegarders();
            synchronized (regarders2) {
                while (!regarders.isEmpty()) {
                    LogController lc = regarders.getFirst();
                    lc.setEffectiveSeverity(this);
                    regarders.remove(lc);
                }
            }
            this.closeGroupAllInt();
            this.removeLogs();
        }
        LoggingManager.getLoggingManager().release(this);
    }

    public void reset() {
        this.resetInt();
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, false);
    }

    synchronized void resetInt() {
        this.setEffectiveSeverity();
        this.removeFilters();
        this.removeLogs();
        this.resetLogged();
        this.resetLoggedCount();
    }

    public void resetAll() {
        this.resetAllInt();
        LoggingManager.getLoggingManager().notifyLogControllerReset(this, true);
    }

    void resetAllInt() {
        this.resetInt();
        Collection children = this.getChildren();
        if (!children.isEmpty()) {
            this.resetChildren(children.toArray(new LogController[0]));
        }
    }

    private void resetChildren(LogController[] logControlers) {
        int i = 0;
        while (i < logControlers.length) {
            logControlers[i].resetAllInt();
            ++i;
        }
    }

    public synchronized String getName() {
        return this.lcName;
    }

    public synchronized void setName(String name) {
        this.lcName = name;
    }

    public synchronized String getDescription() {
        return this.lcDescription;
    }

    public synchronized void setDescription(String value) {
        this.lcDescription = value;
    }

    public synchronized String getVerInUse() {
        return this.logVerInUse;
    }

    public Collection getChildren() {
        Collection children;
        Collection collection = children = this.getChildrenInt();
        synchronized (collection) {
            Collection collection2 = Collections.unmodifiableCollection(new ArrayList(children));
            return collection2;
        }
    }

    LogController getParentInt() {
        return this.parent;
    }

    Collection getChildrenInt() {
        return this.children;
    }

    void addChild(LogController child) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LinkedList linkedList = this.children;
            synchronized (linkedList) {
                this.children.add(child);
            }
        }
    }

    Relations getRelations() {
        return this.relations;
    }

    Regarders getRegarders() {
        return this.regarders;
    }

    public void closeGroup() {
        this.closeGroupInt();
    }

    void closeGroupInt() {
        this.closeGroupInt(this.getCurrentGroup());
    }

    void closeGroupInt(Group group) {
        if (group != null) {
            this.groupT("Closing group");
            GroupFactory.closeGroup(this, group);
        }
    }

    private void closeGroupAllInt() {
        while (this.thrLocals != null) {
            this.closeGroupInt();
        }
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int size) {
        this.groupSize = size;
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc) {
        if (this.beLogged(severity)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, MSG_RELATIVES, grpName, grpDescription, severity, subloc);
        }
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController logC) {
        if (this.beLogged(severity, logC)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, new LogController[]{logC}, grpName, grpDescription, severity, subloc);
        }
        logC.openGroupInt(grpName, grpDescription, severity, subloc);
    }

    void openGroupInt(String grpName, String grpDescription, int severity, String subloc, LogController[] logCs) {
        if (this.beLogged(severity, logCs)) {
            this.setGroupInUse(true);
            GroupFactory.openGroup(this.getGroupSize(), this, logCs, grpName, grpDescription, severity, subloc);
            int i = 0;
            while (i < logCs.length) {
                logCs[i].openGroupInt(grpName, grpDescription, severity, subloc);
                ++i;
            }
        }
    }

    public LogRecord groupT(String msg) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), group.getSubLocationName(), msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord groupT(String subloc, String msg) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord groupT(String msg, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), group.getSubLocationName(), msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord groupT(String subloc, String msg, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityTInt(800, this, group.getRelatives(), subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord group(Object msgCode, Object[] args, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), group.getSubLocationName(), msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord group(String subloc, Object msgCode, Object[] args, String msgClear) {
        if (this.thrLocals == null) {
            return null;
        }
        LogRecord writtenRec = null;
        Group group = this.getCurrentGroup();
        if (this.beGroupInt(group)) {
            writtenRec = this.logSeverityInt(800, this, group.getRelatives(), subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    LogRecord logTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        LogRecord writtenRec = null;
        try {
            String locName = loc.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msg, this.checkArguments(args));
            Group group = null;
            if (this.thrLocals != null) {
                group = this.getCurrentGroup();
                this.fillLogRecordWithGroupData(rec, group);
            }
            writtenRec = this.messageInt(rec);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return writtenRec;
    }

    LogRecord logSeverityTInt(int severity, LogController loc, LogController[] relatives, String subloc, String msg, int msgType, Object[] args) {
        LogRecord writtenRec = null;
        writtenRec = this.logTInt(severity, loc, relatives, subloc, msg, msgType, args);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (relatives[i].beLogged(severity, newRelatives)) {
                    relatives[i].logTInt(severity, loc, newRelatives, subloc, msg, msgType, args);
                }
                ++i;
            }
        }
        return writtenRec;
    }

    LogRecord logInt(int severity, LogController logC, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args) {
        LogRecord writtenRec = null;
        try {
            String resBundleName = logC.getResourceBundleName();
            if (resBundleName == null) {
                resBundleName = this.getResourceBundleName();
            }
            String locName = logC.getName();
            if (subloc != null) {
                locName = locName + '.' + subloc;
            }
            LogRecord rec = new LogRecord(this, locName, severity, this.convertRelatives(relatives), msgType, msgCode, resBundleName, msgClear, this.checkArguments(args));
            Group group = null;
            if (this.thrLocals != null) {
                group = this.getCurrentGroup();
                this.fillLogRecordWithGroupData(rec, group);
            }
            writtenRec = this.messageInt(rec);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return writtenRec;
    }

    LogRecord logSeverityInt(int severity, LogController loc, LogController[] relatives, String subloc, Object msgCode, String msgClear, int msgType, Object[] args) {
        LogRecord writtenRec = this.logInt(severity, loc, relatives, subloc, msgCode, msgClear, msgType, args);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                LogController[] newRelatives = this.copyRelatives(relatives[i], relatives);
                if (relatives[i].beLogged(severity, newRelatives)) {
                    relatives[i].logInt(severity, loc, newRelatives, subloc, msgCode, msgClear, msgType, args);
                }
                ++i;
            }
        }
        return writtenRec;
    }

    protected String[] convertRelatives(LogController[] relatives) {
        String[] tmpValues = null;
        if (relatives != null) {
            tmpValues = new String[relatives.length];
            int i = 0;
            while (i < relatives.length) {
                tmpValues[i] = relatives[i].getName();
                ++i;
            }
        }
        return tmpValues;
    }

    private Object[] checkArguments(Object[] args) {
        Object[] argValues = args;
        if (argValues != null) {
            int i = 0;
            while (i < argValues.length) {
                if (argValues[i] == null) {
                    argValues[i] = NULL_STRING;
                }
                ++i;
            }
        }
        return argValues;
    }

    private LogController[] copyRelatives(LogController logLC, LogController[] relatives) {
        LogController[] tmpRelatives = new LogController[relatives.length];
        int i = 0;
        while (i < relatives.length) {
            tmpRelatives[i] = relatives[i] != logLC ? relatives[i] : this;
            ++i;
        }
        return tmpRelatives;
    }

    private void fillLogRecordWithGroupData(LogRecord rec, Group group) {
        if (group != null) {
            rec.setGroupID(group.getId().toString());
            rec.setGroupName(group.getName());
            rec.setGroupDescription(group.getDescription());
            rec.setGroupLevel(group.getLevel());
            rec.setGroupIndent(group.getIndent());
        }
    }

    protected LogRecord logIntByAPI(int severity, Location loc, String subloc, Object msgCode, String msgClear, Object[] args) {
        return this.logInt(severity, loc, null, subloc, msgCode, msgClear, 1, args);
    }

    protected LogRecord catchingIntByAPI(Throwable exc) {
        return this.logTInt(200, this, MSG_RELATIVES, MSG_SUB_LOC, MSG_CATCHING, 1, new Object[]{ExceptionManager.getStackTrace(exc)});
    }

    protected LogRecord messageInt(LogRecord rec) {
        LogRecord writtenRec = null;
        if (this.isFiltersAgreeing(rec)) {
            if (!this.logs.isEmpty()) {
                writtenRec = this.writeToLogs(this.logs, rec);
                this.setLogged();
            }
            if (writtenRec != null) {
                this.setRecord(writtenRec);
                this.setSumLogged();
            }
        }
        return writtenRec;
    }

    private LogRecord writeToLogs(Collection logs, LogRecord rec) {
        LogRecord writtenRec = null;
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            if (log.getLogTypeAccessibility() == 2) {
                if (log.getLocalLogOwner().equals(this) || !log.getLocalLogOwner().beLogged(rec)) continue;
                writtenRec = log.writeIntByAPI(rec);
                continue;
            }
            if (!log.beLogged(rec)) continue;
            writtenRec = log.writeIntByAPI(rec);
        }
        return writtenRec;
    }

    public LogRecord getRecord() {
        return LoggingManager.getLoggingManager().getRecord();
    }

    void setRecord(LogRecord rec) {
        LoggingManager.getLoggingManager().setRecord(rec);
    }

    public int getMinimumSeverity() {
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController relative) {
        if (this.check(relative)) {
            int minRelationSeverity = this.relations.get((LogController)relative).minSeverity;
            return this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
        }
        return this.minSeverity;
    }

    public int getMinimumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                int minRelationSeverity = this.relations.get((LogController)relatives[i]).minSeverity;
                this.minSeverity = this.minSeverity < minRelationSeverity ? this.minSeverity : minRelationSeverity;
                ++i;
            }
            return this.minSeverity;
        }
        return this.minSeverity;
    }

    public int getEffectiveSeverity() {
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController relative) {
        if (this.check(relative)) {
            int effRelationSeverity = this.relations.get((LogController)relative).effSeverity;
            return this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
        }
        return this.effSeverity;
    }

    public int getEffectiveSeverity(LogController[] relatives) {
        if (relatives != null) {
            this.check(relatives);
            int i = 0;
            while (i < relatives.length) {
                int effRelationSeverity = this.relations.get((LogController)relatives[i]).effSeverity;
                this.effSeverity = this.effSeverity < effRelationSeverity ? this.effSeverity : effRelationSeverity;
                ++i;
            }
        }
        return this.effSeverity;
    }

    public int getMaximumSeverity() {
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController relative) {
        if (this.check(relative)) {
            int maxRelationSeverity = this.relations.get((LogController)relative).maxSeverity;
            return this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
        }
        return this.maxSeverity;
    }

    public int getMaximumSeverity(LogController[] relatives) {
        this.check(relatives);
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                int maxRelationSeverity = this.relations.get((LogController)relatives[i]).maxSeverity;
                this.maxSeverity = this.maxSeverity < maxRelationSeverity ? this.maxSeverity : maxRelationSeverity;
                ++i;
            }
            return this.maxSeverity;
        }
        return this.maxSeverity;
    }

    private boolean isUnchanged() {
        if (this.minSeverity == this.prevMinSeverity && this.maxSeverity == this.prevMaxSeverity) {
            return true;
        }
        this.prevMinSeverity = this.minSeverity;
        this.prevMaxSeverity = this.maxSeverity;
        return false;
    }

    public void setMinimumSeverity(int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = severity = Severity.correct(severity);
                if (this.maxSeverity < this.minSeverity) {
                    this.maxSeverity = this.minSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
        }
    }

    void setMinimumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    public void setMinimumSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = 0;
                this.calculateEffectiveSeverity();
            }
        }
    }

    void setMinimumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMinimumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    public void setEffectiveSeverity(int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            severity = Severity.correct(severity);
            LogController parent = this.getParentInt();
            if (parent == null) {
                this.effSeverity = severity;
            }
            this.minSeverity = severity;
            this.maxSeverity = severity;
            this.calculateEffectiveSeverity();
        }
    }

    void setEffectiveSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            severity = Severity.correct(severity);
            if (relative == null) {
                this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
            }
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            Relation relation = relations.get(relative);
            relation = (Relation)relation.clone();
            relation.setLocalMinimumSeverity(severity);
            relation.setLocalMaximumSeverity(severity);
            relations.put(relative, relation);
            this.calculateEffectiveSeverity(relative);
        }
    }

    public void setEffectiveSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.minSeverity = 0;
                this.maxSeverity = 701;
                this.calculateEffectiveSeverity();
            }
        }
    }

    void setEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setEffectiveSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    public void setMaximumSeverity(int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.maxSeverity = severity = Severity.correct(severity);
                if (this.maxSeverity < this.minSeverity) {
                    this.minSeverity = this.maxSeverity;
                }
                this.calculateEffectiveSeverity();
            } else {
                this.setEffectiveSeverity(severity);
            }
        }
    }

    void setMaximumSeverity(LogController relative, int severity) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                severity = Severity.correct(severity);
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity(severity);
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            } else {
                this.setEffectiveSeverity(relative, severity);
            }
        }
    }

    public void setMaximumSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            LogController parent = this.getParentInt();
            if (parent != null) {
                this.maxSeverity = 701;
                this.calculateEffectiveSeverity();
            }
        }
    }

    void setMaximumSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Relations relations = this.getRelations();
            LogController parent = this.getParentInt();
            if (parent != null) {
                if (relative == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                }
                Relation relation = (Relation)relations.get(relative).clone();
                relation.setLocalMaximumSeverity();
                relations.put(relative, relation);
                this.calculateEffectiveSeverity(relative);
            }
        }
    }

    private void initializeSeverities() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.calculateEffectiveSeverityInt();
            LogController parent = this.getParentInt();
            if (parent != null) {
                Iterator iter = parent.getRelations().entrySet().iterator();
                while (iter.hasNext()) {
                    Relation relation;
                    Map.Entry entry = (Map.Entry)iter.next();
                    Relation parentRelation = (Relation)entry.getValue();
                    if (parentRelation.getMinimumSeverity() == 0 && parentRelation.getMaximumSeverity() == 701) {
                        relation = parentRelation;
                    } else {
                        relation = new Relation();
                        relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
                    }
                    this.getRelations().put((LogController)entry.getKey(), relation);
                }
                this.minEffRelationSeverity = parent.minEffRelationSeverity;
                iter = parent.getRegarders().iterator();
                while (iter.hasNext()) {
                    LogController regarder = (LogController)iter.next();
                    Relations regarderRelations = regarder.getRelations();
                    Relation regarderRelation = new Relation();
                    Relation regarderParentRelation = regarderRelations.get(parent);
                    regarderRelation.calculateMinimumSeverity(regarderParentRelation.getMinimumSeverity());
                    regarderRelation.calculateMaximumSeverity(regarderParentRelation.getMaximumSeverity());
                    LogController parentRegarder = regarder.getParentInt();
                    if (parentRegarder != null) {
                        Relation parentRegarderRelation = parentRegarder.getRelations().get(this);
                        int parentRegarderMinSeverity = parentRegarderRelation.getMinimumSeverity();
                        int parentRegarderMaxSeverity = parentRegarderRelation.getMaximumSeverity();
                        if (parentRegarderMinSeverity == 0 && regarderRelation.getMinimumSeverity() == parentRegarderMinSeverity && parentRegarderMaxSeverity == 701 && regarderRelation.getMaximumSeverity() == parentRegarderMaxSeverity) {
                            regarderRelation = parentRegarderRelation;
                        } else {
                            regarderRelation.calculateEffectiveSeverity(parentRegarderRelation.getEffectiveSeverity());
                        }
                    } else {
                        regarderRelation.calculateEffectiveSeverity(regarderParentRelation.getEffectiveSeverity());
                    }
                    regarderRelations.put(this, regarderRelation);
                }
            }
        }
    }

    private void calculateEffectiveSeverity() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.isUnchanged()) {
                return;
            }
            this.calculateEffectiveSeverityInt();
        }
    }

    private void calculateEffectiveSeverityInt() {
        LogController parent = this.getParentInt();
        if (parent != null) {
            int parentSeverity = parent.getEffectiveSeverity();
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }
        Iterator iter = this.getChildrenInt().iterator();
        while (iter.hasNext()) {
            ((LogController)iter.next()).calculateEffectiveSeverityInt();
        }
    }

    private void calculateEffectiveSeverity(LogController relative) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.getRelations().get(relative).isUnchanged()) {
                return;
            }
            this.calculateEffectiveSeverityInt(relative);
        }
    }

    private void calculateEffectiveSeverityInt(LogController relative) {
        Relations relations = this.getRelations();
        Relation relation = (Relation)relations.get(relative).clone();
        int prevEffSeverity = relation.getEffectiveSeverity();
        LogController parentRelative = relative.getParentInt();
        Relation parentRelativeRelation = relations.get(parentRelative);
        if (parentRelative != null) {
            relation.calculateMinimumSeverity(parentRelativeRelation.getMinimumSeverity());
            relation.calculateMaximumSeverity(parentRelativeRelation.getMaximumSeverity());
        } else {
            relation.calculateMinimumSeverity(relation.getLocalMinimumSeverity());
            relation.calculateMaximumSeverity(relation.getLocalMaximumSeverity());
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            Relation parentRelation = parent.getRelations().get(relative);
            int parentMinSeverity = parentRelation.getMinimumSeverity();
            int parentMaxSeverity = parentRelation.getMaximumSeverity();
            if (parentMinSeverity == 0 && relation.getMinimumSeverity() == parentMinSeverity && parentMaxSeverity == 701 && relation.getMaximumSeverity() == parentMaxSeverity) {
                relation = parentRelation;
            } else {
                relation.calculateEffectiveSeverity(parentRelation.getEffectiveSeverity());
            }
        } else {
            relation.calculateEffectiveSeverity(parentRelativeRelation.getEffectiveSeverity());
        }
        relations.put(relative, relation);
        int effSeverity = relation.getEffectiveSeverity();
        if (effSeverity < this.minEffRelationSeverity) {
            this.minEffRelationSeverity = effSeverity;
        } else if (effSeverity != this.minEffRelationSeverity && this.minEffRelationSeverity >= prevEffSeverity) {
            Iterator iter = this.getRelations().values().iterator();
            this.minEffRelationSeverity = 701;
            while (iter.hasNext()) {
                effSeverity = ((Relation)iter.next()).getEffectiveSeverity();
                if (effSeverity >= this.minEffRelationSeverity) continue;
                this.minEffRelationSeverity = effSeverity;
            }
        }
        Iterator iter = this.getChildrenInt().iterator();
        while (iter.hasNext()) {
            ((LogController)iter.next()).calculateEffectiveSeverityInt(relative);
        }
        iter = relative.getChildrenInt().iterator();
        while (iter.hasNext()) {
            this.calculateEffectiveSeverityInt((LogController)iter.next());
        }
    }

    public Collection getLogs() {
        return this.getLogsInt(1);
    }

    private Collection getLogsInt(int logType) {
        Collection allLogs = this.getAllLogs();
        if (!allLogs.isEmpty()) {
            HashSet<Log> tmpLogs = new HashSet<Log>();
            Iterator iter = allLogs.iterator();
            while (iter.hasNext()) {
                Log tmpLog = (Log)iter.next();
                if (tmpLog.getLogTypeAccessibility() != logType) continue;
                tmpLogs.add(tmpLog);
            }
            return tmpLogs;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getLocalLogs() {
        return this.getLogsInt(2);
    }

    public Collection getPrivateLogs() {
        return this.getLogsInt(3);
    }

    public Collection getAllLogs() {
        if (this.logs != null) {
            HashSet allLogs = new HashSet();
            Collection collection = this.logs;
            synchronized (collection) {
                allLogs.addAll(this.logs);
            }
            return allLogs;
        }
        return Collections.EMPTY_SET;
    }

    private synchronized boolean addLogPrivateInt(int logType, Log log) {
        if (!this.logs.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logs);
            log.setLogTypeAccessibility(logType);
            newLogs.add(log);
            this.logs = newLogs;
            return true;
        }
        return false;
    }

    private synchronized boolean addLogInt(LogController parent, int logType, Log log) {
        if (!this.logs.contains(log)) {
            HashSet<Log> newLogs = new HashSet<Log>(this.logs);
            if (logType == 2) {
                log.setLocalLogOwner(parent);
            }
            log.setLogTypeAccessibility(logType);
            newLogs.add(log);
            this.logs = newLogs;
            Iterator iter = this.getChildrenInt().iterator();
            while (iter.hasNext()) {
                ((LogController)iter.next()).addLogInt(parent, logType, log);
            }
            return true;
        }
        return false;
    }

    public void addLog(Log log) {
        if (log != null) {
            if (this.addLogInt(this, 1, log)) {
                log.addOwner(this.getName());
                LoggingManager.getLoggingManager().notifyAddLog(log);
            }
        } else {
            this.handleException(new NullPointerException(NO_LOG_EMSG));
        }
    }

    public void addLocalLog(Log log) {
        if (log != null) {
            if (this.addLogInt(this, 2, log)) {
                log.addOwner(this.getName());
                LoggingManager.getLoggingManager().notifyAddLog(log);
            }
        } else {
            this.handleException(new NullPointerException(NO_LOG_EMSG));
        }
    }

    public void addPrivateLog(Log log) {
        if (log != null) {
            if (this.addLogPrivateInt(3, log)) {
                log.addOwner(this.getName());
                LoggingManager.getLoggingManager().notifyAddLog(log);
            }
        } else {
            this.handleException(new NullPointerException(NO_LOG_EMSG));
        }
    }

    public void removeLog(Log log) {
        if (log != null) {
            this.removeLogInt(log);
            LoggingManager.getLoggingManager().notifyRemoveLog(log);
        }
    }

    private synchronized void removeLogInt(Log log) {
        if (this.logs.contains(log)) {
            HashSet newLogs = new HashSet(this.logs);
            newLogs.remove(log);
            this.logs = newLogs;
            log.removeOwner(this.getName());
            if (log.getLogTypeAccessibility() != 3) {
                Iterator iter = this.getChildrenInt().iterator();
                while (iter.hasNext()) {
                    ((LogController)iter.next()).removeLogInt(log);
                }
            }
        }
    }

    public void removeLogs() {
        Log[] logs = this.logs.toArray(new Log[this.logs.size()]);
        int i = 0;
        while (i < logs.length) {
            this.removeLogInt(logs[i]);
            ++i;
        }
    }

    private void initializeLogs() {
        LogController parent = this.getParentInt();
        if (parent != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                Iterator iter = parent.getAllLogs().iterator();
                while (iter.hasNext()) {
                    Log log = (Log)iter.next();
                    int type = log.getLogTypeAccessibility();
                    if (type == 3) continue;
                    this.addLogInt(parent, type, log);
                }
            }
        }
    }

    public boolean isFiltersAgreeing(LogRecord rec) {
        Collection filters;
        if (rec.getSeverity() != 800 && !(filters = this.getFiltersInt()).isEmpty()) {
            Iterator iter = filters.iterator();
            try {
                while (iter.hasNext()) {
                    if (((Filter)iter.next()).beLogged(rec)) continue;
                    return false;
                }
            }
            catch (Exception ex) {
                classLoc.logIntByAPI(400, classLoc, "[isFiltersAgreeing(LogRecord rec)]", MSGCollection.LOGGING_MSG_ID_FILTER_EXCEPTION, MSGCollection.LOGGING_MSG_STR_FILTER_EXCEPTION, new String[]{"LogController", this.getName()});
                classLoc.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
        return true;
    }

    public Collection getFilters() {
        return Collections.unmodifiableCollection(this.getFiltersInt());
    }

    Collection getFiltersInt() {
        if (this.filters != null) {
            return this.filters;
        }
        return Collections.EMPTY_LIST;
    }

    public void addFilter(Filter filter) {
        if (filter != null) {
            if (this.filters == null) {
                this.filters = new HashSet();
            }
            Collection collection = this.filters;
            synchronized (collection) {
                if (this.filters.contains(filter)) {
                    this.removeFilter(filter);
                }
                this.filters.add(filter);
            }
        } else {
            this.handleException(new NullPointerException(NO_FILTER_EMSG));
        }
    }

    public void removeFilter(Filter filter) {
        if (this.filters == null) {
            return;
        }
        Collection collection = this.filters;
        synchronized (collection) {
            this.filters.remove(filter);
        }
    }

    public void removeFilters() {
        if (this.filters == null) {
            return;
        }
        Collection collection = this.filters;
        synchronized (collection) {
            this.filters.clear();
        }
    }

    public LogController[] getRelatives() {
        if (this.relations == null) {
            return null;
        }
        LogController[] logControlers = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.relations.relations.isEmpty()) {
                logControlers = this.relations.relations.keySet().toArray(new LogController[0]);
            }
        }
        return logControlers;
    }

    public synchronized String getResourceBundleName() {
        if (this.resourceBundleSet) {
            return this.resourceBundleName;
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getResourceBundleName();
        }
        return null;
    }

    public synchronized void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
        this.resourceBundleSet = true;
    }

    public synchronized void setResourceBundleName() {
        this.resourceBundleName = null;
        this.resourceBundleSet = false;
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.classLoaderSet) {
            return this.classLoader;
        }
        LogController parent = this.getParentInt();
        if (parent != null) {
            return parent.getClassLoader();
        }
        return null;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classLoaderSet = true;
    }

    public synchronized void setClassLoader() {
        this.classLoader = null;
        this.classLoaderSet = false;
    }

    public boolean beLogged(int severity) {
        return this.isActivityTracking() || severity >= this.effSeverity;
    }

    public boolean beLogged(int severity, LogController relative) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relative);
    }

    public boolean beLogged(int severity, LogController[] relatives) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relatives);
    }

    private boolean beLoggedInt(int severity, LogController[] relatives) {
        if (this.isActivityTracking() || severity >= this.effSeverity) {
            return true;
        }
        if (severity < this.minEffRelationSeverity) {
            return false;
        }
        return severity >= this.getEffectiveSeverity(relatives);
    }

    boolean beLogged(LogRecord rec) {
        int severity = rec.getSeverity();
        return this.beLogged(severity) && this.isFiltersAgreeing(rec);
    }

    public boolean beDebug() {
        return this.isActivityTracking() || 100 >= this.effSeverity;
    }

    public boolean beDebug(LogController relative) {
        if (this.isActivityTracking() || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relative);
    }

    public boolean beDebug(LogController[] relatives) {
        if (this.isActivityTracking() || 100 >= this.effSeverity) {
            return true;
        }
        if (100 < this.minEffRelationSeverity) {
            return false;
        }
        return 100 >= this.getEffectiveSeverity(relatives);
    }

    public boolean bePath() {
        return this.isActivityTracking() || 200 >= this.effSeverity;
    }

    public boolean bePath(LogController relative) {
        if (this.isActivityTracking() || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relative);
    }

    public boolean bePath(LogController[] relatives) {
        if (this.isActivityTracking() || 200 >= this.effSeverity) {
            return true;
        }
        if (200 < this.minEffRelationSeverity) {
            return false;
        }
        return 200 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beInfo() {
        return this.isActivityTracking() || 300 >= this.effSeverity;
    }

    public boolean beInfo(LogController relative) {
        if (this.isActivityTracking() || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relative);
    }

    public boolean beInfo(LogController[] relatives) {
        if (this.isActivityTracking() || 300 >= this.effSeverity) {
            return true;
        }
        if (300 < this.minEffRelationSeverity) {
            return false;
        }
        return 300 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beWarning() {
        return this.isActivityTracking() || 400 >= this.effSeverity;
    }

    public boolean beWarning(LogController relative) {
        if (this.isActivityTracking() || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relative);
    }

    public boolean beWarning(LogController[] relatives) {
        if (this.isActivityTracking() || 400 >= this.effSeverity) {
            return true;
        }
        if (400 < this.minEffRelationSeverity) {
            return false;
        }
        return 400 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beError() {
        return this.isActivityTracking() || 500 >= this.effSeverity;
    }

    public boolean beError(LogController relative) {
        if (this.isActivityTracking() || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relative);
    }

    public boolean beError(LogController[] relatives) {
        if (this.isActivityTracking() || 500 >= this.effSeverity) {
            return true;
        }
        if (500 < this.minEffRelationSeverity) {
            return false;
        }
        return 500 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beFatal() {
        return this.isActivityTracking() || 600 >= this.effSeverity;
    }

    public boolean beFatal(LogController relative) {
        if (this.isActivityTracking() || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relative);
    }

    public boolean beFatal(LogController[] relatives) {
        if (this.isActivityTracking() || 600 >= this.effSeverity) {
            return true;
        }
        if (600 < this.minEffRelationSeverity) {
            return false;
        }
        return 600 >= this.getEffectiveSeverity(relatives);
    }

    public boolean beGroup() {
        return this.isActivityTracking() || this.beGroupInt(this.getCurrentGroup());
    }

    boolean beGroupInt(Group group) {
        if (group != null) {
            return this.beLogged(group.getSeverity());
        }
        return false;
    }

    private boolean check(LogController relative) {
        if (relative != null) {
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
        return false;
    }

    private boolean check(LogController[] relatives) {
        if (relatives != null) {
            int i = 0;
            while (i < relatives.length) {
                if (relatives[i] == null) {
                    this.handleException(new IllegalArgumentException(NO_RELATIVE_EMSG));
                    return false;
                }
                ++i;
            }
            return true;
        }
        this.handleException(new IllegalArgumentException(NO_RELATIVES_EMSG));
        return false;
    }

    String getNewMsg(String msg, int argsLength) {
        return msg + POINTER + "{" + argsLength + "}";
    }

    Object[] getNewArgs(Object[] args, Throwable exc) {
        Object[] tmpArgs = args;
        if (args != null) {
            tmpArgs = new Object[args.length + 1];
            int i = 0;
            while (i < args.length) {
                tmpArgs[i] = args[i];
                ++i;
            }
            tmpArgs[tmpArgs.length - 1] = ExceptionManager.getStackTrace(exc);
        }
        return tmpArgs;
    }

    public boolean isActivityTracking() {
        return isActivityTracking != null && isActivityTracking.isActivity(this.getName());
    }

    public static synchronized void setActivityTracking(ISATChecker value) {
        isActivityTracking = value;
    }

    public int getLoggedCount() {
        return this.loggedSumCnt;
    }

    public void resetLoggedCount() {
        this.loggedSumCnt = 0;
    }

    void setSumLogged() {
        ++this.loggedSumCnt;
    }

    boolean wasLogged() {
        return this.loggedCnt > 0;
    }

    public int getLoggedCnt() {
        return this.loggedCnt;
    }

    void resetLogged() {
        this.loggedCnt = 0;
    }

    void setLogged() {
        ++this.loggedCnt;
    }

    boolean isGroupInUse() {
        return this.groupInUse;
    }

    void setGroupInUse(boolean value) {
        if (value) {
            this.initThreadLocals();
        } else if (!value) {
            this.thrLocals = null;
        }
        this.groupInUse = value;
    }

    Group getCurrentGroup() {
        if (this.thrLocals != null) {
            return this.thrLocals.getGroup();
        }
        return null;
    }

    void initThreadLocals() {
        if (this.thrLocals == null) {
            this.thrLocals = new ThreadLocalInfo();
        }
    }

    static {
        standardRelation = new Relation();
    }

    class ThreadLocalInfo
    extends ThreadLocal {
        ThreadLocalInfo() {
        }

        protected Object initialValue() {
            return new Locals();
        }

        public Group getGroup() {
            return ((Locals)super.get()).getGroup();
        }

        public void setGroup(Group group) {
            ((Locals)super.get()).group = group;
        }
    }

    private static class Locals {
        public Group group;

        private Locals() {
        }

        public Group getGroup() {
            return this.group;
        }
    }

    private static class Regarders {
        private LinkedList ordered = new LinkedList();
        private HashSet contained = new HashSet();

        private Regarders() {
        }

        public void put(LogController regarder) {
            if (!this.contained.contains(regarder)) {
                LogController parent = regarder.getParentInt();
                while (parent != null && !this.contained.contains(parent)) {
                    parent = parent.getParentInt();
                }
                if (parent != null) {
                    ListIterator<LogController> iter = this.ordered.listIterator();
                    while (iter.hasNext()) {
                        if (iter.next() != parent) continue;
                        iter.add(regarder);
                        break;
                    }
                } else {
                    this.ordered.addFirst(regarder);
                }
                this.contained.add(regarder);
            }
        }

        public void remove(LogController regarder) {
            if (this.contained.contains(regarder)) {
                this.ordered.remove(regarder);
                this.contained.remove(regarder);
            }
        }

        public boolean isEmpty() {
            return this.ordered.isEmpty();
        }

        public LogController getFirst() {
            return (LogController)this.ordered.getFirst();
        }

        public Iterator iterator() {
            return this.ordered.iterator();
        }
    }

    private class Relations {
        private HashMap relations = new HashMap();

        public Relation get(LogController relative) {
            Relation relation;
            HashMap hashMap = this.relations;
            synchronized (hashMap) {
                relation = (Relation)this.relations.get(relative);
            }
            if (relation == null) {
                relation = standardRelation;
            }
            return relation;
        }

        public void put(LogController relative, Relation relation) {
            if (!relation.equals(standardRelation)) {
                HashMap hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.put(relative, relation);
                }
                relative.getRegarders().put(LogController.this);
            } else {
                HashMap hashMap = this.relations;
                synchronized (hashMap) {
                    this.relations.remove(relative);
                }
                relative.getRegarders().remove(LogController.this);
            }
        }

        public Set entrySet() {
            return this.relations.entrySet();
        }

        public Collection values() {
            return this.relations.values();
        }
    }

    private static class Relation
    implements Cloneable {
        public volatile int localMinSeverity = 0;
        public volatile int minSeverity = 0;
        public volatile int localMaxSeverity = 701;
        public volatile int maxSeverity = 701;
        public volatile int effSeverity = 701;
        private volatile int prevLocalMinSeverity = 0;
        private volatile int prevLocalMaxSeverity = 701;

        private Relation() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException exc) {
                return null;
            }
        }

        public int getLocalMinimumSeverity() {
            return this.localMinSeverity;
        }

        public int getMinimumSeverity() {
            return this.minSeverity;
        }

        public int getEffectiveSeverity() {
            return this.effSeverity;
        }

        public int getLocalMaximumSeverity() {
            return this.localMaxSeverity;
        }

        public int getMaximumSeverity() {
            return this.maxSeverity;
        }

        public synchronized void setLocalMinimumSeverity(int severity) {
            this.localMinSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMaxSeverity = this.localMinSeverity;
            }
        }

        public void setLocalMinimumSeverity() {
            this.localMinSeverity = 0;
        }

        public synchronized void calculateMinimumSeverity(int parentSeverity) {
            this.minSeverity = parentSeverity < this.localMinSeverity ? this.localMinSeverity : (this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : parentSeverity);
        }

        public void setEffectiveSeverity(int severity) {
            this.effSeverity = severity;
        }

        public void setEffectiveSeverity() {
            this.localMinSeverity = 0;
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateEffectiveSeverity(int parentSeverity) {
            this.effSeverity = parentSeverity < this.minSeverity ? this.minSeverity : (this.maxSeverity < parentSeverity ? this.maxSeverity : parentSeverity);
        }

        public synchronized void setLocalMaximumSeverity(int severity) {
            this.localMaxSeverity = severity;
            if (this.localMinSeverity > this.localMaxSeverity) {
                this.localMinSeverity = this.localMaxSeverity;
            }
        }

        public void setLocalMaximumSeverity() {
            this.localMaxSeverity = 701;
        }

        public synchronized void calculateMaximumSeverity(int parentSeverity) {
            this.maxSeverity = this.localMaxSeverity < parentSeverity ? this.localMaxSeverity : (parentSeverity < this.localMinSeverity ? this.localMinSeverity : parentSeverity);
        }

        public synchronized boolean isUnchanged() {
            if (this.localMinSeverity == this.prevLocalMinSeverity && this.localMaxSeverity == this.prevLocalMaxSeverity) {
                return true;
            }
            this.prevLocalMinSeverity = this.localMinSeverity;
            this.prevLocalMaxSeverity = this.localMaxSeverity;
            return false;
        }
    }
}

