/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogHeader;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.interfaces.ILog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Log
extends ExceptionHandling
implements ILog {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$FileLog == null ? (class$com$sap$tc$logging$FileLog = Log.class$("com.sap.tc.logging.FileLog")) : class$com$sap$tc$logging$FileLog);
    private boolean suppressing = false;
    private int loggedCnt = 0;
    private boolean headerWritten = false;
    private boolean autoFlush = true;
    private int effSeverity = 0;
    private int logTypeAccessibility;
    private HashSet filters;
    private Formatter formatter;
    private LinkedList lcOwners;
    private LogController localLogOwner;
    private String logName;
    private String logDescription;
    private String logHeader = "";
    private String logFooter = "";
    private String logVerInUse;
    private LogHeader logHeaderObj;
    private static final int LOG_ACCESSABILITY_TYPE_MIN = 0;
    public static final int LOG_ACCESSABILITY_TYPE_NORMAL_LOG = 1;
    public static final int LOG_ACCESSABILITY_TYPE_LOCAL_LOG = 2;
    public static final int LOG_ACCESSABILITY_TYPE_PRIVATE_LOG = 3;
    private static final int LOG_ACCESSABILITY_TYPE_MAX = 4;
    static /* synthetic */ Class class$com$sap$tc$logging$FileLog;

    protected Log() {
        this.formatter = new ListFormatter();
    }

    protected Log(Formatter formatter) {
        this.setFormatter(formatter);
    }

    protected void finalize() {
        this.close();
    }

    public synchronized String getName() {
        return this.logName;
    }

    public synchronized void setName(String name) {
        this.logName = name;
    }

    public synchronized String getDescription() {
        return this.logDescription;
    }

    public synchronized void setDescription(String value) {
        this.logDescription = value;
    }

    public synchronized String getVerInUse() {
        return this.logVerInUse;
    }

    public LogHeader getLogHeader() {
        return this.logHeaderObj;
    }

    public String getHeader() {
        return this.logHeaderObj.getHeader() + this.getFormatter().getHeader(this);
    }

    public String getFooter() {
        return this.logFooter + this.getFormatter().getFooter(this);
    }

    public synchronized int getEffectiveSeverity() {
        return this.effSeverity;
    }

    public synchronized void setEffectiveSeverity(int severity) {
        this.effSeverity = Severity.correct(severity);
    }

    public synchronized int getLogTypeAccessibility() {
        return this.logTypeAccessibility;
    }

    public synchronized void setLogTypeAccessibility(int value) {
        if (value <= 0 || value >= 4) {
            value = 3;
        }
        this.logTypeAccessibility = value;
    }

    public synchronized Formatter getFormatter() {
        return this.formatter;
    }

    public synchronized void setFormatter(Formatter formatter) {
        if (formatter != null) {
            this.formatter = formatter;
        } else {
            APILogger.logIntByAPI(400, classLoc, "[setFormatter(Formatter formatter)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL_DEF, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL_DEF, new String[]{"Formatter", "Log", this.getName(), "Formatter", "ListFormatter"});
            formatter = new ListFormatter();
        }
    }

    public int getNumberOfLogRecordsWritten() {
        return this.getLoggedCount();
    }

    public abstract String getEncoding();

    public abstract void setEncoding(String var1);

    public boolean isFiltersAgreeing(LogRecord rec) {
        if (rec == null) {
            return false;
        }
        if (this.filters != null && !this.filters.isEmpty() && rec.getSeverity() != 800) {
            Iterator iter = this.getFilters().iterator();
            while (iter.hasNext()) {
                try {
                    if (((Filter)iter.next()).beLogged(rec)) continue;
                    return false;
                }
                catch (Exception ex) {
                    APILogger.logIntByAPI(400, classLoc, "[isFiltersAgreeing(LogRecord rec)]", MSGCollection.LOGGING_MSG_ID_FILTER_EXCEPTION, MSGCollection.LOGGING_MSG_STR_FILTER_EXCEPTION, new String[]{"Log", this.getName()});
                    APILogger.catchingIntByAPI(ex);
                    this.handleException(ex);
                }
            }
        }
        return true;
    }

    public Collection getFilters() {
        if (this.filters != null) {
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                Collection collection = Collections.unmodifiableCollection(new ArrayList(this.filters));
                return collection;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void addFilter(Filter filter) {
        if (filter != null) {
            if (this.filters == null) {
                this.filters = new HashSet();
            }
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                if (this.filters.contains(filter)) {
                    this.removeFilter(filter);
                }
                this.filters.add(filter);
            }
        } else {
            APILogger.logIntByAPI(400, classLoc, "[addFilter(Filter filter)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Filter", "Log", this.getName()});
            this.handleException(new NullPointerException("No filter"), 4);
        }
    }

    public void removeFilter(Filter filter) {
        if (this.filters != null) {
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                this.filters.remove(filter);
            }
        }
    }

    public void removeFilters() {
        if (this.filters != null) {
            HashSet hashSet = this.filters;
            synchronized (hashSet) {
                this.filters.clear();
            }
        }
    }

    public boolean beLogged(int severity) {
        return severity >= this.getEffectiveSeverity();
    }

    public LogRecord write(LogRecord rec) {
        LogRecord writtenRec = null;
        if (this.beLogged(rec)) {
            writtenRec = this.writeIntByAPI(rec);
        }
        return writtenRec;
    }

    public void flush() {
        try {
            this.flushInt();
        }
        catch (IOException ex) {
            APILogger.logIntByAPI(400, classLoc, "[flush()]", MSGCollection.LOGGING_MSG_ID_WRITE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_WRITE_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
        }
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void open() {
        try {
            this.openInt();
        }
        catch (IOException ex) {
            APILogger.logIntByAPI(400, classLoc, "[open()]", MSGCollection.LOGGING_MSG_ID_OPEN_EXCEPTION, MSGCollection.LOGGING_MSG_STR_OPEN_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public synchronized void close() {
        try {
            this.writeLogFooter();
            this.closeInt();
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[close()]", MSGCollection.LOGGING_MSG_ID_CLOSE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_CLOSE_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosedInt();
    }

    public synchronized void reset() {
        try {
            this.resetInt();
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[reset()]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public boolean isSuppressing() {
        return this.suppressing;
    }

    public void setSuppressing(boolean suppressing) {
        this.suppressing = suppressing;
    }

    public int getLoggedCount() {
        return this.loggedCnt;
    }

    public void resetLoggedCount() {
        this.loggedCnt = 0;
    }

    public synchronized List getOwners() {
        if (this.lcOwners != null) {
            return this.lcOwners;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void setLogHeader(LogHeader object) {
        this.logHeaderObj = object;
    }

    protected synchronized void setHeader(String value) {
        this.logHeader = value == null ? "" : value;
    }

    protected synchronized void setFooter(String value) {
        this.logFooter = value;
    }

    protected synchronized void setVerInUse(String value) {
        this.logVerInUse = value;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void writeInt(String s) throws Exception {
    }

    protected void flushInt() throws IOException {
    }

    protected void closeInt() throws IOException {
    }

    protected synchronized boolean isClosedInt() {
        return false;
    }

    protected void openInt() throws IOException {
    }

    protected void resetInt() throws Exception {
    }

    protected String writeInt(LogRecord rec) throws Exception {
        String msg = this.getFormatter().format(rec);
        if (!this.isSuppressing()) {
            this.writeInt(msg);
        }
        return msg;
    }

    protected synchronized boolean isHeaderWritten() {
        return this.headerWritten;
    }

    protected void setHeaderWritten(boolean headerWritten) {
        this.headerWritten = headerWritten;
    }

    protected synchronized void addOwner(String owner) {
        if (this.lcOwners == null) {
            this.lcOwners = new LinkedList();
        }
        this.lcOwners.add(owner);
    }

    protected synchronized void removeOwner(String owner) {
        if (this.lcOwners != null && this.lcOwners.contains(owner)) {
            this.lcOwners.remove(owner);
        }
    }

    protected synchronized void setLocalLogOwner(LogController owner) {
        this.localLogOwner = owner;
    }

    protected synchronized LogController getLocalLogOwner() {
        return this.localLogOwner;
    }

    boolean beLogged(LogRecord rec) {
        return this.beLogged(rec.getSeverity()) && this.isFiltersAgreeing(rec);
    }

    LogRecord writeIntByAPI(LogRecord rec) {
        LogRecord writtenRec = null;
        try {
            this.writeInt(rec);
            writtenRec = rec;
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[write(LogRecord rec)]", MSGCollection.LOGGING_MSG_ID_WRITE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_WRITE_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 3);
        }
        this.setLogged();
        if (this.autoFlush) {
            this.flush();
        }
        return writtenRec;
    }

    boolean wasLogged() {
        return this.loggedCnt > 0;
    }

    void setLogged() {
        ++this.loggedCnt;
    }

    protected synchronized void writeLogHeader() {
    }

    protected synchronized void writeLogFooter() {
    }

    public LogRecord getRecord() {
        return null;
    }

    public boolean beGroup() {
        return false;
    }

    public synchronized String getLogName() {
        return this.logName;
    }

    public synchronized void setLogName(String name) {
        this.logName = name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

