/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogHeader;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.TraceFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FileLogHeader
extends LogHeader {
    private static Location classLoc = Location.getLocation(class$com$sap$tc$logging$FileLogHeader == null ? (class$com$sap$tc$logging$FileLogHeader = FileLogHeader.class$("com.sap.tc.logging.FileLogHeader")) : class$com$sap$tc$logging$FileLogHeader);
    private static final String NULL_STRING = "<null>";
    private static final String EMPTY_STRING = "";
    private static final String HEAD_LINE_START = "<!--";
    private static final String HEAD_LINE_END = "/-->";
    private static final String HEAD_DEL_LEFT = "[";
    private static final String HEAD_DEL_RIGHT = "]";
    private static HashMap headerElements = new HashMap();
    private static final int MIN = 0;
    public static final int LOG_HEAD = 1;
    private static final String STR_LOG_HEAD = "LOGHEADER";
    public static final int LOG_HEAD_HELP = 2;
    private static final String STR_LOG_HEAD_HELP = "HELP";
    public static final int LOGGING_VERSION = 3;
    private static final String STR_LOGGING_VERSION = "LOGGINGVERSION";
    public static final int LOG_NAME = 4;
    private static final String STR_LOG_NAME = "NAME";
    public static final int LOG_DESCRIPT = 5;
    private static final String STR_LOG_DESCRIPT = "DESCRIPTION";
    public static final int LOG_F_NAME_PATTERN = 6;
    private static final String STR_LOG_F_NAME_PATTERN = "PATTERN";
    public static final int LOG_OWNER = 7;
    private static final String STR_LOG_OWNER = "OWNER";
    public static final int LOG_FORMATTER = 8;
    private static final String STR_LOG_FORMATTER = "FORMATTER";
    public static final int LOG_FILESET = 9;
    private static final String STR_LOG_FILESET = "FILESET";
    public static final int LOG_PREV_FILE = 10;
    private static final String STR_LOG_PREV_FILE = "PREVIOUSFILE";
    public static final int LOG_NEXT_FILE = 11;
    private static final String STR_LOG_NEXT_FILE = "NEXTFILE";
    private static final int MAX = 12;
    public static final int MAX_NUMBER_OF_HEADER_LINES = 11;
    private static final int SETTING_LEVEL_DEFAULT = 0;
    private static final int SETTING_LEVEL_CUSTOM = 1;
    private String logPattern;
    private String logFileNamePattern;
    private String logFilePathPattern;
    private String logOwners;
    private String logFileSet;
    private int logFileSetIndex;
    private int logFileSetSize;
    private int logFileSetLimit;
    private String logFileColumnHeader;
    private String logFullHeader;
    static /* synthetic */ Class class$com$sap$tc$logging$FileLogHeader;

    public FileLogHeader(FileLog fileLog) {
        this.init(fileLog);
    }

    public void init(FileLog fileLog) {
        this.loadFileLogHeader(fileLog);
        this.resetIsChanged();
    }

    public void loadFromLog(FileLog fileLog) {
        this.loadFromLogInt(fileLog);
        this.getHeader();
    }

    public void recover(FileLog fileLog) {
        fileLog.setName(this.getName());
        fileLog.setDescription(this.getDescription());
        fileLog.setPattern(this.getPattern());
        fileLog.setFormatter(this.getFormatter());
        fileLog.addOwner(this.getOwners());
        fileLog.setRotation(this.getFileSetSize(), this.getFileSetLimit());
        fileLog.setIndex(this.getFileSetIndex());
    }

    public String getPattern() {
        if (this.logPattern != null) {
            return this.logPattern;
        }
        return EMPTY_STRING;
    }

    public String getOwners() {
        if (this.logOwners != null) {
            return this.logOwners;
        }
        return EMPTY_STRING;
    }

    public String getFileSet() {
        if (this.logFileSetSize > 0) {
            this.logFileSet = EMPTY_STRING + this.logFileSetIndex + ", " + this.logFileSetSize + ", " + this.logFileSetLimit;
        }
        if (this.logFileSet != null) {
            return this.logFileSet;
        }
        return EMPTY_STRING;
    }

    public int getFileSetIndex() {
        return this.logFileSetIndex;
    }

    public int getFileSetSize() {
        return this.logFileSetSize;
    }

    public int getFileSetLimit() {
        return this.logFileSetLimit;
    }

    public String getHeader() {
        if (this.isChanged()) {
            this.logFullHeader = this.format(true);
            this.resetIsChanged();
        }
        if (this.logFullHeader != null) {
            return this.logFullHeader;
        }
        return EMPTY_STRING;
    }

    protected String getFilePathPattern() {
        if (this.logFilePathPattern != null) {
            return this.logFilePathPattern;
        }
        return EMPTY_STRING;
    }

    protected String getFileNamePattern() {
        if (this.logFileNamePattern != null) {
            return this.logFileNamePattern;
        }
        return EMPTY_STRING;
    }

    protected void setPattern(String value) {
        this.logPattern = value;
        this.headerIsChanged();
    }

    protected void setFileNamePattern(String value) {
        this.logFileNamePattern = value;
        this.headerIsChanged();
    }

    protected void setFilePathPattern(String value) {
        this.logFilePathPattern = value;
        this.headerIsChanged();
    }

    protected void setOwners(List value) {
        this.headerIsChanged();
    }

    protected void setFileSetIndex(int value) {
        this.logFileSetIndex = value;
        this.headerIsChanged();
    }

    protected void setFileSet(int size, int limit) {
        this.logFileSetSize = size;
        this.logFileSetLimit = limit;
        this.headerIsChanged();
    }

    protected void setHeader(String value) {
        this.logFullHeader = value;
    }

    protected void buildPattern(String value) {
        if (value != null) {
            File file = new File(value);
            this.setFileNamePattern(file.getName());
            this.setFilePathPattern(file.getParent());
        }
        this.logPattern = value;
        this.headerIsChanged();
    }

    private String getHeaderInt() {
        if (this.isChanged()) {
            this.logFullHeader = this.format(false);
            this.resetIsChanged();
        }
        if (this.logFullHeader != null) {
            return this.logFullHeader;
        }
        return EMPTY_STRING;
    }

    private String getFormatterFull() {
        String formatterName = this.getFormatter().getClass().getName();
        if (this.getFormatter() instanceof TraceFormatter) {
            formatterName = formatterName + "(" + ((TraceFormatter)this.getFormatter()).getPattern() + ")";
        }
        return formatterName;
    }

    private void setFormatter(String value) {
        String strFormatter = null;
        String strFormatterPattern = null;
        int startPos = value.indexOf("(");
        if (startPos > 0) {
            strFormatter = value.substring(0, startPos);
            strFormatterPattern = value.substring(startPos + 1, value.length() - 1);
        } else {
            strFormatter = value;
        }
        this.setFormatter(FileLogHeader.getFormatter(strFormatter));
        if (strFormatterPattern != null && strFormatterPattern.length() > 0) {
            ((TraceFormatter)this.getFormatter()).setPattern(strFormatterPattern);
        }
    }

    private void setFileSet(String value) {
        String[] strFromPat = FileLogHeader.getRotatingSetValues(value);
        if (strFromPat.length == 3) {
            this.setFileSet(new Integer(strFromPat[1].trim()), new Integer(strFromPat[2].trim()));
            this.setFileSetIndex(new Integer(strFromPat[0].trim()));
        }
        this.headerIsChanged();
    }

    private void loadFromLogInt(FileLog fileLog) {
        this.setName(fileLog.getName());
        this.setDescription(fileLog.getDescription());
        this.buildPattern(fileLog.getPattern());
        this.setFormatter(fileLog.getFormatter());
        this.setOwners(fileLog.getOwners());
        this.setFileSet(fileLog.getCnt(), fileLog.getLimit());
        this.setFileSetIndex(fileLog.getIndex());
    }

    private void loadFileLogHeader(FileLog fileLog) {
        String[] headLines = FileLogHeader.getFileHeaderLines(fileLog.expandPattern(true));
        if (headLines != null) {
            if (this.parse(this.parseHeader(headLines))) {
                this.getHeaderInt();
            } else {
                this.setHeader(null);
            }
        }
        if (this.getHeader().length() == 0) {
            this.loadFromLogInt(fileLog);
        }
    }

    private static String[] getFileHeaderLines(String fileName) {
        return FileLogHeader.getFileHeaderLines(fileName, 11);
    }

    /*
     * Unable to fully structure code
     */
    private static String[] getFileHeaderLines(String fileName, int cntHeadLines) {
        block15: {
            headerLines = new String[cntHeadLines];
            headerLineCount = 0;
            file = null;
            file = new BufferedReader(new FileReader(fileName));
            linesRead = 0;
            lenLeftLineMark = "<!--".length();
            lenRightLineMark = "<!--".length();
            if (true) ** GOTO lbl15
            do {
                if (var8_11.length() >= lenLeftLineMark && var8_11.substring(0, lenLeftLineMark).equals("<!--")) {
                    headerLines[headerLineCount] = var8_11.substring(lenLeftLineMark, var8_11.length() - lenRightLineMark);
                    ++headerLineCount;
                }
lbl15:
                // 4 sources

                lineValue = file.readLine();
                if (lineValue == null || headerLineCount >= cntHeadLines) break;
            } while (linesRead++ < 11);
            var10_12 = null;
            if (file == null) break block15;
            try {
                file.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            file = null;
            {
                break block15;
                catch (FileNotFoundException ex) {
                    var10_13 = null;
                    if (file == null) break block15;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                    break block15;
                }
                catch (IOException ex) {
                    APILogger.logIntByAPI(400, FileLogHeader.classLoc, "[getFileHeader(String fileName, int cntHeadLines)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"FileHeader parsing"});
                    APILogger.catchingIntByAPI(ex);
                    var10_14 = null;
                    if (file == null) break block15;
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                }
            }
            catch (Throwable var9_20) {
                var10_15 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    file = null;
                }
                throw var9_20;
            }
        }
        if (headerLineCount > 0) {
            finalHeaderLines = new String[headerLineCount];
            System.arraycopy(headerLines, 0, finalHeaderLines, 0, headerLineCount);
            return finalHeaderLines;
        }
        return null;
    }

    private Map parseHeader(String[] headerLines) {
        String lineKeyName = null;
        String lineValue = null;
        HashMap<String, String> headLines = new HashMap<String, String>();
        int i = 0;
        while (i < headerLines.length) {
            lineKeyName = FileLogHeader.getKey(headerLines[i]);
            lineValue = FileLogHeader.getValue(headerLines[i]);
            if (lineKeyName != null && lineValue != null && lineKeyName.length() > 0) {
                headLines.put(lineKeyName, lineValue);
            }
            ++i;
        }
        return headLines;
    }

    private static String getKey(String value) {
        String lineKey = null;
        int pos = 0;
        if (value == null) {
            return EMPTY_STRING;
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0) {
            lineKey = value.substring(0, pos);
        }
        return lineKey;
    }

    private static String getValue(String value) {
        String lineValue = null;
        int pos = 0;
        if (value == null) {
            return EMPTY_STRING;
        }
        pos = value.indexOf(HEAD_DEL_LEFT);
        if (pos > 0 && pos + 1 < value.length()) {
            lineValue = value.substring(pos + 1, value.length() - 1);
        }
        return lineValue;
    }

    private boolean parse(Map headerLines) {
        int conKey = 0;
        String conValue = null;
        Map.Entry entry = null;
        Iterator iter = headerLines.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            conKey = FileLogHeader.parseKeyByName((String)entry.getKey());
            conValue = (String)entry.getValue();
            switch (conKey) {
                case 3: {
                    this.setVerInUse(conValue);
                    break;
                }
                case 7: {
                    break;
                }
                case 4: {
                    this.setName(conValue);
                    break;
                }
                case 5: {
                    this.setDescription(conValue);
                    break;
                }
                case 6: {
                    this.setPattern(conValue);
                    break;
                }
                case 8: {
                    this.setFormatter(conValue);
                    break;
                }
                case 9: {
                    this.setFileSet(conValue);
                    break;
                }
                case 1: 
                case 2: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    APILogger.logIntByAPI(400, classLoc, "[parse()]", MSGCollection.LOGGING_MSG_ID_HEADER_ERROR, MSGCollection.LOGGING_MSG_STR_HEADER_ERROR, new String[]{this.getPattern()});
                    return false;
                }
            }
        }
        return true;
    }

    private static int parseKeyByName(String keyName) {
        if (keyName != null && headerElements.containsKey(keyName.toUpperCase())) {
            return (Integer)headerElements.get(keyName.toUpperCase());
        }
        return -1;
    }

    private String format(boolean isNew) {
        String pattern = EMPTY_STRING;
        String[] headerFields = new String[13];
        headerFields[0] = this.formatHeaderLine(STR_LOG_HEAD, "START");
        headerFields[2] = this.formatHeaderLine(STR_LOG_HEAD_HELP, "Manual modification of the header may cause parsing problem!");
        headerFields[3] = this.formatHeaderLine(STR_LOGGING_VERSION, this.getVerInUse());
        if (this.getName() != null) {
            headerFields[4] = this.formatHeaderLine(STR_LOG_NAME, this.getName());
        }
        if (this.getDescription() != null) {
            headerFields[5] = this.formatHeaderLine(STR_LOG_DESCRIPT, this.getDescription());
        }
        pattern = this.getFilePathPattern().length() == 0 ? this.getPattern() : this.getFileNamePattern();
        headerFields[6] = this.formatHeaderLine(STR_LOG_F_NAME_PATTERN, pattern);
        headerFields[8] = isNew ? this.formatHeaderLine(STR_LOG_FORMATTER, this.getFormatterFull()) : this.formatHeaderLine(STR_LOG_FORMATTER, this.getFormatter().getClass().getName());
        if (this.getFileSet().length() > 0) {
            headerFields[9] = this.formatHeaderLine(STR_LOG_FILESET, this.getFileSet());
            headerFields[10] = this.formatHeaderLine(STR_LOG_PREV_FILE, EMPTY_STRING + new FileLog().expandPattern(pattern, this.logFileSetIndex - 1 < 0 ? this.logFileSetSize - 1 : this.logFileSetIndex - 1, true, true));
            headerFields[11] = this.formatHeaderLine(STR_LOG_NEXT_FILE, EMPTY_STRING + new FileLog().expandPattern(pattern, this.logFileSetIndex + 1 > this.logFileSetSize - 1 ? 0 : this.logFileSetIndex + 1, true, true));
        }
        headerFields[12] = this.formatHeaderLine(STR_LOG_HEAD, "END");
        return this.formatHeader(headerFields);
    }

    private String formatHeaderLine(String headerKey, String headerValue) {
        StringBuffer header = new StringBuffer();
        if (headerKey != null && headerValue != null) {
            header.append(headerKey);
            header.append(HEAD_DEL_LEFT);
            header.append(headerValue);
            header.append(HEAD_DEL_RIGHT);
        }
        return header.toString();
    }

    private String formatHeader(String[] headerLines) {
        StringBuffer header = new StringBuffer();
        if (headerLines != null && headerLines.length > 0) {
            int i = 0;
            while (i < headerLines.length) {
                if (headerLines[i] != null) {
                    header.append(HEAD_LINE_START);
                    header.append(headerLines[i]);
                    header.append(HEAD_LINE_END + Formatter.EOL);
                }
                ++i;
            }
        }
        return header.toString();
    }

    private static Formatter getFormatter(String fType) {
        if (fType == null) {
            return null;
        }
        try {
            return (Formatter)Class.forName(fType).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] getRotatingSetValues(String value) {
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        StringTokenizer tmpTokens = new StringTokenizer(value, ",", false);
        String[] tmpValue = new String[3];
        if (tmpTokens.countTokens() != 3) {
            return new String[0];
        }
        int i = 0;
        while (i < 3) {
            tmpValue[i] = tmpTokens.nextToken().trim();
            ++i;
        }
        return tmpValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        headerElements.put(STR_LOG_HEAD, new Integer(1));
        headerElements.put(STR_LOG_HEAD_HELP, new Integer(2));
        headerElements.put(STR_LOGGING_VERSION, new Integer(3));
        headerElements.put(STR_LOG_NAME, new Integer(4));
        headerElements.put(STR_LOG_DESCRIPT, new Integer(5));
        headerElements.put(STR_LOG_F_NAME_PATTERN, new Integer(6));
        headerElements.put(STR_LOG_OWNER, new Integer(7));
        headerElements.put(STR_LOG_FORMATTER, new Integer(8));
        headerElements.put(STR_LOG_FILESET, new Integer(9));
        headerElements.put(STR_LOG_PREV_FILE, new Integer(10));
        headerElements.put(STR_LOG_NEXT_FILE, new Integer(11));
    }
}

