/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.eclipse.pde.internal.ui.editor.site.FeatureBuildOperation;

public class SiteBuildListener
implements BuildListener {
    private PrintWriter writer;

    public void buildStarted(BuildEvent event) {
        try {
            File file = FeatureBuildOperation.getDefault().getLogFile();
            FileOutputStream fos = new FileOutputStream(file);
            this.writer = new PrintWriter(fos, true);
        }
        catch (IOException iOException) {}
    }

    public void buildFinished(BuildEvent event) {
        if (this.writer != null) {
            this.writer.println("Build finished.");
            this.writer.close();
        }
    }

    public void targetStarted(BuildEvent event) {
        if (this.writer != null) {
            this.writer.println("Target started: " + event.getTarget().getName());
        }
    }

    public void targetFinished(BuildEvent event) {
        if (this.writer != null) {
            this.writer.println("Target finished: " + event.getTarget().getName());
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this.writer != null) {
            Task task = event.getTask();
            String description = task.getDescription();
            if (description == null) {
                description = task.getTaskName();
            }
            this.writer.println("Task started: " + description);
        }
    }

    public void taskFinished(BuildEvent event) {
        if (this.writer != null) {
            Task task = event.getTask();
            String description = task.getDescription();
            if (description == null) {
                description = task.getTaskName();
            }
            this.writer.println("Task finished: " + description);
        }
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if ((priority == 0 || priority == 1) && this.writer != null) {
            this.writer.println("Message logged: " + event.getMessage());
        }
    }
}

